/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshotInfo;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotDiffInfo;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotStatsMXBean;
import org.apache.hadoop.metrics2.util.MBeans;

public class SnapshotManager
implements SnapshotStatsMXBean {
    private boolean allowNestedSnapshots = false;
    private final FSDirectory fsdir;
    private static final int SNAPSHOT_ID_BIT_WIDTH = 24;
    private final AtomicInteger numSnapshots = new AtomicInteger();
    private int snapshotCounter = 0;
    private final Map<Long, INodeDirectory> snapshottables = new HashMap<Long, INodeDirectory>();
    private ObjectName mxBeanName;

    public SnapshotManager(FSDirectory fsdir) {
        this.fsdir = fsdir;
    }

    public void initAuthorizationProvider() {
        HashMap<AuthorizationProvider.INodeAuthorizationInfo, Integer> map = new HashMap<AuthorizationProvider.INodeAuthorizationInfo, Integer>();
        for (INodeDirectory dir : this.getSnapshottableDirs()) {
            int currentSnapshot = 0x7FFFFFFE;
            DirectorySnapshottableFeature sf = dir.getDirectorySnapshottableFeature();
            if (sf != null) {
                currentSnapshot = sf.getLastSnapshotId();
            }
            map.put(dir, currentSnapshot);
        }
        AuthorizationProvider.get().setSnaphottableDirs(map);
    }

    void setAllowNestedSnapshots(boolean allowNestedSnapshots) {
        this.allowNestedSnapshots = allowNestedSnapshots;
    }

    private void checkNestedSnapshottable(INodeDirectory dir, String path) throws SnapshotException {
        if (this.allowNestedSnapshots) {
            return;
        }
        for (INodeDirectory s : this.snapshottables.values()) {
            if (s.isAncestorDirectory(dir)) {
                throw new SnapshotException("Nested snapshottable directories not allowed: path=" + path + ", the subdirectory " + s.getFullPathName() + " is already a snapshottable directory.");
            }
            if (!dir.isAncestorDirectory(s)) continue;
            throw new SnapshotException("Nested snapshottable directories not allowed: path=" + path + ", the ancestor " + s.getFullPathName() + " is already a snapshottable directory.");
        }
    }

    public void setSnapshottable(String path, boolean checkNestedSnapshottable) throws IOException {
        INodesInPath iip = this.fsdir.getINodesInPath4Write(path);
        INodeDirectory d = INodeDirectory.valueOf(iip.getLastINode(), path);
        if (checkNestedSnapshottable) {
            this.checkNestedSnapshottable(d, path);
        }
        if (d.isSnapshottable()) {
            d.setSnapshotQuota(65536);
        } else {
            d.addSnapshottableFeature();
        }
        this.addSnapshottable(d);
    }

    public void addSnapshottable(INodeDirectory dir) {
        Preconditions.checkArgument((boolean)dir.isSnapshottable());
        AuthorizationProvider.get().addSnapshottable(dir);
        this.snapshottables.put(dir.getId(), dir);
    }

    private void removeSnapshottable(INodeDirectory s) {
        AuthorizationProvider.get().removeSnapshottable(s);
        this.snapshottables.remove(s.getId());
    }

    public void removeSnapshottable(List<INodeDirectory> toRemove) {
        if (toRemove != null) {
            for (INodeDirectory s : toRemove) {
                this.removeSnapshottable(s);
            }
        }
    }

    public void resetSnapshottable(String path) throws IOException {
        INodesInPath iip = this.fsdir.getINodesInPath4Write(path);
        INodeDirectory d = INodeDirectory.valueOf(iip.getLastINode(), path);
        DirectorySnapshottableFeature sf = d.getDirectorySnapshottableFeature();
        if (sf == null) {
            return;
        }
        if (sf.getNumSnapshots() > 0) {
            throw new SnapshotException("The directory " + path + " has snapshot(s). " + "Please redo the operation after removing all the snapshots.");
        }
        if (d == this.fsdir.getRoot()) {
            d.setSnapshotQuota(0);
        } else {
            d.removeSnapshottableFeature();
        }
        this.removeSnapshottable(d);
    }

    public INodeDirectory getSnapshottableRoot(String path) throws IOException {
        INodeDirectory dir = INodeDirectory.valueOf(this.fsdir.getINodesInPath4Write(path).getLastINode(), path);
        if (!dir.isSnapshottable()) {
            throw new SnapshotException("Directory is not a snapshottable directory: " + path);
        }
        return dir;
    }

    public String createSnapshot(String path, String snapshotName) throws IOException {
        INodeDirectory srcRoot = this.getSnapshottableRoot(path);
        if (this.snapshotCounter == this.getMaxSnapshotID()) {
            throw new SnapshotException("Failed to create the snapshot. The FileSystem has run out of snapshot IDs and ID rollover is not supported.");
        }
        AuthorizationProvider.get().createSnapshot(srcRoot, this.snapshotCounter);
        srcRoot.addSnapshot(this.snapshotCounter, snapshotName);
        ++this.snapshotCounter;
        this.numSnapshots.getAndIncrement();
        return Snapshot.getSnapshotPath(path, snapshotName);
    }

    public void deleteSnapshot(String path, String snapshotName, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws IOException {
        INodeDirectory srcRoot = this.getSnapshottableRoot(path);
        AuthorizationProvider.get().removeSnapshot(srcRoot, this.snapshotCounter);
        srcRoot.removeSnapshot(snapshotName, collectedBlocks, removedINodes);
        this.numSnapshots.getAndDecrement();
    }

    public void renameSnapshot(String path, String oldSnapshotName, String newSnapshotName) throws IOException {
        INodeDirectory srcRoot = this.getSnapshottableRoot(path);
        srcRoot.renameSnapshot(path, oldSnapshotName, newSnapshotName);
    }

    public int getNumSnapshottableDirs() {
        return this.snapshottables.size();
    }

    public int getNumSnapshots() {
        return this.numSnapshots.get();
    }

    void setNumSnapshots(int num) {
        this.numSnapshots.set(num);
    }

    int getSnapshotCounter() {
        return this.snapshotCounter;
    }

    void setSnapshotCounter(int counter) {
        this.snapshotCounter = counter;
    }

    INodeDirectory[] getSnapshottableDirs() {
        return this.snapshottables.values().toArray(new INodeDirectory[this.snapshottables.size()]);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.snapshotCounter);
        out.writeInt(this.numSnapshots.get());
        for (INodeDirectory snapshottableDir : this.snapshottables.values()) {
            for (Snapshot s : snapshottableDir.getDirectorySnapshottableFeature().getSnapshotList()) {
                s.write(out);
            }
        }
    }

    public Map<Integer, Snapshot> read(DataInput in, FSImageFormat.Loader loader) throws IOException {
        this.snapshotCounter = in.readInt();
        this.numSnapshots.set(in.readInt());
        HashMap<Integer, Snapshot> snapshotMap = new HashMap<Integer, Snapshot>();
        for (int i = 0; i < this.numSnapshots.get(); ++i) {
            Snapshot s = Snapshot.read(in, loader);
            snapshotMap.put(s.getId(), s);
        }
        return snapshotMap;
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing(String userName) {
        if (this.snapshottables.isEmpty()) {
            return null;
        }
        ArrayList<SnapshottableDirectoryStatus> statusList = new ArrayList<SnapshottableDirectoryStatus>();
        for (INodeDirectory dir : this.snapshottables.values()) {
            if (userName != null && !userName.equals(dir.getUserName())) continue;
            SnapshottableDirectoryStatus status = new SnapshottableDirectoryStatus(dir.getModificationTime(), dir.getAccessTime(), dir.getFsPermission(), dir.getUserName(), dir.getGroupName(), dir.getLocalNameBytes(), dir.getId(), dir.getChildrenNum(0x7FFFFFFE), dir.getDirectorySnapshottableFeature().getNumSnapshots(), dir.getDirectorySnapshottableFeature().getSnapshotQuota(), dir.getParent() == null ? DFSUtil.EMPTY_BYTES : DFSUtil.string2Bytes(dir.getParent().getFullPathName()));
            statusList.add(status);
        }
        Collections.sort(statusList, SnapshottableDirectoryStatus.COMPARATOR);
        return statusList.toArray(new SnapshottableDirectoryStatus[statusList.size()]);
    }

    public SnapshotDiffReport diff(String path, String from, String to) throws IOException {
        INodeDirectory snapshotRoot = this.getSnapshottableRoot(path);
        if ((from == null || from.isEmpty()) && (to == null || to.isEmpty())) {
            return new SnapshotDiffReport(path, from, to, Collections.emptyList());
        }
        SnapshotDiffInfo diffs = snapshotRoot.getDirectorySnapshottableFeature().computeDiff(snapshotRoot, from, to);
        return diffs != null ? diffs.generateReport() : new SnapshotDiffReport(path, from, to, Collections.emptyList());
    }

    public void clearSnapshottableDirs() {
        this.snapshottables.clear();
    }

    public int getMaxSnapshotID() {
        return 0xFFFFFF;
    }

    public void registerMXBean() {
        this.mxBeanName = MBeans.register((String)"NameNode", (String)"SnapshotInfo", (Object)this);
    }

    public void shutdown() {
        MBeans.unregister((ObjectName)this.mxBeanName);
        this.mxBeanName = null;
    }

    @Override
    public SnapshottableDirectoryStatus.Bean[] getSnapshottableDirectories() {
        ArrayList<SnapshottableDirectoryStatus.Bean> beans = new ArrayList<SnapshottableDirectoryStatus.Bean>();
        for (INodeDirectory d : this.getSnapshottableDirs()) {
            beans.add(SnapshotManager.toBean(d));
        }
        return beans.toArray(new SnapshottableDirectoryStatus.Bean[beans.size()]);
    }

    @Override
    public SnapshotInfo.Bean[] getSnapshots() {
        ArrayList<SnapshotInfo.Bean> beans = new ArrayList<SnapshotInfo.Bean>();
        for (INodeDirectory d : this.getSnapshottableDirs()) {
            for (Snapshot s : d.getDirectorySnapshottableFeature().getSnapshotList()) {
                beans.add(SnapshotManager.toBean(s));
            }
        }
        return beans.toArray(new SnapshotInfo.Bean[beans.size()]);
    }

    public static SnapshottableDirectoryStatus.Bean toBean(INodeDirectory d) {
        return new SnapshottableDirectoryStatus.Bean(d.getFullPathName(), d.getDirectorySnapshottableFeature().getNumSnapshots(), d.getDirectorySnapshottableFeature().getSnapshotQuota(), d.getModificationTime(), Short.valueOf(Integer.toOctalString(d.getFsPermissionShort())), d.getUserName(), d.getGroupName());
    }

    public static SnapshotInfo.Bean toBean(Snapshot s) {
        return new SnapshotInfo.Bean(s.getRoot().getLocalName(), s.getRoot().getFullPathName(), s.getRoot().getModificationTime());
    }
}

