/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.LimitInputStream;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public final class PBImageXmlWriter {
    private final Configuration conf;
    private final PrintWriter out;
    private final SimpleDateFormat isoDateFormat;
    private String[] stringTable;

    public static SimpleDateFormat createSimpleDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public PBImageXmlWriter(Configuration conf, PrintWriter out) {
        this.conf = conf;
        this.out = out;
        this.isoDateFormat = PBImageXmlWriter.createSimpleDateFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file.getFD());
            this.out.print("<?xml version=\"1.0\"?>\n<fsimage>");
            this.out.print("<version>");
            this.o("layoutVersion", summary.getLayoutVersion());
            this.o("onDiskVersion", summary.getOndiskVersion());
            this.o("oivRevision", VersionInfo.getRevision());
            this.out.print("</version>\n");
            ArrayList sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            for (FsImageProto.FileSummary.Section s : sections) {
                fin.getChannel().position(s.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, s.getLength())));
                switch (FSImageFormatProtobuf.SectionName.fromString(s.getName())) {
                    case NS_INFO: {
                        this.dumpNameSection(is);
                        break;
                    }
                    case STRING_TABLE: {
                        this.loadStringTable(is);
                        break;
                    }
                    case INODE: {
                        this.dumpINodeSection(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        this.dumpINodeReferenceSection(is);
                        break;
                    }
                    case INODE_DIR: {
                        this.dumpINodeDirectorySection(is);
                        break;
                    }
                    case FILES_UNDERCONSTRUCTION: {
                        this.dumpFileUnderConstructionSection(is);
                        break;
                    }
                    case SNAPSHOT: {
                        this.dumpSnapshotSection(is);
                        break;
                    }
                    case SNAPSHOT_DIFF: {
                        this.dumpSnapshotDiffSection(is);
                        break;
                    }
                    case SECRET_MANAGER: {
                        this.dumpSecretManagerSection(is);
                        break;
                    }
                    case CACHE_MANAGER: {
                        this.dumpCacheManagerSection(is);
                        break;
                    }
                }
            }
            this.out.print("</fsimage>\n");
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fin});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fin});
    }

    private void dumpCacheManagerSection(InputStream is) throws IOException {
        GeneratedMessage p;
        int i;
        this.out.print("<CacheManagerSection>");
        FsImageProto.CacheManagerSection s = FsImageProto.CacheManagerSection.parseDelimitedFrom(is);
        this.o("nextDirectiveId", s.getNextDirectiveId());
        this.o("numDirectives", s.getNumDirectives());
        this.o("numPools", s.getNumPools());
        for (i = 0; i < s.getNumPools(); ++i) {
            p = ClientNamenodeProtocolProtos.CachePoolInfoProto.parseDelimitedFrom(is);
            this.out.print("<pool>");
            this.o("poolName", p.getPoolName()).o("ownerName", p.getOwnerName()).o("groupName", p.getGroupName()).o("mode", p.getMode()).o("limit", p.getLimit()).o("maxRelativeExpiry", p.getMaxRelativeExpiry());
            this.out.print("</pool>\n");
        }
        for (i = 0; i < s.getNumDirectives(); ++i) {
            p = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.parseDelimitedFrom(is);
            this.out.print("<directive>");
            this.o("id", p.getId()).o("path", p.getPath()).o("replication", p.getReplication()).o("pool", p.getPool());
            this.out.print("<expiration>");
            ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto e = p.getExpiration();
            this.o("millis", e.getMillis()).o("relative", e.getIsRelative());
            this.out.print("</expiration>\n");
            this.out.print("</directive>\n");
        }
        this.out.print("</CacheManagerSection>\n");
    }

    private void dumpFileUnderConstructionSection(InputStream in) throws IOException {
        FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e;
        this.out.print("<FileUnderConstructionSection>");
        while ((e = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<inode>");
            this.o("id", e.getInodeId()).o("path", e.getFullPath());
            this.out.print("</inode>\n");
        }
        this.out.print("</FileUnderConstructionSection>\n");
    }

    private void dumpXattrs(FsImageProto.INodeSection.XAttrFeatureProto xattrs) {
        this.out.print("<xattrs>");
        for (FsImageProto.INodeSection.XAttrCompactProto xattr : xattrs.getXAttrsList()) {
            this.out.print("<xattr>");
            int encodedName = xattr.getName();
            int ns = 3 & encodedName >> 30 | (1 & encodedName >> 5) << 2;
            this.o("ns", XAttrProtos.XAttrProto.XAttrNamespaceProto.valueOf(ns).toString());
            this.o("name", this.stringTable[0xFFFFFF & encodedName >> 6]);
            ByteString val = xattr.getValue();
            if (val.isValidUtf8()) {
                this.o("val", val.toStringUtf8());
            } else {
                this.o("valHex", Hex.encodeHexString((byte[])val.toByteArray()));
            }
            this.out.print("</xattr>");
        }
        this.out.print("</xattrs>");
    }

    private void dumpINodeDirectory(FsImageProto.INodeSection.INodeDirectory d) {
        this.o("mtime", d.getModificationTime()).o("permission", this.dumpPermission(d.getPermission()));
        if (d.hasXAttrs()) {
            this.dumpXattrs(d.getXAttrs());
        }
        this.dumpAcls(d.getAcl());
        if (d.hasDsQuota() && d.hasNsQuota()) {
            this.o("nsquota", d.getNsQuota()).o("dsquota", d.getDsQuota());
        }
    }

    private void dumpINodeDirectorySection(InputStream in) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        this.out.print("<INodeDirectorySection>");
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<directory>");
            this.o("parent", e.getParent());
            Iterator<Number> i$ = e.getChildrenList().iterator();
            while (i$.hasNext()) {
                long id = i$.next();
                this.o("child", id);
            }
            i$ = e.getRefChildrenList().iterator();
            while (i$.hasNext()) {
                int refId = (Integer)i$.next();
                this.o("refChild", refId);
            }
            this.out.print("</directory>\n");
        }
        this.out.print("</INodeDirectorySection>\n");
    }

    private void dumpINodeReferenceSection(InputStream in) throws IOException {
        FsImageProto.INodeReferenceSection.INodeReference e;
        this.out.print("<INodeReferenceSection>");
        while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom(in)) != null) {
            this.dumpINodeReference(e);
        }
        this.out.print("</INodeReferenceSection>");
    }

    private void dumpINodeReference(FsImageProto.INodeReferenceSection.INodeReference r) {
        this.out.print("<ref>");
        this.o("referredId", r.getReferredId()).o("name", r.getName().toStringUtf8()).o("dstSnapshotId", r.getDstSnapshotId()).o("lastSnapshotId", r.getLastSnapshotId());
        this.out.print("</ref>\n");
    }

    private void dumpINodeFile(FsImageProto.INodeSection.INodeFile f) {
        this.o("replication", f.getReplication()).o("mtime", f.getModificationTime()).o("atime", f.getAccessTime()).o("preferredBlockSize", f.getPreferredBlockSize()).o("permission", this.dumpPermission(f.getPermission()));
        if (f.hasXAttrs()) {
            this.dumpXattrs(f.getXAttrs());
        }
        this.dumpAcls(f.getAcl());
        if (f.getBlocksCount() > 0) {
            this.out.print("<blocks>");
            for (HdfsProtos.BlockProto b : f.getBlocksList()) {
                this.out.print("<block>");
                this.o("id", b.getBlockId()).o("genstamp", b.getGenStamp()).o("numBytes", b.getNumBytes());
                this.out.print("</block>\n");
            }
            this.out.print("</blocks>\n");
        }
        if (f.hasStoragePolicyID()) {
            this.o("storagePolicyId", f.getStoragePolicyID());
        }
        if (f.hasFileUC()) {
            FsImageProto.INodeSection.FileUnderConstructionFeature u = f.getFileUC();
            this.out.print("<file-under-construction>");
            this.o("clientName", u.getClientName()).o("clientMachine", u.getClientMachine());
            this.out.print("</file-under-construction>\n");
        }
    }

    private void dumpAcls(FsImageProto.INodeSection.AclFeatureProto aclFeatureProto) {
        ImmutableList<AclEntry> aclEntryList = FSImageFormatPBINode.Loader.loadAclEntries(aclFeatureProto, this.stringTable);
        if (aclEntryList.size() > 0) {
            this.out.print("<acls>");
            for (AclEntry aclEntry : aclEntryList) {
                this.o("acl", aclEntry.toString());
            }
            this.out.print("</acls>");
        }
    }

    private void dumpINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        this.out.print("<INodeSection>");
        this.o("lastInodeId", s.getLastInodeId());
        this.o("numInodes", s.getNumInodes());
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            this.out.print("<inode>");
            this.dumpINodeFields(p);
            this.out.print("</inode>\n");
            ++i;
        }
        this.out.print("</INodeSection>\n");
    }

    private void dumpINodeFields(FsImageProto.INodeSection.INode p) {
        this.o("id", p.getId()).o("type", (Object)p.getType()).o("name", p.getName().toStringUtf8());
        if (p.hasFile()) {
            this.dumpINodeFile(p.getFile());
        } else if (p.hasDirectory()) {
            this.dumpINodeDirectory(p.getDirectory());
        } else if (p.hasSymlink()) {
            this.dumpINodeSymlink(p.getSymlink());
        }
    }

    private void dumpINodeSymlink(FsImageProto.INodeSection.INodeSymlink s) {
        this.o("permission", this.dumpPermission(s.getPermission())).o("target", s.getTarget().toStringUtf8()).o("mtime", s.getModificationTime()).o("atime", s.getAccessTime());
    }

    private void dumpNameSection(InputStream in) throws IOException {
        FsImageProto.NameSystemSection s = FsImageProto.NameSystemSection.parseDelimitedFrom(in);
        this.out.print("<NameSection>");
        this.o("namespaceId", s.getNamespaceId());
        this.o("genstampV1", s.getGenstampV1()).o("genstampV2", s.getGenstampV2()).o("genstampV1Limit", s.getGenstampV1Limit()).o("lastAllocatedBlockId", s.getLastAllocatedBlockId()).o("txid", s.getTransactionId());
        this.out.print("</NameSection>\n");
    }

    private String dumpPermission(long permission) {
        PermissionStatus permStatus = FSImageFormatPBINode.Loader.loadPermission(permission, this.stringTable);
        return String.format("%s:%s:%04o", permStatus.getUserName(), permStatus.getGroupName(), permStatus.getPermission().toExtendedShort());
    }

    private void dumpSecretManagerSection(InputStream is) throws IOException {
        int i;
        this.out.print("<SecretManagerSection>");
        FsImageProto.SecretManagerSection s = FsImageProto.SecretManagerSection.parseDelimitedFrom(is);
        int expectedNumDelegationKeys = s.getNumKeys();
        int expectedNumTokens = s.getNumTokens();
        this.o("currentId", s.getCurrentId()).o("tokenSequenceNumber", s.getTokenSequenceNumber()).o("numDelegationKeys", expectedNumDelegationKeys).o("numTokens", expectedNumTokens);
        for (i = 0; i < expectedNumDelegationKeys; ++i) {
            FsImageProto.SecretManagerSection.DelegationKey dkey = FsImageProto.SecretManagerSection.DelegationKey.parseDelimitedFrom(is);
            this.out.print("<delegationKey>");
            this.o("id", dkey.getId());
            this.o("key", Hex.encodeHexString((byte[])dkey.getKey().toByteArray()));
            if (dkey.hasExpiryDate()) {
                this.dumpDate("expiry", dkey.getExpiryDate());
            }
            this.out.print("</delegationKey>");
        }
        for (i = 0; i < expectedNumTokens; ++i) {
            FsImageProto.SecretManagerSection.PersistToken token = FsImageProto.SecretManagerSection.PersistToken.parseDelimitedFrom(is);
            this.out.print("<token>");
            if (token.hasVersion()) {
                this.o("version", token.getVersion());
            }
            if (token.hasOwner()) {
                this.o("owner", token.getOwner());
            }
            if (token.hasRenewer()) {
                this.o("renewer", token.getRenewer());
            }
            if (token.hasRealUser()) {
                this.o("realUser", token.getRealUser());
            }
            if (token.hasIssueDate()) {
                this.dumpDate("issueDate", token.getIssueDate());
            }
            if (token.hasMaxDate()) {
                this.dumpDate("maxDate", token.getMaxDate());
            }
            if (token.hasSequenceNumber()) {
                this.o("sequenceNumber", token.getSequenceNumber());
            }
            if (token.hasMasterKeyId()) {
                this.o("masterKeyId", token.getMasterKeyId());
            }
            if (token.hasExpiryDate()) {
                this.dumpDate("expiryDate", token.getExpiryDate());
            }
            this.out.print("</token>");
        }
        this.out.print("</SecretManagerSection>");
    }

    private void dumpDate(String tag, long date) {
        this.out.print("<" + tag + ">" + this.isoDateFormat.format(new Date(date)) + "</" + tag + ">");
    }

    private void dumpSnapshotDiffSection(InputStream in) throws IOException {
        FsImageProto.SnapshotDiffSection.DiffEntry e;
        this.out.print("<SnapshotDiffSection>");
        block12: while ((e = FsImageProto.SnapshotDiffSection.DiffEntry.parseDelimitedFrom(in)) != null) {
            switch (e.getType()) {
                case FILEDIFF: {
                    this.out.print("<fileDiffEntry>");
                    break;
                }
                case DIRECTORYDIFF: {
                    this.out.print("<dirDiffEntry>");
                    break;
                }
                default: {
                    throw new IOException("unknown DiffEntry type " + (Object)((Object)e.getType()));
                }
            }
            this.o("inodeId", e.getInodeId());
            this.o("count", e.getNumOfDiff());
            switch (e.getType()) {
                case FILEDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<fileDiff>");
                        FsImageProto.SnapshotDiffSection.FileDiff f = FsImageProto.SnapshotDiffSection.FileDiff.parseDelimitedFrom(in);
                        this.o("snapshotId", f.getSnapshotId()).o("size", f.getFileSize()).o("name", f.getName().toStringUtf8());
                        this.out.print("</fileDiff>\n");
                    }
                    break;
                }
                case DIRECTORYDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<dirDiff>");
                        FsImageProto.SnapshotDiffSection.DirectoryDiff d = FsImageProto.SnapshotDiffSection.DirectoryDiff.parseDelimitedFrom(in);
                        this.o("snapshotId", d.getSnapshotId()).o("childrenSize", d.getChildrenSize()).o("isSnapshotRoot", d.getIsSnapshotRoot()).o("name", d.getName().toStringUtf8()).o("createdListSize", d.getCreatedListSize());
                        Iterator<Number> i$ = d.getDeletedINodeList().iterator();
                        while (i$.hasNext()) {
                            long did = i$.next();
                            this.o("deletedInode", did);
                        }
                        i$ = d.getDeletedINodeRefList().iterator();
                        while (i$.hasNext()) {
                            int dRefid = (Integer)i$.next();
                            this.o("deletedInoderef", dRefid);
                        }
                        for (int j = 0; j < d.getCreatedListSize(); ++j) {
                            FsImageProto.SnapshotDiffSection.CreatedListEntry ce = FsImageProto.SnapshotDiffSection.CreatedListEntry.parseDelimitedFrom(in);
                            this.out.print("<created>");
                            this.o("name", ce.getName().toStringUtf8());
                            this.out.print("</created>\n");
                        }
                        this.out.print("</dirDiff>\n");
                    }
                    break;
                }
            }
            switch (e.getType()) {
                case FILEDIFF: {
                    this.out.print("</fileDiffEntry>");
                    continue block12;
                }
                case DIRECTORYDIFF: {
                    this.out.print("</dirDiffEntry>");
                    continue block12;
                }
            }
            throw new IOException("unknown DiffEntry type " + (Object)((Object)e.getType()));
        }
        this.out.print("</SnapshotDiffSection>\n");
    }

    private void dumpSnapshotSection(InputStream in) throws IOException {
        this.out.print("<SnapshotSection>");
        FsImageProto.SnapshotSection s = FsImageProto.SnapshotSection.parseDelimitedFrom(in);
        this.o("snapshotCounter", s.getSnapshotCounter());
        this.o("numSnapshots", s.getNumSnapshots());
        if (s.getSnapshottableDirCount() > 0) {
            this.out.print("<snapshottableDir>");
            for (long id : s.getSnapshottableDirList()) {
                this.o("dir", id);
            }
            this.out.print("</snapshottableDir>\n");
        }
        for (int i = 0; i < s.getNumSnapshots(); ++i) {
            FsImageProto.SnapshotSection.Snapshot pbs = FsImageProto.SnapshotSection.Snapshot.parseDelimitedFrom(in);
            this.out.print("<snapshot>");
            this.o("id", pbs.getSnapshotId());
            this.out.print("<root>");
            this.dumpINodeFields(pbs.getRoot());
            this.out.print("</root>");
            this.out.print("</snapshot>");
        }
        this.out.print("</SnapshotSection>\n");
    }

    private void loadStringTable(InputStream in) throws IOException {
        FsImageProto.StringTableSection s = FsImageProto.StringTableSection.parseDelimitedFrom(in);
        this.stringTable = new String[s.getNumEntry() + 1];
        for (int i = 0; i < s.getNumEntry(); ++i) {
            FsImageProto.StringTableSection.Entry e = FsImageProto.StringTableSection.Entry.parseDelimitedFrom(in);
            this.stringTable[e.getId()] = e.getStr();
        }
    }

    private PBImageXmlWriter o(String e, Object v) {
        if (v instanceof Boolean) {
            if (((Boolean)v).booleanValue()) {
                this.out.print("<" + e + "/>");
            }
            return this;
        }
        this.out.print("<" + e + ">" + XMLUtils.mangleXmlString(v.toString(), true) + "</" + e + ">");
        return this;
    }
}

