/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.io.netty.handler.codec.stomp;

import com.cloudera.io.netty.buffer.ByteBuf;
import com.cloudera.io.netty.channel.ChannelPipeline;
import com.cloudera.io.netty.handler.codec.MessageAggregator;
import com.cloudera.io.netty.handler.codec.stomp.DefaultStompFrame;
import com.cloudera.io.netty.handler.codec.stomp.LastStompContentSubframe;
import com.cloudera.io.netty.handler.codec.stomp.StompContentSubframe;
import com.cloudera.io.netty.handler.codec.stomp.StompFrame;
import com.cloudera.io.netty.handler.codec.stomp.StompHeaders;
import com.cloudera.io.netty.handler.codec.stomp.StompHeadersSubframe;
import com.cloudera.io.netty.handler.codec.stomp.StompSubframe;

public class StompSubframeAggregator
extends MessageAggregator<StompSubframe, StompHeadersSubframe, StompContentSubframe, StompFrame> {
    public StompSubframeAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    @Override
    protected boolean isStartMessage(StompSubframe msg) throws Exception {
        return msg instanceof StompHeadersSubframe;
    }

    @Override
    protected boolean isContentMessage(StompSubframe msg) throws Exception {
        return msg instanceof StompContentSubframe;
    }

    @Override
    protected boolean isLastContentMessage(StompContentSubframe msg) throws Exception {
        return msg instanceof LastStompContentSubframe;
    }

    @Override
    protected boolean isAggregated(StompSubframe msg) throws Exception {
        return msg instanceof StompFrame;
    }

    @Override
    protected boolean isContentLengthInvalid(StompHeadersSubframe start, int maxContentLength) {
        return (int)Math.min(Integer.MAX_VALUE, start.headers().getLong(StompHeaders.CONTENT_LENGTH, -1L)) > maxContentLength;
    }

    @Override
    protected Object newContinueResponse(StompHeadersSubframe start, int maxContentLength, ChannelPipeline pipeline) {
        return null;
    }

    @Override
    protected boolean closeAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean ignoreContentAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected StompFrame beginAggregation(StompHeadersSubframe start, ByteBuf content) throws Exception {
        DefaultStompFrame ret = new DefaultStompFrame(start.command(), content);
        ret.headers().set(start.headers());
        return ret;
    }
}

