/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.io.netty.handler.codec.base64;

import com.cloudera.io.netty.buffer.ByteBuf;
import com.cloudera.io.netty.channel.ChannelHandler;
import com.cloudera.io.netty.channel.ChannelHandlerContext;
import com.cloudera.io.netty.handler.codec.MessageToMessageEncoder;
import com.cloudera.io.netty.handler.codec.base64.Base64;
import com.cloudera.io.netty.handler.codec.base64.Base64Dialect;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

