/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.io.netty.handler.ipfilter;

import com.cloudera.io.netty.channel.ChannelFuture;
import com.cloudera.io.netty.channel.ChannelFutureListener;
import com.cloudera.io.netty.channel.ChannelHandler;
import com.cloudera.io.netty.channel.ChannelHandlerContext;
import com.cloudera.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import com.cloudera.io.netty.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

