/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SlowPeerTracker {
    public static final Logger LOG = LoggerFactory.getLogger(SlowPeerTracker.class);
    private final long reportValidityMs;
    private final Timer timer;
    private static final int MAX_NODES_TO_REPORT = 5;
    private final ConcurrentMap<String, ConcurrentMap<String, Long>> allReports;

    public SlowPeerTracker(Configuration conf, Timer timer) {
        this.timer = timer;
        this.allReports = new ConcurrentHashMap<String, ConcurrentMap<String, Long>>();
        this.reportValidityMs = conf.getTimeDuration("dfs.datanode.outliers.report.interval", "30m", TimeUnit.MILLISECONDS) * 3L;
    }

    public void addReport(String slowNode, String reportingNode) {
        ConcurrentMap nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        if (nodeEntries == null) {
            this.allReports.putIfAbsent(slowNode, new ConcurrentHashMap());
            nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        }
        nodeEntries.put(reportingNode, this.timer.monotonicNow());
    }

    public Set<String> getReportsForNode(String slowNode) {
        ConcurrentMap nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        if (nodeEntries == null || nodeEntries.isEmpty()) {
            return Collections.emptySet();
        }
        return this.filterNodeReports(nodeEntries, this.timer.monotonicNow());
    }

    public Map<String, SortedSet<String>> getReportsForAllDataNodes() {
        if (this.allReports.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap<String, SortedSet<String>> allNodesValidReports = new HashMap<String, SortedSet<String>>();
        long now = this.timer.monotonicNow();
        for (Map.Entry entry : this.allReports.entrySet()) {
            SortedSet<String> validReports = this.filterNodeReports((ConcurrentMap)entry.getValue(), now);
            if (validReports.isEmpty()) continue;
            allNodesValidReports.put((String)entry.getKey(), validReports);
        }
        return allNodesValidReports;
    }

    private SortedSet<String> filterNodeReports(ConcurrentMap<String, Long> reports, long now) {
        TreeSet<String> validReports = new TreeSet<String>();
        for (Map.Entry entry : reports.entrySet()) {
            if (now - (Long)entry.getValue() >= this.reportValidityMs) continue;
            validReports.add((String)entry.getKey());
        }
        return validReports;
    }

    public String getJson() {
        Collection<ReportForJson> validReports = this.getJsonReports(5);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(validReports);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Failed to serialize statistics" + (Object)((Object)e));
            return null;
        }
    }

    private Collection<ReportForJson> getJsonReports(int numNodes) {
        if (this.allReports.isEmpty()) {
            return Collections.emptyList();
        }
        PriorityQueue<ReportForJson> topNReports = new PriorityQueue<ReportForJson>(this.allReports.size(), new Comparator<ReportForJson>(){

            @Override
            public int compare(ReportForJson o1, ReportForJson o2) {
                return Ints.compare((int)o1.reportingNodes.size(), (int)o2.reportingNodes.size());
            }
        });
        long now = this.timer.monotonicNow();
        for (Map.Entry entry : this.allReports.entrySet()) {
            SortedSet<String> validReports = this.filterNodeReports((ConcurrentMap)entry.getValue(), now);
            if (validReports.isEmpty()) continue;
            if (topNReports.size() < numNodes) {
                topNReports.add(new ReportForJson((String)entry.getKey(), validReports));
                continue;
            }
            if (topNReports.peek().getReportingNodes().size() >= validReports.size()) continue;
            topNReports.poll();
            topNReports.add(new ReportForJson((String)entry.getKey(), validReports));
        }
        return topNReports;
    }

    @VisibleForTesting
    long getReportValidityMs() {
        return this.reportValidityMs;
    }

    public static class ReportForJson {
        @JsonProperty(value="SlowNode")
        private final String slowNode;
        @JsonProperty(value="ReportingNodes")
        private final SortedSet<String> reportingNodes;

        public ReportForJson(@JsonProperty(value="SlowNode") String slowNode, @JsonProperty(value="ReportingNodes") SortedSet<String> reportingNodes) {
            this.slowNode = slowNode;
            this.reportingNodes = reportingNodes;
        }

        public String getSlowNode() {
            return this.slowNode;
        }

        public SortedSet<String> getReportingNodes() {
            return this.reportingNodes;
        }
    }
}

