/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetAsyncDiskService;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetCache;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImplBuilder;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskAsyncLazyPersistService;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.VolumeFailureInfo;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetricHelper;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.InstrumentedLock;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class FsDatasetImpl
implements FsDatasetSpi<FsVolumeImpl> {
    static final Logger LOG = LoggerFactory.getLogger(FsDatasetImpl.class);
    private static final boolean isNativeIOAvailable = NativeIO.isAvailable();
    private Timer timer;
    final DataNode datanode;
    final DataStorage dataStorage;
    private final FsVolumeList volumes;
    final Map<String, DatanodeStorage> storageMap;
    final FsDatasetAsyncDiskService asyncDiskService;
    final Daemon lazyWriter;
    final FsDatasetCache cacheManager;
    private final Configuration conf;
    private final int volFailuresTolerated;
    private final int volsConfigured;
    private volatile boolean fsRunning = true;
    final ReplicaMap volumeMap;
    final Map<String, Set<Long>> deletingBlock;
    final RamDiskReplicaTracker ramDiskReplicaTracker;
    final RamDiskAsyncLazyPersistService asyncLazyPersistService;
    private static final int MAX_BLOCK_EVICTIONS_PER_ITERATION = 3;
    private final int smallBufferSize;
    final LocalFileSystem localFS;
    private boolean blockPinningEnabled;
    private final int maxDataLength;
    @VisibleForTesting
    final AutoCloseableLock datasetLock;
    private final Condition datasetLockCondition;
    private ObjectName mbeanName;

    @Override
    public FsDatasetSpi.FsVolumeReferences getFsVolumeReferences() {
        return new FsDatasetSpi.FsVolumeReferences(this.volumes.getVolumes());
    }

    @Override
    public DatanodeStorage getStorage(String storageUuid) {
        return this.storageMap.get(storageUuid);
    }

    @Override
    public StorageReport[] getStorageReports(String bpid) throws IOException {
        List<FsVolumeImpl> curVolumes = this.volumes.getVolumes();
        ArrayList<StorageReport> reports = new ArrayList<StorageReport>(curVolumes.size());
        for (FsVolumeImpl volume : curVolumes) {
            try {
                FsVolumeReference ref = volume.obtainReference();
                Throwable throwable = null;
                try {
                    StorageReport sr = new StorageReport(volume.toDatanodeStorage(), false, volume.getCapacity(), volume.getDfsUsed(), volume.getAvailable(), volume.getBlockPoolUsed(bpid), volume.getNonDfsUsed());
                    reports.add(sr);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (ClosedChannelException e) {}
        }
        return reports.toArray(new StorageReport[reports.size()]);
    }

    @Override
    public FsVolumeImpl getVolume(ExtendedBlock b) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
            FsVolumeImpl fsVolumeImpl = r != null ? (FsVolumeImpl)r.getVolume() : null;
            return fsVolumeImpl;
        }
    }

    @Override
    public Block getStoredBlock(String bpid, long blkid) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo r = this.volumeMap.get(bpid, blkid);
            if (r == null) {
                Block block = null;
                return block;
            }
            Block block = new Block(blkid, r.getBytesOnDisk(), r.getGenerationStamp());
            return block;
        }
    }

    ReplicaInfo fetchReplicaInfo(String bpid, long blockId) {
        ReplicaInfo r = this.volumeMap.get(bpid, blockId);
        if (r == null) {
            return null;
        }
        switch (r.getState()) {
            case FINALIZED: 
            case RBW: 
            case RWR: 
            case RUR: 
            case TEMPORARY: {
                return new ReplicaBuilder(r.getState()).from(r).build();
            }
        }
        return null;
    }

    @Override
    public LengthInputStream getMetaDataInputStream(ExtendedBlock b) throws IOException {
        ReplicaInfo info = this.getBlockReplica(b);
        if (info == null || !info.metadataExists()) {
            return null;
        }
        return info.getMetadataInputStream(0L);
    }

    FsDatasetImpl(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
        this.datanode = datanode;
        this.dataStorage = storage;
        this.conf = conf;
        this.smallBufferSize = DFSUtilClient.getSmallBufferSize((Configuration)conf);
        this.datasetLock = new AutoCloseableLock((Lock)new InstrumentedLock(this.getClass().getName(), LOG, (Lock)new ReentrantLock(true), conf.getTimeDuration("dfs.lock.suppress.warning.interval", 10000L, TimeUnit.MILLISECONDS), 300L));
        this.datasetLockCondition = this.datasetLock.newCondition();
        this.volFailuresTolerated = datanode.getDnConf().getVolFailuresTolerated();
        List<StorageLocation> dataLocations = DataNode.getStorageLocations(conf);
        List<VolumeFailureInfo> volumeFailureInfos = FsDatasetImpl.getInitialVolumeFailureInfos(dataLocations, storage);
        this.volsConfigured = datanode.getDnConf().getVolsConfigured();
        int volsFailed = volumeFailureInfos.size();
        if (this.volFailuresTolerated < -1 || this.volFailuresTolerated >= this.volsConfigured) {
            throw new DiskChecker.DiskErrorException("Invalid value configured for dfs.datanode.failed.volumes.tolerated - " + this.volFailuresTolerated + ". Value configured is either less than maxVolumeFailureLimit or greater than to the number of configured volumes (" + this.volsConfigured + ").");
        }
        if (this.volFailuresTolerated == -1 ? this.volsConfigured == volsFailed : volsFailed > this.volFailuresTolerated) {
            throw new DiskChecker.DiskErrorException("Too many failed volumes - current valid volumes: " + storage.getNumStorageDirs() + ", volumes configured: " + this.volsConfigured + ", volumes failed: " + volsFailed + ", volume failures tolerated: " + this.volFailuresTolerated);
        }
        this.storageMap = new ConcurrentHashMap<String, DatanodeStorage>();
        this.volumeMap = new ReplicaMap(this.datasetLock);
        this.ramDiskReplicaTracker = RamDiskReplicaTracker.getInstance(conf, this);
        VolumeChoosingPolicy blockChooserImpl = (VolumeChoosingPolicy)ReflectionUtils.newInstance((Class)conf.getClass("dfs.datanode.fsdataset.volume.choosing.policy", RoundRobinVolumeChoosingPolicy.class, VolumeChoosingPolicy.class), (Configuration)conf);
        this.volumes = new FsVolumeList(volumeFailureInfos, datanode.getBlockScanner(), blockChooserImpl);
        this.asyncDiskService = new FsDatasetAsyncDiskService(datanode, this);
        this.asyncLazyPersistService = new RamDiskAsyncLazyPersistService(datanode, conf);
        this.deletingBlock = new HashMap<String, Set<Long>>();
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            this.addVolume(storage.getStorageDir(idx));
        }
        this.setupAsyncLazyPersistThreads();
        this.cacheManager = new FsDatasetCache(this);
        if (this.ramDiskReplicaTracker.numReplicasNotPersisted() > 0 || datanode.getDnConf().getMaxLockedMemory() > 0L) {
            this.lazyWriter = new Daemon((Runnable)new LazyWriter(conf));
            this.lazyWriter.start();
        } else {
            this.lazyWriter = null;
        }
        this.registerMBean(datanode.getDatanodeUuid());
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register("FSDatasetState", "FSDatasetState", (Object)this);
        this.localFS = FileSystem.getLocal((Configuration)conf);
        this.blockPinningEnabled = conf.getBoolean("dfs.datanode.block-pinning.enabled", false);
        this.maxDataLength = conf.getInt("ipc.maximum.data.length", 0x4000000);
    }

    @Override
    public AutoCloseableLock acquireDatasetLock() {
        return this.datasetLock.acquire();
    }

    private static List<VolumeFailureInfo> getInitialVolumeFailureInfos(Collection<StorageLocation> dataLocations, DataStorage storage) {
        HashSet failedLocationSet = Sets.newHashSetWithExpectedSize((int)dataLocations.size());
        for (StorageLocation sl : dataLocations) {
            failedLocationSet.add(sl);
        }
        Iterator<Storage.StorageDirectory> it = storage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            failedLocationSet.remove(sd.getStorageLocation());
        }
        ArrayList volumeFailureInfos = Lists.newArrayListWithCapacity((int)failedLocationSet.size());
        long failureDate = Time.now();
        for (StorageLocation failedStorageLocation : failedLocationSet) {
            volumeFailureInfos.add(new VolumeFailureInfo(failedStorageLocation, failureDate));
        }
        return volumeFailureInfos;
    }

    private void activateVolume(ReplicaMap replicaMap, Storage.StorageDirectory sd, StorageType storageType, FsVolumeReference ref) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            DatanodeStorage dnStorage = this.storageMap.get(sd.getStorageUuid());
            if (dnStorage != null) {
                String errorMsg = String.format("Found duplicated storage UUID: %s in %s.", sd.getStorageUuid(), sd.getVersionFile());
                LOG.error(errorMsg);
                throw new IOException(errorMsg);
            }
            this.volumeMap.mergeAll(replicaMap);
            this.storageMap.put(sd.getStorageUuid(), new DatanodeStorage(sd.getStorageUuid(), DatanodeStorage.State.NORMAL, storageType));
            this.asyncDiskService.addVolume((FsVolumeImpl)ref.getVolume());
            this.volumes.addVolume(ref);
        }
    }

    private void addVolume(Storage.StorageDirectory sd) throws IOException {
        StorageLocation storageLocation = sd.getStorageLocation();
        FsVolumeImpl fsVolume = new FsVolumeImplBuilder().setDataset(this).setStorageID(sd.getStorageUuid()).setStorageDirectory(sd).setFileIoProvider(this.datanode.getFileIoProvider()).setConf(this.conf).build();
        FsVolumeReference ref = fsVolume.obtainReference();
        ReplicaMap tempVolumeMap = new ReplicaMap(this.datasetLock);
        fsVolume.getVolumeMap(tempVolumeMap, this.ramDiskReplicaTracker);
        this.activateVolume(tempVolumeMap, sd, storageLocation.getStorageType(), ref);
        LOG.info("Added volume - " + storageLocation + ", StorageType: " + storageLocation.getStorageType());
    }

    @VisibleForTesting
    public FsVolumeImpl createFsVolume(String storageUuid, Storage.StorageDirectory sd, StorageLocation location) throws IOException {
        return new FsVolumeImplBuilder().setDataset(this).setStorageID(storageUuid).setStorageDirectory(sd).setFileIoProvider(this.datanode.getFileIoProvider()).setConf(this.conf).build();
    }

    @Override
    public void addVolume(StorageLocation location, List<NamespaceInfo> nsInfos) throws IOException {
        DataStorage.VolumeBuilder builder;
        try {
            builder = this.dataStorage.prepareVolume(this.datanode, location, nsInfos);
        }
        catch (IOException e) {
            this.volumes.addVolumeFailureInfo(new VolumeFailureInfo(location, Time.now()));
            throw e;
        }
        Storage.StorageDirectory sd = builder.getStorageDirectory();
        StorageType storageType = location.getStorageType();
        FsVolumeImpl fsVolume = this.createFsVolume(sd.getStorageUuid(), sd, location);
        ReplicaMap tempVolumeMap = new ReplicaMap(new AutoCloseableLock());
        ArrayList exceptions = Lists.newArrayList();
        for (NamespaceInfo nsInfo : nsInfos) {
            String bpid = nsInfo.getBlockPoolID();
            try {
                fsVolume.addBlockPool(bpid, this.conf, this.timer);
                fsVolume.getVolumeMap(bpid, tempVolumeMap, this.ramDiskReplicaTracker);
            }
            catch (IOException e) {
                LOG.warn("Caught exception when adding " + fsVolume + ". Will throw later.", (Throwable)e);
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            try {
                sd.unlock();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            throw MultipleIOException.createIOException((List)exceptions);
        }
        FsVolumeReference ref = fsVolume.obtainReference();
        this.setupAsyncLazyPersistThread(fsVolume);
        builder.build();
        this.activateVolume(tempVolumeMap, sd, storageType, ref);
        LOG.info("Added volume - " + location + ", StorageType: " + storageType);
    }

    @Override
    public void removeVolumes(Collection<StorageLocation> storageLocsToRemove, boolean clearFailure) {
        ArrayList<StorageLocation> storageLocationsToRemove = new ArrayList<StorageLocation>(storageLocsToRemove);
        HashMap blkToInvalidate = new HashMap();
        ArrayList<String> storageToRemove = new ArrayList<String>();
        Throwable throwable = null;
        try (Object lock = this.datasetLock.acquire();){
            for (int idx = 0; idx < this.dataStorage.getNumStorageDirs(); ++idx) {
                Storage.StorageDirectory sd = this.dataStorage.getStorageDir(idx);
                StorageLocation sdLocation = sd.getStorageLocation();
                LOG.info("Checking removing StorageLocation " + sdLocation + " with id " + sd.getStorageUuid());
                if (!storageLocationsToRemove.contains(sdLocation)) continue;
                LOG.info("Removing StorageLocation " + sdLocation + " with id " + sd.getStorageUuid() + " from FsDataset.");
                this.asyncDiskService.removeVolume(sd.getStorageUuid());
                this.volumes.removeVolume(sdLocation, clearFailure);
                this.volumes.waitVolumeRemoved(5000, this.datasetLockCondition);
                for (String bpid : this.volumeMap.getBlockPoolList()) {
                    ArrayList<ReplicaInfo> blocks = new ArrayList<ReplicaInfo>();
                    Iterator<ReplicaInfo> it = this.volumeMap.replicas(bpid).iterator();
                    while (it.hasNext()) {
                        ReplicaInfo block = it.next();
                        StorageLocation blockStorageLocation = block.getVolume().getStorageLocation();
                        LOG.trace("checking for block " + block.getBlockId() + " with storageLocation " + blockStorageLocation);
                        if (!blockStorageLocation.equals(sdLocation)) continue;
                        blocks.add(block);
                        it.remove();
                    }
                    blkToInvalidate.put(bpid, blocks);
                }
                storageToRemove.add(sd.getStorageUuid());
                storageLocationsToRemove.remove(sdLocation);
            }
            if (clearFailure) {
                for (StorageLocation storageLocToRemove : storageLocationsToRemove) {
                    this.volumes.removeVolumeFailureInfo(storageLocToRemove);
                }
            }
            this.setupAsyncLazyPersistThreads();
        }
        catch (Throwable idx) {
            Throwable throwable2 = idx;
            throw idx;
        }
        for (Map.Entry entry : blkToInvalidate.entrySet()) {
            String bpid = (String)entry.getKey();
            List blocks = (List)entry.getValue();
            for (ReplicaInfo block : blocks) {
                this.invalidate(bpid, block);
            }
        }
        lock = this.datasetLock.acquire();
        Throwable throwable3 = null;
        try {
            for (String storageUuid : storageToRemove) {
                this.storageMap.remove(storageUuid);
            }
        }
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            throw throwable4;
        }
        finally {
            if (lock != null) {
                if (throwable3 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable6) {
                        throwable3.addSuppressed(throwable6);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    @Override
    public long getDfsUsed() throws IOException {
        return this.volumes.getDfsUsed();
    }

    @Override
    public long getBlockPoolUsed(String bpid) throws IOException {
        return this.volumes.getBlockPoolUsed(bpid);
    }

    @Override
    public boolean hasEnoughResource() {
        if (this.volFailuresTolerated == -1) {
            return this.volumes.getVolumes().size() >= 1;
        }
        return this.getNumFailedVolumes() <= this.volFailuresTolerated;
    }

    @Override
    public long getCapacity() throws IOException {
        return this.volumes.getCapacity();
    }

    @Override
    public long getRemaining() throws IOException {
        return this.volumes.getRemaining();
    }

    @Override
    public int getNumFailedVolumes() {
        return this.volumes.getVolumeFailureInfos().length;
    }

    @Override
    public String[] getFailedStorageLocations() {
        VolumeFailureInfo[] infos = this.volumes.getVolumeFailureInfos();
        ArrayList failedStorageLocations = Lists.newArrayListWithCapacity((int)infos.length);
        for (VolumeFailureInfo info : infos) {
            failedStorageLocations.add(info.getFailedStorageLocation().getNormalizedUri().toString());
        }
        return failedStorageLocations.toArray(new String[failedStorageLocations.size()]);
    }

    @Override
    public long getLastVolumeFailureDate() {
        long lastVolumeFailureDate = 0L;
        for (VolumeFailureInfo info : this.volumes.getVolumeFailureInfos()) {
            long failureDate = info.getFailureDate();
            if (failureDate <= lastVolumeFailureDate) continue;
            lastVolumeFailureDate = failureDate;
        }
        return lastVolumeFailureDate;
    }

    @Override
    public long getEstimatedCapacityLostTotal() {
        long estimatedCapacityLostTotal = 0L;
        for (VolumeFailureInfo info : this.volumes.getVolumeFailureInfos()) {
            estimatedCapacityLostTotal += info.getEstimatedCapacityLost();
        }
        return estimatedCapacityLostTotal;
    }

    @Override
    public VolumeFailureSummary getVolumeFailureSummary() {
        VolumeFailureInfo[] infos = this.volumes.getVolumeFailureInfos();
        if (infos.length == 0) {
            return null;
        }
        ArrayList failedStorageLocations = Lists.newArrayListWithCapacity((int)infos.length);
        long lastVolumeFailureDate = 0L;
        long estimatedCapacityLostTotal = 0L;
        for (VolumeFailureInfo info : infos) {
            failedStorageLocations.add(info.getFailedStorageLocation().getNormalizedUri().toString());
            long failureDate = info.getFailureDate();
            if (failureDate > lastVolumeFailureDate) {
                lastVolumeFailureDate = failureDate;
            }
            estimatedCapacityLostTotal += info.getEstimatedCapacityLost();
        }
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), lastVolumeFailureDate, estimatedCapacityLostTotal);
    }

    @Override
    public long getCacheUsed() {
        return this.cacheManager.getCacheUsed();
    }

    @Override
    public long getCacheCapacity() {
        return this.cacheManager.getCacheCapacity();
    }

    @Override
    public long getNumBlocksFailedToCache() {
        return this.cacheManager.getNumBlocksFailedToCache();
    }

    @Override
    public long getNumBlocksFailedToUncache() {
        return this.cacheManager.getNumBlocksFailedToUncache();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        try {
            DataNodeMetricHelper.getMetrics(collector, this, "FSDatasetState");
        }
        catch (Exception e) {
            LOG.warn("Exception thrown while metric collection. Exception : " + e.getMessage());
        }
    }

    @Override
    public long getNumBlocksCached() {
        return this.cacheManager.getNumBlocksCached();
    }

    @Override
    public long getLength(ExtendedBlock b) throws IOException {
        return this.getBlockReplica(b).getBlockDataLength();
    }

    private ReplicaInfo getBlockReplica(ExtendedBlock b) throws IOException {
        return this.getBlockReplica(b.getBlockPoolId(), b.getBlockId());
    }

    ReplicaInfo getBlockReplica(String bpid, long blockId) throws IOException {
        ReplicaInfo r = this.validateBlockFile(bpid, blockId);
        if (r == null) {
            throw new FileNotFoundException("BlockId " + blockId + " is not valid.");
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
        ReplicaInfo info;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            info = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        }
        if (info != null && info.getVolume().isTransientStorage()) {
            this.ramDiskReplicaTracker.touch(b.getBlockPoolId(), b.getBlockId());
            this.datanode.getMetrics().incrRamDiskBlocksReadHits();
        }
        if (info != null && info.blockDataExists()) {
            return info.getDataInputStream(seekOffset);
        }
        throw new IOException("No data exists for block " + b);
    }

    ReplicaInfo getReplicaInfo(ExtendedBlock b) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (info == null) {
            if (this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock().getBlockId()) == null) {
                throw new ReplicaNotFoundException("Replica does not exist " + b);
            }
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpected generation stamp " + b);
        }
        return info;
    }

    @VisibleForTesting
    ReplicaInfo getReplicaInfo(String bpid, long blkid) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(bpid, blkid);
        if (info == null) {
            throw new ReplicaNotFoundException("Replica does not exist " + bpid + ":" + blkid);
        }
        return info;
    }

    @Override
    public ReplicaInputStreams getTmpInputStreams(ExtendedBlock b, long blkOffset, long metaOffset) throws IOException {
        Throwable throwable = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo info = this.getReplicaInfo(b);
            FsVolumeReference ref = info.getVolume().obtainReference();
            InputStream blockInStream = info.getDataInputStream(blkOffset);
            try {
                LengthInputStream metaInStream = info.getMetadataInputStream(metaOffset);
                ReplicaInputStreams replicaInputStreams = new ReplicaInputStreams(blockInStream, metaInStream, ref, this.datanode.getFileIoProvider());
                return replicaInputStreams;
            }
            catch (IOException e) {
                try {
                    try {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{blockInStream});
                        throw e;
                    }
                    catch (IOException e2) {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                        throw e2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    static File moveBlockFiles(Block b, ReplicaInfo replicaInfo, File destdir) throws IOException {
        File dstfile = new File(destdir, b.getBlockName());
        File dstmeta = FsDatasetUtil.getMetaFile(dstfile, b.getGenerationStamp());
        try {
            replicaInfo.renameMeta(dstmeta.toURI());
        }
        catch (IOException e) {
            throw new IOException("Failed to move meta file for " + b + " from " + replicaInfo.getMetadataURI() + " to " + dstmeta, e);
        }
        try {
            replicaInfo.renameData(dstfile.toURI());
        }
        catch (IOException e) {
            throw new IOException("Failed to move block file for " + b + " from " + replicaInfo.getBlockURI() + " to " + dstfile.getAbsolutePath(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("addFinalizedBlock: Moved " + replicaInfo.getMetadataURI() + " to " + dstmeta + " and " + replicaInfo.getBlockURI() + " to " + dstfile);
        }
        return dstfile;
    }

    static File[] copyBlockFiles(long blockId, long genStamp, ReplicaInfo srcReplica, File destRoot, boolean calculateChecksum, int smallBufferSize, Configuration conf) throws IOException {
        File destDir = DatanodeUtil.idToBlockDir(destRoot, blockId);
        File dstFile = new File(destDir, srcReplica.getBlockName());
        File dstMeta = FsDatasetUtil.getMetaFile(dstFile, genStamp);
        return FsDatasetImpl.copyBlockFiles(srcReplica, dstMeta, dstFile, calculateChecksum, smallBufferSize, conf);
    }

    static File[] copyBlockFiles(ReplicaInfo srcReplica, File dstMeta, File dstFile, boolean calculateChecksum, int smallBufferSize, Configuration conf) throws IOException {
        if (calculateChecksum) {
            FsDatasetImpl.computeChecksum(srcReplica, dstMeta, smallBufferSize, conf);
        } else {
            try {
                srcReplica.copyMetadata(dstMeta.toURI());
            }
            catch (IOException e) {
                throw new IOException("Failed to copy " + srcReplica + " metadata to " + dstMeta, e);
            }
        }
        try {
            srcReplica.copyBlockdata(dstFile.toURI());
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + srcReplica + " block file to " + dstFile, e);
        }
        if (LOG.isDebugEnabled()) {
            if (calculateChecksum) {
                LOG.debug("Copied " + srcReplica.getMetadataURI() + " meta to " + dstMeta + " and calculated checksum");
            } else {
                LOG.debug("Copied " + srcReplica.getBlockURI() + " to " + dstFile);
            }
        }
        return new File[]{dstMeta, dstFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaInfo moveBlockAcrossStorage(ExtendedBlock block, StorageType targetStorageType, String targetStorageId) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(block);
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + block);
        }
        if (replicaInfo.getNumBytes() != block.getNumBytes()) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + block.getNumBytes());
        }
        if (replicaInfo.getVolume().getStorageType() == targetStorageType) {
            throw new ReplicaAlreadyExistsException("Replica " + replicaInfo + " already exists on storage " + targetStorageType);
        }
        if (replicaInfo.isOnTransientStorage()) {
            throw new IOException("Replica " + replicaInfo + " cannot be moved from storageType : " + replicaInfo.getVolume().getStorageType());
        }
        FsVolumeReference volumeRef = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            volumeRef = this.volumes.getNextVolume(targetStorageType, targetStorageId, block.getNumBytes());
        }
        try {
            this.moveBlock(block, replicaInfo, volumeRef);
        }
        finally {
            if (volumeRef != null) {
                volumeRef.close();
            }
        }
        return replicaInfo;
    }

    private ReplicaInfo moveBlock(ExtendedBlock block, ReplicaInfo replicaInfo, FsVolumeReference volumeRef) throws IOException {
        FsVolumeImpl targetVolume = (FsVolumeImpl)volumeRef.getVolume();
        ReplicaInfo newReplicaInfo = targetVolume.moveBlockToTmpLocation(block, replicaInfo, this.smallBufferSize, this.conf);
        newReplicaInfo = this.finalizeReplica(block.getBlockPoolId(), newReplicaInfo);
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            FsVolumeImpl volume = (FsVolumeImpl)newReplicaInfo.getVolume();
            volume.incrNumBlocks(block.getBlockPoolId());
        }
        this.removeOldReplica(replicaInfo, newReplicaInfo, block.getBlockPoolId());
        return newReplicaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaInfo moveBlockAcrossVolumes(ExtendedBlock block, FsVolumeSpi destination) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(block);
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + block);
        }
        FsVolumeReference volumeRef = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            volumeRef = destination.obtainReference();
        }
        try {
            this.moveBlock(block, replicaInfo, volumeRef);
        }
        finally {
            if (volumeRef != null) {
                volumeRef.close();
            }
        }
        return replicaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeChecksum(ReplicaInfo srcReplica, File dstMeta, int smallBufferSize, Configuration conf) throws IOException {
        DataChecksum checksum;
        File srcMeta = new File(srcReplica.getMetadataURI());
        try (FileInputStream fis = srcReplica.getFileIoProvider().getFileInputStream(srcReplica.getVolume(), srcMeta);){
            checksum = BlockMetadataHeader.readDataChecksum((FileInputStream)fis, (int)DFSUtilClient.getIoFileBufferSize((Configuration)conf), (File)srcMeta);
        }
        byte[] data = new byte[65536];
        byte[] crcs = new byte[checksum.getChecksumSize(data.length)];
        DataOutputStream metaOut = null;
        try {
            File parentFile = dstMeta.getParentFile();
            if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
                throw new IOException("Destination '" + parentFile + "' directory cannot be created");
            }
            metaOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dstMeta), smallBufferSize));
            BlockMetadataHeader.writeHeader((DataOutputStream)metaOut, (DataChecksum)checksum);
            int offset = 0;
            try (InputStream dataIn = srcReplica.getDataInputStream(0L);){
                int n;
                while ((n = dataIn.read(data, offset, data.length - offset)) != -1) {
                    int length;
                    if (n <= 0 || (length = (n += offset) - (offset = n % checksum.getBytesPerChecksum())) <= 0) continue;
                    checksum.calculateChunkedSums(data, 0, length, crcs, 0);
                    metaOut.write(crcs, 0, checksum.getChecksumSize(length));
                    System.arraycopy(data, length, data, 0, offset);
                }
            }
            checksum.calculateChunkedSums(data, 0, offset, crcs, 0);
            metaOut.write(crcs, 0, 4);
            metaOut.close();
            metaOut = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(metaOut);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)metaOut);
    }

    @Override
    public ReplicaHandler append(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            if (newGS < b.getGenerationStamp()) {
                throw new IOException("The new generation stamp " + newGS + " should be greater than the replica " + b + "'s generation stamp");
            }
            ReplicaInfo replicaInfo = this.getReplicaInfo(b);
            LOG.info("Appending to " + replicaInfo);
            if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
                throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + b);
            }
            if (replicaInfo.getNumBytes() != expectedBlockLen) {
                throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + expectedBlockLen);
            }
            FsVolumeReference ref = replicaInfo.getVolume().obtainReference();
            ReplicaInPipeline replica = null;
            try {
                replica = this.append(b.getBlockPoolId(), replicaInfo, newGS, b.getNumBytes());
            }
            catch (IOException e) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                throw e;
            }
            ReplicaHandler replicaHandler = new ReplicaHandler(replica, ref);
            return replicaHandler;
        }
    }

    private ReplicaInPipeline append(String bpid, ReplicaInfo replicaInfo, long newGS, long estimateBlockLen) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
                throw new IOException("Only a Finalized replica can be appended to; Replica with blk id " + replicaInfo.getBlockId() + " has state " + (Object)((Object)replicaInfo.getState()));
            }
            this.cacheManager.uncacheBlock(bpid, replicaInfo.getBlockId());
            replicaInfo.breakHardLinksIfNeeded();
            FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
            ReplicaInPipeline rip = v.append(bpid, replicaInfo, newGS, estimateBlockLen);
            if (rip.getReplicaInfo().getState() != HdfsServerConstants.ReplicaState.RBW) {
                throw new IOException("Append on block " + replicaInfo.getBlockId() + " returned a replica of state " + (Object)((Object)rip.getReplicaInfo().getState()) + "; expected RBW");
            }
            this.volumeMap.add(bpid, rip.getReplicaInfo());
            ReplicaInPipeline replicaInPipeline = rip;
            return replicaInPipeline;
        }
    }

    private ReplicaInfo recoverCheck(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException, MustStopExistingWriter {
        ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover append/close to a replica that's not FINALIZED and not RBW " + replicaInfo);
        }
        long replicaGenerationStamp = replicaInfo.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpected generation stamp " + replicaGenerationStamp + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        long replicaLen = replicaInfo.getNumBytes();
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW) {
            ReplicaInPipeline rbw = (ReplicaInPipeline)((Object)replicaInfo);
            if (!rbw.attemptToSetWriter(null, Thread.currentThread())) {
                throw new MustStopExistingWriter(rbw);
            }
            if (replicaLen != rbw.getBytesOnDisk() || replicaLen != rbw.getBytesAcked()) {
                throw new ReplicaAlreadyExistsException("RBW replica " + replicaInfo + "bytesRcvd(" + rbw.getNumBytes() + "), bytesOnDisk(" + rbw.getBytesOnDisk() + "), and bytesAcked(" + rbw.getBytesAcked() + ") are not the same.");
            }
        }
        if (replicaLen != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaLen + " expected length is " + expectedBlockLen);
        }
        return replicaInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReplicaHandler recoverAppend(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        LOG.info("Recover failed append to " + b);
        while (true) {
            try (AutoCloseableLock lock = this.datasetLock.acquire();){
                ReplicaInPipeline replica;
                ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
                FsVolumeReference ref = replicaInfo.getVolume().obtainReference();
                try {
                    if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
                        replica = this.append(b.getBlockPoolId(), replicaInfo, newGS, b.getNumBytes());
                    } else {
                        replicaInfo.bumpReplicaGS(newGS);
                        replica = (ReplicaInPipeline)((Object)replicaInfo);
                    }
                }
                catch (IOException e) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                    throw e;
                }
                ReplicaHandler replicaHandler = new ReplicaHandler(replica, ref);
                return replicaHandler;
            }
            catch (MustStopExistingWriter e) {
                e.getReplicaInPipeline().stopWriter(this.datanode.getDnConf().getXceiverStopTimeout());
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Replica recoverClose(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        LOG.info("Recover failed close " + b);
        while (true) {
            try (AutoCloseableLock lock = this.datasetLock.acquire();){
                ReplicaInfo replicaInfo2 = this.recoverCheck(b, newGS, expectedBlockLen);
                replicaInfo2.bumpReplicaGS(newGS);
                if (replicaInfo2.getState() == HdfsServerConstants.ReplicaState.RBW) {
                    this.finalizeReplica(b.getBlockPoolId(), replicaInfo2);
                }
                ReplicaInfo replicaInfo = replicaInfo2;
                return replicaInfo;
            }
            catch (MustStopExistingWriter e) {
                e.getReplicaInPipeline().stopWriter(this.datanode.getDnConf().getXceiverStopTimeout());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaHandler createRbw(StorageType storageType, String storageId, ExtendedBlock b, boolean allowLazyPersist) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInPipeline newReplicaInfo;
            ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
            if (replicaInfo != null) {
                throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
            }
            FsVolumeReference ref = null;
            if (allowLazyPersist && this.lazyWriter != null && b.getNumBytes() % this.cacheManager.getOsPageSize() == 0L && this.reserveLockedMemory(b.getNumBytes())) {
                try {
                    ref = this.volumes.getNextTransientVolume(b.getNumBytes());
                    this.datanode.getMetrics().incrRamDiskBlocksWrite();
                }
                catch (DiskChecker.DiskOutOfSpaceException diskOutOfSpaceException) {
                }
                finally {
                    if (ref == null) {
                        this.cacheManager.release(b.getNumBytes());
                    }
                }
            }
            if (ref == null) {
                ref = this.volumes.getNextVolume(storageType, storageId, b.getNumBytes());
            }
            FsVolumeImpl v = (FsVolumeImpl)ref.getVolume();
            if (allowLazyPersist && !v.isTransientStorage()) {
                this.datanode.getMetrics().incrRamDiskBlocksWriteFallback();
            }
            try {
                newReplicaInfo = v.createRbw(b);
                if (newReplicaInfo.getReplicaInfo().getState() != HdfsServerConstants.ReplicaState.RBW) {
                    throw new IOException("CreateRBW returned a replica of state " + (Object)((Object)newReplicaInfo.getReplicaInfo().getState()) + " for block " + b.getBlockId());
                }
            }
            catch (IOException e) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                throw e;
            }
            this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo.getReplicaInfo());
            ReplicaHandler replicaHandler = new ReplicaHandler(newReplicaInfo, ref);
            return replicaHandler;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReplicaHandler recoverRbw(ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        LOG.info("Recover RBW replica " + b);
        while (true) {
            try (AutoCloseableLock lock = this.datasetLock.acquire();){
                ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
                if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
                    throw new ReplicaNotFoundException("Cannot recover a non-RBW replica " + replicaInfo);
                }
                ReplicaInPipeline rbw = (ReplicaInPipeline)((Object)replicaInfo);
                if (!rbw.attemptToSetWriter(null, Thread.currentThread())) {
                    throw new MustStopExistingWriter(rbw);
                }
                LOG.info("At " + this.datanode.getDisplayName() + ", Recovering " + rbw);
                ReplicaHandler replicaHandler = this.recoverRbwImpl(rbw, b, newGS, minBytesRcvd, maxBytesRcvd);
                return replicaHandler;
            }
            catch (MustStopExistingWriter e) {
                e.getReplicaInPipeline().stopWriter(this.datanode.getDnConf().getXceiverStopTimeout());
                continue;
            }
            break;
        }
    }

    private ReplicaHandler recoverRbwImpl(ReplicaInPipeline rbw, ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            long blockDataLength;
            long replicaGenerationStamp = rbw.getGenerationStamp();
            if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
                throw new ReplicaNotFoundException("Cannot append to a replica with unexpected generation stamp " + b + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
            }
            long bytesAcked = rbw.getBytesAcked();
            long numBytes = rbw.getNumBytes();
            if (bytesAcked < minBytesRcvd || numBytes > maxBytesRcvd) {
                throw new ReplicaNotFoundException("Unmatched length replica " + rbw + ": BytesAcked = " + bytesAcked + " BytesRcvd = " + numBytes + " are not in the range of [" + minBytesRcvd + ", " + maxBytesRcvd + "].");
            }
            long bytesOnDisk = rbw.getBytesOnDisk();
            if (bytesOnDisk != (blockDataLength = rbw.getReplicaInfo().getBlockDataLength())) {
                LOG.info("Resetting bytesOnDisk to match blockDataLength (={}) for replica {}", (Object)blockDataLength, (Object)rbw);
                bytesOnDisk = blockDataLength;
                rbw.setLastChecksumAndDataLen(bytesOnDisk, null);
            }
            if (bytesOnDisk < bytesAcked) {
                throw new ReplicaNotFoundException("Found fewer bytesOnDisk than bytesAcked for replica " + rbw);
            }
            FsVolumeReference ref = rbw.getReplicaInfo().getVolume().obtainReference();
            try {
                if (bytesOnDisk > bytesAcked) {
                    rbw.getReplicaInfo().truncateBlock(bytesAcked);
                    rbw.setNumBytes(bytesAcked);
                    rbw.setLastChecksumAndDataLen(bytesAcked, null);
                }
                rbw.getReplicaInfo().bumpReplicaGS(newGS);
            }
            catch (IOException e) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                throw e;
            }
            ReplicaHandler replicaHandler = new ReplicaHandler(rbw, ref);
            return replicaHandler;
        }
    }

    @Override
    public ReplicaInPipeline convertTemporaryToRbw(ExtendedBlock b) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            long blockId = b.getBlockId();
            long expectedGs = b.getGenerationStamp();
            long visible = b.getNumBytes();
            LOG.info("Convert " + b + " from Temporary to RBW, visible length=" + visible);
            ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), blockId);
            if (r == null) {
                throw new ReplicaNotFoundException("Replica does not exist " + b);
            }
            if (r.getState() != HdfsServerConstants.ReplicaState.TEMPORARY) {
                throw new ReplicaAlreadyExistsException("r.getState() != ReplicaState.TEMPORARY, r=" + r);
            }
            ReplicaInfo temp = r;
            if (temp.getGenerationStamp() != expectedGs) {
                throw new ReplicaAlreadyExistsException("temp.getGenerationStamp() != expectedGs = " + expectedGs + ", temp=" + temp);
            }
            long numBytes = temp.getNumBytes();
            if (numBytes < visible) {
                throw new IOException(numBytes + " = numBytes < visible = " + visible + ", temp=" + temp);
            }
            FsVolumeImpl v = (FsVolumeImpl)temp.getVolume();
            if (v == null) {
                throw new IOException("r.getVolume() = null, temp=" + temp);
            }
            ReplicaInPipeline rbw = v.convertTemporaryToRbw(b, temp);
            if (rbw.getState() != HdfsServerConstants.ReplicaState.RBW) {
                throw new IOException("Expected replica state: " + (Object)((Object)HdfsServerConstants.ReplicaState.RBW) + " obtained " + (Object)((Object)rbw.getState()) + " for converting block " + b.getBlockId());
            }
            this.volumeMap.add(b.getBlockPoolId(), rbw.getReplicaInfo());
            ReplicaInPipeline replicaInPipeline = rbw;
            return replicaInPipeline;
        }
    }

    @Override
    public ReplicaHandler createTemporary(StorageType storageType, String storageId, ExtendedBlock b, boolean isTransfer) throws IOException {
        Throwable throwable;
        AutoCloseableLock lock;
        long startTimeMs = Time.monotonicNow();
        long writerStopTimeoutMs = this.datanode.getDnConf().getXceiverStopTimeout();
        ReplicaInfo lastFoundReplicaInfo = null;
        boolean isInPipeline = false;
        while (true) {
            lock = this.datasetLock.acquire();
            throwable = null;
            try {
                ReplicaInfo currentReplicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
                if (currentReplicaInfo == lastFoundReplicaInfo) break;
                boolean bl = isInPipeline = currentReplicaInfo.getState() == HdfsServerConstants.ReplicaState.TEMPORARY || currentReplicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW;
                if (currentReplicaInfo.getGenerationStamp() >= b.getGenerationStamp() || !isTransfer && !isInPipeline) {
                    throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)currentReplicaInfo.getState()) + " and thus cannot be created.");
                }
                lastFoundReplicaInfo = currentReplicaInfo;
            }
            catch (Throwable currentReplicaInfo) {
                throwable = currentReplicaInfo;
                throw currentReplicaInfo;
            }
            finally {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
            if (!isInPipeline) continue;
            long writerStopMs = Time.monotonicNow() - startTimeMs;
            if (writerStopMs > writerStopTimeoutMs) {
                LOG.warn("Unable to stop existing writer for block " + b + " after " + writerStopMs + " miniseconds.");
                throw new IOException("Unable to stop existing writer for block " + b + " after " + writerStopMs + " miniseconds.");
            }
            ((ReplicaInPipeline)((Object)lastFoundReplicaInfo)).stopWriter(writerStopTimeoutMs);
        }
        if (lastFoundReplicaInfo != null) {
            this.invalidate(b.getBlockPoolId(), new Block[]{lastFoundReplicaInfo}, false);
        }
        lock = this.datasetLock.acquire();
        throwable = null;
        try {
            ReplicaInPipeline newReplicaInfo;
            FsVolumeReference ref = this.volumes.getNextVolume(storageType, storageId, b.getNumBytes());
            FsVolumeImpl v = (FsVolumeImpl)ref.getVolume();
            try {
                newReplicaInfo = v.createTemporary(b);
            }
            catch (IOException e) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                throw e;
            }
            this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo.getReplicaInfo());
            ReplicaHandler replicaHandler = new ReplicaHandler(newReplicaInfo, ref);
            return replicaHandler;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    @Override
    public void adjustCrcChannelPosition(ExtendedBlock b, ReplicaOutputStreams streams, int checksumSize) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.getChecksumOut();
        FileChannel channel = file.getChannel();
        long oldPos = channel.position();
        long newPos = oldPos - (long)checksumSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changing meta file offset of block " + b + " from " + oldPos + " to " + newPos);
        }
        channel.position(newPos);
    }

    @Override
    public void finalizeBlock(ExtendedBlock b, boolean fsyncDir) throws IOException {
        ReplicaInfo replicaInfo = null;
        ReplicaInfo finalizedReplicaInfo = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            if (Thread.interrupted()) {
                throw new IOException("Cannot finalize block from Interrupted Thread");
            }
            replicaInfo = this.getReplicaInfo(b);
            if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
                return;
            }
            finalizedReplicaInfo = this.finalizeReplica(b.getBlockPoolId(), replicaInfo);
        }
        if (fsyncDir && finalizedReplicaInfo instanceof FinalizedReplica && replicaInfo instanceof LocalReplica) {
            FinalizedReplica finalizedReplica = (FinalizedReplica)finalizedReplicaInfo;
            finalizedReplica.fsyncDirectory();
            LocalReplica localReplica = (LocalReplica)replicaInfo;
            localReplica.fsyncDirectory();
        }
    }

    private ReplicaInfo finalizeReplica(String bpid, ReplicaInfo replicaInfo) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo newReplicaInfo = null;
            if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RUR && replicaInfo.getOriginalReplica().getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
                newReplicaInfo = replicaInfo.getOriginalReplica();
                ((FinalizedReplica)newReplicaInfo).loadLastPartialChunkChecksum();
            } else {
                FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
                if (v == null) {
                    throw new IOException("No volume for block " + replicaInfo);
                }
                newReplicaInfo = v.addFinalizedBlock(bpid, replicaInfo, replicaInfo, replicaInfo.getBytesReserved());
                if (v.isTransientStorage()) {
                    this.releaseLockedMemory(replicaInfo.getOriginalBytesReserved() - replicaInfo.getNumBytes(), false);
                    this.ramDiskReplicaTracker.addReplica(bpid, replicaInfo.getBlockId(), v, replicaInfo.getNumBytes());
                    this.datanode.getMetrics().addRamDiskBytesWrite(replicaInfo.getNumBytes());
                }
            }
            assert (newReplicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) : "Replica should be finalized";
            this.volumeMap.add(bpid, newReplicaInfo);
            ReplicaInfo replicaInfo2 = newReplicaInfo;
            return replicaInfo2;
        }
    }

    @Override
    public void unfinalizeBlock(ExtendedBlock b) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
            if (replicaInfo != null && replicaInfo.getState() == HdfsServerConstants.ReplicaState.TEMPORARY) {
                this.volumeMap.remove(b.getBlockPoolId(), b.getLocalBlock());
                if (this.delBlockFromDisk(replicaInfo)) {
                    LOG.warn("Block " + b + " unfinalized and removed. ");
                }
                if (replicaInfo.getVolume().isTransientStorage()) {
                    this.ramDiskReplicaTracker.discardReplica(b.getBlockPoolId(), b.getBlockId(), true);
                }
            }
        }
    }

    private boolean delBlockFromDisk(ReplicaInfo info) {
        if (!info.deleteBlockData()) {
            LOG.warn("Not able to delete the block data for replica " + info);
            return false;
        }
        if (!info.deleteMetadata()) {
            LOG.warn("Not able to delete the meta data for replica " + info);
            return false;
        }
        return true;
    }

    @Override
    public List<Long> getCacheReport(String bpid) {
        return this.cacheManager.getCachedBlocks(bpid);
    }

    @Override
    public Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String bpid) {
        HashMap<DatanodeStorage, BlockListAsLongs> blockReportsMap = new HashMap<DatanodeStorage, BlockListAsLongs>();
        HashMap<String, BlockListAsLongs.Builder> builders = new HashMap<String, BlockListAsLongs.Builder>();
        List<FsVolumeImpl> curVolumes = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            curVolumes = this.volumes.getVolumes();
            for (FsVolumeSpi fsVolumeSpi : curVolumes) {
                builders.put(fsVolumeSpi.getStorageID(), BlockListAsLongs.builder(this.maxDataLength));
            }
            HashSet<String> missingVolumesReported = new HashSet<String>();
            block15: for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
                String volStorageID = b.getVolume().getStorageID();
                if (!builders.containsKey(volStorageID)) {
                    if (missingVolumesReported.contains(volStorageID)) continue;
                    LOG.warn("Storage volume: " + volStorageID + " missing for the replica block: " + b + ". Probably being removed!");
                    missingVolumesReported.add(volStorageID);
                    continue;
                }
                switch (b.getState()) {
                    case FINALIZED: 
                    case RBW: 
                    case RWR: {
                        ((BlockListAsLongs.Builder)builders.get(b.getVolume().getStorageID())).add(b);
                        continue block15;
                    }
                    case RUR: {
                        ReplicaInfo orig = b.getOriginalReplica();
                        ((BlockListAsLongs.Builder)builders.get(b.getVolume().getStorageID())).add(orig);
                        continue block15;
                    }
                    case TEMPORARY: {
                        continue block15;
                    }
                }
                assert (false) : "Illegal ReplicaInfo state.";
            }
        }
        for (FsVolumeImpl v : curVolumes) {
            blockReportsMap.put(v.toDatanodeStorage(), ((BlockListAsLongs.Builder)builders.get(v.getStorageID())).build());
        }
        return blockReportsMap;
    }

    @Override
    public List<ReplicaInfo> getFinalizedBlocks(String bpid) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ArrayList<ReplicaInfo> finalized = new ArrayList<ReplicaInfo>(this.volumeMap.size(bpid));
            for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
                if (b.getState() != HdfsServerConstants.ReplicaState.FINALIZED) continue;
                finalized.add(b);
            }
            ArrayList<ReplicaInfo> arrayList = finalized;
            return arrayList;
        }
    }

    @Override
    public void checkBlock(ExtendedBlock b, long minLength, HdfsServerConstants.ReplicaState state) throws ReplicaNotFoundException, UnexpectedReplicaStateException, FileNotFoundException, EOFException, IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (replicaInfo == null) {
            throw new ReplicaNotFoundException(b);
        }
        if (replicaInfo.getState() != state) {
            throw new UnexpectedReplicaStateException(b, state);
        }
        if (!replicaInfo.blockDataExists()) {
            throw new FileNotFoundException(replicaInfo.getBlockURI().toString());
        }
        long onDiskLength = this.getLength(b);
        if (onDiskLength < minLength) {
            throw new EOFException(b + "'s on-disk length " + onDiskLength + " is shorter than minLength " + minLength);
        }
    }

    @Override
    public boolean isValidBlock(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.FINALIZED);
    }

    @Override
    public boolean isValidRbw(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.RBW);
    }

    private boolean isValid(ExtendedBlock b, HdfsServerConstants.ReplicaState state) {
        try {
            this.checkBlock(b, 0L, state);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    ReplicaInfo validateBlockFile(String bpid, long blockId) {
        ReplicaInfo r;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            r = this.volumeMap.get(bpid, blockId);
        }
        if (r != null) {
            if (r.blockDataExists()) {
                return r;
            }
            this.datanode.checkDiskErrorAsync(r.getVolume());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blockId=" + blockId + ", replica=" + r);
        }
        return null;
    }

    static void checkReplicaFiles(ReplicaInfo r) throws IOException {
        if (!r.blockDataExists()) {
            throw new FileNotFoundException("Block data not found, r=" + r);
        }
        if (r.getBytesOnDisk() != r.getBlockDataLength()) {
            throw new IOException("Block length mismatch, len=" + r.getBlockDataLength() + " but r=" + r);
        }
        if (!r.metadataExists()) {
            throw new IOException(r.getMetadataURI() + " does not exist, r=" + r);
        }
        if (r.getMetadataLength() == 0L) {
            throw new IOException("Metafile is empty, r=" + r);
        }
    }

    @Override
    public void invalidate(String bpid, Block[] invalidBlks) throws IOException {
        this.invalidate(bpid, invalidBlks, true);
    }

    /*
     * Loose catch block
     */
    private void invalidate(String bpid, Block[] invalidBlks, boolean async) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < invalidBlks.length; ++i) {
            RamDiskReplicaTracker.RamDiskReplica replicaInfo;
            ReplicaInfo removing;
            FsVolumeImpl v;
            ReplicaInfo info;
            Throwable throwable;
            AutoCloseableLock lock;
            block38: {
                block39: {
                    block36: {
                        block37: {
                            block34: {
                                block35: {
                                    lock = this.datasetLock.acquire();
                                    throwable = null;
                                    info = this.volumeMap.get(bpid, invalidBlks[i]);
                                    if (info != null) break block34;
                                    ReplicaInfo infoByBlockId = this.volumeMap.get(bpid, invalidBlks[i].getBlockId());
                                    if (infoByBlockId == null) {
                                        LOG.info("Failed to delete replica " + invalidBlks[i] + ": ReplicaInfo not found.");
                                    } else {
                                        errors.add("Failed to delete replica " + invalidBlks[i] + ": GenerationStamp not matched, existing replica is " + Block.toString((Block)infoByBlockId));
                                    }
                                    if (lock == null) continue;
                                    if (throwable == null) break block35;
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                lock.close();
                                continue;
                            }
                            v = (FsVolumeImpl)info.getVolume();
                            if (v != null) break block36;
                            errors.add("Failed to delete replica " + invalidBlks[i] + ". No volume for replica " + info);
                            if (lock == null) continue;
                            if (throwable == null) break block37;
                            try {
                                lock.close();
                            }
                            catch (Throwable infoByBlockId) {
                                throwable.addSuppressed(infoByBlockId);
                            }
                            continue;
                        }
                        lock.close();
                        continue;
                    }
                    File blockFile = new File(info.getBlockURI());
                    if (blockFile == null || blockFile.getParentFile() != null) break block38;
                    errors.add("Failed to delete replica " + invalidBlks[i] + ". Parent not found for block file: " + blockFile);
                    if (lock == null) continue;
                    if (throwable == null) break block39;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
                continue;
            }
            try {
                block41: {
                    break block41;
                    catch (IllegalArgumentException e) {
                        LOG.warn("Parent directory check failed; replica " + info + " is not backed by a local file");
                    }
                }
                removing = this.volumeMap.remove(bpid, invalidBlks[i]);
                this.addDeletingBlock(bpid, removing.getBlockId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Block file " + removing.getBlockURI() + " is to be deleted");
                }
                if (removing instanceof ReplicaInPipeline) {
                    ((ReplicaInPipeline)((Object)removing)).releaseAllBytesReserved();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
            if (v.isTransientStorage() && (replicaInfo = this.ramDiskReplicaTracker.getReplica(bpid, invalidBlks[i].getBlockId())) != null) {
                if (!replicaInfo.getIsPersisted()) {
                    this.datanode.getMetrics().incrRamDiskBlocksDeletedBeforeLazyPersisted();
                }
                this.ramDiskReplicaTracker.discardReplica(replicaInfo.getBlockPoolId(), replicaInfo.getBlockId(), true);
            }
            this.datanode.getShortCircuitRegistry().processBlockInvalidation(new ExtendedBlockId(invalidBlks[i].getBlockId(), bpid));
            this.cacheManager.uncacheBlock(bpid, invalidBlks[i].getBlockId());
            try {
                if (async) {
                    this.asyncDiskService.deleteAsync(v.obtainReference(), removing, new ExtendedBlock(bpid, invalidBlks[i]), this.dataStorage.getTrashDirectoryForReplica(bpid, removing));
                    continue;
                }
                this.asyncDiskService.deleteSync(v.obtainReference(), removing, new ExtendedBlock(bpid, invalidBlks[i]), this.dataStorage.getTrashDirectoryForReplica(bpid, removing));
                continue;
            }
            catch (ClosedChannelException e) {
                LOG.warn("Volume " + v + " is closed, ignore the deletion task for block " + invalidBlks[i]);
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder b = new StringBuilder("Failed to delete ").append(errors.size()).append(" (out of ").append(invalidBlks.length).append(") replica(s):");
            for (int i = 0; i < errors.size(); ++i) {
                b.append("\n").append(i).append(") ").append((String)errors.get(i));
            }
            throw new IOException(b.toString());
        }
    }

    public void invalidate(String bpid, ReplicaInfo block) {
        this.datanode.getShortCircuitRegistry().processBlockInvalidation(new ExtendedBlockId(block.getBlockId(), bpid));
        this.cacheManager.uncacheBlock(bpid, block.getBlockId());
        this.datanode.notifyNamenodeDeletedBlock(new ExtendedBlock(bpid, (Block)block), block.getStorageUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cacheBlock(String bpid, long blockId) {
        Executor volumeExecutor;
        long genstamp;
        long length;
        String blockFileName;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            FsVolumeImpl volume;
            boolean success;
            ReplicaInfo info;
            block39: {
                block38: {
                    block37: {
                        info = this.volumeMap.get(bpid, blockId);
                        success = false;
                        if (info != null) break block37;
                        LOG.warn("Failed to cache block with id " + blockId + ", pool " + bpid + ": ReplicaInfo not found.");
                        if (success) return;
                        this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                        return;
                    }
                    if (info.getState() == HdfsServerConstants.ReplicaState.FINALIZED) break block38;
                    LOG.warn("Failed to cache block with id " + blockId + ", pool " + bpid + ": replica is not finalized; it is in state " + (Object)((Object)info.getState()));
                    if (success) return;
                    this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                    return;
                }
                volume = (FsVolumeImpl)info.getVolume();
                if (volume != null) break block39;
                LOG.warn("Failed to cache block with id " + blockId + ", pool " + bpid + ": volume not found.");
                if (success) return;
                this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                return;
            }
            try {
                block42: {
                    block43: {
                        if (!volume.isTransientStorage()) break block42;
                        break block43;
                        catch (ClassCastException e) {
                            LOG.warn("Failed to cache block with id " + blockId + ": volume was not an instance of FsVolumeImpl.");
                            return;
                        }
                    }
                    LOG.warn("Caching not supported on block with id " + blockId + " since the volume is backed by RAM.");
                    return;
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                }
            }
            blockFileName = info.getBlockURI().toString();
            length = info.getVisibleLength();
            genstamp = info.getGenerationStamp();
            volumeExecutor = volume.getCacheExecutor();
        }
        this.cacheManager.cacheBlock(blockId, bpid, blockFileName, length, genstamp, volumeExecutor);
    }

    @Override
    public void cache(String bpid, long[] blockIds) {
        for (int i = 0; i < blockIds.length; ++i) {
            this.cacheBlock(bpid, blockIds[i]);
        }
    }

    @Override
    public void uncache(String bpid, long[] blockIds) {
        for (int i = 0; i < blockIds.length; ++i) {
            this.cacheManager.uncacheBlock(bpid, blockIds[i]);
        }
    }

    @Override
    public boolean isCached(String bpid, long blockId) {
        return this.cacheManager.isCached(bpid, blockId);
    }

    @Override
    public boolean contains(ExtendedBlock block) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            long blockId = block.getLocalBlock().getBlockId();
            String bpid = block.getBlockPoolId();
            ReplicaInfo r = this.volumeMap.get(bpid, blockId);
            boolean bl = r != null && r.blockDataExists();
            return bl;
        }
    }

    @Override
    public void handleVolumeFailures(Set<FsVolumeSpi> failedVolumes) {
        this.volumes.handleVolumeFailures(failedVolumes);
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String datanodeUuid) {
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register((String)"DataNode", (String)("FSDatasetState-" + datanodeUuid), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn("Error registering FSDatasetState MBean", (Throwable)e);
        }
        LOG.info("Registered FSDatasetState MBean");
    }

    @Override
    public void shutdown() {
        this.fsRunning = false;
        if (this.lazyWriter != null) {
            ((LazyWriter)this.lazyWriter.getRunnable()).stop();
            this.lazyWriter.interrupt();
        }
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
        if (this.asyncDiskService != null) {
            this.asyncDiskService.shutdown();
        }
        if (this.asyncLazyPersistService != null) {
            this.asyncLazyPersistService.shutdown();
        }
        if (this.volumes != null) {
            this.volumes.shutdown();
        }
        if (this.lazyWriter != null) {
            try {
                this.lazyWriter.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("FsDatasetImpl.shutdown ignoring InterruptedException from LazyWriter.join");
            }
        }
    }

    @Override
    public String getStorageInfo() {
        return this.toString();
    }

    @Override
    public void checkAndUpdate(String bpid, long blockId, File diskFile, File diskMetaFile, FsVolumeSpi vol) throws IOException {
        ReplicaInfo memBlockInfo;
        Block corruptBlock = null;
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            long diskGS;
            memBlockInfo = this.volumeMap.get(bpid, blockId);
            if (memBlockInfo != null && memBlockInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
                return;
            }
            FileIoProvider fileIoProvider = this.datanode.getFileIoProvider();
            boolean diskMetaFileExists = diskMetaFile != null && fileIoProvider.exists(vol, diskMetaFile);
            boolean diskFileExists = diskFile != null && fileIoProvider.exists(vol, diskFile);
            long l = diskGS = diskMetaFileExists ? Block.getGenerationStamp((String)diskMetaFile.getName()) : 0L;
            if (!diskFileExists) {
                if (memBlockInfo == null) {
                    if (diskMetaFileExists && fileIoProvider.delete(vol, diskMetaFile)) {
                        LOG.warn("Deleted a metadata file without a block " + diskMetaFile.getAbsolutePath());
                    }
                    return;
                }
                if (!memBlockInfo.blockDataExists()) {
                    this.volumeMap.remove(bpid, blockId);
                    if (vol.isTransientStorage()) {
                        this.ramDiskReplicaTracker.discardReplica(bpid, blockId, true);
                    }
                    LOG.warn("Removed block " + blockId + " from memory with missing block file on the disk");
                    if (diskMetaFileExists && fileIoProvider.delete(vol, diskMetaFile)) {
                        LOG.warn("Deleted a metadata file for the deleted block " + diskMetaFile.getAbsolutePath());
                    }
                }
                return;
            }
            if (memBlockInfo == null) {
                ReplicaInfo diskBlockInfo = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(diskFile.length()).setGenerationStamp(diskGS).setFsVolume(vol).setDirectoryToUse(diskFile.getParentFile()).build();
                this.volumeMap.add(bpid, diskBlockInfo);
                if (vol.isTransientStorage()) {
                    long lockedBytesReserved = this.cacheManager.reserve(diskBlockInfo.getNumBytes()) > 0L ? diskBlockInfo.getNumBytes() : 0L;
                    this.ramDiskReplicaTracker.addReplica(bpid, blockId, (FsVolumeImpl)vol, lockedBytesReserved);
                }
                LOG.warn("Added missing block to memory " + diskBlockInfo);
                return;
            }
            if (memBlockInfo.blockDataExists()) {
                if (memBlockInfo.getBlockURI().compareTo(diskFile.toURI()) != 0) {
                    if (diskMetaFileExists) {
                        if (memBlockInfo.metadataExists()) {
                            ReplicaInfo diskBlockInfo = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(diskFile.length()).setGenerationStamp(diskGS).setFsVolume(vol).setDirectoryToUse(diskFile.getParentFile()).build();
                            ((FsVolumeImpl)vol).resolveDuplicateReplicas(bpid, memBlockInfo, diskBlockInfo, this.volumeMap);
                        }
                    } else if (!fileIoProvider.delete(vol, diskFile)) {
                        LOG.warn("Failed to delete " + diskFile);
                    }
                }
            } else {
                LOG.warn("Block file in replica " + memBlockInfo.getBlockURI() + " does not exist. Updating it to the file found during scan " + diskFile.getAbsolutePath());
                memBlockInfo.updateWithReplica(StorageLocation.parse(diskFile.toString()));
                LOG.warn("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + diskGS);
                memBlockInfo.setGenerationStamp(diskGS);
            }
            if (memBlockInfo.getGenerationStamp() != diskGS) {
                File memMetaFile = FsDatasetUtil.getMetaFile(diskFile, memBlockInfo.getGenerationStamp());
                if (fileIoProvider.exists(vol, memMetaFile)) {
                    String warningPrefix = "Metadata file in memory " + memMetaFile.getAbsolutePath() + " does not match file found by scan ";
                    if (!diskMetaFileExists) {
                        LOG.warn(warningPrefix + "null");
                    } else if (memMetaFile.compareTo(diskMetaFile) != 0) {
                        LOG.warn(warningPrefix + diskMetaFile.getAbsolutePath());
                    }
                } else {
                    try {
                        File memFile = new File(memBlockInfo.getBlockURI());
                        long gs = diskMetaFileExists && diskMetaFile.getParent().equals(memFile.getParent()) ? diskGS : 0L;
                        LOG.warn("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + gs);
                        memBlockInfo.setGenerationStamp(gs);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Block URI could not be resolved to a file", (Throwable)e);
                    }
                }
            }
            if (memBlockInfo.getNumBytes() != memBlockInfo.getBlockDataLength()) {
                corruptBlock = new Block((Block)memBlockInfo);
                LOG.warn("Updating size of block " + blockId + " from " + memBlockInfo.getNumBytes() + " to " + memBlockInfo.getBlockDataLength());
                memBlockInfo.setNumBytes(memBlockInfo.getBlockDataLength());
            }
        }
        if (corruptBlock != null) {
            LOG.warn("Reporting the block " + corruptBlock + " as corrupt due to length mismatch");
            try {
                this.datanode.reportBadBlocks(new ExtendedBlock(bpid, corruptBlock), memBlockInfo.getVolume());
            }
            catch (IOException e) {
                LOG.warn("Failed to report bad block " + corruptBlock, (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public ReplicaInfo getReplica(String bpid, long blockId) {
        return this.volumeMap.get(bpid, blockId);
    }

    @Override
    public String getReplicaString(String bpid, long blockId) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo r = this.volumeMap.get(bpid, blockId);
            String string = r == null ? "null" : ((Object)r).toString();
            return string;
        }
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return FsDatasetImpl.initReplicaRecovery(rBlock.getBlock().getBlockPoolId(), this.volumeMap, rBlock.getBlock().getLocalBlock(), rBlock.getNewGenerationStamp(), this.datanode.getDnConf().getXceiverStopTimeout());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ReplicaRecoveryInfo initReplicaRecovery(String bpid, ReplicaMap map, Block block, long recoveryId, long xceiverStopTimeout) throws IOException {
        while (true) {
            try (AutoCloseableLock lock = map.getLock().acquire();){
                ReplicaRecoveryInfo replicaRecoveryInfo = FsDatasetImpl.initReplicaRecoveryImpl(bpid, map, block, recoveryId);
                return replicaRecoveryInfo;
            }
            catch (MustStopExistingWriter e) {
                e.getReplicaInPipeline().stopWriter(xceiverStopTimeout);
                continue;
            }
            break;
        }
    }

    static ReplicaRecoveryInfo initReplicaRecoveryImpl(String bpid, ReplicaMap map, Block block, long recoveryId) throws IOException, MustStopExistingWriter {
        ReplicaInfo rur;
        ReplicaInfo replica = map.get(bpid, block.getBlockId());
        LOG.info("initReplicaRecovery: " + block + ", recoveryId=" + recoveryId + ", replica=" + replica);
        if (replica == null) {
            return null;
        }
        if (replica.getState() == HdfsServerConstants.ReplicaState.TEMPORARY || replica.getState() == HdfsServerConstants.ReplicaState.RBW) {
            ReplicaInPipeline rip = (ReplicaInPipeline)((Object)replica);
            if (!rip.attemptToSetWriter(null, Thread.currentThread())) {
                throw new MustStopExistingWriter(rip);
            }
            if (replica.getBytesOnDisk() < replica.getVisibleLength()) {
                throw new IOException("getBytesOnDisk() < getVisibleLength(), rip=" + replica);
            }
            FsDatasetImpl.checkReplicaFiles(replica);
        }
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        if (replica.getGenerationStamp() >= recoveryId) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getGenerationStamp() >= recoveryId = " + recoveryId + ", block=" + block + ", replica=" + replica);
        }
        if (replica.getState() == HdfsServerConstants.ReplicaState.RUR) {
            rur = replica;
            if (rur.getRecoveryID() >= recoveryId) {
                throw new RecoveryInProgressException("rur.getRecoveryID() >= recoveryId = " + recoveryId + ", block=" + block + ", rur=" + rur);
            }
            long oldRecoveryID = rur.getRecoveryID();
            rur.setRecoveryID(recoveryId);
            LOG.info("initReplicaRecovery: update recovery id for " + block + " from " + oldRecoveryID + " to " + recoveryId);
        } else {
            rur = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RUR).from(replica).setRecoveryId(recoveryId).build();
            map.add(bpid, rur);
            LOG.info("initReplicaRecovery: changing replica state for " + block + " from " + (Object)((Object)replica.getState()) + " to " + (Object)((Object)rur.getState()));
            if (replica.getState() == HdfsServerConstants.ReplicaState.TEMPORARY || replica.getState() == HdfsServerConstants.ReplicaState.RBW) {
                ((ReplicaInPipeline)((Object)replica)).releaseAllBytesReserved();
            }
        }
        return rur.createInfo();
    }

    @Override
    public Replica updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newlength) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            boolean copyTruncate;
            String bpid = oldBlock.getBlockPoolId();
            ReplicaInfo replica = this.volumeMap.get(bpid, oldBlock.getBlockId());
            LOG.info("updateReplica: " + oldBlock + ", recoveryId=" + recoveryId + ", length=" + newlength + ", replica=" + replica);
            if (replica == null) {
                throw new ReplicaNotFoundException(oldBlock);
            }
            if (replica.getState() != HdfsServerConstants.ReplicaState.RUR) {
                throw new IOException("replica.getState() != " + (Object)((Object)HdfsServerConstants.ReplicaState.RUR) + ", replica=" + replica);
            }
            if (replica.getBytesOnDisk() != oldBlock.getNumBytes()) {
                throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getBytesOnDisk() != block.getNumBytes(), block=" + oldBlock + ", replica=" + replica);
            }
            FsDatasetImpl.checkReplicaFiles(replica);
            ReplicaInfo finalized = this.updateReplicaUnderRecovery(oldBlock.getBlockPoolId(), replica, recoveryId, newBlockId, newlength);
            boolean bl = copyTruncate = newBlockId != oldBlock.getBlockId();
            if (!copyTruncate) {
                assert (finalized.getBlockId() == oldBlock.getBlockId() && finalized.getGenerationStamp() == recoveryId && finalized.getNumBytes() == newlength) : "Replica information mismatched: oldBlock=" + oldBlock + ", recoveryId=" + recoveryId + ", newlength=" + newlength + ", newBlockId=" + newBlockId + ", finalized=" + finalized;
            } else assert (finalized.getBlockId() == oldBlock.getBlockId() && finalized.getGenerationStamp() == oldBlock.getGenerationStamp() && finalized.getNumBytes() == oldBlock.getNumBytes()) : "Finalized and old information mismatched: oldBlock=" + oldBlock + ", genStamp=" + oldBlock.getGenerationStamp() + ", len=" + oldBlock.getNumBytes() + ", finalized=" + finalized;
            FsDatasetImpl.checkReplicaFiles(finalized);
            ReplicaInfo replicaInfo = finalized;
            return replicaInfo;
        }
    }

    private ReplicaInfo updateReplicaUnderRecovery(String bpid, ReplicaInfo rur, long recoveryId, long newBlockId, long newlength) throws IOException {
        boolean copyOnTruncate;
        if (rur.getRecoveryID() != recoveryId) {
            throw new IOException("rur.getRecoveryID() != recoveryId = " + recoveryId + ", rur=" + rur);
        }
        boolean bl = copyOnTruncate = newBlockId > 0L && rur.getBlockId() != newBlockId;
        if (!copyOnTruncate) {
            rur.bumpReplicaGS(recoveryId);
        }
        if (rur.getNumBytes() < newlength) {
            throw new IOException("rur.getNumBytes() < newlength = " + newlength + ", rur=" + rur);
        }
        if (rur.getNumBytes() > newlength) {
            if (!copyOnTruncate) {
                rur.breakHardLinksIfNeeded();
                rur.truncateBlock(newlength);
                rur.setNumBytes(newlength);
            } else {
                FsVolumeImpl volume = (FsVolumeImpl)rur.getVolume();
                ReplicaInPipeline newReplicaInfo = volume.updateRURCopyOnTruncate(rur, bpid, newBlockId, recoveryId, newlength);
                if (newReplicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
                    throw new IOException("Append on block " + rur.getBlockId() + " returned a replica of state " + (Object)((Object)newReplicaInfo.getState()) + "; expected RBW");
                }
                newReplicaInfo.setNumBytes(newlength);
                this.volumeMap.add(bpid, newReplicaInfo.getReplicaInfo());
                this.finalizeReplica(bpid, newReplicaInfo.getReplicaInfo());
            }
        }
        return this.finalizeReplica(bpid, rur);
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo replica = this.getReplicaInfo(block.getBlockPoolId(), block.getBlockId());
            if (replica.getGenerationStamp() < block.getGenerationStamp()) {
                throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
            }
            long l = replica.getVisibleLength();
            return l;
        }
    }

    @Override
    public void addBlockPool(String bpid, Configuration conf) throws IOException {
        LOG.info("Adding block pool " + bpid);
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            this.volumes.addBlockPool(bpid, conf);
            this.volumeMap.initBlockPool(bpid);
        }
        this.volumes.getAllVolumesMap(bpid, this.volumeMap, this.ramDiskReplicaTracker);
    }

    @Override
    public void shutdownBlockPool(String bpid) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            LOG.info("Removing block pool " + bpid);
            Map<DatanodeStorage, BlockListAsLongs> blocksPerVolume = this.getBlockReports(bpid);
            this.volumeMap.cleanUpBlockPool(bpid);
            this.volumes.removeBlockPool(bpid, blocksPerVolume);
        }
    }

    private Collection<VolumeInfo> getVolumeInfo() {
        ArrayList<VolumeInfo> info = new ArrayList<VolumeInfo>();
        for (FsVolumeImpl volume : this.volumes.getVolumes()) {
            long used = 0L;
            long free = 0L;
            try (FsVolumeReference ref = volume.obtainReference();){
                used = volume.getDfsUsed();
                free = volume.getAvailable();
            }
            catch (ClosedChannelException e) {
                continue;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                used = 0L;
                free = 0L;
            }
            info.add(new VolumeInfo(volume, used, free));
        }
        return info;
    }

    @Override
    public Map<String, Object> getVolumeInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Collection<VolumeInfo> volumes = this.getVolumeInfo();
        for (VolumeInfo v : volumes) {
            HashMap<String, Long> innerInfo = new HashMap<String, Long>();
            innerInfo.put("usedSpace", v.usedSpace);
            innerInfo.put("freeSpace", v.freeSpace);
            innerInfo.put("reservedSpace", v.reservedSpace);
            innerInfo.put("reservedSpaceForReplicas", v.reservedSpaceForReplicas);
            innerInfo.put("numBlocks", v.numBlocks);
            innerInfo.put("storageType", (Long)v.storageType);
            info.put(v.directory, innerInfo);
        }
        return info;
    }

    @Override
    public void deleteBlockPool(String bpid, boolean force) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            Throwable throwable;
            FsVolumeReference ref2;
            List<FsVolumeImpl> curVolumes = this.volumes.getVolumes();
            if (!force) {
                for (FsVolumeImpl volume : curVolumes) {
                    try {
                        ref2 = volume.obtainReference();
                        throwable = null;
                        try {
                            if (volume.isBPDirEmpty(bpid)) continue;
                            LOG.warn(bpid + " has some block files, cannot delete unless forced");
                            throw new IOException("Cannot delete block pool, it contains some block files");
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ref2 == null) continue;
                            if (throwable != null) {
                                try {
                                    ref2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ref2.close();
                        }
                    }
                    catch (ClosedChannelException ref2) {}
                }
            }
            for (FsVolumeImpl volume : curVolumes) {
                try {
                    ref2 = volume.obtainReference();
                    throwable = null;
                    try {
                        volume.deleteBPDirectories(bpid, force);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ref2 == null) continue;
                        if (throwable != null) {
                            try {
                                ref2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ref2.close();
                    }
                }
                catch (ClosedChannelException closedChannelException) {}
            }
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block) throws IOException {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            ReplicaInfo replica = this.volumeMap.get(block.getBlockPoolId(), block.getBlockId());
            if (replica == null) {
                throw new ReplicaNotFoundException(block);
            }
            if (replica.getGenerationStamp() < block.getGenerationStamp()) {
                throw new IOException("Replica generation stamp < block generation stamp, block=" + block + ", replica=" + replica);
            }
            if (replica.getGenerationStamp() > block.getGenerationStamp()) {
                block.setGenerationStamp(replica.getGenerationStamp());
            }
        }
        ReplicaInfo r = this.getBlockReplica(block);
        File blockFile = new File(r.getBlockURI());
        File metaFile = new File(r.getMetadataURI());
        BlockLocalPathInfo info = new BlockLocalPathInfo(block, blockFile.getAbsolutePath(), metaFile.toString());
        return info;
    }

    @Override
    public void enableTrash(String bpid) {
        this.dataStorage.enableTrash(bpid);
    }

    @Override
    public void clearTrash(String bpid) {
        this.dataStorage.clearTrash(bpid);
    }

    @Override
    public boolean trashEnabled(String bpid) {
        return this.dataStorage.trashEnabled(bpid);
    }

    @Override
    public void setRollingUpgradeMarker(String bpid) throws IOException {
        this.dataStorage.setRollingUpgradeMarker(bpid);
    }

    @Override
    public void clearRollingUpgradeMarker(String bpid) throws IOException {
        this.dataStorage.clearRollingUpgradeMarker(bpid);
    }

    @Override
    public void onCompleteLazyPersist(String bpId, long blockId, long creationTime, File[] savedFiles, FsVolumeImpl targetVolume) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            this.ramDiskReplicaTracker.recordEndLazyPersist(bpId, blockId, savedFiles);
            targetVolume.incDfsUsedAndNumBlocks(bpId, savedFiles[0].length() + savedFiles[1].length());
            this.datanode.getMetrics().incrRamDiskBlocksLazyPersisted();
            this.datanode.getMetrics().incrRamDiskBytesLazyPersisted(savedFiles[1].length());
            this.datanode.getMetrics().addRamDiskBlocksLazyPersistWindowMs(Time.monotonicNow() - creationTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug("LazyWriter: Finish persisting RamDisk block:  block pool Id: " + bpId + " block id: " + blockId + " to block file " + savedFiles[1] + " and meta file " + savedFiles[0] + " on target volume " + targetVolume);
            }
        }
    }

    @Override
    public void onFailLazyPersist(String bpId, long blockId) {
        RamDiskReplicaTracker.RamDiskReplica block = null;
        block = this.ramDiskReplicaTracker.getReplica(bpId, blockId);
        if (block != null) {
            LOG.warn("Failed to save replica " + block + ". re-enqueueing it.");
            this.ramDiskReplicaTracker.reenqueueReplicaNotPersisted(block);
        }
    }

    @Override
    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock block, ReplicaOutputStreams outs, long offset, long nbytes, int flags) {
        FsVolumeImpl fsVolumeImpl = this.getVolume(block);
        this.asyncDiskService.submitSyncFileRangeRequest(fsVolumeImpl, outs, offset, nbytes, flags);
    }

    private boolean ramDiskConfigured() {
        for (FsVolumeImpl v : this.volumes.getVolumes()) {
            if (!v.isTransientStorage()) continue;
            return true;
        }
        return false;
    }

    private void setupAsyncLazyPersistThreads() {
        for (FsVolumeImpl v : this.volumes.getVolumes()) {
            this.setupAsyncLazyPersistThread(v);
        }
    }

    private void setupAsyncLazyPersistThread(FsVolumeImpl v) {
        if (v.isTransientStorage()) {
            return;
        }
        boolean ramDiskConfigured = this.ramDiskConfigured();
        if (ramDiskConfigured && this.asyncLazyPersistService != null && !this.asyncLazyPersistService.queryVolume(v)) {
            this.asyncLazyPersistService.addVolume(v);
        }
        if (!ramDiskConfigured && this.asyncLazyPersistService != null && this.asyncLazyPersistService.queryVolume(v)) {
            this.asyncLazyPersistService.removeVolume(v);
        }
    }

    private void removeOldReplica(ReplicaInfo replicaInfo, ReplicaInfo newReplicaInfo, String bpid) {
        ExtendedBlock extendedBlock = new ExtendedBlock(bpid, (Block)newReplicaInfo);
        this.datanode.getShortCircuitRegistry().processBlockInvalidation(ExtendedBlockId.fromExtendedBlock((ExtendedBlock)extendedBlock));
        this.datanode.notifyNamenodeReceivedBlock(extendedBlock, null, newReplicaInfo.getStorageUuid(), newReplicaInfo.isOnTransientStorage());
        if (replicaInfo.deleteBlockData() || !replicaInfo.blockDataExists()) {
            FsVolumeImpl volume = (FsVolumeImpl)replicaInfo.getVolume();
            volume.onBlockFileDeletion(bpid, replicaInfo.getBytesOnDisk());
            if (replicaInfo.deleteMetadata() || !replicaInfo.metadataExists()) {
                volume.onMetaFileDeletion(bpid, replicaInfo.getMetadataLength());
            }
        }
    }

    @Override
    public void setPinning(ExtendedBlock block) throws IOException {
        if (!this.blockPinningEnabled) {
            return;
        }
        ReplicaInfo r = this.getBlockReplica(block);
        r.setPinning(this.localFS);
    }

    @Override
    public boolean getPinning(ExtendedBlock block) throws IOException {
        if (!this.blockPinningEnabled) {
            return false;
        }
        ReplicaInfo r = this.getBlockReplica(block);
        return r.getPinning(this.localFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeletingBlock(String bpid, long blockId) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            return s != null ? s.contains(blockId) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeletedBlocks(String bpid, Set<Long> blockIds) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            if (s != null) {
                for (Long id : blockIds) {
                    s.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeletingBlock(String bpid, Long blockId) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            if (s == null) {
                s = new HashSet<Long>();
                this.deletingBlock.put(bpid, s);
            }
            s.add(blockId);
        }
    }

    void releaseLockedMemory(long count, boolean roundup) {
        if (roundup) {
            this.cacheManager.release(count);
        } else {
            this.cacheManager.releaseRoundDown(count);
        }
    }

    @VisibleForTesting
    public void evictLazyPersistBlocks(long bytesNeeded) {
        try {
            ((LazyWriter)this.lazyWriter.getRunnable()).evictBlocks(bytesNeeded);
        }
        catch (IOException ioe) {
            LOG.info("Ignoring exception ", (Throwable)ioe);
        }
    }

    boolean reserveLockedMemory(long bytesNeeded) {
        if (this.cacheManager.reserve(bytesNeeded) > 0L) {
            return true;
        }
        bytesNeeded = this.cacheManager.roundUpPageSize(bytesNeeded);
        this.evictLazyPersistBlocks(bytesNeeded);
        return this.cacheManager.reserve(bytesNeeded) > 0L;
    }

    @VisibleForTesting
    public void setTimer(Timer newTimer) {
        this.timer = newTimer;
    }

    void stopAllDataxceiverThreads(FsVolumeImpl volume) {
        try (AutoCloseableLock lock = this.datasetLock.acquire();){
            for (String blockPoolId : this.volumeMap.getBlockPoolList()) {
                Collection<ReplicaInfo> replicas = this.volumeMap.replicas(blockPoolId);
                for (ReplicaInfo replicaInfo : replicas) {
                    if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.TEMPORARY && replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW || !replicaInfo.getVolume().equals(volume)) continue;
                    ReplicaInPipeline replicaInPipeline = (ReplicaInPipeline)((Object)replicaInfo);
                    replicaInPipeline.interruptThread();
                }
            }
        }
    }

    static {
        if (Path.WINDOWS && !isNativeIOAvailable) {
            LOG.warn("Data node cannot fully support concurrent reading and writing without native code extensions on Windows.");
        }
    }

    class LazyWriter
    implements Runnable {
        private volatile boolean shouldRun = true;
        final int checkpointerInterval;

        public LazyWriter(Configuration conf) {
            this.checkpointerInterval = conf.getInt("dfs.datanode.lazywriter.interval.sec", 60);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveNextReplica() {
            RamDiskReplicaTracker.RamDiskReplica block = null;
            boolean succeeded = false;
            try {
                block = FsDatasetImpl.this.ramDiskReplicaTracker.dequeueNextReplicaToPersist();
                if (block != null) {
                    try (AutoCloseableLock lock = FsDatasetImpl.this.datasetLock.acquire();){
                        ReplicaInfo replicaInfo = FsDatasetImpl.this.volumeMap.get(block.getBlockPoolId(), block.getBlockId());
                        if (replicaInfo != null && replicaInfo.getVolume().isTransientStorage()) {
                            FsVolumeReference targetReference = FsDatasetImpl.this.volumes.getNextVolume(StorageType.DEFAULT, null, replicaInfo.getNumBytes());
                            FsVolumeImpl targetVolume = (FsVolumeImpl)targetReference.getVolume();
                            FsDatasetImpl.this.ramDiskReplicaTracker.recordStartLazyPersist(block.getBlockPoolId(), block.getBlockId(), targetVolume);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("LazyWriter: Start persisting RamDisk block: block pool Id: " + block.getBlockPoolId() + " block id: " + block.getBlockId() + " on target volume " + targetVolume);
                            }
                            FsDatasetImpl.this.asyncLazyPersistService.submitLazyPersistTask(block.getBlockPoolId(), block.getBlockId(), replicaInfo.getGenerationStamp(), block.getCreationTime(), replicaInfo, targetReference);
                        }
                    }
                }
                succeeded = true;
            }
            catch (IOException ioe) {
                LOG.warn("Exception saving replica " + block, (Throwable)ioe);
            }
            finally {
                if (!succeeded && block != null) {
                    LOG.warn("Failed to save replica " + block + ". re-enqueueing it.");
                    FsDatasetImpl.this.onFailLazyPersist(block.getBlockPoolId(), block.getBlockId());
                }
            }
            return succeeded;
        }

        public void evictBlocks(long bytesNeeded) throws IOException {
            RamDiskReplicaTracker.RamDiskReplica replicaState;
            int iterations = 0;
            long cacheCapacity = FsDatasetImpl.this.cacheManager.getCacheCapacity();
            while (iterations++ < 3 && cacheCapacity - FsDatasetImpl.this.cacheManager.getCacheUsed() < bytesNeeded && (replicaState = FsDatasetImpl.this.ramDiskReplicaTracker.getNextCandidateForEviction()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Evicting block " + replicaState);
                }
                String bpid = replicaState.getBlockPoolId();
                AutoCloseableLock lock = FsDatasetImpl.this.datasetLock.acquire();
                Throwable throwable = null;
                try {
                    ReplicaInfo replicaInfo = FsDatasetImpl.this.getReplicaInfo(replicaState.getBlockPoolId(), replicaState.getBlockId());
                    Preconditions.checkState((boolean)replicaInfo.getVolume().isTransientStorage());
                    FsDatasetImpl.this.ramDiskReplicaTracker.discardReplica(replicaState.getBlockPoolId(), replicaState.getBlockId(), false);
                    ReplicaInfo newReplicaInfo = replicaState.getLazyPersistVolume().activateSavedReplica(bpid, replicaInfo, replicaState);
                    FsDatasetImpl.this.volumeMap.add(bpid, newReplicaInfo);
                    FsDatasetImpl.this.datanode.getMetrics().incrRamDiskBlocksEvicted();
                    FsDatasetImpl.this.datanode.getMetrics().addRamDiskBlocksEvictionWindowMs(Time.monotonicNow() - replicaState.getCreationTime());
                    if (replicaState.getNumReads() == 0L) {
                        FsDatasetImpl.this.datanode.getMetrics().incrRamDiskBlocksEvictedWithoutRead();
                    }
                    FsDatasetImpl.this.removeOldReplica(replicaInfo, newReplicaInfo, bpid);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lock == null) continue;
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lock.close();
                }
            }
        }

        @Override
        public void run() {
            int numSuccessiveFailures = 0;
            while (FsDatasetImpl.this.fsRunning && this.shouldRun) {
                try {
                    numSuccessiveFailures = this.saveNextReplica() ? 0 : numSuccessiveFailures + 1;
                    if (numSuccessiveFailures < FsDatasetImpl.this.ramDiskReplicaTracker.numReplicasNotPersisted()) continue;
                    Thread.sleep(this.checkpointerInterval * 1000);
                    numSuccessiveFailures = 0;
                }
                catch (InterruptedException e) {
                    LOG.info("LazyWriter was interrupted, exiting");
                    break;
                }
                catch (Exception e) {
                    LOG.warn("Ignoring exception in LazyWriter:", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    private static class VolumeInfo {
        final String directory;
        final long usedSpace;
        final long freeSpace;
        final long reservedSpace;
        final long reservedSpaceForReplicas;
        final long numBlocks;
        final StorageType storageType;

        VolumeInfo(FsVolumeImpl v, long usedSpace, long freeSpace) {
            this.directory = v.toString();
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
            this.reservedSpace = v.getReserved();
            this.reservedSpaceForReplicas = v.getReservedForReplicas();
            this.numBlocks = v.getNumBlocks();
            this.storageType = v.getStorageType();
        }
    }

    private static class MustStopExistingWriter
    extends Exception {
        private final ReplicaInPipeline rip;

        MustStopExistingWriter(ReplicaInPipeline rip) {
            this.rip = rip;
        }

        ReplicaInPipeline getReplicaInPipeline() {
            return this.rip;
        }
    }
}

