/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalReplica
extends ReplicaInfo {
    private File baseDir;
    private boolean hasSubdirs;
    private static final Map<String, File> internedBaseDirs = new HashMap<String, File>();
    static final Logger LOG = LoggerFactory.getLogger(LocalReplica.class);

    LocalReplica(Block block, FsVolumeSpi vol, File dir) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir);
    }

    LocalReplica(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        super(vol, blockId, len, genStamp);
        this.setDirInternal(dir);
    }

    LocalReplica(LocalReplica from) {
        this(from, from.getVolume(), from.getDir());
    }

    @VisibleForTesting
    public File getBlockFile() {
        return new File(this.getDir(), this.getBlockName());
    }

    @VisibleForTesting
    public File getMetaFile() {
        return new File(this.getDir(), DatanodeUtil.getMetaName(this.getBlockName(), this.getGenerationStamp()));
    }

    protected File getDir() {
        return this.hasSubdirs ? DatanodeUtil.idToBlockDir(this.baseDir, this.getBlockId()) : this.baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirInternal(File dir) {
        if (dir == null) {
            this.baseDir = null;
            return;
        }
        ReplicaDirInfo dirInfo = LocalReplica.parseBaseDir(dir, this.getBlockId());
        this.hasSubdirs = dirInfo.hasSubidrs;
        Map<String, File> map = internedBaseDirs;
        synchronized (map) {
            if (!internedBaseDirs.containsKey(dirInfo.baseDirPath)) {
                File baseDir = new File(dirInfo.baseDirPath);
                internedBaseDirs.put(dirInfo.baseDirPath, baseDir);
            }
            this.baseDir = internedBaseDirs.get(dirInfo.baseDirPath);
        }
    }

    @VisibleForTesting
    public static ReplicaDirInfo parseBaseDir(File dir, long blockId) {
        File idToBlockDir;
        File currentDir = dir;
        boolean hasSubdirs = false;
        while (currentDir.getName().startsWith("subdir")) {
            hasSubdirs = true;
            currentDir = currentDir.getParentFile();
        }
        if (hasSubdirs && (idToBlockDir = DatanodeUtil.idToBlockDir(currentDir, blockId)).equals(dir)) {
            return new ReplicaDirInfo(currentDir.getAbsolutePath(), true);
        }
        return new ReplicaDirInfo(dir.getAbsolutePath(), false);
    }

    private void breakHardlinks(File file, Block b) throws IOException {
        FileIoProvider fileIoProvider = this.getFileIoProvider();
        File tmpFile = DatanodeUtil.createFileWithExistsCheck(this.getVolume(), b, DatanodeUtil.getUnlinkTmpFile(file), fileIoProvider);
        try {
            try (FileInputStream in = fileIoProvider.getFileInputStream(this.getVolume(), file);
                 FileOutputStream out = fileIoProvider.getFileOutputStream(this.getVolume(), tmpFile);){
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)16384);
            }
            if (file.length() != tmpFile.length()) {
                throw new IOException("Copy of file " + file + " size " + file.length() + " into file " + tmpFile + " resulted in a size of " + tmpFile.length());
            }
            fileIoProvider.replaceFile(this.getVolume(), tmpFile, file);
        }
        catch (IOException e) {
            if (!fileIoProvider.delete(this.getVolume(), tmpFile)) {
                DataNode.LOG.info("detachFile failed to delete temporary file " + tmpFile);
            }
            throw e;
        }
    }

    @Override
    public boolean breakHardLinksIfNeeded() throws IOException {
        File file = this.getBlockFile();
        FileIoProvider fileIoProvider = this.getFileIoProvider();
        if (file == null || this.getVolume() == null) {
            throw new IOException("detachBlock:Block not found. " + this);
        }
        File meta = this.getMetaFile();
        int linkCount = fileIoProvider.getHardLinkCount(this.getVolume(), file);
        if (linkCount > 1) {
            DataNode.LOG.info("Breaking hardlink for " + linkCount + "x-linked " + "block " + this);
            this.breakHardlinks(file, this);
        }
        if (fileIoProvider.getHardLinkCount(this.getVolume(), meta) > 1) {
            this.breakHardlinks(meta, this);
        }
        return true;
    }

    @Override
    public URI getBlockURI() {
        return this.getBlockFile().toURI();
    }

    @Override
    public InputStream getDataInputStream(long seekOffset) throws IOException {
        return this.getDataInputStream(this.getBlockFile(), seekOffset);
    }

    @Override
    public OutputStream getDataOutputStream(boolean append) throws IOException {
        return this.getFileIoProvider().getFileOutputStream(this.getVolume(), this.getBlockFile(), append);
    }

    @Override
    public boolean blockDataExists() {
        return this.getFileIoProvider().exists(this.getVolume(), this.getBlockFile());
    }

    @Override
    public boolean deleteBlockData() {
        return this.getFileIoProvider().fullyDelete(this.getVolume(), this.getBlockFile());
    }

    @Override
    public long getBlockDataLength() {
        return this.getBlockFile().length();
    }

    @Override
    public URI getMetadataURI() {
        return this.getMetaFile().toURI();
    }

    @Override
    public LengthInputStream getMetadataInputStream(long offset) throws IOException {
        File meta = this.getMetaFile();
        return new LengthInputStream(this.getFileIoProvider().openAndSeek(this.getVolume(), meta, offset), meta.length());
    }

    @Override
    public OutputStream getMetadataOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this.getMetaFile(), append);
    }

    @Override
    public boolean metadataExists() {
        return this.getFileIoProvider().exists(this.getVolume(), this.getMetaFile());
    }

    @Override
    public boolean deleteMetadata() {
        return this.getFileIoProvider().fullyDelete(this.getVolume(), this.getMetaFile());
    }

    @Override
    public long getMetadataLength() {
        return this.getMetaFile().length();
    }

    @Override
    public boolean renameMeta(URI destURI) throws IOException {
        return this.renameFile(this.getMetaFile(), new File(destURI));
    }

    @Override
    public boolean renameData(URI destURI) throws IOException {
        return this.renameFile(this.getBlockFile(), new File(destURI));
    }

    private boolean renameFile(File srcfile, File destfile) throws IOException {
        try {
            this.getFileIoProvider().rename(this.getVolume(), srcfile, destfile);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to move block file for " + this + " from " + srcfile + " to " + destfile.getAbsolutePath(), e);
        }
    }

    @Override
    public void updateWithReplica(StorageLocation replicaLocation) {
        File diskFile = null;
        try {
            diskFile = new File(replicaLocation.getUri());
        }
        catch (IllegalArgumentException e) {
            diskFile = null;
        }
        if (null == diskFile) {
            this.setDirInternal(null);
        } else {
            this.setDirInternal(diskFile.getParentFile());
        }
    }

    @Override
    public boolean getPinning(LocalFileSystem localFS) throws IOException {
        return this.getPinning(localFS, new Path(this.getBlockFile().getAbsolutePath()));
    }

    @Override
    public void setPinning(LocalFileSystem localFS) throws IOException {
        File f = this.getBlockFile();
        Path p = new Path(f.getAbsolutePath());
        this.setPinning(localFS, p);
    }

    @Override
    public void bumpReplicaGS(long newGS) throws IOException {
        long oldGS = this.getGenerationStamp();
        File oldmeta = this.getMetaFile();
        this.setGenerationStamp(newGS);
        File newmeta = this.getMetaFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Renaming " + oldmeta + " to " + newmeta);
        }
        try {
            this.getFileIoProvider().rename(this.getVolume(), oldmeta, newmeta);
        }
        catch (IOException e) {
            this.setGenerationStamp(oldGS);
            throw new IOException("Block " + this + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to " + newmeta, e);
        }
    }

    @Override
    public void truncateBlock(long newLength) throws IOException {
        LocalReplica.truncateBlock(this.getVolume(), this.getBlockFile(), this.getMetaFile(), this.getNumBytes(), newLength, this.getFileIoProvider());
    }

    @Override
    public int compareWith(FsVolumeSpi.ScanInfo info) {
        return info.getBlockFile().compareTo(this.getBlockFile());
    }

    @Override
    public void copyMetadata(URI destination) throws IOException {
        this.getFileIoProvider().nativeCopyFileUnbuffered(this.getVolume(), this.getMetaFile(), new File(destination), true);
    }

    @Override
    public void copyBlockdata(URI destination) throws IOException {
        this.getFileIoProvider().nativeCopyFileUnbuffered(this.getVolume(), this.getBlockFile(), new File(destination), true);
    }

    private FileInputStream getDataInputStream(File f, long seekOffset) throws IOException {
        FileInputStream fis;
        FileIoProvider fileIoProvider = this.getFileIoProvider();
        if (NativeIO.isAvailable()) {
            fis = fileIoProvider.getShareDeleteFileInputStream(this.getVolume(), f, seekOffset);
        } else {
            try {
                fis = fileIoProvider.openAndSeek(this.getVolume(), f, seekOffset);
            }
            catch (FileNotFoundException fnfe) {
                throw new IOException("Expected block file at " + f + " does not exist.");
            }
        }
        return fis;
    }

    public boolean getPinning(LocalFileSystem localFS, Path path) throws IOException {
        boolean stickyBit = localFS.getFileStatus(path).getPermission().getStickyBit();
        return stickyBit;
    }

    public void setPinning(LocalFileSystem localFS, Path path) throws IOException {
        FsPermission oldPermission = localFS.getFileStatus(path).getPermission();
        FsPermission permission = new FsPermission(oldPermission.getUserAction(), oldPermission.getGroupAction(), oldPermission.getOtherAction(), true);
        localFS.setPermission(path, permission);
    }

    public static void truncateBlock(FsVolumeSpi volume, File blockFile, File metaFile, long oldlen, long newlen, FileIoProvider fileIoProvider) throws IOException {
        LOG.info("truncateBlock: blockFile=" + blockFile + ", metaFile=" + metaFile + ", oldlen=" + oldlen + ", newlen=" + newlen);
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannot truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        FileInputStream fis = fileIoProvider.getFileInputStream(volume, metaFile);
        DataChecksum dcs = BlockMetadataHeader.readHeader((FileInputStream)fis).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long n = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + n * (long)checksumsize;
        long lastchunkoffset = (n - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        try (RandomAccessFile blockRAF = fileIoProvider.getRandomAccessFile(volume, blockFile, "rw");){
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        var21_16 = null;
        try (RandomAccessFile metaRAF = fileIoProvider.getRandomAccessFile(volume, metaFile, "rw");){
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
        catch (Throwable throwable) {
            var21_16 = throwable;
            throw throwable;
        }
    }

    public void fsyncDirectory() throws IOException {
        File dir = this.getDir();
        try {
            this.getFileIoProvider().dirSync(this.getVolume(), this.getDir());
        }
        catch (IOException e) {
            throw new IOException("Failed to sync " + dir, e);
        }
    }

    @VisibleForTesting
    public static class ReplicaDirInfo {
        public String baseDirPath;
        public boolean hasSubidrs;

        public ReplicaDirInfo(String baseDirPath, boolean hasSubidrs) {
            this.baseDirPath = baseDirPath;
            this.hasSubidrs = hasSubidrs;
        }
    }
}

