/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReferenceValidation;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.visitor.NamespaceVisitor;
import org.apache.hadoop.security.AccessControlException;

public abstract class INodeReference
extends INode {
    private INode referred;

    abstract void assertReferences();

    @Override
    public String toDetailString() {
        String s = this.referred == null ? null : this.referred.getFullPathAndObjectString();
        return super.toDetailString() + ", ->" + s;
    }

    public static int tryRemoveReference(INode inode) {
        if (!inode.isReference()) {
            return -1;
        }
        return INodeReference.removeReference(inode.asReference());
    }

    private static int removeReference(INodeReference ref) {
        INode referred = ref.getReferredINode();
        if (!(referred instanceof WithCount)) {
            return -1;
        }
        WithCount wc = (WithCount)referred;
        wc.removeReference(ref);
        return wc.getReferenceCount();
    }

    static int getPriorSnapshot(INodeReference ref) {
        WithCount wc = (WithCount)ref.getReferredINode();
        WithName wn = null;
        if (ref instanceof DstReference) {
            wn = wc.getLastWithName();
        } else if (ref instanceof WithName) {
            wn = wc.getPriorWithName((WithName)ref);
        }
        if (wn != null) {
            DirectoryWithSnapshotFeature sf;
            INode referred = wc.getReferredINode();
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                return referred.asFile().getDiffs().getPrior(wn.lastSnapshotId);
            }
            if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                return sf.getDiffs().getPrior(wn.lastSnapshotId);
            }
        }
        return -1;
    }

    public INodeReference(INode parent, INode referred) {
        super(parent);
        this.referred = referred;
    }

    public final INode getReferredINode() {
        return this.referred;
    }

    @Override
    public final boolean isReference() {
        return true;
    }

    @Override
    public final INodeReference asReference() {
        return this;
    }

    @Override
    public final boolean isFile() {
        return this.referred.isFile();
    }

    @Override
    public final INodeFile asFile() {
        return this.referred.asFile();
    }

    @Override
    public final boolean isDirectory() {
        return this.referred.isDirectory();
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this.referred.asDirectory();
    }

    @Override
    public final boolean isSymlink() {
        return this.referred.isSymlink();
    }

    @Override
    public final INodeSymlink asSymlink() {
        return this.referred.asSymlink();
    }

    @Override
    public byte[] getLocalNameBytes() {
        return this.referred.getLocalNameBytes();
    }

    @Override
    public void setLocalName(byte[] name) {
        this.referred.setLocalName(name);
    }

    @Override
    public final long getId() {
        return this.referred.getId();
    }

    @Override
    public final PermissionStatus getPermissionStatus(int snapshotId) {
        return this.referred.getPermissionStatus(snapshotId);
    }

    @Override
    public final String getUserName(int snapshotId) {
        return this.referred.getUserName(snapshotId);
    }

    @Override
    final void setUser(String user) {
        this.referred.setUser(user);
    }

    @Override
    public final String getGroupName(int snapshotId) {
        return this.referred.getGroupName(snapshotId);
    }

    @Override
    final void setGroup(String group) {
        this.referred.setGroup(group);
    }

    @Override
    public final FsPermission getFsPermission(int snapshotId) {
        return this.referred.getFsPermission(snapshotId);
    }

    @Override
    final AclFeature getAclFeature(int snapshotId) {
        return this.referred.getAclFeature(snapshotId);
    }

    @Override
    final void addAclFeature(AclFeature aclFeature) {
        this.referred.addAclFeature(aclFeature);
    }

    @Override
    final void removeAclFeature() {
        this.referred.removeAclFeature();
    }

    @Override
    final XAttrFeature getXAttrFeature(int snapshotId) {
        return this.referred.getXAttrFeature(snapshotId);
    }

    @Override
    final void addXAttrFeature(XAttrFeature xAttrFeature) {
        this.referred.addXAttrFeature(xAttrFeature);
    }

    @Override
    final void removeXAttrFeature() {
        this.referred.removeXAttrFeature();
    }

    @Override
    public final short getFsPermissionShort() {
        return this.referred.getFsPermissionShort();
    }

    @Override
    void setPermission(FsPermission permission) {
        this.referred.setPermission(permission);
    }

    @Override
    public long getPermissionLong() {
        return this.referred.getPermissionLong();
    }

    @Override
    public final long getModificationTime(int snapshotId) {
        return this.referred.getModificationTime(snapshotId);
    }

    @Override
    public final INode updateModificationTime(long mtime, int latestSnapshotId) {
        return this.referred.updateModificationTime(mtime, latestSnapshotId);
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.referred.setModificationTime(modificationTime);
    }

    @Override
    public final long getAccessTime(int snapshotId) {
        return this.referred.getAccessTime(snapshotId);
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.referred.setAccessTime(accessTime);
    }

    @Override
    public final byte getStoragePolicyID() {
        return this.referred.getStoragePolicyID();
    }

    @Override
    public final byte getLocalStoragePolicyID() {
        return this.referred.getLocalStoragePolicyID();
    }

    @Override
    final void recordModification(int latestSnapshotId) {
        this.referred.recordModification(latestSnapshotId);
    }

    @Override
    public void cleanSubtree(INode.ReclaimContext reclaimContext, int snapshot, int prior) {
        this.referred.cleanSubtree(reclaimContext, snapshot, prior);
    }

    @Override
    public void destroyAndCollectBlocks(INode.ReclaimContext reclaimContext) {
        if (INodeReference.removeReference(this) <= 0) {
            this.referred.destroyAndCollectBlocks(reclaimContext);
        }
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) throws AccessControlException {
        return this.referred.computeContentSummary(snapshotId, summary);
    }

    @Override
    public QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, boolean useCache, int lastSnapshotId) {
        return this.referred.computeQuotaUsage(bsps, blockStoragePolicyId, useCache, lastSnapshotId);
    }

    @Override
    public final INodeAttributes getSnapshotINode(int snapshotId) {
        return this.referred.getSnapshotINode(snapshotId);
    }

    @Override
    public QuotaCounts getQuotaCounts() {
        return this.referred.getQuotaCounts();
    }

    @Override
    public final void clear() {
        super.clear();
        this.referred = null;
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        if (this instanceof DstReference) {
            out.print(", dstSnapshotId=" + ((DstReference)this).dstSnapshotId);
        }
        if (this instanceof WithCount) {
            out.print(", " + ((WithCount)this).getCountDetails());
        }
        out.println();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            b.append(' ');
        }
        b.append("->");
        this.getReferredINode().dumpTreeRecursively(out, b, snapshot);
    }

    @Override
    public void accept(NamespaceVisitor visitor, int snapshot) {
        visitor.visitReferenceRecursively(this, snapshot);
    }

    public int getDstSnapshotId() {
        return 0x7FFFFFFE;
    }

    public static class DstReference
    extends INodeReference {
        private final int dstSnapshotId;

        @Override
        public final int getDstSnapshotId() {
            return this.dstSnapshotId;
        }

        public DstReference(INodeDirectory parent, WithCount referred, int dstSnapshotId) {
            super(parent, referred);
            this.dstSnapshotId = dstSnapshotId;
            referred.addReference(this);
            INodeReferenceValidation.add(this, DstReference.class);
        }

        @Override
        void assertReferences() {
            String err;
            INode ref = this.getReferredINode();
            if (ref instanceof WithCount) {
                if (ref.getParentReference() == this) {
                    return;
                }
                err = "OBJECT MISMATCH, ref.getParentReference() != this";
            } else {
                err = "UNEXPECTED CLASS, expecting WithCount";
            }
            throw new IllegalStateException(err + ":\n  ref: " + (ref == null ? null : ref.toDetailString()) + "\n this: " + this.toDetailString());
        }

        @Override
        public void cleanSubtree(INode.ReclaimContext reclaimContext, int snapshot, int prior) {
            if (snapshot == 0x7FFFFFFE && prior == -1) {
                this.destroyAndCollectBlocks(reclaimContext);
            } else {
                if (prior == -1) {
                    prior = DstReference.getPriorSnapshot(this);
                }
                if (snapshot != 0x7FFFFFFE && prior != -1 && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshot, prior) <= 0) {
                    return;
                }
                this.getReferredINode().cleanSubtree(reclaimContext, snapshot, prior);
            }
        }

        @Override
        public void destroyAndCollectBlocks(INode.ReclaimContext reclaimContext) {
            reclaimContext.quotaDelta().add(this.computeQuotaUsage(reclaimContext.bsps));
            INode.ReclaimContext newCtx = reclaimContext.getCopy();
            if (INodeReference.removeReference((INodeReference)this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(newCtx);
            } else {
                int prior = DstReference.getPriorSnapshot(this);
                Preconditions.checkState((prior != -1 ? 1 : 0) != 0);
                int snapshot = this.getSelfSnapshot(prior);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (referred.isFile()) {
                    INodeFile file = referred.asFile();
                    Preconditions.checkState((boolean)file.isWithSnapshot());
                    file.getFileWithSnapshotFeature().deleteCurrentFile();
                    referred.cleanSubtree(newCtx, snapshot, prior);
                } else if (referred.isDirectory()) {
                    INodeDirectory dir = referred.asDirectory();
                    Preconditions.checkState((boolean)dir.isWithSnapshot());
                    DirectoryWithSnapshotFeature.destroyDstSubtree(newCtx, dir, snapshot, prior);
                }
            }
        }

        private int getSelfSnapshot(int prior) {
            DirectoryWithSnapshotFeature sf;
            WithCount wc = (WithCount)this.getReferredINode().asReference();
            INode referred = wc.getReferredINode();
            int lastSnapshot = 0x7FFFFFFE;
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                lastSnapshot = referred.asFile().getDiffs().getLastSnapshotId();
            } else if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                lastSnapshot = sf.getLastSnapshotId();
            }
            if (lastSnapshot != 0x7FFFFFFE && lastSnapshot != prior) {
                return lastSnapshot;
            }
            return 0x7FFFFFFE;
        }
    }

    public static class WithName
    extends INodeReference {
        private final byte[] name;
        private final int lastSnapshotId;

        public WithName(INodeDirectory parent, WithCount referred, byte[] name, int lastSnapshotId) {
            super(parent, referred);
            this.name = name;
            this.lastSnapshotId = lastSnapshotId;
            referred.addReference(this);
            INodeReferenceValidation.add(this, WithName.class);
        }

        @Override
        void assertReferences() {
            String err;
            INode ref = this.getReferredINode();
            if (ref instanceof WithCount) {
                WithCount withCount = (WithCount)ref;
                int i = withCount.search(this);
                if (i >= 0) {
                    if (withCount.withNameList.get(i) == this) {
                        return;
                    }
                    err = "OBJECT MISMATCH, withNameList.get(" + i + ") != this";
                } else {
                    err = "NOT FOUND in withNameList";
                }
            } else {
                err = "UNEXPECTED CLASS, expecting WithCount";
            }
            throw new IllegalStateException(err + ":\n  ref: " + (ref == null ? null : ref.toDetailString()) + "\n this: " + this.toDetailString());
        }

        @Override
        public final byte[] getLocalNameBytes() {
            return this.name;
        }

        @Override
        public final void setLocalName(byte[] name) {
            throw new UnsupportedOperationException("Cannot set name: " + this.getClass() + " is immutable.");
        }

        public int getLastSnapshotId() {
            return this.lastSnapshotId;
        }

        @Override
        public final ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) throws AccessControlException {
            Preconditions.checkState((snapshotId == 0x7FFFFFFE || this.lastSnapshotId >= snapshotId ? 1 : 0) != 0);
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int id = snapshotId != 0x7FFFFFFE ? snapshotId : this.lastSnapshotId;
            return referred.computeContentSummary(id, summary);
        }

        @Override
        public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, boolean useCache, int lastSnapshotId) {
            Preconditions.checkState((lastSnapshotId == 0x7FFFFFFE || this.lastSnapshotId >= lastSnapshotId ? 1 : 0) != 0);
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int id = lastSnapshotId != 0x7FFFFFFE ? lastSnapshotId : this.lastSnapshotId;
            return referred.computeQuotaUsage(bsps, blockStoragePolicyId, false, id);
        }

        @Override
        public void cleanSubtree(INode.ReclaimContext reclaimContext, int snapshot, int prior) {
            Preconditions.checkArgument((snapshot != 0x7FFFFFFE ? 1 : 0) != 0);
            if (prior == -1) {
                prior = WithName.getPriorSnapshot(this);
            }
            if (prior != -1 && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshot, prior) <= 0) {
                return;
            }
            QuotaCounts old = reclaimContext.quotaDelta().getCountsCopy();
            this.getReferredINode().cleanSubtree(reclaimContext, snapshot, prior);
            INodeReference ref = this.getReferredINode().getParentReference();
            if (ref != null) {
                QuotaCounts current = reclaimContext.quotaDelta().getCountsCopy();
                current.subtract(old);
                reclaimContext.quotaDelta().addUpdatePath(ref, current);
            }
            if (snapshot < this.lastSnapshotId) {
                reclaimContext.quotaDelta().setCounts(old);
            }
        }

        @Override
        public void destroyAndCollectBlocks(INode.ReclaimContext reclaimContext) {
            int snapshot = this.getSelfSnapshot();
            reclaimContext.quotaDelta().add(this.computeQuotaUsage(reclaimContext.bsps));
            if (INodeReference.removeReference((INodeReference)this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(reclaimContext.getCopy());
            } else {
                int prior = WithName.getPriorSnapshot(this);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (snapshot != -1) {
                    if (prior != -1 && snapshot <= prior) {
                        return;
                    }
                    INode.ReclaimContext newCtx = reclaimContext.getCopy();
                    referred.cleanSubtree(newCtx, snapshot, prior);
                    INodeReference ref = this.getReferredINode().getParentReference();
                    if (ref != null) {
                        reclaimContext.quotaDelta().addUpdatePath(ref, newCtx.quotaDelta().getCountsCopy());
                    }
                }
            }
        }

        private int getSelfSnapshot() {
            DirectoryWithSnapshotFeature sf;
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int snapshot = -1;
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                snapshot = referred.asFile().getDiffs().getPrior(this.lastSnapshotId);
            } else if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                snapshot = sf.getDiffs().getPrior(this.lastSnapshotId);
            }
            return snapshot;
        }
    }

    public static class WithCount
    extends INodeReference {
        private final List<WithName> withNameList = new ArrayList<WithName>();
        public static final Comparator<WithName> WITHNAME_COMPARATOR = new Comparator<WithName>(){

            @Override
            public int compare(WithName left, WithName right) {
                return left.lastSnapshotId - right.lastSnapshotId;
            }
        };

        public WithCount(INodeReference parent, INode referred) {
            super(parent, referred);
            Preconditions.checkArgument((!referred.isReference() ? 1 : 0) != 0);
            Preconditions.checkArgument((parent == null ? 1 : 0) != 0);
            referred.setParentReference(this);
            INodeReferenceValidation.add(this, WithCount.class);
        }

        public String getCountDetails() {
            StringBuilder b = new StringBuilder("[");
            if (!this.withNameList.isEmpty()) {
                Iterator<WithName> i = this.withNameList.iterator();
                b.append(i.next().getFullPathAndObjectString());
                while (i.hasNext()) {
                    b.append(", ").append(i.next().getFullPathAndObjectString());
                }
            }
            b.append("]");
            return ", count=" + this.getReferenceCount() + ", names=" + b;
        }

        @Override
        public String toDetailString() {
            return super.toDetailString() + this.getCountDetails();
        }

        private void assertDstReference(INodeReference parentRef) {
            if (parentRef instanceof DstReference) {
                return;
            }
            throw new IllegalArgumentException("Unexpected non-DstReference:\n  parentRef: " + parentRef.toDetailString() + "\n  withCount: " + this.toDetailString());
        }

        private void assertReferredINode(INodeReference ref, String name) {
            if (ref.getReferredINode() == this) {
                return;
            }
            throw new IllegalStateException("Inconsistent Reference:\n  " + name + ": " + ref.toDetailString() + "\n  withCount: " + this.toDetailString());
        }

        @Override
        void assertReferences() {
            for (WithName withName : this.withNameList) {
                this.assertReferredINode(withName, " withName");
            }
            INodeReference parentRef = this.getParentReference();
            if (parentRef != null) {
                this.assertDstReference(parentRef);
                this.assertReferredINode(parentRef, "parentRef");
            }
        }

        public int getReferenceCount() {
            int count = this.withNameList.size();
            if (this.getParentReference() != null) {
                ++count;
            }
            return count;
        }

        public void addReference(INodeReference ref) {
            if (ref instanceof WithName) {
                WithName refWithName = (WithName)ref;
                int i = Collections.binarySearch(this.withNameList, refWithName, WITHNAME_COMPARATOR);
                Preconditions.checkState((i < 0 ? 1 : 0) != 0);
                this.withNameList.add(-i - 1, refWithName);
            } else if (ref instanceof DstReference) {
                this.setParentReference(ref);
            }
        }

        private int search(WithName ref) {
            return Collections.binarySearch(this.withNameList, ref, WITHNAME_COMPARATOR);
        }

        public void removeReference(INodeReference ref) {
            if (ref instanceof WithName) {
                WithName withName = (WithName)ref;
                int i = this.search(withName);
                if (i >= 0) {
                    this.withNameList.remove(i);
                    INodeReferenceValidation.remove(withName, WithName.class);
                }
            } else if (ref == this.getParentReference()) {
                this.setParent(null);
                INodeReferenceValidation.remove((DstReference)ref, DstReference.class);
            }
            if (this.getReferenceCount() == 0) {
                INodeReferenceValidation.remove(this, WithCount.class);
            }
        }

        public WithName getLastWithName() {
            return this.withNameList.size() > 0 ? this.withNameList.get(this.withNameList.size() - 1) : null;
        }

        WithName getPriorWithName(WithName post) {
            int i = Collections.binarySearch(this.withNameList, post, WITHNAME_COMPARATOR);
            if (i > 0) {
                return this.withNameList.get(i - 1);
            }
            if (i == 0 || i == -1) {
                return null;
            }
            return this.withNameList.get(-i - 2);
        }

        public INodeReference getParentRef(int snapshotId) {
            int start = 0;
            int end = this.withNameList.size() - 1;
            while (start < end) {
                int mid = start + (end - start) / 2;
                int sid = this.withNameList.get(mid).lastSnapshotId;
                if (sid == snapshotId) {
                    return this.withNameList.get(mid);
                }
                if (sid < snapshotId) {
                    start = mid + 1;
                    continue;
                }
                end = mid;
            }
            if (start < this.withNameList.size() && this.withNameList.get(start).lastSnapshotId >= snapshotId) {
                return this.withNameList.get(start);
            }
            return this.getParentReference();
        }
    }
}

