/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FSCachingGetSpaceUsed;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockPoolSlice {
    static final Logger LOG = LoggerFactory.getLogger(BlockPoolSlice.class);
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final File finalizedDir;
    private final File lazypersistDir;
    private final File rbwDir;
    private final File tmpDir;
    private final int ioFileBufferSize;
    @VisibleForTesting
    public static final String DU_CACHE_FILE = "dfsUsed";
    private final Runnable shutdownHook;
    private volatile boolean dfsUsedSaved = false;
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final boolean deleteDuplicateReplicas;
    private static final String REPLICA_CACHE_FILE = "replicas";
    private final long replicaCacheExpiry = 300000L;
    private AtomicLong numOfBlocks = new AtomicLong();
    private final long cachedDfsUsedCheckTime;
    private final Timer timer;
    private final int maxDataLength;
    private final FileIoProvider fileIoProvider;
    private static ForkJoinPool addReplicaThreadPool = null;
    private static final int VOLUMES_REPLICA_ADD_THREADPOOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private final GetSpaceUsed dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf, Timer timer) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.fileIoProvider = volume.getFileIoProvider();
        this.currentDir = new File(bpDir, "current");
        this.finalizedDir = new File(this.currentDir, "finalized");
        this.lazypersistDir = new File(this.currentDir, "lazypersist");
        if (!this.finalizedDir.exists() && !this.finalizedDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + this.finalizedDir);
        }
        this.ioFileBufferSize = DFSUtilClient.getIoFileBufferSize((Configuration)conf);
        this.deleteDuplicateReplicas = conf.getBoolean("dfs.datanode.duplicate.replica.deletion", true);
        this.cachedDfsUsedCheckTime = conf.getLong("dfs.datanode.cached-dfsused.check.interval.ms", 600000L);
        this.maxDataLength = conf.getInt("ipc.maximum.data.length", 0x8000000);
        this.timer = timer;
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            this.fileIoProvider.fullyDelete(volume, this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        this.fileIoProvider.mkdirs(volume, this.rbwDir);
        this.fileIoProvider.mkdirs(volume, this.tmpDir);
        this.dfsUsage = new FSCachingGetSpaceUsed.Builder().setBpid(bpid).setVolume(volume).setPath(bpDir).setConf(conf).setInitialUsed(this.loadDfsUsed()).build();
        if (addReplicaThreadPool == null) {
            BlockPoolSlice.initializeAddReplicaPool(conf, (FsDatasetImpl)volume.getDataset());
        }
        this.shutdownHook = new Runnable(){

            @Override
            public void run() {
                if (!BlockPoolSlice.this.dfsUsedSaved) {
                    BlockPoolSlice.this.saveDfsUsed();
                    addReplicaThreadPool.shutdownNow();
                }
            }
        };
        ShutdownHookManager.get().addShutdownHook(this.shutdownHook, 30);
    }

    private static synchronized void initializeAddReplicaPool(Configuration conf, FsDatasetImpl dataset) {
        if (addReplicaThreadPool == null) {
            int numberOfBlockPoolSlice = dataset.getVolumeCount() * dataset.getBPServiceCount();
            int poolsize = Math.max(numberOfBlockPoolSlice, VOLUMES_REPLICA_ADD_THREADPOOL_SIZE);
            addReplicaThreadPool = new ForkJoinPool(conf.getInt("dfs.datanode.volumes.replica-add.threadpool.size", poolsize));
        }
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir;
    }

    File getLazypersistDir() {
        return this.lazypersistDir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    File getTmpDir() {
        return this.tmpDir;
    }

    void decDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(-value);
        }
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    void incDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadDfsUsed() {
        Scanner sc;
        try {
            sc = new Scanner(new File(this.currentDir, DU_CACHE_FILE), "UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedDfsUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && this.timer.now() - mtime < this.cachedDfsUsedCheckTime) {
                FsDatasetImpl.LOG.info("Cached dfsUsed found for " + this.currentDir + ": " + cachedDfsUsed);
                long l = cachedDfsUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    void saveDfsUsed() {
        File outFile = new File(this.currentDir, DU_CACHE_FILE);
        if (!this.fileIoProvider.deleteWithExistsCheck(this.volume, outFile)) {
            FsDatasetImpl.LOG.warn("Failed to delete old dfsUsed file in " + outFile.getParent());
        }
        try {
            long used = this.getDfsUsed();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
                out.write(Long.toString(used) + " " + Long.toString(this.timer.now()));
                ((Writer)out).flush();
            }
        }
        catch (IOException ioe) {
            FsDatasetImpl.LOG.warn("Failed to write dfsUsed to " + outFile, (Throwable)ioe);
        }
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        File tmpFile = DatanodeUtil.createFileWithExistsCheck(this.volume, b, f, this.fileIoProvider);
        this.incrNumBlocks();
        return tmpFile;
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        File rbwFile = DatanodeUtil.createFileWithExistsCheck(this.volume, b, f, this.fileIoProvider);
        this.incrNumBlocks();
        return rbwFile;
    }

    File addFinalizedBlock(Block b, ReplicaInfo replicaInfo) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        this.fileIoProvider.mkdirsWithExistsCheck(this.volume, blockDir);
        File blockFile = FsDatasetImpl.moveBlockFiles(b, replicaInfo, blockDir);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(b.getNumBytes() + metaFile.length());
        }
        return blockFile;
    }

    ReplicaInfo activateSavedReplica(ReplicaInfo replicaInfo, RamDiskReplicaTracker.RamDiskReplica replicaState) throws IOException {
        File metaFile = replicaState.getSavedMetaFile();
        File blockFile = replicaState.getSavedBlockFile();
        long blockId = replicaInfo.getBlockId();
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, blockId);
        File targetBlockFile = new File(blockDir, blockFile.getName());
        File targetMetaFile = new File(blockDir, metaFile.getName());
        this.fileIoProvider.moveFile(this.volume, blockFile, targetBlockFile);
        FsDatasetImpl.LOG.info("Moved " + blockFile + " to " + targetBlockFile);
        this.fileIoProvider.moveFile(this.volume, metaFile, targetMetaFile);
        FsDatasetImpl.LOG.info("Moved " + metaFile + " to " + targetMetaFile);
        ReplicaInfo newReplicaInfo = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(replicaInfo.getBytesOnDisk()).setGenerationStamp(replicaInfo.getGenerationStamp()).setFsVolume(replicaState.getLazyPersistVolume()).setDirectoryToUse(targetBlockFile.getParentFile()).build();
        return newReplicaInfo;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDir((File)this.finalizedDir);
        DiskChecker.checkDir((File)this.tmpDir);
        DiskChecker.checkDir((File)this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) throws IOException {
        boolean success;
        if (this.lazypersistDir.exists()) {
            int numRecovered = this.moveLazyPersistReplicasToFinalized(this.lazypersistDir);
            FsDatasetImpl.LOG.info("Recovered " + numRecovered + " replicas from " + this.lazypersistDir);
        }
        if (!(success = this.readReplicasFromCache(volumeMap, lazyWriteReplicaMap))) {
            List<IOException> exceptions = Collections.synchronizedList(new ArrayList());
            ConcurrentLinkedQueue<RecursiveAction> subTaskQueue = new ConcurrentLinkedQueue<RecursiveAction>();
            AddReplicaProcessor task = new AddReplicaProcessor(volumeMap, this.finalizedDir, lazyWriteReplicaMap, true, exceptions, subTaskQueue);
            ForkJoinTask<Void> finalizedTask = addReplicaThreadPool.submit(task);
            task = new AddReplicaProcessor(volumeMap, this.rbwDir, lazyWriteReplicaMap, false, exceptions, subTaskQueue);
            ForkJoinTask<Void> rbwTask = addReplicaThreadPool.submit(task);
            try {
                finalizedTask.get();
                rbwTask.get();
            }
            catch (InterruptedException | ExecutionException e) {
                exceptions.add(new IOException("Failed to start sub tasks to add replica in replica map :" + e.getMessage()));
            }
            this.waitForSubTaskToFinish(subTaskQueue, exceptions);
        }
    }

    private void waitForSubTaskToFinish(Queue<RecursiveAction> subTaskQueue, List<IOException> exceptions) throws IOException {
        while (!subTaskQueue.isEmpty()) {
            RecursiveAction task = subTaskQueue.poll();
            if (task == null) continue;
            task.join();
        }
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    File recoverTempUnlinkedBlock(File unlinkedTmp) throws IOException {
        File blockFile = FsDatasetUtil.getOrigFile(unlinkedTmp);
        if (blockFile.exists()) {
            if (!this.fileIoProvider.delete(this.volume, unlinkedTmp)) {
                throw new IOException("Unable to cleanup unlinked tmp file " + unlinkedTmp);
            }
            return null;
        }
        this.fileIoProvider.rename(this.volume, unlinkedTmp, blockFile);
        return blockFile;
    }

    private int moveLazyPersistReplicasToFinalized(File source) throws IOException {
        File[] files = this.fileIoProvider.listFiles(this.volume, source);
        int numRecovered = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                numRecovered += this.moveLazyPersistReplicasToFinalized(file);
            }
            if (!Block.isMetaFilename((String)file.getName())) continue;
            File metaFile = file;
            File blockFile = Block.metaToBlockFile((File)metaFile);
            long blockId = Block.filename2id((String)blockFile.getName());
            File targetDir = DatanodeUtil.idToBlockDir(this.finalizedDir, blockId);
            if (!blockFile.exists()) continue;
            try {
                this.fileIoProvider.mkdirsWithExistsCheck(this.volume, targetDir);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to mkdirs " + targetDir);
                continue;
            }
            File targetMetaFile = new File(targetDir, metaFile.getName());
            try {
                this.fileIoProvider.rename(this.volume, metaFile, targetMetaFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to move meta file from " + metaFile + " to " + targetMetaFile, (Throwable)e);
                continue;
            }
            File targetBlockFile = new File(targetDir, blockFile.getName());
            try {
                this.fileIoProvider.rename(this.volume, blockFile, targetBlockFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to move block file from " + blockFile + " to " + targetBlockFile, (Throwable)e);
                continue;
            }
            if (targetBlockFile.exists() && targetMetaFile.exists()) {
                ++numRecovered;
                continue;
            }
            LOG.warn("Failed to move " + blockFile + " to " + targetDir);
        }
        this.fileIoProvider.fullyDelete(this.volume, source);
        return numRecovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicaToReplicasMap(Block block, ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized) throws IOException {
        ReplicaInfo oldReplica;
        ReplicaInfo newReplica = null;
        long blockId = block.getBlockId();
        long genStamp = block.getGenerationStamp();
        if (isFinalized) {
            newReplica = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(blockId).setLength(block.getNumBytes()).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(DatanodeUtil.idToBlockDir(this.finalizedDir, blockId)).build();
        } else {
            File file = new File(this.rbwDir, block.getBlockName());
            boolean loadRwr = true;
            File restartMeta = new File(file.getParent() + File.pathSeparator + "." + file.getName() + ".restart");
            try (Scanner sc = null;){
                sc = new Scanner(restartMeta, "UTF-8");
                if (sc.hasNextLong() && sc.nextLong() > this.timer.now()) {
                    newReplica = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RBW).setBlockId(blockId).setLength(this.validateIntegrityAndSetLength(file, genStamp)).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(file.getParentFile()).setWriterThread(null).setBytesToReserve(0L).build();
                    loadRwr = false;
                }
                sc.close();
                if (!this.fileIoProvider.delete(this.volume, restartMeta)) {
                    FsDatasetImpl.LOG.warn("Failed to delete restart meta file: " + restartMeta.getPath());
                }
            }
            if (loadRwr) {
                ReplicaBuilder builder = new ReplicaBuilder(HdfsServerConstants.ReplicaState.RWR).setBlockId(blockId).setLength(this.validateIntegrityAndSetLength(file, genStamp)).setGenerationStamp(genStamp).setFsVolume(this.volume).setDirectoryToUse(file.getParentFile());
                newReplica = builder.build();
            }
        }
        ReplicaInfo tmpReplicaInfo = volumeMap.addAndGet(this.bpid, newReplica);
        ReplicaInfo replicaInfo = oldReplica = tmpReplicaInfo == newReplica ? null : tmpReplicaInfo;
        if (oldReplica != null) {
            newReplica = this.resolveDuplicateReplicas(newReplica, oldReplica, volumeMap);
        }
        if (newReplica.getVolume().isTransientStorage()) {
            lazyWriteReplicaMap.addReplica(this.bpid, blockId, (FsVolumeImpl)newReplica.getVolume(), 0L);
        } else {
            lazyWriteReplicaMap.discardReplica(this.bpid, blockId, false);
        }
        if (oldReplica == null) {
            this.incrNumBlocks();
        }
    }

    void addToReplicasMap(ReplicaMap volumeMap, File dir, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized, List<IOException> exceptions, Queue<RecursiveAction> subTaskQueue) throws IOException {
        File[] files = this.fileIoProvider.listFiles(this.volume, dir);
        Arrays.sort(files, FILE_COMPARATOR);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                AddReplicaProcessor subTask = new AddReplicaProcessor(volumeMap, file, lazyWriteReplicaMap, isFinalized, exceptions, subTaskQueue);
                subTask.fork();
                subTaskQueue.add(subTask);
            }
            if (isFinalized && FsDatasetUtil.isUnlinkTmpFile(file) && (file = this.recoverTempUnlinkedBlock(file)) == null || !Block.isBlockFilename((File)file)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(files, file, i);
            long blockId = Block.filename2id((String)file.getName());
            Block block = new Block(blockId, file.length(), genStamp);
            this.addReplicaToReplicasMap(block, volumeMap, lazyWriteReplicaMap, isFinalized);
        }
    }

    ReplicaInfo resolveDuplicateReplicas(ReplicaInfo replica1, ReplicaInfo replica2, ReplicaMap volumeMap) throws IOException {
        if (!this.deleteDuplicateReplicas) {
            return replica1;
        }
        ReplicaInfo replicaToDelete = BlockPoolSlice.selectReplicaToDelete(replica1, replica2);
        ReplicaInfo replicaToKeep = replicaToDelete != replica1 ? replica1 : replica2;
        volumeMap.add(this.bpid, replicaToKeep);
        if (replicaToDelete != null) {
            this.deleteReplica(replicaToDelete);
        }
        return replicaToKeep;
    }

    @VisibleForTesting
    static ReplicaInfo selectReplicaToDelete(ReplicaInfo replica1, ReplicaInfo replica2) {
        ReplicaInfo replicaToDelete;
        if (replica1.getBlockURI().equals(replica2.getBlockURI())) {
            return null;
        }
        ReplicaInfo replicaToKeep = replica1.getGenerationStamp() != replica2.getGenerationStamp() ? (replica1.getGenerationStamp() > replica2.getGenerationStamp() ? replica1 : replica2) : (replica1.getNumBytes() != replica2.getNumBytes() ? (replica1.getNumBytes() > replica2.getNumBytes() ? replica1 : replica2) : (replica1.getVolume().isTransientStorage() && !replica2.getVolume().isTransientStorage() ? replica2 : replica1));
        ReplicaInfo replicaInfo = replicaToDelete = replicaToKeep == replica1 ? replica2 : replica1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolveDuplicateReplicas decide to keep " + replicaToKeep + ".  Will try to delete " + replicaToDelete);
        }
        return replicaToDelete;
    }

    private void deleteReplica(ReplicaInfo replicaToDelete) {
        if (!replicaToDelete.deleteBlockData()) {
            LOG.warn("Failed to delete block file for replica " + replicaToDelete);
        }
        if (!replicaToDelete.deleteMetadata()) {
            LOG.warn("Failed to delete meta file for replica " + replicaToDelete);
        }
    }

    /*
     * Exception decompiling
     */
    private long validateIntegrityAndSetLength(File blockFile, long genStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown(BlockListAsLongs blocksListToPersist) {
        this.saveReplicas(blocksListToPersist);
        this.saveDfsUsed();
        this.dfsUsedSaved = true;
        if (this.shutdownHook != null) {
            ShutdownHookManager.get().removeShutdownHook(this.shutdownHook);
        }
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{(CachingGetSpaceUsed)this.dfsUsage});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readReplicasFromCache(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) {
        boolean bl;
        BlockListAsLongs blocksList;
        FileInputStream inputStream;
        File replicaFile;
        ReplicaMap tmpReplicaMap;
        block18: {
            tmpReplicaMap = new ReplicaMap(new ReentrantReadWriteLock());
            replicaFile = new File(this.currentDir, REPLICA_CACHE_FILE);
            if (!replicaFile.exists()) {
                LOG.info("Replica Cache file: " + replicaFile.getPath() + " doesn't exist ");
                return false;
            }
            long fileLastModifiedTime = replicaFile.lastModified();
            if (System.currentTimeMillis() > fileLastModifiedTime + 300000L) {
                LOG.info("Replica Cache file: " + replicaFile.getPath() + " has gone stale");
                if (!replicaFile.delete()) {
                    LOG.info("Replica Cache file: " + replicaFile.getPath() + " cannot be deleted");
                }
                return false;
            }
            inputStream = null;
            inputStream = this.fileIoProvider.getFileInputStream(this.volume, replicaFile);
            blocksList = BlockListAsLongs.readFrom(inputStream, this.maxDataLength);
            if (blocksList != null) break block18;
            boolean bl2 = false;
            IOUtils.closeStream((Closeable)inputStream);
            if (!this.fileIoProvider.delete(this.volume, replicaFile)) {
                LOG.info("Failed to delete replica cache file: " + replicaFile.getPath());
            }
            return bl2;
        }
        try {
            for (BlockListAsLongs.BlockReportReplica replica : blocksList) {
                switch (replica.getState()) {
                    case FINALIZED: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, true);
                        break;
                    }
                    case RUR: 
                    case RBW: 
                    case RWR: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, false);
                        break;
                    }
                }
            }
            Iterator<ReplicaInfo> iter = tmpReplicaMap.replicas(this.bpid).iterator();
            while (iter.hasNext()) {
                ReplicaInfo info = iter.next();
                iter.remove();
                volumeMap.add(this.bpid, info);
            }
            LOG.info("Successfully read replica from cache file : " + replicaFile.getPath());
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                LOG.info("Exception occurred while reading the replicas cache file: " + replicaFile.getPath(), (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(inputStream);
                if (!this.fileIoProvider.delete(this.volume, replicaFile)) {
                    LOG.info("Failed to delete replica cache file: " + replicaFile.getPath());
                }
                throw throwable;
            }
            IOUtils.closeStream((Closeable)inputStream);
            if (!this.fileIoProvider.delete(this.volume, replicaFile)) {
                LOG.info("Failed to delete replica cache file: " + replicaFile.getPath());
            }
            return bl3;
        }
        IOUtils.closeStream((Closeable)inputStream);
        if (!this.fileIoProvider.delete(this.volume, replicaFile)) {
            LOG.info("Failed to delete replica cache file: " + replicaFile.getPath());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReplicas(BlockListAsLongs blocksListToPersist) {
        if (blocksListToPersist == null || blocksListToPersist.getNumberOfBlocks() == 0) {
            return;
        }
        File tmpFile = new File(this.currentDir, "replicas.tmp");
        File replicaCacheFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (!this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile) || !this.fileIoProvider.deleteWithExistsCheck(this.volume, replicaCacheFile)) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = this.fileIoProvider.getFileOutputStream((FsVolumeSpi)this.volume, tmpFile);
            blocksListToPersist.writeTo(out);
            out.close();
            this.fileIoProvider.moveFile(this.volume, tmpFile, replicaCacheFile);
        }
        catch (Exception e) {
            try {
                LOG.warn("Failed to write replicas to cache ", (Throwable)e);
                this.fileIoProvider.deleteWithExistsCheck(this.volume, replicaCacheFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
            this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
        }
        IOUtils.closeStream((Closeable)out);
        this.fileIoProvider.deleteWithExistsCheck(this.volume, tmpFile);
    }

    void incrNumBlocks() {
        this.numOfBlocks.incrementAndGet();
    }

    void decrNumBlocks() {
        this.numOfBlocks.decrementAndGet();
    }

    public long getNumOfBlocks() {
        return this.numOfBlocks.get();
    }

    @VisibleForTesting
    public static int getAddReplicaForkPoolSize() {
        return addReplicaThreadPool.getPoolSize();
    }

    @VisibleForTesting
    public ForkJoinPool getAddReplicaThreadPool() {
        return addReplicaThreadPool;
    }

    @VisibleForTesting
    public static void reInitializeAddReplicaThreadPool() {
        addReplicaThreadPool.shutdown();
        addReplicaThreadPool = null;
    }

    class AddReplicaProcessor
    extends RecursiveAction {
        private ReplicaMap volumeMap;
        private File dir;
        private RamDiskReplicaTracker lazyWriteReplicaMap;
        private boolean isFinalized;
        private List<IOException> exceptions;
        private Queue<RecursiveAction> subTaskQueue;

        AddReplicaProcessor(ReplicaMap volumeMap, File dir, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized, List<IOException> exceptions, Queue<RecursiveAction> subTaskQueue) {
            this.volumeMap = volumeMap;
            this.dir = dir;
            this.lazyWriteReplicaMap = lazyWriteReplicaMap;
            this.isFinalized = isFinalized;
            this.exceptions = exceptions;
            this.subTaskQueue = subTaskQueue;
        }

        @Override
        protected void compute() {
            try {
                BlockPoolSlice.this.addToReplicasMap(this.volumeMap, this.dir, this.lazyWriteReplicaMap, this.isFinalized, this.exceptions, this.subTaskQueue);
            }
            catch (IOException e) {
                LOG.warn("Caught exception while adding replicas from " + BlockPoolSlice.this.volume + " in subtask. Will throw later.", (Throwable)e);
                this.exceptions.add(e);
            }
        }
    }
}

