/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DFSZKFailoverController
extends ZKFailoverController {
    private static final Logger LOG = LoggerFactory.getLogger(DFSZKFailoverController.class);
    private final AccessControlList adminAcl;
    private final NNHAServiceTarget localNNTarget;
    private boolean isThreadDumpCaptured = false;

    protected HAServiceTarget dataToTarget(byte[] data) {
        HAZKInfoProtos.ActiveNodeInfo proto;
        try {
            proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid data in ZK: " + StringUtils.byteToHexString((byte[])data));
        }
        NNHAServiceTarget ret = new NNHAServiceTarget(this.conf, proto.getNameserviceId(), proto.getNamenodeId());
        InetSocketAddress addressFromProtobuf = new InetSocketAddress(proto.getHostname(), proto.getPort());
        if (!addressFromProtobuf.equals(ret.getAddress())) {
            throw new RuntimeException("Mismatched address stored in ZK for " + (Object)((Object)ret) + ": Stored protobuf was " + proto + ", address from our own configuration for this NameNode was " + ret.getAddress());
        }
        ret.setZkfcPort(proto.getZkfcPort());
        return ret;
    }

    protected byte[] targetToData(HAServiceTarget target) {
        InetSocketAddress addr = target.getAddress();
        return HAZKInfoProtos.ActiveNodeInfo.newBuilder().setHostname(addr.getHostName()).setPort(addr.getPort()).setZkfcPort(target.getZKFCAddress().getPort()).setNameserviceId(this.localNNTarget.getNameServiceId()).setNamenodeId(this.localNNTarget.getNameNodeId()).build().toByteArray();
    }

    protected InetSocketAddress getRpcAddressToBindTo() {
        int zkfcPort = DFSZKFailoverController.getZkfcPort(this.conf);
        return new InetSocketAddress(this.localTarget.getAddress().getAddress(), zkfcPort);
    }

    protected PolicyProvider getPolicyProvider() {
        return new HDFSPolicyProvider();
    }

    static int getZkfcPort(Configuration conf) {
        return conf.getInt("dfs.ha.zkfc.port", 8019);
    }

    public static DFSZKFailoverController create(Configuration conf) {
        String nsId;
        Configuration localNNConf = DFSHAAdmin.addSecurityConfiguration(conf);
        if (!HAUtil.isHAEnabled(localNNConf, nsId = DFSUtil.getNamenodeNameServiceId(conf))) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        String nnId = HAUtil.getNameNodeId(localNNConf, nsId);
        if (nnId == null) {
            String msg = "Could not get the namenode ID of this node. You may run zkfc on the node other than namenode.";
            throw new HadoopIllegalArgumentException(msg);
        }
        NameNode.initializeGenericKeys(localNNConf, nsId, nnId);
        DFSUtil.setGenericConf(localNNConf, nsId, nnId, ZKFC_CONF_KEYS);
        NNHAServiceTarget localTarget = new NNHAServiceTarget(localNNConf, nsId, nnId);
        return new DFSZKFailoverController(localNNConf, localTarget);
    }

    private DFSZKFailoverController(Configuration conf, NNHAServiceTarget localTarget) {
        super(conf, (HAServiceTarget)localTarget);
        this.localNNTarget = localTarget;
        this.adminAcl = new AccessControlList(conf.get("dfs.cluster.administrators", " "));
        LOG.info("Failover controller configured for NameNode " + (Object)((Object)localTarget));
    }

    protected void initRPC() throws IOException {
        super.initRPC();
        this.localNNTarget.setZkfcPort(this.rpcServer.getAddress().getPort());
    }

    public void loginAsFCUser() throws IOException {
        InetSocketAddress socAddr = DFSUtilClient.getNNAddress((Configuration)this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected String getScopeInsideParentNode() {
        return this.localNNTarget.getNameServiceId();
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(DFSZKFailoverController.class, (String[])args, (Logger)LOG);
        if (DFSUtil.parseHelpArgument(args, "Usage: hdfs zkfc [ -formatZK [-force] [-nonInteractive] ]\n\t-force: formats the znode if the znode exists.\n\t-nonInteractive: formats the znode aborts if the znode exists,\n\tunless -force option is specified.", System.out, true)) {
            System.exit(0);
        }
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)new HdfsConfiguration(), args);
        try {
            DFSZKFailoverController zkfc = DFSZKFailoverController.create(parser.getConfiguration());
            System.exit(zkfc.run(parser.getRemainingArgs()));
        }
        catch (Throwable t) {
            LOG.error("DFSZKFailOverController exiting due to earlier exception " + t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    protected void checkRpcAdminAccess() throws IOException, AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation zkfcUgi = UserGroupInformation.getLoginUser();
        if (this.adminAcl.isUserAllowed(ugi) || ugi.getShortUserName().equals(zkfcUgi.getShortUserName())) {
            LOG.info("Allowed RPC access from " + ugi + " at " + Server.getRemoteAddress());
            return;
        }
        String msg = "Disallowed RPC access from " + ugi + " at " + Server.getRemoteAddress() + ". Not listed in " + "dfs.cluster.administrators";
        LOG.warn(msg);
        throw new AccessControlException(msg);
    }

    private void getLocalNNThreadDump() {
        this.isThreadDumpCaptured = false;
        int httpTimeOut = this.conf.getInt("dfs.ha.zkfc.nn.http.timeout.ms", 20000);
        if (httpTimeOut == 0) {
            return;
        }
        try {
            String stacksUrl = DFSUtil.getInfoServer(this.localNNTarget.getAddress(), this.conf, DFSUtil.getHttpClientScheme(this.conf)) + "/stacks";
            URL url = new URL(stacksUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(httpTimeOut);
            conn.setConnectTimeout(httpTimeOut);
            conn.connect();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
            StringBuilder localNNThreadDumpContent = new StringBuilder("-- Local NN thread dump -- \n");
            localNNThreadDumpContent.append(out).append("\n -- Local NN thread dump -- ");
            LOG.info("{}", (Object)localNNThreadDumpContent.toString());
            this.isThreadDumpCaptured = true;
        }
        catch (IOException e) {
            LOG.warn("Can't get local NN thread dump due to " + e.getMessage());
        }
    }

    protected synchronized void setLastHealthState(HealthMonitor.State newState) {
        super.setLastHealthState(newState);
        if (this.getLastHealthState() == HealthMonitor.State.SERVICE_NOT_RESPONDING || this.getLastHealthState() == HealthMonitor.State.SERVICE_UNHEALTHY) {
            this.getLocalNNThreadDump();
        }
    }

    @VisibleForTesting
    boolean isThreadDumpCaptured() {
        return this.isThreadDumpCaptured;
    }

    public List<HAServiceTarget> getAllOtherNodes() {
        String nsId = DFSUtil.getNamenodeNameServiceId(this.conf);
        List<String> otherNn = HAUtil.getNameNodeIdOfOtherNodes(this.conf, nsId);
        ArrayList<HAServiceTarget> targets = new ArrayList<HAServiceTarget>(otherNn.size());
        for (String nnId : otherNn) {
            targets.add(new NNHAServiceTarget(this.conf, nsId, nnId));
        }
        return targets;
    }
}

