/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class QueueInfo {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, String queuePath, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled, float weight) {
        QueueInfo queueInfo = Records.newRecord(QueueInfo.class);
        queueInfo.setQueueName(queueName);
        queueInfo.setQueuePath(queuePath);
        queueInfo.setCapacity(capacity);
        queueInfo.setMaximumCapacity(maximumCapacity);
        queueInfo.setCurrentCapacity(currentCapacity);
        queueInfo.setChildQueues(childQueues);
        queueInfo.setApplications(applications);
        queueInfo.setQueueState(queueState);
        queueInfo.setAccessibleNodeLabels(accessibleNodeLabels);
        queueInfo.setDefaultNodeLabelExpression(defaultNodeLabelExpression);
        queueInfo.setQueueStatistics(queueStatistics);
        queueInfo.setPreemptionDisabled(preemptionDisabled);
        queueInfo.setWeight(weight);
        return queueInfo;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, String queuePath, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled, float weight, Map<String, QueueConfigurations> queueConfigurations) {
        QueueInfo queueInfo = QueueInfo.newInstance(queueName, queuePath, capacity, maximumCapacity, currentCapacity, childQueues, applications, queueState, accessibleNodeLabels, defaultNodeLabelExpression, queueStatistics, preemptionDisabled, weight);
        queueInfo.setQueueConfigurations(queueConfigurations);
        return queueInfo;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, String queuePath, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression, QueueStatistics queueStatistics, boolean preemptionDisabled, float weight, Map<String, QueueConfigurations> queueConfigurations, boolean intraQueuePreemptionDisabled) {
        QueueInfo queueInfo = QueueInfo.newInstance(queueName, queuePath, capacity, maximumCapacity, currentCapacity, childQueues, applications, queueState, accessibleNodeLabels, defaultNodeLabelExpression, queueStatistics, preemptionDisabled, weight, queueConfigurations);
        queueInfo.setIntraQueuePreemptionDisabled(intraQueuePreemptionDisabled);
        return queueInfo;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueueName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueuePath();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueuePath(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getWeight();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setWeight(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getMaximumCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setMaximumCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCurrentCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCurrentCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<QueueInfo> getChildQueues();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setChildQueues(List<QueueInfo> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ApplicationReport> getApplications();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplications(List<ApplicationReport> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract QueueState getQueueState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueState(QueueState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getAccessibleNodeLabels();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAccessibleNodeLabels(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDefaultNodeLabelExpression();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setDefaultNodeLabelExpression(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract QueueStatistics getQueueStatistics();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setQueueStatistics(QueueStatistics var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Boolean getPreemptionDisabled();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptionDisabled(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<String, QueueConfigurations> getQueueConfigurations();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueConfigurations(Map<String, QueueConfigurations> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Boolean getIntraQueuePreemptionDisabled();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setIntraQueuePreemptionDisabled(boolean var1);
}

