/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LightWeightResource
extends Resource {
    private ResourceInformation memoryResInfo;
    private ResourceInformation vcoresResInfo;

    public LightWeightResource(long value) {
        ResourceInformation[] types = ResourceUtils.getResourceTypesArray();
        this.initResourceInformations(value, value, types.length);
        for (int i = 2; i < types.length; ++i) {
            this.resources[i] = new ResourceInformation();
            ResourceInformation.copy(types[i], this.resources[i]);
            this.resources[i].setValue(value);
        }
    }

    public LightWeightResource(long memory, int vcores) {
        int numberOfKnownResourceTypes = ResourceUtils.getNumberOfKnownResourceTypes();
        this.initResourceInformations(memory, vcores, numberOfKnownResourceTypes);
        if (numberOfKnownResourceTypes > 2) {
            ResourceInformation[] types = ResourceUtils.getResourceTypesArray();
            for (int i = 2; i < numberOfKnownResourceTypes; ++i) {
                this.resources[i] = new ResourceInformation();
                ResourceInformation.copy(types[i], this.resources[i]);
            }
        }
    }

    public LightWeightResource(long memory, int vcores, ResourceInformation[] source) {
        int numberOfKnownResourceTypes = ResourceUtils.getNumberOfKnownResourceTypes();
        this.initResourceInformations(memory, vcores, numberOfKnownResourceTypes);
        for (int i = 2; i < numberOfKnownResourceTypes; ++i) {
            this.resources[i] = new ResourceInformation();
            ResourceInformation.copy(source[i], this.resources[i]);
        }
    }

    private void initResourceInformations(long memory, long vcores, int numberOfKnownResourceTypes) {
        this.memoryResInfo = LightWeightResource.newDefaultInformation("memory-mb", ResourceInformation.MEMORY_MB.getUnits(), memory);
        this.vcoresResInfo = LightWeightResource.newDefaultInformation("vcores", ResourceInformation.VCORES.getUnits(), vcores);
        this.resources = new ResourceInformation[numberOfKnownResourceTypes];
        this.resources[0] = this.memoryResInfo;
        this.resources[1] = this.vcoresResInfo;
    }

    @Override
    public int getMemory() {
        return LightWeightResource.castToIntSafely(this.memoryResInfo.getValue());
    }

    @Override
    public void setMemory(int memory) {
        this.memoryResInfo.setValue(memory);
    }

    @Override
    public long getMemorySize() {
        return this.memoryResInfo.getValue();
    }

    @Override
    public void setMemorySize(long memory) {
        this.memoryResInfo.setValue(memory);
    }

    @Override
    public int getVirtualCores() {
        return LightWeightResource.castToIntSafely(this.vcoresResInfo.getValue());
    }

    @Override
    public void setVirtualCores(int vcores) {
        this.vcoresResInfo.setValue(vcores);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.getMemorySize() != other.getMemorySize() || this.getVirtualCores() != other.getVirtualCores()) {
            return false;
        }
        if (this.resources.length > 2) {
            ResourceInformation[] otherVectors = other.getResources();
            if (this.resources.length != otherVectors.length) {
                return false;
            }
            for (int i = 2; i < this.resources.length; ++i) {
                ResourceInformation a = this.resources[i];
                ResourceInformation b = otherVectors[i];
                if (a == b || a != null && a.equals(b)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Resource other) {
        if (this.resources.length <= 2) {
            long diff = this.getMemorySize() - other.getMemorySize();
            if (diff == 0L) {
                return this.getVirtualCores() - other.getVirtualCores();
            }
            if (diff > 0L) {
                return 1;
            }
            return -1;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        int prime = 47;
        return 47 * (47 + Long.hashCode(this.getMemorySize())) + this.getVirtualCores();
    }
}

