/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerResourceDecrease;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncrease;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerResourceDecreasePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerResourceIncreasePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NMTokenPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionMessagePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AllocateResponsePBImpl
extends AllocateResponse {
    YarnServiceProtos.AllocateResponseProto proto = YarnServiceProtos.AllocateResponseProto.getDefaultInstance();
    YarnServiceProtos.AllocateResponseProto.Builder builder = null;
    boolean viaProto = false;
    Resource limit;
    private List<Container> allocatedContainers = null;
    private List<NMToken> nmTokens = null;
    private List<ContainerStatus> completedContainersStatuses = null;
    private List<ContainerResourceIncrease> increasedContainers = null;
    private List<ContainerResourceDecrease> decreasedContainers = null;
    private List<NodeReport> updatedNodes = null;
    private PreemptionMessage preempt;
    private Token amrmToken = null;

    public AllocateResponsePBImpl() {
        this.builder = YarnServiceProtos.AllocateResponseProto.newBuilder();
    }

    public AllocateResponsePBImpl(YarnServiceProtos.AllocateResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.AllocateResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((AllocateResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private synchronized void mergeLocalToBuilder() {
        Iterable iterable;
        if (this.allocatedContainers != null) {
            this.builder.clearAllocatedContainers();
            iterable = this.getContainerProtoIterable(this.allocatedContainers);
            this.builder.addAllAllocatedContainers(iterable);
        }
        if (this.nmTokens != null) {
            this.builder.clearNmTokens();
            iterable = this.getTokenProtoIterable(this.nmTokens);
            this.builder.addAllNmTokens(iterable);
        }
        if (this.completedContainersStatuses != null) {
            this.builder.clearCompletedContainerStatuses();
            iterable = this.getContainerStatusProtoIterable(this.completedContainersStatuses);
            this.builder.addAllCompletedContainerStatuses(iterable);
        }
        if (this.updatedNodes != null) {
            this.builder.clearUpdatedNodes();
            iterable = this.getNodeReportProtoIterable(this.updatedNodes);
            this.builder.addAllUpdatedNodes(iterable);
        }
        if (this.limit != null) {
            this.builder.setLimit(this.convertToProtoFormat(this.limit));
        }
        if (this.preempt != null) {
            this.builder.setPreempt(this.convertToProtoFormat(this.preempt));
        }
        if (this.increasedContainers != null) {
            this.builder.clearIncreasedContainers();
            iterable = this.getIncreaseProtoIterable(this.increasedContainers);
            this.builder.addAllIncreasedContainers(iterable);
        }
        if (this.decreasedContainers != null) {
            this.builder.clearDecreasedContainers();
            iterable = this.getChangeProtoIterable(this.decreasedContainers);
            this.builder.addAllDecreasedContainers(iterable);
        }
        if (this.amrmToken != null) {
            this.builder.setAmRmToken(this.convertToProtoFormat(this.amrmToken));
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.AllocateResponseProto.newBuilder((YarnServiceProtos.AllocateResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized AMCommand getAMCommand() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAMCommand()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat((YarnProtos.AMCommandProto)p.getAMCommand());
    }

    public synchronized void setAMCommand(AMCommand command) {
        this.maybeInitBuilder();
        if (command == null) {
            this.builder.clearAMCommand();
            return;
        }
        this.builder.setAMCommand(ProtoUtils.convertToProtoFormat((AMCommand)command));
    }

    public synchronized int getResponseId() {
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    public synchronized void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    public synchronized Resource getAvailableResources() {
        YarnServiceProtos.AllocateResponseProto p;
        if (this.limit != null) {
            return this.limit;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasLimit()) {
            return null;
        }
        this.limit = this.convertFromProtoFormat(p.getLimit());
        return this.limit;
    }

    public synchronized void setAvailableResources(Resource limit) {
        this.maybeInitBuilder();
        if (limit == null) {
            this.builder.clearLimit();
        }
        this.limit = limit;
    }

    public synchronized List<NodeReport> getUpdatedNodes() {
        this.initLocalNewNodeReportList();
        return this.updatedNodes;
    }

    public synchronized void setUpdatedNodes(List<NodeReport> updatedNodes) {
        if (updatedNodes == null) {
            this.updatedNodes.clear();
            return;
        }
        this.updatedNodes = new ArrayList(updatedNodes.size());
        this.updatedNodes.addAll(updatedNodes);
    }

    public synchronized List<Container> getAllocatedContainers() {
        this.initLocalNewContainerList();
        return this.allocatedContainers;
    }

    public synchronized void setAllocatedContainers(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalNewContainerList();
        this.allocatedContainers.addAll(containers);
    }

    public synchronized List<ContainerStatus> getCompletedContainersStatuses() {
        this.initLocalFinishedContainerList();
        return this.completedContainersStatuses;
    }

    public synchronized void setCompletedContainersStatuses(List<ContainerStatus> containers) {
        if (containers == null) {
            return;
        }
        this.initLocalFinishedContainerList();
        this.completedContainersStatuses.addAll(containers);
    }

    public synchronized void setNMTokens(List<NMToken> nmTokens) {
        if (nmTokens == null || nmTokens.isEmpty()) {
            if (this.nmTokens != null) {
                this.nmTokens.clear();
            }
            this.builder.clearNmTokens();
            return;
        }
        this.initLocalNewNMTokenList();
        this.nmTokens.addAll(nmTokens);
    }

    public synchronized List<NMToken> getNMTokens() {
        this.initLocalNewNMTokenList();
        return this.nmTokens;
    }

    public synchronized int getNumClusterNodes() {
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumClusterNodes();
    }

    public synchronized void setNumClusterNodes(int numNodes) {
        this.maybeInitBuilder();
        this.builder.setNumClusterNodes(numNodes);
    }

    public synchronized PreemptionMessage getPreemptionMessage() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.preempt != null) {
            return this.preempt;
        }
        if (!p.hasPreempt()) {
            return null;
        }
        this.preempt = this.convertFromProtoFormat(p.getPreempt());
        return this.preempt;
    }

    public synchronized void setPreemptionMessage(PreemptionMessage preempt) {
        this.maybeInitBuilder();
        if (null == preempt) {
            this.builder.clearPreempt();
        }
        this.preempt = preempt;
    }

    public synchronized List<ContainerResourceIncrease> getIncreasedContainers() {
        this.initLocalIncreasedContainerList();
        return this.increasedContainers;
    }

    public synchronized void setIncreasedContainers(List<ContainerResourceIncrease> increasedContainers) {
        if (increasedContainers == null) {
            return;
        }
        this.initLocalIncreasedContainerList();
        this.increasedContainers.addAll(increasedContainers);
    }

    public synchronized List<ContainerResourceDecrease> getDecreasedContainers() {
        this.initLocalDecreasedContainerList();
        return this.decreasedContainers;
    }

    public synchronized void setDecreasedContainers(List<ContainerResourceDecrease> decreasedContainers) {
        if (decreasedContainers == null) {
            return;
        }
        this.initLocalDecreasedContainerList();
        this.decreasedContainers.addAll(decreasedContainers);
    }

    public synchronized Token getAMRMToken() {
        YarnServiceProtos.AllocateResponseProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.amrmToken != null) {
            return this.amrmToken;
        }
        if (!p.hasAmRmToken()) {
            return null;
        }
        this.amrmToken = this.convertFromProtoFormat(p.getAmRmToken());
        return this.amrmToken;
    }

    public synchronized void setAMRMToken(Token amRMToken) {
        this.maybeInitBuilder();
        if (amRMToken == null) {
            this.builder.clearAmRmToken();
        }
        this.amrmToken = amRMToken;
    }

    private synchronized void initLocalIncreasedContainerList() {
        if (this.increasedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getIncreasedContainersList();
        this.increasedContainers = new ArrayList();
        for (YarnProtos.ContainerResourceIncreaseProto c : list) {
            this.increasedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalDecreasedContainerList() {
        if (this.decreasedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getDecreasedContainersList();
        this.decreasedContainers = new ArrayList();
        for (YarnProtos.ContainerResourceDecreaseProto c : list) {
            this.decreasedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalNewNodeReportList() {
        if (this.updatedNodes != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getUpdatedNodesList();
        this.updatedNodes = new ArrayList(list.size());
        for (YarnProtos.NodeReportProto n : list) {
            this.updatedNodes.add(this.convertFromProtoFormat(n));
        }
    }

    private synchronized void initLocalNewContainerList() {
        if (this.allocatedContainers != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getAllocatedContainersList();
        this.allocatedContainers = new ArrayList();
        for (YarnProtos.ContainerProto c : list) {
            this.allocatedContainers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initLocalNewNMTokenList() {
        if (this.nmTokens != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getNmTokensList();
        this.nmTokens = new ArrayList();
        for (YarnServiceProtos.NMTokenProto t : list) {
            this.nmTokens.add(this.convertFromProtoFormat(t));
        }
    }

    private synchronized Iterable<YarnProtos.ContainerResourceIncreaseProto> getIncreaseProtoIterable(List<ContainerResourceIncrease> newContainersList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized Iterable<YarnProtos.ContainerResourceDecreaseProto> getChangeProtoIterable(List<ContainerResourceDecrease> newContainersList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized Iterable<YarnProtos.ContainerProto> getContainerProtoIterable(List<Container> newContainersList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized Iterable<YarnServiceProtos.NMTokenProto> getTokenProtoIterable(List<NMToken> nmTokenList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized Iterable<YarnProtos.ContainerStatusProto> getContainerStatusProtoIterable(List<ContainerStatus> newContainersList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized Iterable<YarnProtos.NodeReportProto> getNodeReportProtoIterable(List<NodeReport> newNodeReportsList) {
        this.maybeInitBuilder();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private synchronized void initLocalFinishedContainerList() {
        if (this.completedContainersStatuses != null) {
            return;
        }
        YarnServiceProtos.AllocateResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getCompletedContainerStatusesList();
        this.completedContainersStatuses = new ArrayList();
        for (YarnProtos.ContainerStatusProto c : list) {
            this.completedContainersStatuses.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized ContainerResourceIncrease convertFromProtoFormat(YarnProtos.ContainerResourceIncreaseProto p) {
        return new ContainerResourceIncreasePBImpl(p);
    }

    private synchronized YarnProtos.ContainerResourceIncreaseProto convertToProtoFormat(ContainerResourceIncrease t) {
        return ((ContainerResourceIncreasePBImpl)t).getProto();
    }

    private synchronized ContainerResourceDecrease convertFromProtoFormat(YarnProtos.ContainerResourceDecreaseProto p) {
        return new ContainerResourceDecreasePBImpl(p);
    }

    private synchronized YarnProtos.ContainerResourceDecreaseProto convertToProtoFormat(ContainerResourceDecrease t) {
        return ((ContainerResourceDecreasePBImpl)t).getProto();
    }

    private synchronized NodeReportPBImpl convertFromProtoFormat(YarnProtos.NodeReportProto p) {
        return new NodeReportPBImpl(p);
    }

    private synchronized YarnProtos.NodeReportProto convertToProtoFormat(NodeReport t) {
        return ((NodeReportPBImpl)t).getProto();
    }

    private synchronized ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private synchronized YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    private synchronized ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    private synchronized YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus t) {
        return ((ContainerStatusPBImpl)t).getProto();
    }

    private synchronized ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private synchronized YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ((ResourcePBImpl)r).getProto();
    }

    private synchronized PreemptionMessagePBImpl convertFromProtoFormat(YarnProtos.PreemptionMessageProto p) {
        return new PreemptionMessagePBImpl(p);
    }

    private synchronized YarnProtos.PreemptionMessageProto convertToProtoFormat(PreemptionMessage r) {
        return ((PreemptionMessagePBImpl)r).getProto();
    }

    private synchronized YarnServiceProtos.NMTokenProto convertToProtoFormat(NMToken token) {
        return ((NMTokenPBImpl)token).getProto();
    }

    private synchronized NMToken convertFromProtoFormat(YarnServiceProtos.NMTokenProto proto) {
        return new NMTokenPBImpl(proto);
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    static /* synthetic */ YarnProtos.ContainerResourceIncreaseProto access$000(AllocateResponsePBImpl x0, ContainerResourceIncrease x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ YarnProtos.ContainerResourceDecreaseProto access$100(AllocateResponsePBImpl x0, ContainerResourceDecrease x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ YarnProtos.ContainerProto access$200(AllocateResponsePBImpl x0, Container x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ YarnServiceProtos.NMTokenProto access$300(AllocateResponsePBImpl x0, NMToken x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ YarnProtos.ContainerStatusProto access$400(AllocateResponsePBImpl x0, ContainerStatus x1) {
        return x0.convertToProtoFormat(x1);
    }

    static /* synthetic */ YarnProtos.NodeReportProto access$500(AllocateResponsePBImpl x0, NodeReport x1) {
        return x0.convertToProtoFormat(x1);
    }
}

