/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationResourceUsageReportPBImpl
extends ApplicationResourceUsageReport {
    YarnProtos.ApplicationResourceUsageReportProto proto = YarnProtos.ApplicationResourceUsageReportProto.getDefaultInstance();
    YarnProtos.ApplicationResourceUsageReportProto.Builder builder = null;
    boolean viaProto = false;
    Resource usedResources;
    Resource reservedResources;
    Resource neededResources;

    public ApplicationResourceUsageReportPBImpl() {
        this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder();
    }

    public ApplicationResourceUsageReportPBImpl(YarnProtos.ApplicationResourceUsageReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.ApplicationResourceUsageReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((ApplicationResourceUsageReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.usedResources != null && !((ResourcePBImpl)this.usedResources).getProto().equals((Object)this.builder.getUsedResources())) {
            this.builder.setUsedResources(this.convertToProtoFormat(this.usedResources));
        }
        if (this.reservedResources != null && !((ResourcePBImpl)this.reservedResources).getProto().equals((Object)this.builder.getReservedResources())) {
            this.builder.setReservedResources(this.convertToProtoFormat(this.reservedResources));
        }
        if (this.neededResources != null && !((ResourcePBImpl)this.neededResources).getProto().equals((Object)this.builder.getNeededResources())) {
            this.builder.setNeededResources(this.convertToProtoFormat(this.neededResources));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder((YarnProtos.ApplicationResourceUsageReportProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized int getNumUsedContainers() {
        YarnProtos.ApplicationResourceUsageReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumUsedContainers();
    }

    public synchronized void setNumUsedContainers(int num_containers) {
        this.maybeInitBuilder();
        this.builder.setNumUsedContainers(num_containers);
    }

    public synchronized int getNumReservedContainers() {
        YarnProtos.ApplicationResourceUsageReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumReservedContainers();
    }

    public synchronized void setNumReservedContainers(int num_reserved_containers) {
        this.maybeInitBuilder();
        this.builder.setNumReservedContainers(num_reserved_containers);
    }

    public synchronized Resource getUsedResources() {
        YarnProtos.ApplicationResourceUsageReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.usedResources != null) {
            return this.usedResources;
        }
        if (!p.hasUsedResources()) {
            return null;
        }
        this.usedResources = this.convertFromProtoFormat(p.getUsedResources());
        return this.usedResources;
    }

    public synchronized void setUsedResources(Resource resources) {
        this.maybeInitBuilder();
        if (resources == null) {
            this.builder.clearUsedResources();
        }
        this.usedResources = resources;
    }

    public synchronized Resource getReservedResources() {
        YarnProtos.ApplicationResourceUsageReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.reservedResources != null) {
            return this.reservedResources;
        }
        if (!p.hasReservedResources()) {
            return null;
        }
        this.reservedResources = this.convertFromProtoFormat(p.getReservedResources());
        return this.reservedResources;
    }

    public synchronized void setReservedResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearReservedResources();
        }
        this.reservedResources = reserved_resources;
    }

    public synchronized Resource getNeededResources() {
        YarnProtos.ApplicationResourceUsageReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.neededResources != null) {
            return this.neededResources;
        }
        if (!p.hasNeededResources()) {
            return null;
        }
        this.neededResources = this.convertFromProtoFormat(p.getNeededResources());
        return this.neededResources;
    }

    public synchronized void setNeededResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearNeededResources();
        }
        this.neededResources = reserved_resources;
    }

    public synchronized void setMemorySeconds(long memory_seconds) {
        this.maybeInitBuilder();
        this.builder.setMemorySeconds(memory_seconds);
    }

    public synchronized long getMemorySeconds() {
        YarnProtos.ApplicationResourceUsageReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getMemorySeconds();
    }

    public synchronized void setVcoreSeconds(long vcore_seconds) {
        this.maybeInitBuilder();
        this.builder.setVcoreSeconds(vcore_seconds);
    }

    public synchronized long getVcoreSeconds() {
        YarnProtos.ApplicationResourceUsageReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getVcoreSeconds();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }
}

