/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ReservationDefinitionPBImpl
extends ReservationDefinition {
    YarnProtos.ReservationDefinitionProto proto = YarnProtos.ReservationDefinitionProto.getDefaultInstance();
    YarnProtos.ReservationDefinitionProto.Builder builder = null;
    boolean viaProto = false;
    private ReservationRequests reservationReqs;

    public ReservationDefinitionPBImpl() {
        this.builder = YarnProtos.ReservationDefinitionProto.newBuilder();
    }

    public ReservationDefinitionPBImpl(YarnProtos.ReservationDefinitionProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ReservationDefinitionProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.reservationReqs != null) {
            this.builder.setReservationRequests(this.convertToProtoFormat(this.reservationReqs));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ReservationDefinitionProto.newBuilder((YarnProtos.ReservationDefinitionProto)this.proto);
        }
        this.viaProto = false;
    }

    public long getArrival() {
        YarnProtos.ReservationDefinitionProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasArrival()) {
            return 0L;
        }
        return p.getArrival();
    }

    public void setArrival(long earliestStartTime) {
        this.maybeInitBuilder();
        if (earliestStartTime <= 0L) {
            this.builder.clearArrival();
            return;
        }
        this.builder.setArrival(earliestStartTime);
    }

    public long getDeadline() {
        YarnProtos.ReservationDefinitionProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDeadline()) {
            return 0L;
        }
        return p.getDeadline();
    }

    public void setDeadline(long latestEndTime) {
        this.maybeInitBuilder();
        if (latestEndTime <= 0L) {
            this.builder.clearDeadline();
            return;
        }
        this.builder.setDeadline(latestEndTime);
    }

    public ReservationRequests getReservationRequests() {
        YarnProtos.ReservationDefinitionProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationReqs != null) {
            return this.reservationReqs;
        }
        if (!p.hasReservationRequests()) {
            return null;
        }
        this.reservationReqs = this.convertFromProtoFormat(p.getReservationRequests());
        return this.reservationReqs;
    }

    public void setReservationRequests(ReservationRequests reservationRequests) {
        if (reservationRequests == null) {
            this.builder.clearReservationRequests();
            return;
        }
        this.reservationReqs = reservationRequests;
    }

    public String getReservationName() {
        YarnProtos.ReservationDefinitionProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasReservationName()) {
            return null;
        }
        return p.getReservationName();
    }

    public void setReservationName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearReservationName();
            return;
        }
        this.builder.setReservationName(name);
    }

    private ReservationRequestsPBImpl convertFromProtoFormat(YarnProtos.ReservationRequestsProto p) {
        return new ReservationRequestsPBImpl(p);
    }

    private YarnProtos.ReservationRequestsProto convertToProtoFormat(ReservationRequests t) {
        return ((ReservationRequestsPBImpl)t).getProto();
    }

    public String toString() {
        return "{Arrival: " + this.getArrival() + ", Deadline: " + this.getDeadline() + ", Reservation Name: " + this.getReservationName() + ", Resources: " + this.getReservationRequests() + "}";
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((ReservationDefinitionPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

