/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineClientImpl
extends TimelineClient {
    private static final Log LOG = LogFactory.getLog(TimelineClientImpl.class);
    private static final String RESOURCE_URI_STR = "/ws/v1/timeline/";
    private static final Joiner JOINER = Joiner.on((String)"");
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static Options opts = new Options();
    private static final String ENTITY_DATA_TYPE = "entity";
    private static final String DOMAIN_DATA_TYPE = "domain";
    private Client client;
    private ConnectionConfigurator connConfigurator;
    private DelegationTokenAuthenticator authenticator;
    private DelegationTokenAuthenticatedURL.Token token;
    private URI resURI;
    private boolean isEnabled;
    @InterfaceAudience.Private
    @VisibleForTesting
    TimelineClientConnectionRetry connectionRetry;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR;

    public TimelineClientImpl() {
        super(TimelineClientImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.isEnabled = conf.getBoolean("yarn.timeline-service.enabled", false);
        if (!this.isEnabled) {
            LOG.info((Object)"Timeline service is not enabled");
        } else {
            DefaultClientConfig cc = new DefaultClientConfig();
            cc.getClasses().add(YarnJacksonJaxbJsonProvider.class);
            this.connConfigurator = TimelineClientImpl.newConnConfigurator((Configuration)conf);
            this.authenticator = UserGroupInformation.isSecurityEnabled() ? new KerberosDelegationTokenAuthenticator() : new PseudoDelegationTokenAuthenticator();
            this.authenticator.setConnectionConfigurator(this.connConfigurator);
            this.token = new DelegationTokenAuthenticatedURL.Token();
            this.connectionRetry = new TimelineClientConnectionRetry(conf);
            this.client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new TimelineURLConnectionFactory(this, null)), (ClientConfig)cc);
            TimelineJerseyRetryFilter retryFilter = new TimelineJerseyRetryFilter(this, null);
            this.client.addFilter((ClientFilter)retryFilter);
            this.resURI = YarnConfiguration.useHttps((Configuration)conf) ? URI.create(JOINER.join((Object)"https://", (Object)conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190"), new Object[]{"/ws/v1/timeline/"})) : URI.create(JOINER.join((Object)"http://", (Object)conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188"), new Object[]{"/ws/v1/timeline/"}));
            LOG.info((Object)("Timeline service address: " + this.resURI));
        }
        super.serviceInit(conf);
    }

    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        if (!this.isEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nothing will be put because timeline service is not enabled");
            }
            return new TimelinePutResponse();
        }
        TimelineEntities entitiesContainer = new TimelineEntities();
        entitiesContainer.addEntities(Arrays.asList(entities));
        ClientResponse resp = this.doPosting((Object)entitiesContainer, null);
        return (TimelinePutResponse)resp.getEntity(TimelinePutResponse.class);
    }

    public void putDomain(TimelineDomain domain) throws IOException, YarnException {
        if (!this.isEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nothing will be put because timeline service is not enabled");
            }
            return;
        }
        this.doPosting((Object)domain, "domain");
    }

    private ClientResponse doPosting(Object obj, String path) throws IOException, YarnException {
        ClientResponse resp;
        try {
            resp = this.doPostingObject(obj, path);
        }
        catch (RuntimeException re) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg, (Throwable)re);
            throw re;
        }
        if (resp == null || resp.getClientResponseStatus() != ClientResponse.Status.OK) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg);
            if (LOG.isDebugEnabled() && resp != null) {
                String output = (String)resp.getEntity(String.class);
                LOG.debug((Object)("HTTP error code: " + resp.getStatus() + " Server response : \n" + output));
            }
            throw new YarnException(msg);
        }
        return resp;
    }

    public Token<TimelineDelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException, YarnException {
        boolean isProxyAccess = UserGroupInformation.getCurrentUser().getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY;
        String doAsUser = isProxyAccess ? UserGroupInformation.getCurrentUser().getShortUserName() : null;
        1 getDTAction = new /* Unavailable Anonymous Inner Class!! */;
        return (Token)this.operateDelegationToken((PrivilegedExceptionAction)getDTAction);
    }

    public long renewDelegationToken(Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        boolean isProxyAccess = UserGroupInformation.getCurrentUser().getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY;
        String doAsUser = isProxyAccess ? UserGroupInformation.getCurrentUser().getShortUserName() : null;
        2 renewDTAction = new /* Unavailable Anonymous Inner Class!! */;
        return (Long)this.operateDelegationToken((PrivilegedExceptionAction)renewDTAction);
    }

    public void cancelDelegationToken(Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        boolean isProxyAccess = UserGroupInformation.getCurrentUser().getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY;
        String doAsUser = isProxyAccess ? UserGroupInformation.getCurrentUser().getShortUserName() : null;
        3 cancelDTAction = new /* Unavailable Anonymous Inner Class!! */;
        this.operateDelegationToken((PrivilegedExceptionAction)cancelDTAction);
    }

    private Object operateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException, YarnException {
        4 tokenRetryOp = new /* Unavailable Anonymous Inner Class!! */;
        return this.connectionRetry.retryOn((TimelineClientRetryOp)tokenRetryOp);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ClientResponse doPostingObject(Object object, String path) {
        WebResource webResource = this.client.resource(this.resURI);
        if (path == null) {
            return (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, object);
        }
        if (path.equals("domain")) {
            return (ClientResponse)((WebResource.Builder)webResource.path(path).accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, object);
        }
        throw new YarnRuntimeException("Unknown resource type");
    }

    private static ConnectionConfigurator newConnConfigurator(Configuration conf) {
        try {
            return TimelineClientImpl.newSslConnConfigurator((int)60000, (Configuration)conf);
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
    }

    private static ConnectionConfigurator newSslConnConfigurator(int timeout, Configuration conf) throws IOException, GeneralSecurityException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        SSLSocketFactory sf = factory.createSSLSocketFactory();
        HostnameVerifier hv = factory.getHostnameVerifier();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    public static void main(String[] argv) throws Exception {
        String path;
        CommandLine cliParser = new GnuParser().parse(opts, argv);
        if (cliParser.hasOption("put") && (path = cliParser.getOptionValue("put")) != null && path.length() > 0) {
            if (cliParser.hasOption("entity")) {
                TimelineClientImpl.putTimelineDataInJSONFile((String)path, (String)"entity");
                return;
            }
            if (cliParser.hasOption("domain")) {
                TimelineClientImpl.putTimelineDataInJSONFile((String)path, (String)"domain");
                return;
            }
        }
        TimelineClientImpl.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTimelineDataInJSONFile(String path, String type) {
        File jsonFile = new File(path);
        if (!jsonFile.exists()) {
            LOG.error((Object)("File [" + jsonFile.getAbsolutePath() + "] doesn't exist"));
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        YarnJacksonJaxbJsonProvider.configObjectMapper((ObjectMapper)mapper);
        TimelineEntities entities = null;
        TimelineDomains domains = null;
        try {
            if (type.equals("entity")) {
                entities = (TimelineEntities)mapper.readValue(jsonFile, TimelineEntities.class);
            } else if (type.equals("domain")) {
                domains = (TimelineDomains)mapper.readValue(jsonFile, TimelineDomains.class);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error when reading  " + e.getMessage()));
            e.printStackTrace(System.err);
            return;
        }
        YarnConfiguration conf = new YarnConfiguration();
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init((Configuration)conf);
        client.start();
        try {
            if (UserGroupInformation.isSecurityEnabled() && conf.getBoolean("yarn.timeline-service.enabled", false)) {
                Token token = client.getDelegationToken(UserGroupInformation.getCurrentUser().getUserName());
                UserGroupInformation.getCurrentUser().addToken(token);
            }
            if (type.equals("entity")) {
                TimelinePutResponse response = client.putEntities(entities.getEntities().toArray(new TimelineEntity[entities.getEntities().size()]));
                if (response.getErrors().size() == 0) {
                    LOG.info((Object)"Timeline entities are successfully put");
                } else {
                    for (TimelinePutResponse.TimelinePutError error : response.getErrors()) {
                        LOG.error((Object)("TimelineEntity [" + error.getEntityType() + ":" + error.getEntityId() + "] is not successfully put. Error code: " + error.getErrorCode()));
                    }
                }
            } else if (type.equals("domain") && domains != null) {
                boolean hasError = false;
                for (TimelineDomain domain : domains.getDomains()) {
                    try {
                        client.putDomain(domain);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error when putting domain " + domain.getId()), (Throwable)e);
                        hasError = true;
                    }
                }
                if (!hasError) {
                    LOG.info((Object)"Timeline domains are successfully put");
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        finally {
            client.stop();
        }
    }

    private static void printUsage() {
        new HelpFormatter().printHelp("TimelineClient", opts);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ DelegationTokenAuthenticator access$400(TimelineClientImpl x0) {
        return x0.authenticator;
    }

    static /* synthetic */ ConnectionConfigurator access$500(TimelineClientImpl x0) {
        return x0.connConfigurator;
    }

    static /* synthetic */ URI access$600(TimelineClientImpl x0) {
        return x0.resURI;
    }

    static /* synthetic */ DelegationTokenAuthenticatedURL.Token access$700(TimelineClientImpl x0) {
        return x0.token;
    }

    static /* synthetic */ void access$800(URLConnection x0, int x1) {
        TimelineClientImpl.setTimeouts((URLConnection)x0, (int)x1);
    }

    static {
        opts.addOption("put", true, "Put the timeline entities/domain in a JSON file");
        opts.getOption("put").setArgName("Path to the JSON file");
        opts.addOption("entity", false, "Specify the JSON file contains the entities");
        opts.addOption("domain", false, "Specify the JSON file contains the domain");
        opts.addOption("help", false, "Print usage");
        DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new /* Unavailable Anonymous Inner Class!! */;
    }
}

