/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"yarn", "mapreduce"})
public class AggregatedLogDeletionService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AggregatedLogDeletionService.class);
    private Timer timer = null;
    private long checkIntervalMsecs;
    private LogDeletionTask task;

    private static void logIOException(String comment, IOException e) {
        if (e instanceof AccessControlException) {
            String message = e.getMessage();
            message = message.split("\n")[0];
            LOG.warn((Object)(comment + " " + message));
        } else {
            LOG.error((Object)comment, (Throwable)e);
        }
    }

    public AggregatedLogDeletionService() {
        super(AggregatedLogDeletionService.class.getName());
    }

    protected void serviceStart() throws Exception {
        this.scheduleLogDeletionTask();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopRMClient();
        this.stopTimer();
        super.serviceStop();
    }

    private void setLogAggCheckIntervalMsecs(long retentionSecs) {
        Configuration conf = this.getConfig();
        this.checkIntervalMsecs = 1000L * conf.getLong("yarn.log-aggregation.retain-check-interval-seconds", -1L);
        if (this.checkIntervalMsecs <= 0L) {
            this.checkIntervalMsecs = retentionSecs * 1000L / 10L;
        }
    }

    public void refreshLogRetentionSettings() throws IOException {
        if (this.getServiceState() == Service.STATE.STARTED) {
            Configuration conf = this.createConf();
            this.setConfig(conf);
            this.stopRMClient();
            this.stopTimer();
            this.scheduleLogDeletionTask();
        } else {
            LOG.warn((Object)"Failed to execute refreshLogRetentionSettings : Aggregated Log Deletion Service is not started");
        }
    }

    private void scheduleLogDeletionTask() throws IOException {
        Configuration conf = this.getConfig();
        if (!conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return;
        }
        long retentionSecs = conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
        if (retentionSecs < 0L) {
            LOG.info((Object)("Log Aggregation deletion is disabled because retention is too small (" + retentionSecs + ")"));
            return;
        }
        this.setLogAggCheckIntervalMsecs(retentionSecs);
        this.task = new LogDeletionTask(conf, retentionSecs, this.creatRMClient());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 0L, this.checkIntervalMsecs);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public long getCheckIntervalMsecs() {
        return this.checkIntervalMsecs;
    }

    protected Configuration createConf() {
        return new Configuration();
    }

    @VisibleForTesting
    protected ApplicationClientProtocol creatRMClient() throws IOException {
        return (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.getConfig(), ApplicationClientProtocol.class);
    }

    @VisibleForTesting
    protected void stopRMClient() {
        if (this.task != null && this.task.getRMClient() != null) {
            RPC.stopProxy((Object)this.task.getRMClient());
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(String x0, IOException x1) {
        AggregatedLogDeletionService.logIOException((String)x0, (IOException)x1);
    }
}

