/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.nodelabels.TestFileSystemNodeLabelsStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFileSystemNodeLabelsStore
extends NodeLabelTestBase {
    MockNodeLabelManager mgr = null;
    Configuration conf = null;

    private FileSystemNodeLabelsStore getStore() {
        return (FileSystemNodeLabelsStore)this.mgr.store;
    }

    @Before
    public void before() throws IOException {
        this.mgr = new MockNodeLabelManager(null);
        this.conf = new Configuration();
        File tempDir = File.createTempFile("nlb", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        this.conf.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
        this.mgr.init(this.conf);
        this.mgr.start();
    }

    @After
    public void after() throws IOException {
        this.getStore().fs.delete(this.getStore().fsWorkingPath, true);
        this.mgr.stop();
    }

    @Test(timeout=10000L)
    public void testRecoverWithMirror() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5", "p6"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p3"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n5"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.removeFromClusterNodeLabels((Collection)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains((Map)this.mgr.getNodeLabels(), (ImmutableMap)ImmutableMap.of((Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains((Map)this.mgr.getNodeLabels(), (ImmutableMap)ImmutableMap.of((Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.stop();
    }

    @Test(timeout=10000L)
    public void testEditlogRecover() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5", "p6"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p3"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n5"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.removeFromClusterNodeLabels((Collection)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains((Map)this.mgr.getNodeLabels(), (ImmutableMap)ImmutableMap.of((Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.stop();
    }

    @Test
    public void testSerilizationAfterRecovery() throws Exception {
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}));
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5", "p6"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p3"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n5"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p5"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr.removeFromClusterNodeLabels((Collection)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p1"}));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("p3", "p5"));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((long)3L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6")));
        TestFileSystemNodeLabelsStore.assertMapContains((Map)this.mgr.getNodeLabels(), (ImmutableMap)ImmutableMap.of((Object)this.toNodeId("n2"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n4"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n6"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"}), (Object)this.toNodeId("n7"), (Object)TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p6"})));
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p7", "p8"}));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabels(TestFileSystemNodeLabelsStore.toSet((Object[])new String[]{"p9"}));
        this.mgr.stop();
        this.mgr = new MockNodeLabelManager(null);
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((long)6L, (long)this.mgr.getClusterNodeLabels().size());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabels().containsAll(Arrays.asList("p2", "p4", "p6", "p7", "p8", "p9")));
        this.mgr.stop();
    }
}

