/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfiguredYarnAuthorizer
extends YarnAuthorizationProvider {
    private final ConcurrentMap<PrivilegedEntity, Map<AccessType, AccessControlList>> allAcls = new ConcurrentHashMap();
    private volatile AccessControlList adminAcl = null;

    public void init(Configuration conf) {
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
    }

    public void setPermission(PrivilegedEntity target, Map<AccessType, AccessControlList> acls, UserGroupInformation ugi) {
        this.allAcls.put(target, acls);
    }

    public boolean checkPermission(AccessType accessType, PrivilegedEntity target, UserGroupInformation user) {
        AccessControlList list;
        boolean ret = false;
        Map acls = (Map)this.allAcls.get(target);
        if (acls != null && (list = (AccessControlList)acls.get(accessType)) != null) {
            ret = list.isUserAllowed(user);
        }
        if (target.getType() == PrivilegedEntity.EntityType.QUEUE && !ret) {
            String queueName = target.getName();
            if (!queueName.contains(".")) {
                return ret;
            }
            String parentQueueName = queueName.substring(0, queueName.lastIndexOf("."));
            return this.checkPermission(accessType, new PrivilegedEntity(target.getType(), parentQueueName), user);
        }
        return ret;
    }

    public void setAdmins(AccessControlList acls, UserGroupInformation ugi) {
        this.adminAcl = acls;
    }

    public boolean isAdmin(UserGroupInformation ugi) {
        return this.adminAcl.isUserAllowed(ugi);
    }

    public AccessControlList getAdminAcls() {
        return this.adminAcl;
    }
}

