/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.client.BaseClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientToAMTokenSecretManager
extends BaseClientToAMTokenSecretManager {
    private static final int MASTER_KEY_WAIT_MSEC = 10000;
    private volatile SecretKey masterKey;

    public ClientToAMTokenSecretManager(ApplicationAttemptId applicationAttemptID, byte[] key) {
        this.masterKey = key != null ? SecretManager.createSecretKey((byte[])key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrievePassword(ClientToAMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        if (this.masterKey == null) {
            ClientToAMTokenSecretManager clientToAMTokenSecretManager = this;
            synchronized (clientToAMTokenSecretManager) {
                while (this.masterKey == null) {
                    try {
                        this.wait(10000L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
        return super.retrievePassword(identifier);
    }

    public SecretKey getMasterKey(ApplicationAttemptId applicationAttemptID) {
        return this.masterKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterKey(byte[] key) {
        ClientToAMTokenSecretManager clientToAMTokenSecretManager = this;
        synchronized (clientToAMTokenSecretManager) {
            this.masterKey = SecretManager.createSecretKey((byte[])key);
            this.notifyAll();
        }
    }
}

