/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.TestContainerId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConverterUtils {
    @Test
    public void testConvertUrlWithNoPort() throws URISyntaxException {
        Path expectedPath = new Path("hdfs://foo.com");
        URL url = ConverterUtils.getYarnUrlFromPath((Path)expectedPath);
        Path actualPath = ConverterUtils.getPathFromYarnURL((URL)url);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testConvertUrlWithUserinfo() throws URISyntaxException {
        Path expectedPath = new Path("foo://username:password@example.com:8042");
        URL url = ConverterUtils.getYarnUrlFromPath((Path)expectedPath);
        Path actualPath = ConverterUtils.getPathFromYarnURL((URL)url);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testContainerId() throws URISyntaxException {
        ContainerId id = TestContainerId.newContainerId((int)0, (int)0, (long)0L, (long)0L);
        String cid = ConverterUtils.toString((ContainerId)id);
        Assert.assertEquals((Object)"container_0_0000_00_000000", (Object)cid);
        ContainerId gen = ConverterUtils.toContainerId((String)cid);
        Assert.assertEquals((Object)gen, (Object)id);
    }

    @Test
    public void testContainerIdWithEpoch() throws URISyntaxException {
        ContainerId id = TestContainerId.newContainerId((int)0, (int)0, (long)0L, (long)25645811L);
        String cid = ConverterUtils.toString((ContainerId)id);
        Assert.assertEquals((Object)"container_0_0000_00_25645811", (Object)cid);
        ContainerId gen = ConverterUtils.toContainerId((String)cid);
        Assert.assertEquals((Object)gen.toString(), (Object)id.toString());
        long ts = System.currentTimeMillis();
        ContainerId id2 = TestContainerId.newContainerId((int)36473, (int)4365472, (long)ts, (long)4298334883325L);
        String cid2 = ConverterUtils.toString((ContainerId)id2);
        Assert.assertEquals((Object)("container_e03_" + ts + "_36473_4365472_999799999997"), (Object)cid2);
        ContainerId gen2 = ConverterUtils.toContainerId((String)cid2);
        Assert.assertEquals((Object)gen2.toString(), (Object)id2.toString());
        ContainerId id3 = TestContainerId.newContainerId((int)36473, (int)4365472, (long)ts, (long)0x2FFFFFFFFFFFDL);
        String cid3 = ConverterUtils.toString((ContainerId)id3);
        Assert.assertEquals((Object)("container_e767_" + ts + "_36473_4365472_1099511627773"), (Object)cid3);
        ContainerId gen3 = ConverterUtils.toContainerId((String)cid3);
        Assert.assertEquals((Object)gen3.toString(), (Object)id3.toString());
    }

    @Test
    public void testContainerIdNull() throws URISyntaxException {
        Assert.assertNull((Object)ConverterUtils.toString((ContainerId)null));
    }

    @Test
    public void testNodeIdWithDefaultPort() throws URISyntaxException {
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)"node:10");
        Assert.assertEquals((long)nid.getPort(), (long)10L);
        Assert.assertEquals((Object)nid.getHost(), (Object)"node");
        nid = ConverterUtils.toNodeIdWithDefaultPort((String)"node");
        Assert.assertEquals((long)nid.getPort(), (long)0L);
        Assert.assertEquals((Object)nid.getHost(), (Object)"node");
    }
}

