/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.TestWindowsBasedProcessTree;
import org.apache.hadoop.yarn.util.WindowsBasedProcessTree;
import org.junit.Assert;
import org.junit.Test;

public class TestWindowsBasedProcessTree {
    private static final Log LOG = LogFactory.getLog(TestWindowsBasedProcessTree.class);

    @Test(timeout=30000L)
    public void tree() {
        if (!Shell.WINDOWS) {
            LOG.info((Object)"Platform not Windows. Not testing");
            return;
        }
        Assert.assertTrue((String)"WindowsBasedProcessTree should be available on Windows", (boolean)WindowsBasedProcessTree.isAvailable());
        WindowsBasedProcessTreeTester pTree = new WindowsBasedProcessTreeTester(this, "-1");
        pTree.infoStr = "3524,1024,1024,500\r\n2844,1024,1024,500\r\n";
        pTree.updateProcessTree();
        Assert.assertTrue((pTree.getVirtualMemorySize() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getVirtualMemorySize(0) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem(0) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize(0) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem(0) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeCpuTime() == 1000L ? 1 : 0) != 0);
        pTree.infoStr = "3524,1024,1024,1000\r\n2844,1024,1024,1000\r\n1234,1024,1024,1000\r\n";
        pTree.updateProcessTree();
        Assert.assertTrue((pTree.getVirtualMemorySize() == 3072L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem() == 3072L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getVirtualMemorySize(1) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem(1) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize() == 3072L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem() == 3072L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize(1) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem(1) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeCpuTime() == 3000L ? 1 : 0) != 0);
        pTree.infoStr = "3524,1024,1024,1500\r\n2844,1024,1024,1500\r\n";
        pTree.updateProcessTree();
        Assert.assertTrue((pTree.getVirtualMemorySize() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getVirtualMemorySize(2) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeVmem(2) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem() == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getRssMemorySize(2) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeRssmem(2) == 2048L ? 1 : 0) != 0);
        Assert.assertTrue((pTree.getCumulativeCpuTime() == 4000L ? 1 : 0) != 0);
    }
}

