/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceCalculator
extends ResourceCalculator {
    public int compare(Resource clusterResource, Resource lhs, Resource rhs, boolean singleType) {
        float r;
        float l;
        if (lhs.equals((Object)rhs)) {
            return 0;
        }
        if (this.isInvalidDivisor(clusterResource)) {
            if (lhs.getMemory() < rhs.getMemory() && lhs.getVirtualCores() > rhs.getVirtualCores() || lhs.getMemory() > rhs.getMemory() && lhs.getVirtualCores() < rhs.getVirtualCores()) {
                return 0;
            }
            if (lhs.getMemory() > rhs.getMemory() || lhs.getVirtualCores() > rhs.getVirtualCores()) {
                return 1;
            }
            if (lhs.getMemory() < rhs.getMemory() || lhs.getVirtualCores() < rhs.getVirtualCores()) {
                return -1;
            }
        }
        if ((l = this.getResourceAsValue(clusterResource, lhs, true)) < (r = this.getResourceAsValue(clusterResource, rhs, true))) {
            return -1;
        }
        if (l > r) {
            return 1;
        }
        if (!singleType) {
            l = this.getResourceAsValue(clusterResource, lhs, false);
            if (l < (r = this.getResourceAsValue(clusterResource, rhs, false))) {
                return -1;
            }
            if (l > r) {
                return 1;
            }
        }
        return 0;
    }

    protected float getResourceAsValue(Resource clusterResource, Resource resource, boolean dominant) {
        return dominant ? Math.max((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()) : Math.min((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores());
    }

    public int computeAvailableContainers(Resource available, Resource required) {
        return Math.min(available.getMemory() / required.getMemory(), available.getVirtualCores() / required.getVirtualCores());
    }

    public float divide(Resource clusterResource, Resource numerator, Resource denominator) {
        return this.getResourceAsValue(clusterResource, numerator, true) / this.getResourceAsValue(clusterResource, denominator, true);
    }

    public boolean isInvalidDivisor(Resource r) {
        return (float)r.getMemory() == 0.0f || (float)r.getVirtualCores() == 0.0f;
    }

    public float ratio(Resource a, Resource b) {
        return Math.max((float)a.getMemory() / (float)b.getMemory(), (float)a.getVirtualCores() / (float)b.getVirtualCores());
    }

    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource((int)DominantResourceCalculator.divideAndCeil((int)numerator.getMemory(), (int)denominator), (int)DominantResourceCalculator.divideAndCeil((int)numerator.getVirtualCores(), (int)denominator));
    }

    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DominantResourceCalculator.roundUp((int)Math.max(r.getMemory(), minimumResource.getMemory()), (int)stepFactor.getMemory()), maximumResource.getMemory());
        int normalizedCores = Math.min(DominantResourceCalculator.roundUp((int)Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), (int)stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        return Resources.createResource((int)normalizedMemory, (int)normalizedCores);
    }

    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DominantResourceCalculator.roundUp((int)r.getMemory(), (int)stepFactor.getMemory()), (int)DominantResourceCalculator.roundUp((int)r.getVirtualCores(), (int)stepFactor.getVirtualCores()));
    }

    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DominantResourceCalculator.roundDown((int)r.getMemory(), (int)stepFactor.getMemory()), (int)DominantResourceCalculator.roundDown((int)r.getVirtualCores(), (int)stepFactor.getVirtualCores()));
    }

    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DominantResourceCalculator.roundUp((int)((int)Math.ceil((double)r.getMemory() * by)), (int)stepFactor.getMemory()), (int)DominantResourceCalculator.roundUp((int)((int)Math.ceil((double)r.getVirtualCores() * by)), (int)stepFactor.getVirtualCores()));
    }

    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DominantResourceCalculator.roundDown((int)((int)((double)r.getMemory() * by)), (int)stepFactor.getMemory()), (int)DominantResourceCalculator.roundDown((int)((int)((double)r.getVirtualCores() * by)), (int)stepFactor.getVirtualCores()));
    }
}

