/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestResources {
    public Resource createResource(int memory, int vCores) {
        return Resource.newInstance((int)memory, (int)vCores);
    }

    @Test(timeout=1000L)
    public void testCompareToWithNoneResource() {
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0, 0)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(1, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0, 1)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleRoundUp() {
        double by = 0.5;
        String memoryErrorMsg = "Invalid memory size.";
        String vcoreErrorMsg = "Invalid virtual core number.";
        Resource resource = Resources.createResource((int)1, (int)1);
        Resource result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assert.assertEquals((String)"Invalid memory size.", (long)result.getMemory(), (long)1L);
        Assert.assertEquals((String)"Invalid virtual core number.", (long)result.getVirtualCores(), (long)1L);
        resource = Resources.createResource((int)2, (int)2);
        result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assert.assertEquals((String)"Invalid memory size.", (long)result.getMemory(), (long)1L);
        Assert.assertEquals((String)"Invalid virtual core number.", (long)result.getVirtualCores(), (long)1L);
        resource = Resources.createResource((int)0, (int)0);
        result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assert.assertEquals((String)"Invalid memory size.", (long)result.getMemory(), (long)0L);
        Assert.assertEquals((String)"Invalid virtual core number.", (long)result.getVirtualCores(), (long)0L);
    }
}

