/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.TextView;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class HtmlBlock
extends TextView
implements SubView {
    private Block block;

    private Block block() {
        if (this.block == null) {
            this.block = new Block(this, this.writer(), this.context().nestLevel(), this.context().wasInline());
        }
        return this.block;
    }

    protected HtmlBlock() {
        this(null);
    }

    protected HtmlBlock(View.ViewContext ctx) {
        super(ctx, "text/html; charset=UTF-8");
    }

    public void render() {
        int nestLevel = this.context().nestLevel();
        LOG.debug("Rendering {} @{}", this.getClass(), (Object)nestLevel);
        this.render(this.block());
        if (this.block.nestLevel() != nestLevel) {
            throw new WebAppException("Error rendering block: nestLevel=" + this.block.nestLevel() + " expected " + nestLevel);
        }
        this.context().set(nestLevel, this.block.wasInline());
    }

    public void renderPartial() {
        this.render();
    }

    protected abstract void render(Block var1);

    protected UserGroupInformation getCallerUGI() {
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }
}

