/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.services;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.registry.client.api.RegistryConstants;
import org.apache.hadoop.registry.client.impl.zk.BindingInformation;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.impl.zk.ZookeeperConfigOptions;
import org.apache.hadoop.registry.server.services.MicroZookeeperServiceKeys;
import org.apache.hadoop.service.AbstractService;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class MicroZookeeperService
extends AbstractService
implements RegistryBindingSource,
RegistryConstants,
ZookeeperConfigOptions,
MicroZookeeperServiceKeys {
    private static final Logger LOG = LoggerFactory.getLogger(MicroZookeeperService.class);
    private File instanceDir;
    private File dataDir;
    private int tickTime;
    private int port;
    private String host;
    private boolean secureServer;
    private ServerCnxnFactory factory;
    private BindingInformation binding;
    private File confDir;
    private StringBuilder diagnostics = new StringBuilder();

    public MicroZookeeperService(String name) {
        super(name);
    }

    public String getConnectionString() {
        Preconditions.checkState((this.factory != null ? 1 : 0) != 0, (Object)"service not started");
        InetSocketAddress addr = this.factory.getLocalAddress();
        return String.format("%s:%d", addr.getHostName(), addr.getPort());
    }

    public InetSocketAddress getConnectionAddress() {
        Preconditions.checkState((this.factory != null ? 1 : 0) != 0, (Object)"service not started");
        return this.factory.getLocalAddress();
    }

    private InetSocketAddress getAddress(int port) throws UnknownHostException {
        return new InetSocketAddress(this.host, port <= 0 ? this.getRandomAvailablePort() : port);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.port = conf.getInt("hadoop.registry.zk.service.port", 0);
        this.tickTime = conf.getInt("hadoop.registry.zk.service.ticktime", 3000);
        String instancedirname = conf.getTrimmed("hadoop.registry.zk.service.dir", "");
        this.host = conf.getTrimmed("hadoop.registry.zk.service.host", "localhost");
        if (instancedirname.isEmpty()) {
            File testdir = new File(System.getProperty("test.dir", "target"));
            this.instanceDir = new File(testdir, "zookeeper" + this.getName());
        } else {
            this.instanceDir = new File(instancedirname);
            FileUtil.fullyDelete((File)this.instanceDir);
        }
        LOG.debug("Instance directory is {}", (Object)this.instanceDir);
        this.mkdirStrict(this.instanceDir);
        this.dataDir = new File(this.instanceDir, "data");
        this.confDir = new File(this.instanceDir, "conf");
        this.mkdirStrict(this.dataDir);
        this.mkdirStrict(this.confDir);
        super.serviceInit(conf);
    }

    private void mkdirStrict(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Failed to mkdir " + dir);
        }
    }

    protected void addDiagnostics(String text, Object ... args) {
        this.diagnostics.append(String.format(text, args)).append('\n');
    }

    public String getDiagnostics() {
        return this.diagnostics.toString();
    }

    public boolean setupSecurity() throws IOException {
        Configuration conf = this.getConfig();
        String jaasContext = conf.getTrimmed("hadoop.registry.zk.service.service.jaas.context");
        this.secureServer = StringUtils.isNotEmpty((String)jaasContext);
        if (this.secureServer) {
            RegistrySecurity.validateContext(jaasContext);
            RegistrySecurity.bindZKToServerJAASContext(jaasContext);
            System.setProperty("zookeeper.allowSaslFailedClients", conf.get("hadoop.registry.zk.service.allow.failed.sasl.clients", "true"));
            System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            String serverContext = System.getProperty("zookeeper.sasl.serverconfig");
            this.addDiagnostics("Server JAAS context s = %s", serverContext);
            return true;
        }
        return false;
    }

    protected void serviceStart() throws Exception {
        this.setupSecurity();
        FileTxnSnapLog ftxn = new FileTxnSnapLog(this.dataDir, this.dataDir);
        ZooKeeperServer zkServer = new ZooKeeperServer(ftxn, this.tickTime, "");
        LOG.info("Starting Local Zookeeper service");
        this.factory = ServerCnxnFactory.createFactory();
        this.factory.configure(this.getAddress(this.port), -1);
        this.factory.startup(zkServer);
        String connectString = this.getConnectionString();
        LOG.info("In memory ZK started at {}\n", (Object)connectString);
        if (LOG.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            zkServer.dumpConf(pw);
            pw.flush();
            LOG.debug("ZooKeeper config:\n" + sw.toString());
        }
        this.binding = new BindingInformation();
        this.binding.ensembleProvider = new FixedEnsembleProvider(connectString);
        this.binding.description = this.getName() + " reachable at \"" + connectString + "\"";
        this.addDiagnostics(this.binding.description, new Object[0]);
        this.getConfig().set("hadoop.registry.zk.quorum", connectString);
    }

    protected void serviceStop() throws Exception {
        if (this.factory != null) {
            this.factory.shutdown();
            this.factory = null;
        }
        if (this.dataDir != null) {
            FileUtil.fullyDelete((File)this.dataDir);
        }
    }

    @Override
    public BindingInformation supplyBindingInformation() {
        Preconditions.checkNotNull((Object)this.binding, (Object)"Service is not started: binding information undefined");
        return this.binding;
    }

    private int getRandomAvailablePort() {
        this.port = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            this.port = s.getLocalPort();
            s.close();
        }
        catch (IOException e) {
            LOG.warn("ERROR during selecting random port for ZooKeeper server to bind.", (Throwable)e);
        }
        return this.port;
    }
}

