/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.uam;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.uam.UnmanagedApplicationManager;
import org.apache.hadoop.yarn.server.utils.AMRMClientUtils;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class UnmanagedAMPoolManager
extends AbstractService {
    public static final Logger LOG = LoggerFactory.getLogger(UnmanagedAMPoolManager.class);
    private Map<String, UnmanagedApplicationManager> unmanagedAppMasterMap;
    private Map<String, ApplicationAttemptId> attemptIdMap;
    private ExecutorService threadpool;

    public UnmanagedAMPoolManager(ExecutorService threadpool) {
        super(UnmanagedAMPoolManager.class.getName());
        this.threadpool = threadpool;
    }

    protected void serviceStart() throws Exception {
        if (this.threadpool == null) {
            this.threadpool = Executors.newCachedThreadPool();
        }
        this.unmanagedAppMasterMap = new ConcurrentHashMap<String, UnmanagedApplicationManager>();
        this.attemptIdMap = new ConcurrentHashMap<String, ApplicationAttemptId>();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        ExecutorCompletionService<KillApplicationResponse> completionService = new ExecutorCompletionService<KillApplicationResponse>(this.threadpool);
        if (this.unmanagedAppMasterMap.isEmpty()) {
            return;
        }
        HashSet<String> addressList = new HashSet<String>(this.unmanagedAppMasterMap.keySet());
        LOG.warn("Abnormal shutdown of UAMPoolManager, still {} UAMs in map", (Object)addressList.size());
        for (final String uamId : addressList) {
            completionService.submit(new Callable<KillApplicationResponse>(){

                @Override
                public KillApplicationResponse call() throws Exception {
                    try {
                        LOG.info("Force-killing UAM id " + uamId + " for application " + UnmanagedAMPoolManager.this.attemptIdMap.get(uamId));
                        return ((UnmanagedApplicationManager)UnmanagedAMPoolManager.this.unmanagedAppMasterMap.remove(uamId)).forceKillApplication();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to kill unmanaged application master", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        for (int i = 0; i < addressList.size(); ++i) {
            try {
                Future future = completionService.take();
                future.get();
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to kill unmanaged application master", (Throwable)e);
            }
        }
        this.attemptIdMap.clear();
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAndRegisterNewUAM(RegisterApplicationMasterRequest registerRequest, Configuration conf, String queueName, String submitter, String appNameSuffix) throws YarnException, IOException {
        ApplicationClientProtocol rmClient;
        ApplicationId appId = null;
        try {
            UserGroupInformation appSubmitter = UserGroupInformation.createRemoteUser((String)submitter);
            rmClient = AMRMClientUtils.createRMProxy(conf, ApplicationClientProtocol.class, appSubmitter, null);
            GetNewApplicationResponse response = rmClient.getNewApplication(GetNewApplicationRequest.newInstance());
            if (response == null) {
                throw new YarnException("getNewApplication got null response");
            }
            appId = response.getApplicationId();
            LOG.info("Received new application ID {} from RM", (Object)appId);
        }
        finally {
            rmClient = null;
        }
        this.createAndRegisterNewUAM(appId.toString(), registerRequest, conf, appId, queueName, submitter, appNameSuffix);
        return appId.toString();
    }

    public RegisterApplicationMasterResponse createAndRegisterNewUAM(String uamId, RegisterApplicationMasterRequest registerRequest, Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix) throws YarnException, IOException {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " already exists");
        }
        UnmanagedApplicationManager uam = this.createUAM(conf, appId, queueName, submitter, appNameSuffix);
        this.unmanagedAppMasterMap.put(uamId, uam);
        RegisterApplicationMasterResponse response = null;
        try {
            LOG.info("Creating and registering UAM id {} for application {}", (Object)uamId, (Object)appId);
            response = uam.createAndRegisterApplicationMaster(registerRequest);
        }
        catch (Exception e) {
            this.unmanagedAppMasterMap.remove(uamId);
            throw e;
        }
        this.attemptIdMap.put(uamId, uam.getAttemptId());
        return response;
    }

    @VisibleForTesting
    protected UnmanagedApplicationManager createUAM(Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix) {
        return new UnmanagedApplicationManager(conf, appId, queueName, submitter, appNameSuffix);
    }

    public void allocateAsync(String uamId, AllocateRequest request, AsyncCallback<AllocateResponse> callback) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        this.unmanagedAppMasterMap.get(uamId).allocateAsync(request, callback);
    }

    public FinishApplicationMasterResponse finishApplicationMaster(String uamId, FinishApplicationMasterRequest request) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Finishing application for UAM id {} ", (Object)uamId);
        FinishApplicationMasterResponse response = this.unmanagedAppMasterMap.get(uamId).finishApplicationMaster(request);
        if (response.getIsUnregistered()) {
            this.unmanagedAppMasterMap.remove(uamId);
            this.attemptIdMap.remove(uamId);
            LOG.info("UAM id {} is unregistered", (Object)uamId);
        }
        return response;
    }

    public Set<String> getAllUAMIds() {
        return new HashSet<String>(this.unmanagedAppMasterMap.keySet());
    }

    public boolean hasUAMId(String uamId) {
        return this.unmanagedAppMasterMap.containsKey(uamId);
    }
}

