/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class YarnServerSecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YarnServerSecurityUtils.class);
    @VisibleForTesting
    public static final String CCJ_FIPS_APPROVED_ONLY_PROPERTY = "com.safelogic.cryptocomply.fips.approved_only";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String KEYSTORE_TYPE_BCFKS = "BCFKS";

    private YarnServerSecurityUtils() {
    }

    public static AMRMTokenIdentifier authorizeRequest() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name for authorizing ApplicationMaster. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        boolean tokenFound = false;
        String message = "";
        AMRMTokenIdentifier appTokenIdentifier = null;
        try {
            appTokenIdentifier = YarnServerSecurityUtils.selectAMRMTokenIdentifier(remoteUgi);
            if (appTokenIdentifier == null) {
                tokenFound = false;
                message = "No AMRMToken found for user " + remoteUgi.getUserName();
            } else {
                tokenFound = true;
            }
        }
        catch (IOException e) {
            tokenFound = false;
            message = "Got exception while looking for AMRMToken for user " + remoteUgi.getUserName();
        }
        if (!tokenFound) {
            LOG.warn(message);
            throw RPCUtil.getRemoteException((String)message);
        }
        return appTokenIdentifier;
    }

    private static AMRMTokenIdentifier selectAMRMTokenIdentifier(UserGroupInformation remoteUgi) throws IOException {
        AMRMTokenIdentifier result = null;
        Set tokenIds = remoteUgi.getTokenIdentifiers();
        for (TokenIdentifier tokenId : tokenIds) {
            if (!(tokenId instanceof AMRMTokenIdentifier)) continue;
            result = (AMRMTokenIdentifier)tokenId;
            break;
        }
        return result;
    }

    public static void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token, UserGroupInformation user, Configuration conf) {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        user.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService((Configuration)conf));
    }

    public static Credentials parseCredentials(ContainerLaunchContext launchContext) throws IOException {
        Credentials credentials = new Credentials();
        ByteBuffer tokens = launchContext.getTokens();
        if (tokens != null) {
            DataInputByteBuffer buf = new DataInputByteBuffer();
            tokens.rewind();
            buf.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)buf);
            if (LOG.isDebugEnabled()) {
                for (Token tk : credentials.getAllTokens()) {
                    LOG.debug(tk.getService() + " = " + tk.toString());
                }
            }
        }
        return credentials;
    }

    public static boolean isFipsEnabled() {
        boolean fipsEnabled;
        String fipsApprovedModeValue = System.getProperty(CCJ_FIPS_APPROVED_ONLY_PROPERTY);
        boolean bl = fipsEnabled = fipsApprovedModeValue != null && Boolean.valueOf(fipsApprovedModeValue) != false;
        if (LOG.isTraceEnabled()) {
            LOG.trace("FIPS mode: {}, value of JVM property '{}' is: {}", new Object[]{fipsEnabled, CCJ_FIPS_APPROVED_ONLY_PROPERTY, fipsApprovedModeValue});
        }
        return fipsEnabled;
    }

    public static void printSecurityProviders() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Available Security Providers are:");
        }
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            if (LOG.isTraceEnabled()) {
                LOG.trace("[" + (i + 1) + "] - Name: " + provider.getName());
                LOG.trace("Information:\n" + provider.getInfo());
                LOG.trace("Listing providers with types of service and algorithm provided:\n");
            }
            Set<Provider.Service> services = provider.getServices();
            ArrayList<Provider.Service> servicesList = new ArrayList<Provider.Service>(services);
            servicesList.sort(Comparator.comparing(Provider.Service::getType));
            for (Provider.Service service : servicesList) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace(String.format("- Name: %s, Service Type: %s, Algorithm: %s", provider.getName(), service.getType(), service.getAlgorithm()));
            }
        }
    }

    public static int getProviderIndex(String providerName) {
        int providerIndex = 1;
        if (providerName == null) {
            return -1;
        }
        for (Provider provider : Security.getProviders()) {
            if (providerName.equalsIgnoreCase(provider.getName())) {
                return providerIndex;
            }
            ++providerIndex;
        }
        return -1;
    }
}

