/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;

@InterfaceAudience.Private
public class RMCriticalThreadUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log LOG = LogFactory.getLog(RMCriticalThreadUncaughtExceptionHandler.class);
    private RMContext rmContext;

    public RMCriticalThreadUncaughtExceptionHandler(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        LOG.fatal((Object)("Critical thread " + t.getName() + " crashed!"), e);
        if (HAUtil.isHAEnabled((Configuration)this.rmContext.getYarnConfiguration())) {
            this.rmContext.getResourceManager().handleTransitionToStandByInNewThread();
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.CRITICAL_THREAD_CRASH, new Exception(e)));
        }
    }
}

