/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.InvalidQueueNameException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueManager {
    public static final Log LOG = LogFactory.getLog((String)QueueManager.class.getName());
    public static final String ROOT_QUEUE = "root";
    private final FairScheduler scheduler;
    private final Collection<FSLeafQueue> leafQueues = new CopyOnWriteArrayList<FSLeafQueue>();
    private final Map<String, FSQueue> queues = new HashMap<String, FSQueue>();
    private FSParentQueue rootQueue;

    public QueueManager(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public FSParentQueue getRootQueue() {
        return this.rootQueue;
    }

    public void initialize(Configuration conf) throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        this.rootQueue = new FSParentQueue(ROOT_QUEUE, this.scheduler, null);
        this.queues.put(this.rootQueue.getName(), this.rootQueue);
        this.getLeafQueue("default", true);
    }

    public FSLeafQueue getLeafQueue(String name, boolean create) {
        return this.getLeafQueue(name, create, true);
    }

    public FSLeafQueue getLeafQueue(String name, boolean create, boolean recomputeSteadyShares) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.LEAF, recomputeSteadyShares);
        if (queue instanceof FSParentQueue) {
            return null;
        }
        return (FSLeafQueue)queue;
    }

    public FSParentQueue getParentQueue(String name, boolean create) {
        return this.getParentQueue(name, create, true);
    }

    public FSParentQueue getParentQueue(String name, boolean create, boolean recomputeSteadyShares) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.PARENT, recomputeSteadyShares);
        if (queue instanceof FSLeafQueue) {
            return null;
        }
        return (FSParentQueue)queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSQueue getQueue(String name, boolean create, FSQueueType queueType, boolean recomputeSteadyShares) {
        FSQueue queue;
        boolean recompute = recomputeSteadyShares;
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            queue = this.queues.get(name);
            if (queue == null && create) {
                queue = this.createQueue(name, queueType);
            } else {
                recompute = false;
            }
        }
        if (recompute) {
            this.rootQueue.recomputeSteadyShares();
        }
        return queue;
    }

    @VisibleForTesting
    FSQueue createQueue(String name, FSQueueType queueType) {
        ArrayList<String> newQueueNames = new ArrayList<String>();
        FSParentQueue parent = this.buildNewQueueList(name, newQueueNames);
        FSQueue queue = null;
        if (parent != null) {
            queue = this.createNewQueues(queueType, parent, newQueueNames);
        }
        return queue;
    }

    private FSParentQueue buildNewQueueList(String name, List<String> newQueueNames) {
        newQueueNames.add(name);
        int sepIndex = name.length();
        FSParentQueue parent = null;
        while (sepIndex != -1) {
            int prevSepIndex = sepIndex;
            String node = name.substring((sepIndex = name.lastIndexOf(46, sepIndex - 1)) + 1, prevSepIndex);
            if (!this.isQueueNameValid(node)) {
                throw new InvalidQueueNameException("Illegal node name at offset " + (sepIndex + 1) + " for queue name " + name);
            }
            String curName = name.substring(0, sepIndex);
            FSQueue queue = this.queues.get(curName);
            if (queue == null) {
                newQueueNames.add(0, curName);
                continue;
            }
            if (!(queue instanceof FSParentQueue)) break;
            parent = (FSParentQueue)queue;
            break;
        }
        return parent;
    }

    private FSQueue createNewQueues(FSQueueType queueType, FSParentQueue topParent, List<String> newQueueNames) {
        AllocationConfiguration queueConf = this.scheduler.getAllocationConfiguration();
        Iterator<String> i = newQueueNames.iterator();
        FSParentQueue parent = topParent;
        FSQueue queue = null;
        while (i.hasNext()) {
            FSParentQueue newParent = null;
            String queueName = i.next();
            if (!i.hasNext() && queueType != FSQueueType.PARENT) {
                FSLeafQueue leafQueue = new FSLeafQueue(queueName, this.scheduler, parent);
                try {
                    leafQueue.setPolicy(queueConf.getDefaultSchedulingPolicy());
                }
                catch (AllocationConfigurationException ex) {
                    LOG.warn((Object)("Failed to set default scheduling policy " + queueConf.getDefaultSchedulingPolicy() + " on new leaf queue."), (Throwable)ex);
                }
                this.leafQueues.add(leafQueue);
                queue = leafQueue;
            } else {
                newParent = new FSParentQueue(queueName, this.scheduler, parent);
                try {
                    newParent.setPolicy(queueConf.getDefaultSchedulingPolicy());
                }
                catch (AllocationConfigurationException ex) {
                    LOG.warn((Object)("Failed to set default scheduling policy " + queueConf.getDefaultSchedulingPolicy() + " on new parent queue."), (Throwable)ex);
                }
                queue = newParent;
            }
            parent.addChildQueue(queue);
            this.setChildResourceLimits(parent, queue, queueConf);
            this.queues.put(queue.getName(), queue);
            queue.updatePreemptionVariables();
            parent = newParent;
        }
        return queue;
    }

    void setChildResourceLimits(FSParentQueue parent, FSQueue child, AllocationConfiguration queueConf) {
        Resource maxChild;
        Map<FSQueueType, Set<String>> configuredQueues = queueConf.getConfiguredQueues();
        if (!configuredQueues.get((Object)FSQueueType.LEAF).contains(child.getName()) && !configuredQueues.get((Object)FSQueueType.PARENT).contains(child.getName()) && (maxChild = queueConf.getMaxChildResources(parent.getName())) != null) {
            queueConf.setMaxResources(child.getName(), maxChild);
        }
    }

    private boolean removeEmptyIncompatibleQueues(String queueToCreate, FSQueueType queueType) {
        if ((queueToCreate = this.ensureRootPrefix(queueToCreate)).equals(ROOT_QUEUE) || queueToCreate.startsWith("root.default.")) {
            return false;
        }
        FSQueue queue = this.queues.get(queueToCreate);
        if (queue != null) {
            if (queue instanceof FSLeafQueue) {
                if (queueType == FSQueueType.LEAF) {
                    return true;
                }
                return this.removeQueueIfEmpty(queue);
            }
            if (queueType == FSQueueType.PARENT) {
                return true;
            }
            return this.removeQueueIfEmpty(queue);
        }
        int sepIndex = queueToCreate.length();
        sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        while (sepIndex != -1) {
            String prefixString = queueToCreate.substring(0, sepIndex);
            FSQueue prefixQueue = this.queues.get(prefixString);
            if (prefixQueue != null && prefixQueue instanceof FSLeafQueue) {
                return this.removeQueueIfEmpty(prefixQueue);
            }
            sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        }
        return true;
    }

    private boolean removeQueueIfEmpty(FSQueue queue) {
        if (this.isEmpty(queue)) {
            this.removeQueue(queue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeQueue(FSQueue queue) {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            if (queue instanceof FSLeafQueue) {
                this.leafQueues.remove(queue);
            } else {
                for (FSQueue childQueue : queue.getChildQueues()) {
                    this.removeQueue(childQueue);
                }
            }
            this.queues.remove(queue.getName());
            FSParentQueue parent = queue.getParent();
            parent.removeChildQueue(queue);
        }
    }

    protected boolean isEmpty(FSQueue queue) {
        if (queue instanceof FSLeafQueue) {
            FSLeafQueue leafQueue = (FSLeafQueue)queue;
            return queue.getNumRunnableApps() == 0 && leafQueue.getNumNonRunnableApps() == 0;
        }
        for (FSQueue child : queue.getChildQueues()) {
            if (this.isEmpty(child)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSQueue getQueue(String name) {
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSLeafQueue> getLeafQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.leafQueues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSQueue> getQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return ImmutableList.copyOf(this.queues.values());
        }
    }

    private String ensureRootPrefix(String name) {
        if (!name.startsWith("root.") && !name.equals(ROOT_QUEUE)) {
            name = "root." + name;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllocationConfiguration(AllocationConfiguration queueConf) {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            for (String name : queueConf.getConfiguredQueues().get((Object)FSQueueType.LEAF)) {
                if (!this.removeEmptyIncompatibleQueues(name, FSQueueType.LEAF)) continue;
                this.getLeafQueue(name, true, false);
            }
            for (String name : queueConf.getConfiguredQueues().get((Object)FSQueueType.PARENT)) {
                if (!this.removeEmptyIncompatibleQueues(name, FSQueueType.PARENT)) continue;
                this.getParentQueue(name, true, false);
            }
        }
        this.rootQueue.recomputeSteadyShares();
        for (FSQueue queue : this.queues.values()) {
            FSQueueMetrics queueMetrics = queue.getMetrics();
            queueMetrics.setMinShare(queue.getMinShare());
            queueMetrics.setMaxShare(queue.getMaxShare());
            try {
                SchedulingPolicy policy = queueConf.getSchedulingPolicy(queue.getName());
                policy.initialize(this.scheduler.getContext());
                queue.setPolicy(policy);
                queueMetrics.setMaxApps(queueConf.getQueueMaxApps(queue.getName()));
                queueMetrics.setSchedulingPolicy(policy.getName());
            }
            catch (AllocationConfigurationException ex) {
                LOG.warn((Object)("Cannot apply configured scheduling policy to queue " + queue.getName()), (Throwable)ex);
            }
        }
        this.rootQueue.recomputeSteadyShares();
        this.rootQueue.updatePreemptionVariables();
    }

    @VisibleForTesting
    boolean isQueueNameValid(String node) {
        return !node.isEmpty() && node.equals(CharMatcher.WHITESPACE.trimFrom((CharSequence)node));
    }
}

