/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class AMRMTokenSecretManager
extends SecretManager<AMRMTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(AMRMTokenSecretManager.class);
    private int serialNo = new SecureRandom().nextInt();
    private MasterKeyData nextMasterKey;
    private MasterKeyData currentMasterKey;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Timer timer;
    private final long rollingInterval;
    private final long activationDelay;
    private RMContext rmContext;
    private final Set<ApplicationAttemptId> appAttemptSet = new HashSet<ApplicationAttemptId>();

    public AMRMTokenSecretManager(Configuration conf, RMContext rmContext) {
        this.rmContext = rmContext;
        this.timer = new Timer();
        this.rollingInterval = conf.getLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 86400L) * 1000L;
        this.activationDelay = (long)((double)conf.getLong("yarn.am.liveness-monitor.expiry-interval-ms", 600000L) * 1.5);
        LOG.info((Object)("AMRMTokenKeyRollingInterval: " + this.rollingInterval + "ms and AMRMTokenKeyActivationDelay: " + this.activationDelay + " ms"));
        if (this.rollingInterval <= this.activationDelay * 2L) {
            throw new IllegalArgumentException("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs should be more than 2 X yarn.am.liveness-monitor.expiry-interval-ms");
        }
    }

    public void start() {
        if (this.currentMasterKey == null) {
            this.currentMasterKey = this.createNewMasterKey();
            AMRMTokenSecretManagerState state = AMRMTokenSecretManagerState.newInstance(this.currentMasterKey.getMasterKey(), null);
            this.rmContext.getStateStore().storeOrUpdateAMRMTokenSecretManager(state, false);
        }
        this.timer.scheduleAtFixedRate((TimerTask)new MasterKeyRoller(), this.rollingInterval, this.rollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationMasterFinished(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            LOG.info((Object)("Application finished, removing password for " + appAttemptId));
            this.appAttemptSet.remove(appAttemptId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void rollMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info((Object)"Rolling master-key for amrm-tokens");
            this.nextMasterKey = this.createNewMasterKey();
            AMRMTokenSecretManagerState state = AMRMTokenSecretManagerState.newInstance(this.currentMasterKey.getMasterKey(), this.nextMasterKey.getMasterKey());
            this.rmContext.getStateStore().storeOrUpdateAMRMTokenSecretManager(state, true);
            this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateNextMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info((Object)("Activating next master key with id: " + this.nextMasterKey.getMasterKey().getKeyId()));
            this.currentMasterKey = this.nextMasterKey;
            this.nextMasterKey = null;
            AMRMTokenSecretManagerState state = AMRMTokenSecretManagerState.newInstance(this.currentMasterKey.getMasterKey(), null);
            this.rmContext.getStateStore().storeOrUpdateAMRMTokenSecretManager(state, true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData createNewMasterKey() {
        this.writeLock.lock();
        try {
            MasterKeyData masterKeyData = new MasterKeyData(this.serialNo++, this.generateSecret());
            return masterKeyData;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<AMRMTokenIdentifier> createAndGetAMRMToken(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            LOG.info((Object)("Create AMRMToken for ApplicationAttempt: " + appAttemptId));
            AMRMTokenIdentifier identifier = new AMRMTokenIdentifier(appAttemptId, this.getMasterKey().getMasterKey().getKeyId());
            byte[] password = this.createPassword(identifier);
            this.appAttemptSet.add(appAttemptId);
            Token token = new Token(identifier.getBytes(), password, identifier.getKind(), new Text());
            return token;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public MasterKeyData getMasterKey() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.nextMasterKey == null ? this.currentMasterKey : this.nextMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistedPassword(Token<AMRMTokenIdentifier> token) throws IOException {
        this.writeLock.lock();
        try {
            AMRMTokenIdentifier identifier = (AMRMTokenIdentifier)token.decodeIdentifier();
            LOG.debug((Object)("Adding password for " + identifier.getApplicationAttemptId()));
            this.appAttemptSet.add(identifier.getApplicationAttemptId());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public byte[] retrievePassword(AMRMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.readLock.lock();
        try {
            ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to retrieve password for " + applicationAttemptId));
            }
            if (!this.appAttemptSet.contains(applicationAttemptId)) {
                throw new SecretManager.InvalidToken(applicationAttemptId + " not found in AMRMTokenSecretManager.");
            }
            if (identifier.getKeyId() == this.currentMasterKey.getMasterKey().getKeyId()) {
                byte[] byArray = AMRMTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.currentMasterKey.getSecretKey());
                return byArray;
            }
            if (this.nextMasterKey != null && identifier.getKeyId() == this.nextMasterKey.getMasterKey().getKeyId()) {
                byte[] byArray = AMRMTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.nextMasterKey.getSecretKey());
                return byArray;
            }
            throw new SecretManager.InvalidToken("Invalid AMRMToken from " + applicationAttemptId);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AMRMTokenIdentifier createIdentifier() {
        return new AMRMTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData getCurrnetMasterKeyData() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.currentMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData getNextMasterKeyData() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.nextMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected byte[] createPassword(AMRMTokenIdentifier identifier) {
        this.readLock.lock();
        try {
            ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
            LOG.info((Object)("Creating password for " + applicationAttemptId));
            byte[] byArray = AMRMTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.getMasterKey().getSecretKey());
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void recover(RMStateStore.RMState state) {
        if (state.getAMRMTokenSecretManagerState() != null) {
            MasterKey currentKey = state.getAMRMTokenSecretManagerState().getCurrentMasterKey();
            this.currentMasterKey = new MasterKeyData(currentKey, AMRMTokenSecretManager.createSecretKey((byte[])currentKey.getBytes().array()));
            MasterKey nextKey = state.getAMRMTokenSecretManagerState().getNextMasterKey();
            if (nextKey != null) {
                this.nextMasterKey = new MasterKeyData(nextKey, AMRMTokenSecretManager.createSecretKey((byte[])nextKey.getBytes().array()));
                this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
            }
        }
    }

    private class NextKeyActivator
    extends TimerTask {
        private NextKeyActivator() {
        }

        @Override
        public void run() {
            AMRMTokenSecretManager.this.activateNextMasterKey();
        }
    }

    private class MasterKeyRoller
    extends TimerTask {
        private MasterKeyRoller() {
        }

        @Override
        public void run() {
            AMRMTokenSecretManager.this.rollMasterKey();
        }
    }
}

