/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePlacementRuleUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;

public class UserGroupMappingPlacementRule
extends PlacementRule {
    private static final Log LOG = LogFactory.getLog(UserGroupMappingPlacementRule.class);
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    public static final String SECONDARY_GROUP_MAPPING = "%secondary_group";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMapping> mappings = null;
    private Groups groups;
    private CapacitySchedulerQueueManager queueManager;

    public UserGroupMappingPlacementRule() {
        this(false, null, null);
    }

    @VisibleForTesting
    UserGroupMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMapping> newMappings, Groups groups) {
        this.mappings = newMappings;
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.groups = groups;
    }

    private String getPrimaryGroup(String user) throws IOException {
        return (String)this.groups.getGroups(user).get(0);
    }

    private String getSecondaryGroup(String user) throws IOException {
        List groupsList = this.groups.getGroups(user);
        String secondaryGroup = null;
        for (int i = 1; i < groupsList.size(); ++i) {
            if (this.queueManager.getQueue((String)groupsList.get(i)) == null) continue;
            secondaryGroup = (String)groupsList.get(i);
            break;
        }
        if (secondaryGroup == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("User " + user + " is not associated with any Secondary " + "Group. Hence it may use the 'default' queue"));
        }
        return secondaryGroup;
    }

    private ApplicationPlacementContext getPlacementForUser(String user) throws IOException {
        for (QueueMapping mapping : this.mappings) {
            if (mapping.getType().equals((Object)QueueMapping.MappingType.USER)) {
                if (mapping.getSource().equals(CURRENT_USER_MAPPING)) {
                    if (mapping.getParentQueue() != null && mapping.getParentQueue().equals(PRIMARY_GROUP_MAPPING) && mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                        return this.getContextForGroupParent(user, mapping, this.getPrimaryGroup(user));
                    }
                    if (mapping.getParentQueue() != null && mapping.getParentQueue().equals(SECONDARY_GROUP_MAPPING) && mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                        return this.getContextForGroupParent(user, mapping, this.getSecondaryGroup(user));
                    }
                    if (mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                        return this.getPlacementContext(mapping, user);
                    }
                    if (mapping.getQueue().equals(PRIMARY_GROUP_MAPPING)) {
                        return this.getPlacementContext(mapping, this.getPrimaryGroup(user));
                    }
                    if (mapping.getQueue().equals(SECONDARY_GROUP_MAPPING)) {
                        return this.getPlacementContext(mapping, this.getSecondaryGroup(user));
                    }
                    return this.getPlacementContext(mapping);
                }
                if (user.equals(mapping.getSource())) {
                    if (mapping.getQueue().equals(PRIMARY_GROUP_MAPPING)) {
                        return this.getPlacementContext(mapping, this.getPrimaryGroup(user));
                    }
                    if (mapping.getQueue().equals(SECONDARY_GROUP_MAPPING)) {
                        String secondaryGroup = this.getSecondaryGroup(user);
                        if (secondaryGroup != null) {
                            return this.getPlacementContext(mapping, secondaryGroup);
                        }
                        return null;
                    }
                    return this.getPlacementContext(mapping);
                }
            }
            if (!mapping.getType().equals((Object)QueueMapping.MappingType.GROUP)) continue;
            for (String userGroups : this.groups.getGroups(user)) {
                if (!userGroups.equals(mapping.getSource())) continue;
                if (mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                    return this.getPlacementContext(mapping, user);
                }
                return this.getPlacementContext(mapping);
            }
        }
        return null;
    }

    private QueueMapping alterMapping(QueueMapping mapping, String parentPath, String leafName) {
        return QueueMapping.QueueMappingBuilder.create().type(mapping.getType()).source(mapping.getSource()).queue(leafName).parentQueue(parentPath).build();
    }

    private ApplicationPlacementContext getContextForGroupParent(String user, QueueMapping mapping, String group) throws IOException {
        CSQueue groupQueue = this.queueManager.getQueue(group);
        if (groupQueue != null) {
            QueueMapping resolvedGroupMapping = this.alterMapping(mapping, groupQueue.getQueuePath(), user);
            this.validateQueueMapping(resolvedGroupMapping);
            return this.getPlacementContext(resolvedGroupMapping, user);
        }
        return null;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        ApplicationId applicationId = asc.getApplicationId();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                ApplicationPlacementContext mappedQueue = this.getPlacementForUser(user);
                if (mappedQueue != null && (queueName.equals("default") || queueName.equals(mappedQueue.getQueue()) || this.overrideWithQueueMappings)) {
                    LOG.info((Object)("Application " + applicationId + " user " + user + " mapping [" + queueName + "] to [" + mappedQueue.getQueue() + "] override " + this.overrideWithQueueMappings));
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationId + " submitted by user " + user + " reason: " + ioex.getMessage();
                throw new YarnException(message, (Throwable)ioex);
            }
        }
        return null;
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping) throws IOException {
        return this.getPlacementContext(mapping, mapping.getQueue());
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping, String leafQueueName) throws IOException {
        if (!mapping.hasParentQueue() && this.queueManager.isAmbiguous(leafQueueName)) {
            throw new IOException("mapping contains ambiguous leaf queue reference " + leafQueueName);
        }
        if (!StringUtils.isEmpty((String)mapping.getParentQueue())) {
            return this.getPlacementContextWithParent(mapping, leafQueueName);
        }
        return this.getPlacementContextNoParent(leafQueueName);
    }

    private ApplicationPlacementContext getPlacementContextWithParent(QueueMapping mapping, String leafQueueName) {
        CSQueue queue;
        CSQueue parent = this.queueManager.getQueue(mapping.getParentQueue());
        if (parent == null) {
            return null;
        }
        String parentPath = parent.getQueuePath();
        if (!(parent instanceof ManagedParentQueue) && (queue = this.queueManager.getQueue(parentPath + "." + leafQueueName)) == null) {
            return null;
        }
        return new ApplicationPlacementContext(leafQueueName, parentPath);
    }

    private ApplicationPlacementContext getPlacementContextNoParent(String leafQueueName) {
        CSQueue queue = this.queueManager.getQueue(leafQueueName);
        if (queue == null) {
            return null;
        }
        CSQueue parent = this.queueManager.getQueue(leafQueueName).getParent();
        return new ApplicationPlacementContext(leafQueueName, parent.getQueuePath());
    }

    @Override
    @VisibleForTesting
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new IOException("UserGroupMappingPlacementRule can be configured only for CapacityScheduler");
        }
        CapacitySchedulerContext schedulerContext = (CapacitySchedulerContext)((Object)scheduler);
        CapacitySchedulerConfiguration conf = schedulerContext.getConfiguration();
        boolean overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        LOG.info((Object)("Initialized queue mappings, override: " + overrideWithQueueMappings));
        List<QueueMapping> queueMappings = conf.getQueueMappings();
        ArrayList<QueueMapping> newMappings = new ArrayList<QueueMapping>();
        this.queueManager = schedulerContext.getCapacitySchedulerQueueManager();
        for (QueueMapping mapping : queueMappings) {
            QueuePath queuePath = mapping.getQueuePath();
            if (UserGroupMappingPlacementRule.isStaticQueueMapping(mapping)) {
                QueueMapping newMapping;
                CSQueue queue = this.queueManager.getQueue(mapping.getFullPath());
                if (UserGroupMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                    if (this.queueManager.isAmbiguous(mapping.getFullPath())) {
                        throw new IOException("mapping contains ambiguous leaf queue reference " + mapping.getFullPath());
                    }
                    newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(this.queueManager, mapping, queuePath);
                    if (newMapping == null) {
                        throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
                    }
                    newMappings.add(newMapping);
                    continue;
                }
                newMapping = UserGroupMappingPlacementRule.validateAndGetQueueMapping(this.queueManager, queue, mapping, queuePath);
                newMappings.add(newMapping);
                continue;
            }
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(this.queueManager, mapping, queuePath);
            if (newMapping != null) {
                newMappings.add(newMapping);
                continue;
            }
            newMappings.add(mapping);
        }
        if (newMappings.size() > 0) {
            this.mappings = newMappings;
            this.groups = Groups.getUserToGroupsMappingService((Configuration)((CapacityScheduler)scheduler).getConf());
            this.overrideWithQueueMappings = overrideWithQueueMappings;
            return true;
        }
        return false;
    }

    private static QueueMapping validateAndGetQueueMapping(CapacitySchedulerQueueManager queueManager, CSQueue queue, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (!(queue instanceof LeafQueue)) {
            throw new IOException("mapping contains invalid or non-leaf queue : " + mapping.getFullPath());
        }
        if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping == null) {
                throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getFullPath());
            }
            return newMapping;
        }
        return mapping;
    }

    private static boolean ifQueueDoesNotExist(CSQueue queue) {
        return queue == null;
    }

    private static QueueMapping validateAndGetAutoCreatedQueueMapping(CapacitySchedulerQueueManager queueManager, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (queuePath.hasParentQueue() && (queuePath.getParentQueue().equals(PRIMARY_GROUP_MAPPING) || queuePath.getParentQueue().equals(SECONDARY_GROUP_MAPPING))) {
            return QueueMapping.QueueMappingBuilder.create().type(mapping.getType()).source(mapping.getSource()).queue(queuePath.getLeafQueue()).parentQueue(queuePath.getParentQueue()).build();
        }
        if (queuePath.hasParentQueue()) {
            QueuePlacementRuleUtils.validateQueueMappingUnderParentQueue(queueManager.getQueue(queuePath.getParentQueue()), queuePath.getParentQueue(), queuePath.getLeafQueue());
            return QueueMapping.QueueMappingBuilder.create().type(mapping.getType()).source(mapping.getSource()).queue(queuePath.getLeafQueue()).parentQueue(queuePath.getParentQueue()).build();
        }
        return null;
    }

    private static boolean isStaticQueueMapping(QueueMapping mapping) {
        return !mapping.getQueue().contains(CURRENT_USER_MAPPING) && !mapping.getQueue().contains(PRIMARY_GROUP_MAPPING) && !mapping.getQueue().contains(SECONDARY_GROUP_MAPPING);
    }

    private void validateQueueMapping(QueueMapping queueMapping) throws IOException {
        String parentQueueName = queueMapping.getParentQueue();
        String leafQueueFullName = queueMapping.getFullPath();
        CSQueue parentQueue = this.queueManager.getQueueByFullName(parentQueueName);
        CSQueue leafQueue = this.queueManager.getQueue(leafQueueFullName);
        if (leafQueue == null || !(leafQueue instanceof LeafQueue)) {
            if (leafQueue == null && this.queueManager.isAmbiguous(leafQueueFullName)) {
                throw new IOException("mapping contains ambiguous leaf queue name: " + leafQueueFullName);
            }
            if (parentQueue == null || !(parentQueue instanceof ManagedParentQueue)) {
                throw new IOException("mapping contains invalid or non-leaf queue  and no managed parent is found: " + leafQueueFullName);
            }
        } else {
            if (parentQueue == null || !(parentQueue instanceof ParentQueue)) {
                throw new IOException("mapping contains invalid parent queue [" + parentQueueName + "]");
            }
            if (!parentQueue.getQueuePath().equals(leafQueue.getParent().getQueuePath())) {
                throw new IOException("mapping contains invalid parent queue which does not match existing leaf queue's parent : [" + parentQueue.getQueuePath() + "] does not match [ " + leafQueue.getParent().getQueuePath() + "]");
            }
        }
    }

    @VisibleForTesting
    public List<QueueMapping> getQueueMappings() {
        return this.mappings;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setQueueManager(CapacitySchedulerQueueManager queueManager) {
        this.queueManager = queueManager;
    }
}

