/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CustomResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceRequestCountInfo;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

@XmlRootElement(name="clusterScalingMetrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClusterScalingMetrics {
    protected ResourceRequestCountInfo resourceRequests;

    public ClusterScalingMetrics() {
    }

    public ClusterScalingMetrics(ResourceManager rm) {
        this(rm, rm.getResourceScheduler());
    }

    public ClusterScalingMetrics(ResourceManager rm, ResourceScheduler rs) {
        if (rs == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        if (!(rs instanceof CapacityScheduler)) {
            throw new BadRequestException("Only Capacity Scheduler is supported!");
        }
        QueueMetrics metrics = rs.getRootQueueMetrics();
        Map<Resource, Integer> pendingContainers = metrics.getContainerAskToCount();
        this.resourceRequests = new ResourceRequestCountInfo();
        for (Map.Entry<Resource, Integer> pendingContainer : pendingContainers.entrySet()) {
            this.resourceRequests.add(new CustomResourceInfo(pendingContainer.getKey()), pendingContainer.getValue());
        }
    }

    public ResourceRequestCountInfo getResourceRequests() {
        return this.resourceRequests;
    }
}

