/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleMatchers;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MappingRuleValidationContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;

public class MappingRule {
    public static final String USER_MAPPING = "u";
    public static final String GROUP_MAPPING = "g";
    public static final String APPLICATION_MAPPING = "a";
    private final MappingRuleMatcher matcher;
    private final MappingRuleAction action;

    public MappingRule(MappingRuleMatcher matcher, MappingRuleAction action) {
        this.matcher = matcher;
        this.action = action;
    }

    public MappingRuleResult evaluate(VariableContext variables) {
        if (this.matcher.match(variables)) {
            return this.action.execute(variables);
        }
        return MappingRuleResult.createSkipResult();
    }

    public MappingRuleResult getFallback() {
        return this.action.getFallback();
    }

    public static MappingRule createLegacyRule(String source, String path) {
        return MappingRule.createLegacyRule(APPLICATION_MAPPING, source, path);
    }

    public static MappingRule createLegacyRule(String type, String source, String path) {
        MappingRuleMatcher matcher;
        MappingRuleAction action = MappingRuleActions.createPlaceToQueueAction(path, true);
        action.setFallbackDefaultPlacement();
        switch (type) {
            case "u": {
                matcher = MappingRuleMatchers.createUserMatcher(source);
                break;
            }
            case "g": {
                matcher = MappingRuleMatchers.createUserGroupMatcher(source);
                break;
            }
            case "a": {
                matcher = MappingRuleMatchers.createApplicationNameMatcher(source);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mapping rule type '" + type + "'");
            }
        }
        return new MappingRule(matcher, action);
    }

    public void validate(MappingRuleValidationContext ctx) throws YarnException {
        this.action.validate(ctx);
    }

    public String toString() {
        return "MappingRule{matcher=" + this.matcher + ", action=" + this.action + '}';
    }
}

