/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VariableContext {
    private Map<String, String> variables = new HashMap<String, String>();
    private Set<String> immutableNames;
    private Map<String, Set<String>> extraDataset = new HashMap<String, Set<String>>();

    boolean isImmutable(String name) {
        return this.immutableNames != null && this.immutableNames.contains(name);
    }

    public VariableContext setImmutables(Set<String> variableNames) {
        if (this.immutableNames != null) {
            throw new IllegalStateException("Immutable variables are already defined, variable immutability cannot be changed once set!");
        }
        this.immutableNames = ImmutableSet.copyOf(variableNames);
        return this;
    }

    public VariableContext setImmutables(String ... variableNames) {
        if (this.immutableNames != null) {
            throw new IllegalStateException("Immutable variables are already defined, variable immutability cannot be changed once set!");
        }
        this.immutableNames = ImmutableSet.copyOf((Object[])variableNames);
        return this;
    }

    public VariableContext put(String name, String value) {
        if (this.variables.containsKey(name) && this.isImmutable(name)) {
            throw new IllegalStateException("Variable '" + name + "' is immutable, cannot update it's value!");
        }
        this.variables.put(name, value);
        return this;
    }

    public String get(String name) {
        String ret = this.variables.get(name);
        return ret == null ? "" : ret;
    }

    public void putExtraDataset(String name, Set<String> set) {
        if (this.extraDataset.containsKey(name)) {
            throw new IllegalStateException("Dataset '" + name + "' is already set!");
        }
        this.extraDataset.put(name, set);
    }

    public Set<String> getExtraDataset(String name) {
        return this.extraDataset.get(name);
    }

    public boolean containsKey(String name) {
        return this.variables.containsKey(name);
    }

    public String replaceVariables(String input) {
        if (input == null) {
            return null;
        }
        String[] keys = this.variables.keySet().toArray(new String[0]);
        Arrays.sort(keys, (a, b) -> b.length() - a.length());
        String ret = input;
        for (String key : keys) {
            if (key == null) continue;
            ret = ret.replace(key, this.get(key));
        }
        return ret;
    }

    public String replacePathVariables(String input) {
        if (input == null) {
            return null;
        }
        CharSequence[] parts = input.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String newVal = this.variables.getOrDefault(parts[i], (String)parts[i]);
            if (newVal == null) {
                newVal = "";
            }
            parts[i] = newVal;
        }
        return String.join((CharSequence)".", parts);
    }
}

