/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.AllocationExpirationInfo;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeDecommissioningEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeFinishedContainersPulledByAMEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeSignalContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeUpdateContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ConcurrentLinkedQueue<UpdatedContainerInfo> nodeUpdateQueue;
    private volatile boolean nextHeartBeat = true;
    private final NodeId nodeId;
    private final RMContext context;
    private final String hostName;
    private final int commandPort;
    private int httpPort;
    private final String nodeAddress;
    private String httpAddress;
    private volatile Resource originalTotalCapability;
    private volatile Resource totalCapability;
    private final Node node;
    private String healthReport;
    private long lastHealthReportTime;
    private String nodeManagerVersion;
    private Integer decommissioningTimeout;
    private long timeStamp;
    private ResourceUtilization containersUtilization;
    private ResourceUtilization nodeUtilization;
    private volatile Resource physicalResource;
    private OpportunisticContainersStatus opportunisticContainersStatus;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private final Set<ContainerId> launchedContainers = new HashSet<ContainerId>();
    private final Set<ContainerId> completedContainers = new HashSet<ContainerId>();
    private final Set<ContainerId> containersToClean = new TreeSet<ContainerId>((Comparator<ContainerId>)new BuilderUtils.ContainerIdComparator());
    private final List<SignalContainerRequest> containersToSignal = new ArrayList<SignalContainerRequest>();
    private final Set<ContainerId> containersToBeRemovedFromNM = new HashSet<ContainerId>();
    private final List<ApplicationId> finishedApplications = new ArrayList<ApplicationId>();
    private final List<ApplicationId> runningApplications = new ArrayList<ApplicationId>();
    private final Map<ContainerId, Container> toBeUpdatedContainers = new HashMap<ContainerId, Container>();
    private final Map<ContainerId, Container> toBeDecreasedContainers = new HashMap<ContainerId, Container>();
    private final Map<ContainerId, Container> nmReportedIncreasedContainers = new HashMap<ContainerId, Container>();
    private NodeHeartbeatResponse latestNodeHeartBeatResponse = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, NodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)NodeState.NEW).addTransition((Enum)NodeState.NEW, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)NodeState.NEW, (Enum)NodeState.NEW, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.NEW, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING, NodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.RUNNING, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.UPDATE_CONTAINER, (SingleArcTransition)new UpdateContainersTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.SIGNAL_CONTAINER, (SingleArcTransition)new SignalContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.REBOOTED, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.DECOMMISSIONED, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.DECOMMISSIONED, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RECOMMISSION, (SingleArcTransition)new RecommissionNodeTransition(NodeState.RUNNING)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, EnumSet.of(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONED), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, EnumSet.of(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONED), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.LOST, (Enum)NodeState.LOST, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.LOST, (Enum)NodeState.LOST, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY, NodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.UNHEALTHY, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.SIGNAL_CONTAINER, (SingleArcTransition)new SignalContainerTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.SHUTDOWN, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.SHUTDOWN, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).installTopology();
    private final StateMachine<NodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability, String nodeManagerVersion) {
        this(nodeId, context, hostName, cmPort, httpPort, node, capability, nodeManagerVersion, null);
    }

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability, String nodeManagerVersion, Resource physResource) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.totalCapability = capability;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.healthReport = "Healthy";
        this.lastHealthReportTime = System.currentTimeMillis();
        this.nodeManagerVersion = nodeManagerVersion;
        this.timeStamp = 0L;
        this.physicalResource = physResource;
        this.latestNodeHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.nodeUpdateQueue = new ConcurrentLinkedQueue();
        this.containerAllocationExpirer = context.getContainerAllocationExpirer();
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getCommandPort() {
        return this.commandPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    @Override
    public NodeId getNodeID() {
        return this.nodeId;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public Resource getTotalCapability() {
        return this.totalCapability;
    }

    @Override
    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getHealthReport() {
        this.readLock.lock();
        try {
            String string = this.healthReport;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setHealthReport(String healthReport) {
        this.writeLock.lock();
        try {
            this.healthReport = healthReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.writeLock.lock();
        try {
            this.lastHealthReportTime = lastHealthReportTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getLastHealthReportTime() {
        this.readLock.lock();
        try {
            long l = this.lastHealthReportTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeManagerVersion() {
        return this.nodeManagerVersion;
    }

    @Override
    public ResourceUtilization getAggregatedContainersUtilization() {
        this.readLock.lock();
        try {
            ResourceUtilization resourceUtilization = this.containersUtilization;
            return resourceUtilization;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setAggregatedContainersUtilization(ResourceUtilization containersUtilization) {
        this.writeLock.lock();
        try {
            this.containersUtilization = containersUtilization;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ResourceUtilization getNodeUtilization() {
        this.readLock.lock();
        try {
            ResourceUtilization resourceUtilization = this.nodeUtilization;
            return resourceUtilization;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setNodeUtilization(ResourceUtilization nodeUtilization) {
        this.writeLock.lock();
        try {
            this.nodeUtilization = nodeUtilization;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Resource getPhysicalResource() {
        return this.physicalResource;
    }

    public void setPhysicalResource(Resource physicalResource) {
        this.physicalResource = physicalResource;
    }

    @Override
    public NodeState getState() {
        this.readLock.lock();
        try {
            NodeState nodeState = (NodeState)this.stateMachine.getCurrentState();
            return nodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ApplicationId> getAppsToCleanup() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.finishedApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ApplicationId> getRunningApps() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.runningApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ContainerId> getContainersToCleanUp() {
        this.readLock.lock();
        try {
            ArrayList<ContainerId> arrayList = new ArrayList<ContainerId>(this.containersToClean);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setAndUpdateNodeHeartbeatResponse(NodeHeartbeatResponse response) {
        this.writeLock.lock();
        try {
            response.addAllContainersToCleanup(new ArrayList<ContainerId>(this.containersToClean));
            response.addAllApplicationsToCleanup(this.finishedApplications);
            response.addContainersToBeRemovedFromNM(new ArrayList<ContainerId>(this.containersToBeRemovedFromNM));
            response.addAllContainersToSignal(this.containersToSignal);
            this.completedContainers.removeAll(this.containersToBeRemovedFromNM);
            this.containersToClean.clear();
            this.finishedApplications.clear();
            this.containersToSignal.clear();
            this.containersToBeRemovedFromNM.clear();
            response.addAllContainersToUpdate(this.toBeUpdatedContainers.values());
            this.toBeUpdatedContainers.clear();
            response.addAllContainersToDecrease(this.toBeDecreasedContainers.values());
            this.toBeDecreasedContainers.clear();
            this.latestNodeHeartBeatResponse = response;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public Collection<Container> getToBeUpdatedContainers() {
        return this.toBeUpdatedContainers.values();
    }

    @Override
    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        this.readLock.lock();
        try {
            NodeHeartbeatResponse nodeHeartbeatResponse = this.latestNodeHeartBeatResponse;
            return nodeHeartbeatResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void resetLastNodeHeartBeatResponse() {
        this.writeLock.lock();
        try {
            this.latestNodeHeartBeatResponse.setResponseId(0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.debug((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            NodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId + " oldState " + oldState));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateMetricsForRejoinedNode(NodeState previousNodeState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.incrNumActiveNodes();
        switch (previousNodeState) {
            case LOST: {
                metrics.decrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.decrNumRebootedNMs();
                break;
            }
            case DECOMMISSIONED: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case SHUTDOWN: {
                metrics.decrNumShutdownNMs();
                break;
            }
            case DECOMMISSIONING: {
                metrics.decrDecommissioningNMs();
                break;
            }
            default: {
                LOG.debug((Object)"Unexpected previous node state");
            }
        }
    }

    private void updateMetricsForGracefulDecommission(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (initialState) {
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case RUNNING: {
                metrics.decrNumActiveNodes();
                break;
            }
            case DECOMMISSIONING: {
                metrics.decrDecommissioningNMs();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected initial state");
            }
        }
        switch (finalState) {
            case DECOMMISSIONING: {
                metrics.incrDecommissioningNMs();
                break;
            }
            case RUNNING: {
                metrics.incrNumActiveNodes();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected final state");
            }
        }
    }

    private void updateMetricsForDeactivatedNode(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (initialState) {
            case RUNNING: {
                metrics.decrNumActiveNodes();
                break;
            }
            case DECOMMISSIONING: {
                metrics.decrDecommissioningNMs();
                break;
            }
            case DECOMMISSIONED: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case NEW: {
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected initial state");
            }
        }
        switch (finalState) {
            case DECOMMISSIONED: {
                metrics.incrDecommisionedNMs();
                break;
            }
            case LOST: {
                metrics.incrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.incrNumRebootedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.incrNumUnhealthyNMs();
                break;
            }
            case SHUTDOWN: {
                metrics.incrNumShutdownNMs();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected final state");
            }
        }
    }

    private static void handleRunningAppOnNode(RMNodeImpl rmNode, RMContext context, ApplicationId appId, NodeId nodeId) {
        RMApp app = (RMApp)context.getRMApps().get(appId);
        if (null == app) {
            LOG.warn((Object)("Cannot get RMApp by appId=" + appId + ", just added it to finishedApplications list for cleanup"));
            rmNode.finishedApplications.add(appId);
            rmNode.runningApplications.remove(appId);
            return;
        }
        rmNode.runningApplications.add(appId);
        context.getDispatcher().getEventHandler().handle((Event)new RMAppRunningOnNodeEvent(appId, nodeId));
    }

    private static void updateNodeResourceFromEvent(RMNodeImpl rmNode, RMNodeResourceUpdateEvent event) {
        ResourceOption resourceOption = event.getResourceOption();
        rmNode.totalCapability = resourceOption.getResource();
    }

    private static NodeHealthStatus updateRMNodeFromStatusEvents(RMNodeImpl rmNode, RMNodeStatusEvent statusEvent) {
        NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
        rmNode.setHealthReport(remoteNodeHealthStatus.getHealthReport());
        rmNode.setLastHealthReportTime(remoteNodeHealthStatus.getLastHealthReportTime());
        rmNode.setAggregatedContainersUtilization(statusEvent.getAggregatedContainersUtilization());
        rmNode.setNodeUtilization(statusEvent.getNodeUtilization());
        return remoteNodeHealthStatus;
    }

    public static void deactivateNode(RMNodeImpl rmNode, NodeState finalState) {
        if (rmNode.getNodeID().getPort() == -1) {
            rmNode.updateMetricsForDeactivatedNode(rmNode.getState(), finalState);
            return;
        }
        RMNodeImpl.reportNodeUnusable(rmNode, finalState);
        rmNode.context.getRMNodes().remove(rmNode.nodeId);
        LOG.info((Object)("Deactivating Node " + rmNode.nodeId + " as it is now " + finalState));
        rmNode.context.getInactiveRMNodes().put(rmNode.nodeId, rmNode);
        if (rmNode.context.getNodesListManager().isUntrackedNode(rmNode.hostName)) {
            rmNode.setUntrackedTimeStamp(Time.monotonicNow());
        }
    }

    public static void reportNodeUnusable(RMNodeImpl rmNode, NodeState finalState) {
        rmNode.nodeUpdateQueue.clear();
        NodeState initialState = rmNode.getState();
        if (!initialState.equals((Object)NodeState.UNHEALTHY)) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
        }
        rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmNode));
        rmNode.updateMetricsForDeactivatedNode(initialState, finalState);
    }

    @Override
    public List<UpdatedContainerInfo> pullContainerUpdates() {
        UpdatedContainerInfo containerInfo;
        ArrayList<UpdatedContainerInfo> latestContainerInfoList = new ArrayList<UpdatedContainerInfo>();
        while ((containerInfo = this.nodeUpdateQueue.poll()) != null) {
            latestContainerInfoList.add(containerInfo);
        }
        this.nextHeartBeat = true;
        return latestContainerInfoList;
    }

    @VisibleForTesting
    public void setNextHeartBeat(boolean nextHeartBeat) {
        this.nextHeartBeat = nextHeartBeat;
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.nodeUpdateQueue.size();
    }

    @VisibleForTesting
    public Set<ContainerId> getLaunchedContainers() {
        return this.launchedContainers;
    }

    @VisibleForTesting
    public Set<ContainerId> getCompletedContainers() {
        return this.completedContainers;
    }

    @Override
    public Set<String> getNodeLabels() {
        RMNodeLabelsManager nlm = this.context.getNodeLabelManager();
        if (nlm == null || nlm.getLabelsOnNode(this.nodeId) == null) {
            return CommonNodeLabelsManager.EMPTY_STRING_SET;
        }
        return nlm.getLabelsOnNode(this.nodeId);
    }

    private void handleReportedIncreasedContainers(List<Container> reportedIncreasedContainers) {
        for (Container container : reportedIncreasedContainers) {
            ContainerId containerId = container.getId();
            if (this.containersToClean.contains(containerId)) {
                LOG.info((Object)("Container " + containerId + " already scheduled for cleanup, no further processing"));
                continue;
            }
            ApplicationId containerAppId = containerId.getApplicationAttemptId().getApplicationId();
            if (this.finishedApplications.contains(containerAppId)) {
                LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed, no further processing"));
                continue;
            }
            this.nmReportedIncreasedContainers.put(containerId, container);
        }
    }

    private void handleContainerStatus(List<ContainerStatus> containerStatuses) {
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> newlyCompletedContainers = new ArrayList<ContainerStatus>();
        int numRemoteRunningContainers = 0;
        for (ContainerStatus remoteContainer : containerStatuses) {
            ContainerId containerId = remoteContainer.getContainerId();
            if (this.containersToClean.contains(containerId)) {
                LOG.info((Object)("Container " + containerId + " already scheduled for cleanup, no further processing"));
                continue;
            }
            ApplicationId containerAppId = containerId.getApplicationAttemptId().getApplicationId();
            if (this.finishedApplications.contains(containerAppId)) {
                LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed, no further processing"));
                continue;
            }
            if (!this.runningApplications.contains(containerAppId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Container " + containerId + " is the first container get launched for application " + containerAppId));
                }
                RMNodeImpl.handleRunningAppOnNode(this, this.context, containerAppId, this.nodeId);
            }
            if (remoteContainer.getState() == ContainerState.RUNNING) {
                ++numRemoteRunningContainers;
                if (this.launchedContainers.contains(containerId)) continue;
                this.launchedContainers.add(containerId);
                newlyLaunchedContainers.add(remoteContainer);
                this.containerAllocationExpirer.unregister(new AllocationExpirationInfo(containerId));
                continue;
            }
            this.launchedContainers.remove(containerId);
            if (this.completedContainers.add(containerId)) {
                newlyCompletedContainers.add(remoteContainer);
            }
            this.containerAllocationExpirer.unregister(new AllocationExpirationInfo(containerId));
        }
        List<ContainerStatus> lostContainers = this.findLostContainers(numRemoteRunningContainers, containerStatuses);
        for (ContainerStatus remoteContainer : lostContainers) {
            ContainerId containerId = remoteContainer.getContainerId();
            if (!this.completedContainers.add(containerId)) continue;
            newlyCompletedContainers.add(remoteContainer);
        }
        if (newlyLaunchedContainers.size() != 0 || newlyCompletedContainers.size() != 0) {
            this.nodeUpdateQueue.add(new UpdatedContainerInfo(newlyLaunchedContainers, newlyCompletedContainers));
        }
    }

    private List<ContainerStatus> findLostContainers(int numRemoteRunning, List<ContainerStatus> containerStatuses) {
        if (numRemoteRunning >= this.launchedContainers.size()) {
            return Collections.emptyList();
        }
        HashSet<ContainerId> nodeContainers = new HashSet<ContainerId>(numRemoteRunning);
        ArrayList<ContainerStatus> lostContainers = new ArrayList<ContainerStatus>(this.launchedContainers.size() - numRemoteRunning);
        for (ContainerStatus remoteContainer : containerStatuses) {
            if (remoteContainer.getState() != ContainerState.RUNNING || remoteContainer.getExecutionType() != ExecutionType.GUARANTEED) continue;
            nodeContainers.add(remoteContainer.getContainerId());
        }
        Iterator<ContainerId> iter = this.launchedContainers.iterator();
        while (iter.hasNext()) {
            ContainerId containerId = iter.next();
            if (nodeContainers.contains(containerId)) continue;
            String diag = "Container " + containerId + " was running but not reported from " + this.nodeId;
            LOG.warn((Object)diag);
            lostContainers.add(SchedulerUtils.createAbnormalContainerStatus(containerId, diag));
            iter.remove();
        }
        return lostContainers;
    }

    private void handleLogAggregationStatus(List<LogAggregationReport> logAggregationReportsForApps) {
        for (LogAggregationReport report : logAggregationReportsForApps) {
            RMApp rmApp = (RMApp)this.context.getRMApps().get(report.getApplicationId());
            if (rmApp == null) continue;
            ((RMAppImpl)rmApp).aggregateLogReport(this.nodeId, report);
        }
    }

    @Override
    public List<Container> pullNewlyIncreasedContainers() {
        try {
            this.writeLock.lock();
            if (this.nmReportedIncreasedContainers.isEmpty()) {
                List<Container> list = Collections.emptyList();
                return list;
            }
            ArrayList<Container> container = new ArrayList<Container>(this.nmReportedIncreasedContainers.values());
            this.nmReportedIncreasedContainers.clear();
            ArrayList<Container> arrayList = container;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Resource getOriginalTotalCapability() {
        return this.originalTotalCapability;
    }

    @Override
    public OpportunisticContainersStatus getOpportunisticContainersStatus() {
        this.readLock.lock();
        try {
            OpportunisticContainersStatus opportunisticContainersStatus = this.opportunisticContainersStatus;
            return opportunisticContainersStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOpportunisticContainersStatus(OpportunisticContainersStatus opportunisticContainersStatus) {
        this.writeLock.lock();
        try {
            this.opportunisticContainersStatus = opportunisticContainersStatus;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getUntrackedTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setUntrackedTimeStamp(long ts) {
        this.timeStamp = ts;
    }

    @Override
    public Integer getDecommissioningTimeout() {
        return this.decommissioningTimeout;
    }

    @Override
    public Map<String, Long> getAllocationTagsWithCount() {
        return this.context.getAllocationTagsManager().getAllocationTagsWithCount(this.getNodeID());
    }

    @Override
    public RMContext getRMContext() {
        return this.context;
    }

    public static class SignalContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToSignal.add(((RMNodeSignalContainerEvent)event).getSignalRequest());
        }
    }

    public static class StatusUpdateWhenUnHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            NodeHealthStatus remoteNodeHealthStatus = RMNodeImpl.updateRMNodeFromStatusEvents(rmNode, statusEvent);
            if (remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmNode));
                rmNode.updateMetricsForRejoinedNode(NodeState.UNHEALTHY);
                return NodeState.RUNNING;
            }
            return NodeState.UNHEALTHY;
        }
    }

    public static class StatusUpdateWhenHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.setOpportunisticContainersStatus(statusEvent.getOpportunisticContainersStatus());
            NodeHealthStatus remoteNodeHealthStatus = RMNodeImpl.updateRMNodeFromStatusEvents(rmNode, statusEvent);
            NodeState initialState = rmNode.getState();
            boolean isNodeDecommissioning = initialState.equals((Object)NodeState.DECOMMISSIONING);
            if (isNodeDecommissioning) {
                List<ApplicationId> keepAliveApps = statusEvent.getKeepAliveAppIds();
                if (rmNode.runningApplications.isEmpty() && (keepAliveApps == null || keepAliveApps.isEmpty())) {
                    RMNodeImpl.deactivateNode(rmNode, NodeState.DECOMMISSIONED);
                    return NodeState.DECOMMISSIONED;
                }
            }
            if (!remoteNodeHealthStatus.getIsNodeHealthy()) {
                LOG.info((Object)("Node " + rmNode.nodeId + " reported UNHEALTHY with details: " + remoteNodeHealthStatus.getHealthReport()));
                if (isNodeDecommissioning) {
                    return NodeState.DECOMMISSIONING;
                }
                RMNodeImpl.reportNodeUnusable(rmNode, NodeState.UNHEALTHY);
                return NodeState.UNHEALTHY;
            }
            rmNode.handleContainerStatus(statusEvent.getContainers());
            rmNode.handleReportedIncreasedContainers(statusEvent.getNMReportedIncreasedContainers());
            List<LogAggregationReport> logAggregationReportsForApps = statusEvent.getLogAggregationReportsForApps();
            if (logAggregationReportsForApps != null && !logAggregationReportsForApps.isEmpty()) {
                rmNode.handleLogAggregationStatus(logAggregationReportsForApps);
            }
            if (rmNode.nextHeartBeat) {
                rmNode.nextHeartBeat = false;
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeUpdateSchedulerEvent(rmNode));
            }
            if (UserGroupInformation.isSecurityEnabled()) {
                rmNode.context.getDelegationTokenRenewer().updateKeepAliveApplications(statusEvent.getKeepAliveAppIds());
            }
            return initialState;
        }
    }

    public static class RecommissionNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState finalState;

        public RecommissionNodeTransition(NodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            if (rmNode.originalTotalCapability != null) {
                rmNode.totalCapability = rmNode.originalTotalCapability;
                rmNode.originalTotalCapability = null;
            }
            LOG.info((Object)("Node " + rmNode.nodeId + " in DECOMMISSIONING is recommissioned back to RUNNING."));
            rmNode.updateMetricsForGracefulDecommission(rmNode.getState(), this.finalState);
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, ResourceOption.newInstance((Resource)rmNode.totalCapability, (int)0)));
        }
    }

    public static class DecommissioningNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState initState;
        private final NodeState finalState;

        public DecommissioningNodeTransition(NodeState initState, NodeState finalState) {
            this.initState = initState;
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            Integer timeout = null;
            if (RMNodeDecommissioningEvent.class.isInstance((Object)event)) {
                RMNodeDecommissioningEvent e = (RMNodeDecommissioningEvent)event;
                timeout = e.getDecommissioningTimeout();
            }
            if (rmNode.getState() == NodeState.DECOMMISSIONING) {
                if (!Objects.equals(rmNode.getDecommissioningTimeout(), timeout)) {
                    LOG.info((Object)("Update " + rmNode.getNodeID() + " DecommissioningTimeout to be " + timeout));
                    rmNode.decommissioningTimeout = timeout;
                } else {
                    LOG.info((Object)(rmNode.getNodeID() + " is already DECOMMISSIONING"));
                }
                return;
            }
            LOG.info((Object)("Put Node " + rmNode.nodeId + " in DECOMMISSIONING."));
            rmNode.updateMetricsForGracefulDecommission(this.initState, this.finalState);
            rmNode.decommissioningTimeout = timeout;
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_DECOMMISSIONING, rmNode));
            if (rmNode.originalTotalCapability == null) {
                rmNode.originalTotalCapability = Resources.clone((Resource)rmNode.totalCapability);
                LOG.info((Object)("Preserve original total capability: " + rmNode.originalTotalCapability));
            }
        }
    }

    public static class DeactivateNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState finalState;

        public DeactivateNodeTransition(NodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeImpl.deactivateNode(rmNode, this.finalState);
        }
    }

    public static class UpdateContainersTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeUpdateContainerEvent de = (RMNodeUpdateContainerEvent)event;
            for (Map.Entry<Container, ContainerUpdateType> e : de.getToBeUpdatedContainers().entrySet()) {
                if (ContainerUpdateType.DECREASE_RESOURCE == e.getValue()) {
                    rmNode.toBeDecreasedContainers.put(e.getKey().getId(), e.getKey());
                }
                rmNode.toBeUpdatedContainers.put(e.getKey().getId(), e.getKey());
            }
        }
    }

    public static class AddContainersToBeRemovedFromNMTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToBeRemovedFromNM.addAll(((RMNodeFinishedContainersPulledByAMEvent)event).getContainers());
        }
    }

    public static class CleanUpContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToClean.add(((RMNodeCleanContainerEvent)event).getContainerId());
        }
    }

    public static class CleanUpAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            ApplicationId appId = ((RMNodeCleanAppEvent)event).getAppId();
            rmNode.finishedApplications.add(appId);
            rmNode.runningApplications.remove(appId);
        }
    }

    public static class UpdateNodeResourceWhenUnusableTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            LOG.warn((Object)("Try to update resource on a " + rmNode.getState().toString() + " node: " + rmNode.toString()));
            RMNodeImpl.updateNodeResourceFromEvent(rmNode, (RMNodeResourceUpdateEvent)event);
        }
    }

    public static class UpdateNodeResourceWhenRunningTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeResourceUpdateEvent updateEvent = (RMNodeResourceUpdateEvent)event;
            RMNodeImpl.updateNodeResourceFromEvent(rmNode, updateEvent);
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, updateEvent.getResourceOption()));
        }
    }

    public static class ReconnectNodeTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            boolean noRunningApps;
            RMNodeReconnectEvent reconnectEvent = (RMNodeReconnectEvent)event;
            RMNode newNode = reconnectEvent.getReconnectedNode();
            rmNode.nodeManagerVersion = newNode.getNodeManagerVersion();
            List<ApplicationId> runningApps = reconnectEvent.getRunningApplications();
            boolean bl = noRunningApps = runningApps == null || runningApps.size() == 0;
            if (noRunningApps) {
                if (rmNode.getState() == NodeState.DECOMMISSIONING) {
                    RMNodeImpl.deactivateNode(rmNode, NodeState.DECOMMISSIONED);
                    return NodeState.DECOMMISSIONED;
                }
                rmNode.nodeUpdateQueue.clear();
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
                if (rmNode.getHttpPort() == newNode.getHttpPort()) {
                    if (!rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability())) {
                        rmNode.totalCapability = newNode.getTotalCapability();
                    }
                    if (rmNode.getState().equals((Object)NodeState.RUNNING)) {
                        rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                    }
                }
            } else {
                rmNode.httpPort = newNode.getHttpPort();
                rmNode.httpAddress = newNode.getHttpAddress();
                boolean isCapabilityChanged = false;
                if (!rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability())) {
                    rmNode.totalCapability = newNode.getTotalCapability();
                    isCapabilityChanged = true;
                }
                this.handleNMContainerStatus(reconnectEvent.getNMContainerStatuses(), rmNode);
                for (ApplicationId appId : reconnectEvent.getRunningApplications()) {
                    RMNodeImpl.handleRunningAppOnNode(rmNode, rmNode.context, appId, rmNode.nodeId);
                }
                if (isCapabilityChanged && rmNode.getState().equals((Object)NodeState.RUNNING)) {
                    rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, ResourceOption.newInstance((Resource)newNode.getTotalCapability(), (int)-1)));
                }
            }
            return rmNode.getState();
        }

        private void handleNMContainerStatus(List<NMContainerStatus> nmContainerStatuses, RMNodeImpl rmnode) {
            if (nmContainerStatuses != null) {
                ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
                for (NMContainerStatus nmContainerStatus : nmContainerStatuses) {
                    containerStatuses.add(this.createContainerStatus(nmContainerStatus));
                }
                rmnode.handleContainerStatus(containerStatuses);
            }
        }

        private ContainerStatus createContainerStatus(NMContainerStatus remoteContainer) {
            ContainerStatus cStatus = ContainerStatus.newInstance((ContainerId)remoteContainer.getContainerId(), (ContainerState)remoteContainer.getContainerState(), (String)remoteContainer.getDiagnostics(), (int)remoteContainer.getContainerExitStatus());
            return cStatus;
        }
    }

    public static class AddNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStartedEvent startEvent = (RMNodeStartedEvent)event;
            List<NMContainerStatus> containers = null;
            NodeId nodeId = rmNode.nodeId;
            RMNode previousRMNode = (RMNode)rmNode.context.getInactiveRMNodes().remove(nodeId);
            if (previousRMNode != null) {
                rmNode.updateMetricsForRejoinedNode(previousRMNode.getState());
            } else {
                NodeId unknownNodeId = NodesListManager.createUnknownNodeId(nodeId.getHost());
                previousRMNode = (RMNode)rmNode.context.getInactiveRMNodes().remove(unknownNodeId);
                if (previousRMNode != null) {
                    ClusterMetrics.getMetrics().decrDecommisionedNMs();
                }
                ClusterMetrics.getMetrics().incrNumActiveNodes();
                containers = startEvent.getNMContainerStatuses();
                if (containers != null && !containers.isEmpty()) {
                    for (NMContainerStatus container : containers) {
                        if (container.getContainerState() != ContainerState.RUNNING) continue;
                        rmNode.launchedContainers.add(container.getContainerId());
                    }
                }
            }
            if (null != startEvent.getRunningApplications()) {
                for (ApplicationId appId : startEvent.getRunningApplications()) {
                    RMNodeImpl.handleRunningAppOnNode(rmNode, rmNode.context, appId, rmNode.nodeId);
                }
            }
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode, containers));
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmNode));
            List<LogAggregationReport> logAggregationReportsForApps = startEvent.getLogAggregationReportsForApps();
            if (logAggregationReportsForApps != null && !logAggregationReportsForApps.isEmpty()) {
                rmNode.handleLogAggregationStatus(logAggregationReportsForApps);
            }
        }
    }
}

