/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;

public class CapacitySchedulerAutoQueueHandler {
    private final CapacitySchedulerQueueManager queueManager;
    private static final int MAXIMUM_DEPTH_ALLOWED = 2;

    public CapacitySchedulerAutoQueueHandler(CapacitySchedulerQueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public LeafQueue autoCreateQueue(ApplicationPlacementContext queue) throws YarnException {
        ApplicationPlacementContext parentContext = CSQueueUtils.extractQueuePath(queue.getParentQueue());
        ArrayList<ApplicationPlacementContext> parentsToCreate = new ArrayList<ApplicationPlacementContext>();
        ApplicationPlacementContext queueCandidateContext = parentContext;
        CSQueue existingQueueCandidate = this.getQueue(queueCandidateContext.getFullQueuePath());
        while (existingQueueCandidate == null) {
            parentsToCreate.add(queueCandidateContext);
            queueCandidateContext = CSQueueUtils.extractQueuePath(queueCandidateContext.getParentQueue());
            existingQueueCandidate = this.getQueue(queueCandidateContext.getFullQueuePath());
        }
        Collections.reverse(parentsToCreate);
        if (!(existingQueueCandidate instanceof ParentQueue)) {
            throw new SchedulerDynamicEditException("Could not auto create hierarchy of " + queue.getFullQueuePath() + ". Queue " + existingQueueCandidate.getQueuePath() + " is not a ParentQueue.");
        }
        ParentQueue existingParentQueue = (ParentQueue)existingQueueCandidate;
        int depthLimit = this.extractDepthLimit(existingParentQueue);
        int levelsToCreate = parentsToCreate.size() + 1;
        if (depthLimit == 0) {
            throw new SchedulerDynamicEditException("Auto creation of queue " + queue.getFullQueuePath() + " is not enabled under parent " + existingParentQueue.getQueuePath());
        }
        if (levelsToCreate > depthLimit) {
            throw new SchedulerDynamicEditException("Could not auto create queue " + queue.getFullQueuePath() + ". In order to create the desired queue hierarchy, " + levelsToCreate + " levels of queues would need to be created, which is above the limit.");
        }
        for (ApplicationPlacementContext current : parentsToCreate) {
            existingParentQueue = existingParentQueue.addDynamicParentQueue(current.getFullQueuePath());
            this.queueManager.addQueue(existingParentQueue.getQueuePath(), existingParentQueue);
        }
        LeafQueue leafQueue = existingParentQueue.addDynamicLeafQueue(queue.getFullQueuePath());
        this.queueManager.addQueue(leafQueue.getQueuePath(), leafQueue);
        return leafQueue;
    }

    private int extractDepthLimit(ParentQueue parentQueue) {
        if (parentQueue.isEligibleForAutoQueueCreation()) {
            return 2;
        }
        return 0;
    }

    private CSQueue getQueue(String queue) {
        return queue != null ? this.queueManager.getQueue(queue) : null;
    }
}

