/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.VisitedResourceRequestTracker;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSAppAttempt
extends SchedulerApplicationAttempt
implements Schedulable {
    private static final Log LOG = LogFactory.getLog(FSAppAttempt.class);
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private final long startTime;
    private final Priority appPriority;
    private Resource demand = Resources.createResource((int)0);
    private final FairScheduler scheduler;
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private final Object preemptionVariablesLock = new Object();
    private final Set<RMContainer> containersToBePreempted = new HashSet<RMContainer>();
    private final Resource resourcesToBePreempted = Resources.clone((Resource)Resources.none());
    private Resource fairshareStarvation = Resources.none();
    private long lastTimeAtFairShare;
    private long nextStarvationCheck;
    private Resource minshareStarvation = Resources.none();
    private final Map<String, Set<String>> reservations = new HashMap<String, Set<String>>();
    private final List<FSSchedulerNode> blacklistNodeIds = new ArrayList<FSSchedulerNode>();
    private boolean enableAMPreemption;
    private final Map<SchedulerRequestKey, NodeType> allowedLocalityLevel = new HashMap<SchedulerRequestKey, NodeType>();

    public FSAppAttempt(FairScheduler scheduler, ApplicationAttemptId applicationAttemptId, String user, FSLeafQueue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
        this.scheduler = scheduler;
        this.lastTimeAtFairShare = this.startTime = scheduler.getClock().getTime();
        this.appPriority = Priority.newInstance((int)1);
        this.enableAMPreemption = scheduler.getConf().getAMPreemptionEnabled(this.getQueue().getQueueName());
    }

    public QueueMetrics getMetrics() {
        return this.queue.getMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        try {
            this.writeLock.lock();
            Container container = rmContainer.getContainer();
            ContainerId containerId = container.getId();
            if (this.liveContainers.remove(containerId) == null) {
                LOG.info((Object)("Additional complete request on completed container " + rmContainer.getContainerId()));
                return;
            }
            this.newlyAllocatedContainers.remove(rmContainer);
            rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + (Object)((Object)rmContainer.getState()) + " event:" + (Object)((Object)event)));
            }
            this.untrackContainerForPreemption(rmContainer);
            if (containerStatus.getDiagnostics().equals("Container preempted by scheduler")) {
                this.queue.getMetrics().preemptContainer();
            }
            Resource containerResource = rmContainer.getContainer().getResource();
            RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId, containerResource, rmContainer.getQueueName(), null);
            this.queue.getMetrics().releaseResources(rmContainer.getNodeLabelExpression(), this.getUser(), 1, containerResource);
            this.attemptResourceUsage.decUsed(containerResource);
            this.getQueue().decUsedResource(containerResource);
            this.lastMemoryAggregateAllocationUpdateTime = -1L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveInternal(SchedulerRequestKey schedulerKey, FSSchedulerNode node) {
        try {
            this.writeLock.lock();
            Map reservedContainers = (Map)this.reservedContainers.get(schedulerKey);
            RMContainer reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID());
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(schedulerKey);
            }
            this.resetReReservations(schedulerKey);
            Resource resource = reservedContainer.getContainer().getResource();
            this.attemptResourceUsage.decReserved(resource);
            LOG.info((Object)("Application " + this.getApplicationId() + " unreserved  on node " + node + ", currently has " + reservedContainers.size() + " at priority " + schedulerKey.getPriority() + "; currentReservation " + this.attemptResourceUsage.getReserved()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void subtractResourcesOnBlacklistedNodes(Resource availableResources) {
        if (this.appSchedulingInfo.getAndResetBlacklistChanged()) {
            this.blacklistNodeIds.clear();
            this.blacklistNodeIds.addAll(this.scheduler.getBlacklistedNodes(this));
        }
        for (FSSchedulerNode node : this.blacklistNodeIds) {
            Resources.subtractFromNonNegative((Resource)availableResources, (Resource)node.getUnallocatedResource());
        }
    }

    @Override
    public Resource getHeadroom() {
        FSLeafQueue fsQueue = this.getQueue();
        SchedulingPolicy policy = fsQueue.getPolicy();
        Resource queueFairShare = fsQueue.getFairShare();
        Resource queueUsage = fsQueue.getResourceUsage();
        Resource clusterResource = this.scheduler.getClusterResource();
        Resource clusterUsage = this.scheduler.getRootQueueMetrics().getAllocatedResources();
        Resource clusterAvailableResources = Resources.subtract((Resource)clusterResource, (Resource)clusterUsage);
        this.subtractResourcesOnBlacklistedNodes(clusterAvailableResources);
        Resource queueMaxAvailableResources = Resources.subtract((Resource)fsQueue.getMaxShare(), (Resource)queueUsage);
        Resource maxAvailableResource = Resources.componentwiseMin((Resource)clusterAvailableResources, (Resource)queueMaxAvailableResources);
        Resource headroom = policy.getHeadroom(queueFairShare, queueUsage, maxAvailableResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for " + this.getName() + ":Min((queueFairShare=" + queueFairShare + " - queueUsage=" + queueUsage + "), maxAvailableResource=" + maxAvailableResource + "Headroom=" + headroom));
        }
        return headroom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeType getAllowedLocalityLevel(SchedulerRequestKey schedulerKey, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        try {
            double thresholdNum;
            this.writeLock.lock();
            if (!this.allowedLocalityLevel.containsKey(schedulerKey)) {
                this.allowedLocalityLevel.put(schedulerKey, NodeType.NODE_LOCAL);
                NodeType nodeType = NodeType.NODE_LOCAL;
                return nodeType;
            }
            NodeType allowed = this.allowedLocalityLevel.get(schedulerKey);
            if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
                NodeType nodeType = NodeType.OFF_SWITCH;
                return nodeType;
            }
            double threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
            int schedulingOpportunities = this.getSchedulingOpportunities(schedulerKey);
            if ((double)schedulingOpportunities > (thresholdNum = (double)numNodes * threshold)) {
                if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("SchedulingOpportunities: " + schedulingOpportunities + ", nodeLocalityThreshold: " + thresholdNum + ", change allowedLocality from NODE_LOCAL to RACK_LOCAL, priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    this.allowedLocalityLevel.put(schedulerKey, NodeType.RACK_LOCAL);
                    this.resetSchedulingOpportunities(schedulerKey);
                } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("SchedulingOpportunities: " + schedulingOpportunities + ", rackLocalityThreshold: " + thresholdNum + ", change allowedLocality from RACK_LOCAL to OFF_SWITCH, priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    this.allowedLocalityLevel.put(schedulerKey, NodeType.OFF_SWITCH);
                    this.resetSchedulingOpportunities(schedulerKey);
                }
            }
            NodeType nodeType = this.allowedLocalityLevel.get(schedulerKey);
            return nodeType;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeType getAllowedLocalityLevelByTime(SchedulerRequestKey schedulerKey, long nodeLocalityDelayMs, long rackLocalityDelayMs, long currentTimeMs) {
        if (nodeLocalityDelayMs < 0L || rackLocalityDelayMs < 0L) {
            return NodeType.OFF_SWITCH;
        }
        try {
            long thresholdTime;
            this.writeLock.lock();
            if (!this.allowedLocalityLevel.containsKey(schedulerKey)) {
                this.lastScheduledContainer.put(schedulerKey, currentTimeMs);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Init the lastScheduledContainer time, priority: " + schedulerKey.getPriority() + ", time: " + currentTimeMs));
                }
                this.allowedLocalityLevel.put(schedulerKey, NodeType.NODE_LOCAL);
                NodeType nodeType = NodeType.NODE_LOCAL;
                return nodeType;
            }
            NodeType allowed = this.allowedLocalityLevel.get(schedulerKey);
            if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
                NodeType nodeType = NodeType.OFF_SWITCH;
                return nodeType;
            }
            long waitTime = currentTimeMs;
            waitTime = this.lastScheduledContainer.containsKey(schedulerKey) ? (waitTime -= ((Long)this.lastScheduledContainer.get(schedulerKey)).longValue()) : (waitTime -= this.getStartTime());
            long l = thresholdTime = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityDelayMs : rackLocalityDelayMs;
            if (waitTime > thresholdTime) {
                if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Waiting time: " + waitTime + " ms, nodeLocalityDelay time: " + nodeLocalityDelayMs + " ms, change allowedLocality from NODE_LOCAL to RACK_LOCAL, priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    this.allowedLocalityLevel.put(schedulerKey, NodeType.RACK_LOCAL);
                    this.resetSchedulingOpportunities(schedulerKey, currentTimeMs);
                } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Waiting time: " + waitTime + " ms, nodeLocalityDelay time: " + nodeLocalityDelayMs + " ms, change allowedLocality from RACK_LOCAL to OFF_SWITCH, priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    this.allowedLocalityLevel.put(schedulerKey, NodeType.OFF_SWITCH);
                    this.resetSchedulingOpportunities(schedulerKey, currentTimeMs);
                }
            }
            NodeType nodeType = this.allowedLocalityLevel.get(schedulerKey);
            return nodeType;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainer allocate(NodeType type, FSSchedulerNode node, SchedulerRequestKey schedulerKey, PendingAsk pendingAsk, Container reservedContainer) {
        RMContainerImpl rmContainer;
        try {
            this.writeLock.lock();
            NodeType allowed = this.allowedLocalityLevel.get(schedulerKey);
            if (allowed != null) {
                if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                    this.resetAllowedLocalityLevel(schedulerKey, type);
                } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                    this.resetAllowedLocalityLevel(schedulerKey, type);
                }
            }
            if (this.getOutstandingAsksCount(schedulerKey) <= 0) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            Container container = reservedContainer;
            if (container == null) {
                container = this.createContainer(node, pendingAsk.getPerAllocationResource(), schedulerKey);
            }
            rmContainer = new RMContainerImpl(container, schedulerKey, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
            rmContainer.setQueueName(this.getQueueName());
            this.addToNewlyAllocatedContainers(node, rmContainer);
            this.liveContainers.put(container.getId(), rmContainer);
            ContainerRequest containerRequest = this.appSchedulingInfo.allocate(type, node, schedulerKey, container);
            this.attemptResourceUsage.incUsed(container.getResource());
            this.getQueue().incUsedResource(container.getResource());
            rmContainer.setContainerRequest(containerRequest);
            rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
            }
            RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId(), container.getResource(), this.getQueueName(), null);
        }
        finally {
            this.writeLock.unlock();
        }
        return rmContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllowedLocalityLevel(SchedulerRequestKey schedulerKey, NodeType level) {
        NodeType old;
        try {
            this.writeLock.lock();
            old = this.allowedLocalityLevel.put(schedulerKey, level);
        }
        finally {
            this.writeLock.unlock();
        }
        LOG.info((Object)("Raising locality level from " + (Object)((Object)old) + " to " + (Object)((Object)level) + " at  priority " + schedulerKey.getPriority()));
    }

    @Override
    public FSLeafQueue getQueue() {
        return (FSLeafQueue)this.queue;
    }

    Resource getStarvation() {
        return Resources.add((Resource)this.fairshareStarvation, (Resource)this.minshareStarvation);
    }

    Resource getFairshareStarvation() {
        return this.fairshareStarvation;
    }

    void setMinshareStarvation(Resource starvation) {
        this.minshareStarvation = starvation;
    }

    void resetMinshareStarvation() {
        this.minshareStarvation = Resources.none();
    }

    Resource getMinshareStarvation() {
        return this.minshareStarvation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackContainerForPreemption(RMContainer container) {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToBePreempted.add(container)) {
                Resources.addTo((Resource)this.resourcesToBePreempted, (Resource)container.getAllocatedResource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackContainerForPreemption(RMContainer container) {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToBePreempted.remove(container)) {
                Resources.subtractFrom((Resource)this.resourcesToBePreempted, (Resource)container.getAllocatedResource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ContainerId> getPreemptionContainerIds() {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            HashSet<ContainerId> preemptionContainerIds = new HashSet<ContainerId>();
            for (RMContainer container : this.containersToBePreempted) {
                preemptionContainerIds.add(container.getContainerId());
            }
            return preemptionContainerIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canContainerBePreempted(RMContainer container, Resource alreadyConsideringForPreemption) {
        if (!this.isPreemptable()) {
            return false;
        }
        if (container.isAMContainer() && !this.enableAMPreemption) {
            return false;
        }
        if (!this.getLiveContainersMap().containsKey(container.getContainerId()) && !this.newlyAllocatedContainers.contains(container)) {
            LOG.error((Object)("Looking to preempt container " + container + ". Container does not belong to app " + this.getApplicationId()));
            return false;
        }
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToBePreempted.contains(container)) {
                return false;
            }
        }
        Resource usageAfterPreemption = this.getUsageAfterPreemptingContainer(container.getAllocatedResource(), alreadyConsideringForPreemption);
        return !this.isUsageBelowShare(usageAfterPreemption, this.getFairShare());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getUsageAfterPreemptingContainer(Resource containerResources, Resource alreadyConsideringForPreemption) {
        Resource usageAfterPreemption = Resources.clone((Resource)this.getResourceUsage());
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            Resources.subtractFrom((Resource)usageAfterPreemption, (Resource)this.resourcesToBePreempted);
        }
        Resources.subtractFrom((Resource)usageAfterPreemption, (Resource)containerResources);
        Resources.subtractFrom((Resource)usageAfterPreemption, (Resource)alreadyConsideringForPreemption);
        return usageAfterPreemption;
    }

    private Container createContainer(FSSchedulerNode node, Resource capability, SchedulerRequestKey schedulerKey) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(), (long)this.getNewContainerId());
        return BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)schedulerKey.getPriority(), null, (long)schedulerKey.getAllocationRequestId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recoverContainer(SchedulerNode node, RMContainer rmContainer) {
        try {
            this.writeLock.lock();
            super.recoverContainer(node, rmContainer);
            if (!rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
                this.getQueue().incUsedResource(rmContainer.getContainer().getResource());
            }
            if (!this.isAmRunning() && !this.getUnmanagedAM()) {
                Resource resource = rmContainer.getAllocatedResource();
                this.setAMResource(resource);
                this.getQueue().addAMResourceUsage(resource);
                this.setAmRunning(true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean reserve(Resource perAllocationResource, FSSchedulerNode node, Container reservedContainer, NodeType type, SchedulerRequestKey schedulerKey) {
        boolean reservableForThisApp;
        RMContainer nodeReservedContainer = node.getReservedContainer();
        boolean bl = reservableForThisApp = nodeReservedContainer == null || nodeReservedContainer.getApplicationAttemptId().equals((Object)this.getApplicationAttemptId());
        if (reservableForThisApp && !this.reservationExceedsThreshold(node, type)) {
            LOG.info((Object)("Making reservation: node=" + node.getNodeName() + " app_id=" + this.getApplicationId()));
            if (reservedContainer == null) {
                reservedContainer = this.createContainer(node, perAllocationResource, schedulerKey);
                this.getMetrics().reserveResource(node.getPartition(), this.getUser(), reservedContainer.getResource());
                RMContainer rmContainer = super.reserve(node, schedulerKey, null, reservedContainer);
                node.reserveResource(this, schedulerKey, rmContainer);
                this.setReservation(node);
            } else {
                RMContainer rmContainer = node.getReservedContainer();
                super.reserve(node, schedulerKey, rmContainer, reservedContainer);
                node.reserveResource(this, schedulerKey, rmContainer);
                this.setReservation(node);
            }
            return true;
        }
        return false;
    }

    private boolean reservationExceedsThreshold(FSSchedulerNode node, NodeType type) {
        int totalAvailNodes;
        int numAllowedReservations;
        int existingReservations;
        if (type != NodeType.NODE_LOCAL && (existingReservations = this.getNumReservations(node.getRackName(), type == NodeType.OFF_SWITCH)) >= (numAllowedReservations = (int)Math.ceil((float)(totalAvailNodes = type == NodeType.OFF_SWITCH ? this.scheduler.getNumClusterNodes() : this.scheduler.getNumNodesInRack(node.getRackName())) * this.scheduler.getReservableNodesRatio()))) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reservation Exceeds Allowed number of nodes: app_id=" + this.getApplicationId() + " existingReservations=" + existingReservations + " totalAvailableNodes=" + totalAvailNodes + " reservableNodesRatio=" + df.format(this.scheduler.getReservableNodesRatio()) + " numAllowedReservations=" + numAllowedReservations));
            }
            return true;
        }
        return false;
    }

    public void unreserve(SchedulerRequestKey schedulerKey, FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        this.unreserveInternal(schedulerKey, node);
        node.unreserveResource(this);
        this.clearReservation(node);
        this.getMetrics().unreserveResource(node.getPartition(), this.getUser(), rmContainer.getContainer().getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReservation(SchedulerNode node) {
        String rackName = node.getRackName() == null ? "NULL" : node.getRackName();
        try {
            this.writeLock.lock();
            Set<String> rackReservations = this.reservations.get(rackName);
            if (rackReservations == null) {
                rackReservations = new HashSet<String>();
                this.reservations.put(rackName, rackReservations);
            }
            rackReservations.add(node.getNodeName());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReservation(SchedulerNode node) {
        String rackName = node.getRackName() == null ? "NULL" : node.getRackName();
        try {
            this.writeLock.lock();
            Set<String> rackReservations = this.reservations.get(rackName);
            if (rackReservations != null) {
                rackReservations.remove(node.getNodeName());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    int getNumReservations(String rackName, boolean isAny) {
        int counter = 0;
        if (isAny) {
            for (Set<String> nodes : this.reservations.values()) {
                if (nodes == null) continue;
                counter += nodes.size();
            }
        } else {
            Set<String> nodes = this.reservations.get(rackName == null ? "NULL" : rackName);
            if (nodes != null) {
                counter += nodes.size();
            }
        }
        return counter;
    }

    private Resource assignContainer(FSSchedulerNode node, PendingAsk pendingAsk, NodeType type, boolean reserved, SchedulerRequestKey schedulerKey) {
        Resource capability = pendingAsk.getPerAllocationResource();
        Resource available = node.getUnallocatedResource();
        Container reservedContainer = null;
        if (reserved) {
            reservedContainer = node.getReservedContainer().getContainer();
        }
        if (Resources.fitsIn((Resource)capability, (Resource)available)) {
            RMContainer allocatedContainer = this.allocate(type, node, schedulerKey, pendingAsk, reservedContainer);
            if (allocatedContainer == null) {
                if (reserved) {
                    this.unreserve(schedulerKey, node);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Resource ask %s fits in available node resources %s, but no container was allocated", capability, available));
                }
                return Resources.none();
            }
            if (reserved) {
                this.unreserve(schedulerKey, node);
            }
            node.allocateContainer(allocatedContainer);
            if (!this.isAmRunning() && !this.getUnmanagedAM()) {
                this.setAMResource(capability);
                this.getQueue().addAMResourceUsage(capability);
                this.setAmRunning(true);
            }
            return capability;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource request: " + capability + " exceeds the available resources of the node."));
        }
        if (this.isReservable(capability) && !node.isPreemptedForApp(this) && this.reserve(pendingAsk.getPerAllocationResource(), node, reservedContainer, type, schedulerKey)) {
            this.updateAMDiagnosticMsg(capability, " exceeds the available resources of the node and the request is reserved)");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + "'s resource request is reserved."));
            }
            return FairScheduler.CONTAINER_RESERVED;
        }
        this.updateAMDiagnosticMsg(capability, " exceeds the available resources of the node and the request cannot be reserved)");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Couldn't create reservation for app:  " + this.getName() + ", at priority " + schedulerKey.getPriority()));
        }
        return Resources.none();
    }

    private boolean isReservable(Resource capacity) {
        return this.isStarved() && this.scheduler.isAtLeastReservationThreshold(this.getQueue().getPolicy().getResourceCalculator(), capacity);
    }

    private boolean isOverAMShareLimit() {
        PendingAsk ask;
        return !this.isAmRunning() && !this.getUnmanagedAM() && (ask = this.appSchedulingInfo.getNextPendingAsk()) != null && (ask.getCount() == 0 || !this.getQueue().canRunAppAM(ask.getPerAllocationResource()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Node offered to app: " + this.getName() + " reserved: " + reserved));
        }
        Collection<SchedulerRequestKey> keysToTry = reserved ? Collections.singletonList(node.getReservedContainer().getReservedSchedulerKey()) : this.getSchedulerKeys();
        try {
            this.writeLock.lock();
            for (SchedulerRequestKey schedulerKey : keysToTry) {
                Resource resource;
                if (!reserved && !this.hasContainerForNode(schedulerKey, node)) continue;
                this.addSchedulingOpportunity(schedulerKey);
                PendingAsk rackLocalPendingAsk = this.getPendingAsk(schedulerKey, node.getRackName());
                PendingAsk nodeLocalPendingAsk = this.getPendingAsk(schedulerKey, node.getNodeName());
                if (nodeLocalPendingAsk.getCount() > 0 && !this.appSchedulingInfo.canDelayTo(schedulerKey, node.getNodeName())) {
                    LOG.warn((Object)("Relax locality off is not supported on local request: " + nodeLocalPendingAsk));
                }
                NodeType allowedLocality = this.scheduler.isContinuousSchedulingEnabled() ? this.getAllowedLocalityLevelByTime(schedulerKey, this.scheduler.getNodeLocalityDelayMs(), this.scheduler.getRackLocalityDelayMs(), this.scheduler.getClock().getTime()) : this.getAllowedLocalityLevel(schedulerKey, this.scheduler.getNumClusterNodes(), this.scheduler.getNodeLocalityThreshold(), this.scheduler.getRackLocalityThreshold());
                if (rackLocalPendingAsk.getCount() > 0 && nodeLocalPendingAsk.getCount() > 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Assign container on " + node.getNodeName() + " node, assignType: NODE_LOCAL, allowedLocality: " + (Object)((Object)allowedLocality) + ", priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    resource = this.assignContainer(node, nodeLocalPendingAsk, NodeType.NODE_LOCAL, reserved, schedulerKey);
                    return resource;
                }
                if (!this.appSchedulingInfo.canDelayTo(schedulerKey, node.getRackName())) continue;
                if (rackLocalPendingAsk.getCount() > 0 && (allowedLocality.equals((Object)NodeType.RACK_LOCAL) || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Assign container on " + node.getNodeName() + " node, assignType: RACK_LOCAL, allowedLocality: " + (Object)((Object)allowedLocality) + ", priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    resource = this.assignContainer(node, rackLocalPendingAsk, NodeType.RACK_LOCAL, reserved, schedulerKey);
                    return resource;
                }
                PendingAsk offswitchAsk = this.getPendingAsk(schedulerKey, "*");
                if (!this.appSchedulingInfo.canDelayTo(schedulerKey, "*")) continue;
                if (offswitchAsk.getCount() > 0 && (this.getAppPlacementAllocator(schedulerKey).getUniqueLocationAsks() <= 1 || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Assign container on " + node.getNodeName() + " node, assignType: OFF_SWITCH, allowedLocality: " + (Object)((Object)allowedLocality) + ", priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
                    }
                    Resource resource2 = this.assignContainer(node, offswitchAsk, NodeType.OFF_SWITCH, reserved, schedulerKey);
                    return resource2;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Can't assign container on " + node.getNodeName() + " node, allowedLocality: " + (Object)((Object)allowedLocality) + ", priority: " + schedulerKey.getPriority() + ", app attempt id: " + this.attemptId));
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return Resources.none();
    }

    private boolean hasContainerForNode(SchedulerRequestKey key, FSSchedulerNode node) {
        PendingAsk offswitchAsk = this.getPendingAsk(key, "*");
        Resource resource = offswitchAsk.getPerAllocationResource();
        boolean hasRequestForOffswitch = offswitchAsk.getCount() > 0;
        boolean hasRequestForRack = this.getOutstandingAsksCount(key, node.getRackName()) > 0;
        boolean hasRequestForNode = this.getOutstandingAsksCount(key, node.getNodeName()) > 0;
        boolean ret = true;
        if (!hasRequestForOffswitch || !this.appSchedulingInfo.canDelayTo(key, "*") && !hasRequestForRack || hasRequestForRack && !this.appSchedulingInfo.canDelayTo(key, node.getRackName()) && !hasRequestForNode || !Resources.fitsIn((Resource)resource, (Resource)node.getRMNode().getTotalCapability())) {
            ret = false;
        } else if (!this.getQueue().fitsInMaxShare(resource)) {
            this.updateAMDiagnosticMsg(resource, " exceeds current queue or its parents maximum resource allowed). Max share of queue: " + this.getQueue().getMaxShare());
            ret = false;
        }
        return ret;
    }

    private boolean isValidReservation(FSSchedulerNode node) {
        SchedulerRequestKey schedulerKey = node.getReservedContainer().getReservedSchedulerKey();
        return this.hasContainerForNode(schedulerKey, node) && !this.isOverAMShareLimit();
    }

    boolean assignReservedContainer(FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        SchedulerRequestKey reservedSchedulerKey = rmContainer.getReservedSchedulerKey();
        if (!this.isValidReservation(node)) {
            LOG.info((Object)("Releasing reservation that cannot be satisfied for application " + this.getApplicationAttemptId() + " on node " + node));
            this.unreserve(reservedSchedulerKey, node);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to fulfill reservation for application " + this.getApplicationAttemptId() + " on node: " + node));
        }
        if (Resources.fitsIn((Resource)node.getReservedContainer().getReservedResource(), (Resource)node.getUnallocatedResource())) {
            this.assignContainer(node, true);
        }
        return true;
    }

    Resource fairShareStarvation() {
        long now = this.scheduler.getClock().getTime();
        Resource threshold = Resources.multiply((Resource)this.getFairShare(), (double)this.getQueue().getFairSharePreemptionThreshold());
        Resource fairDemand = Resources.componentwiseMin((Resource)threshold, (Resource)this.demand);
        boolean starved = this.isUsageBelowShare(this.getResourceUsage(), fairDemand);
        if (!starved) {
            this.lastTimeAtFairShare = now;
        }
        this.fairshareStarvation = !starved || now - this.lastTimeAtFairShare < this.getQueue().getFairSharePreemptionTimeout() ? Resources.none() : Resources.subtractFromNonNegative((Resource)fairDemand, (Resource)this.getResourceUsage());
        return this.fairshareStarvation;
    }

    private boolean isUsageBelowShare(Resource usage, Resource share) {
        return this.getQueue().getPolicy().getResourceCalculator().compare(this.scheduler.getClusterResource(), usage, share, true) < 0;
    }

    boolean isStarvedForFairShare() {
        return this.isUsageBelowShare(this.getResourceUsage(), this.getFairShare());
    }

    boolean isStarved() {
        return this.isStarvedForFairShare() || !Resources.isNone((Resource)this.minshareStarvation);
    }

    List<ResourceRequest> getStarvedResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        VisitedResourceRequestTracker visitedRRs = new VisitedResourceRequestTracker(this.scheduler.getNodeTracker());
        Resource pending = this.getStarvation();
        for (ResourceRequest rr : this.appSchedulingInfo.getAllResourceRequests()) {
            int numContainersThatFit;
            if (Resources.isNone((Resource)pending)) break;
            if (!visitedRRs.visit(rr) || (numContainersThatFit = (int)Math.floor(Resources.ratio((ResourceCalculator)this.scheduler.getResourceCalculator(), (Resource)pending, (Resource)rr.getCapability()))) == 0) continue;
            if (numContainersThatFit < rr.getNumContainers()) {
                rr = ResourceRequest.newInstance((Priority)rr.getPriority(), (String)rr.getResourceName(), (Resource)rr.getCapability(), (int)numContainersThatFit);
            }
            ret.add(rr);
            Resources.subtractFromNonNegative((Resource)pending, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    void preemptionTriggered(long delayBeforeNextStarvationCheck) {
        this.nextStarvationCheck = this.scheduler.getClock().getTime() + delayBeforeNextStarvationCheck;
    }

    boolean shouldCheckForStarvation() {
        return this.scheduler.getClock().getTime() >= this.nextStarvationCheck;
    }

    @Override
    public String getName() {
        return this.getApplicationId().toString();
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    Resource getPendingDemand() {
        return Resources.subtract((Resource)this.demand, (Resource)this.getResourceUsage());
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getMinShare() {
        return Resources.none();
    }

    @Override
    public Resource getMaxShare() {
        return Resources.unbounded();
    }

    @Override
    public Resource getResourceUsage() {
        return this.getCurrentConsumption();
    }

    @Override
    public float getWeight() {
        float weight = 1.0f;
        if (this.scheduler.isSizeBasedWeight()) {
            weight = (float)(Math.log1p(this.demand.getMemorySize()) / Math.log(2.0));
        }
        return weight * (float)this.appPriority.getPriority();
    }

    @Override
    public Priority getPriority() {
        return this.appPriority;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
    }

    @Override
    public void updateDemand() {
        Resource tmpDemand = Resources.clone((Resource)this.getCurrentConsumption());
        for (SchedulerRequestKey k : this.getSchedulerKeys()) {
            PendingAsk pendingAsk = this.getPendingAsk(k, "*");
            if (pendingAsk.getCount() <= 0) continue;
            Resources.multiplyAndAddTo((Resource)tmpDemand, (Resource)pendingAsk.getPerAllocationResource(), (double)pendingAsk.getCount());
        }
        this.demand = tmpDemand;
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        if (this.isOverAMShareLimit()) {
            PendingAsk amAsk = this.appSchedulingInfo.getNextPendingAsk();
            this.updateAMDiagnosticMsg(amAsk.getPerAllocationResource(), " exceeds maximum AM resource allowed).");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AM resource request: " + amAsk.getPerAllocationResource() + " exceeds maximum AM resource allowed, " + this.getQueue().dumpState()));
            }
            return Resources.none();
        }
        return this.assignContainer(node, false);
    }

    private void updateAMDiagnosticMsg(Resource resource, String reason) {
        if (!this.isWaitingForAMContainer()) {
            return;
        }
        StringBuilder diagnosticMessageBldr = new StringBuilder();
        diagnosticMessageBldr.append(" (Resource request: ");
        diagnosticMessageBldr.append(resource);
        diagnosticMessageBldr.append(reason);
        this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, diagnosticMessageBldr.toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return this.getApplicationAttemptId() + " Alloc: " + this.getCurrentConsumption();
    }

    @Override
    public boolean isPreemptable() {
        return this.getQueue().isPreemptable();
    }

    @VisibleForTesting
    public void setEnableAMPreemption(boolean enableAMPreemption) {
        this.enableAMPreemption = enableAMPreemption;
    }
}

