/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionQueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.webapp.AppBlock;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed #BFBFBF";
    static final String Q_AUTO_CREATED = "background:#F4F0CB";
    static final String Q_OVER = "background:#FFA333";
    static final String Q_UNDER = "background:#5BD75B";
    static final String ACTIVE_USER = "background:#FFFF00";

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage.__> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css").__(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"}).__()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript").__(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'Queue: root') q = '';", "    else {", "      q = q.substr(q.lastIndexOf(':') + 2);", "      q = '^' + q.substr(q.lastIndexOf('.') + 1) + '$';", "    }", "    $('#apps').dataTable().fnFilter(q, 5, true);", "  });", "  $('#cs').show();", "});"}).__()).__(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String appendPercent(ResourceInfo resourceInfo, float f) {
        if (resourceInfo == null) {
            return "";
        }
        return resourceInfo.toString() + " (" + StringUtils.formatPercent((double)f, (int)1) + ")";
    }

    static String percent(float f) {
        return StringUtils.formatPercent((double)f, (int)1);
    }

    static String width(float f) {
        return StringUtils.format((String)"width:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    static String left(float f) {
        return StringUtils.format((String)"left:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    public static class HealthBlock
    extends HtmlBlock {
        final CapacityScheduler cs;

        @Inject
        HealthBlock(ResourceManager rm) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
        }

        public void render(HtmlBlock.Block html) {
            SchedulerHealth healthInfo = this.cs.getSchedulerHealth();
            Hamlet.DIV div = html.div("#health");
            div.h4("Aggregate scheduler counts");
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#lastrun").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Total Container Allocations(count)"}).__()).th().$class("ui-state-default").__(new Object[]{"Total Container Releases(count)"}).__()).th().$class("ui-state-default").__(new Object[]{"Total Fulfilled Reservations(count)"}).__()).th().$class("ui-state-default").__(new Object[]{"Total Container Preemptions(count)"}).__()).__()).__()).tbody();
            ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(String.valueOf(this.cs.getRootQueueMetrics().getAggregateAllocatedContainers())).td(String.valueOf(this.cs.getRootQueueMetrics().getAggegatedReleasedContainers())).td(healthInfo.getAggregateFulFilledReservationsCount().toString()).td(healthInfo.getAggregatePreemptionCount().toString()).__()).__()).__();
            div.h4("Last scheduler run");
            tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#lastrun").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Time"}).__()).th().$class("ui-state-default").__(new Object[]{"Allocations(count - resources)"}).__()).th().$class("ui-state-default").__(new Object[]{"Reservations(count - resources)"}).__()).th().$class("ui-state-default").__(new Object[]{"Releases(count - resources)"}).__()).__()).__()).tbody();
            ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(Times.format((long)healthInfo.getLastSchedulerRunTime())).td(healthInfo.getAllocationCount().toString() + " - " + healthInfo.getResourcesAllocated().toString()).td(healthInfo.getReservationCount().toString() + " - " + healthInfo.getResourcesReserved().toString()).td(healthInfo.getReleaseCount().toString() + " - " + healthInfo.getResourcesReleased().toString()).__()).__()).__();
            HashMap<String, SchedulerHealth.DetailedInformation> info = new HashMap<String, SchedulerHealth.DetailedInformation>();
            info.put("Allocation", healthInfo.getLastAllocationDetails());
            info.put("Reservation", healthInfo.getLastReservationDetails());
            info.put("Release", healthInfo.getLastReleaseDetails());
            info.put("Preemption", healthInfo.getLastPreemptionDetails());
            for (Map.Entry entry : info.entrySet()) {
                String containerId = "N/A";
                String nodeId = "N/A";
                String queue = "N/A";
                String table = "#" + (String)entry.getKey();
                div.h4("Last " + (String)entry.getKey());
                tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table(table).thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Time"}).__()).th().$class("ui-state-default").__(new Object[]{"Container Id"}).__()).th().$class("ui-state-default").__(new Object[]{"Node Id"}).__()).th().$class("ui-state-default").__(new Object[]{"Queue"}).__()).__()).__()).tbody();
                SchedulerHealth.DetailedInformation di = (SchedulerHealth.DetailedInformation)entry.getValue();
                if (di.getTimestamp() != 0L) {
                    if (di.getContainerId() != null) {
                        containerId = di.getContainerId().toString();
                    }
                    if (di.getNodeId() != null) {
                        nodeId = di.getNodeId().toString();
                    }
                    queue = di.getQueue();
                }
                ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(Times.format((long)di.getTimestamp())).td(containerId).td(nodeId).td(queue).__()).__()).__();
            }
            div.__();
        }
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final CSQInfo csqinfo;
        private final ResourceManager rm;
        private List<RMNodeLabel> nodeLabelsInfo;

        @Inject
        QueuesBlock(ResourceManager rm, CSQInfo info) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.csqinfo = info;
            this.rm = rm;
            RMNodeLabelsManager nodeLabelManager = rm.getRMContext().getNodeLabelManager();
            this.nodeLabelsInfo = nodeLabelManager.pullRMNodeLabelsInfo();
        }

        public void render(HtmlBlock.Block html) {
            html.__(MetricsOverviewTable.class);
            UserGroupInformation callerUGI = this.getCallerUGI();
            boolean isAdmin = false;
            ApplicationACLsManager aclsManager = this.rm.getApplicationACLsManager();
            if (aclsManager.areACLsEnabled()) {
                if (callerUGI != null && aclsManager.isAdmin(callerUGI)) {
                    isAdmin = true;
                }
            } else {
                isAdmin = true;
            }
            if (isAdmin) {
                ((Hamlet.DIV)((Hamlet.SELECT)((Hamlet.SELECT)((Hamlet.SELECT)((Hamlet.DIV)html.div().button().$style("border-style: solid; border-color: #000000; border-width: 1px; cursor: hand; cursor: pointer; border-radius: 4px").$onclick("confirmAction()").b("Dump scheduler logs").__()).select().$id("time").option().$value("60").__(new Object[]{"1 min"}).__()).option().$value("300").__(new Object[]{"5 min"}).__()).option().$value("600").__(new Object[]{"10 min"}).__()).__()).__();
                StringBuilder script = new StringBuilder();
                script.append("function confirmAction() {").append(" b = confirm(\"Are you sure you wish to generate scheduler logs?\");").append(" if (b == true) {").append(" var timePeriod = $(\"#time\").val();").append(" $.ajax({").append(" type: 'POST',").append(" url: '/ws/v1/cluster/scheduler/logs',").append(" contentType: 'text/plain',").append(AppBlock.getCSRFHeaderString((Configuration)this.rm.getConfig())).append(" data: 'time=' + timePeriod,").append(" dataType: 'text'").append(" }).done(function(data){").append(" setTimeout(function(){").append(" alert(\"Scheduler log is being generated.\");").append(" }, 1000);").append(" }).fail(function(data){").append(" alert(\"Scheduler log generation failed. Please check the ResourceManager log for more information.\");").append(" console.log(data);").append(" });").append(" }").append("}");
                html.script().$type("text/javascript").__(new Object[]{script.toString()}).__();
            }
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top").__(new Object[]{"Application Queues"}).__()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END).__(new Object[]{"100% "}).__()).span(".q", "default").__()).__();
            } else {
                CapacitySchedulerInfo sinfo;
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold").__(new Object[]{"Legend:"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_GIVEN).__(new Object[]{"Capacity"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_UNDER).__(new Object[]{"Used"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_OVER).__(new Object[]{"Used (over capacity)"}).__()).span().$class("qlegend ui-corner-all ui-state-default").__(new Object[]{"Max Capacity"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.ACTIVE_USER).__(new Object[]{"Users Requesting Resources"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_AUTO_CREATED).__(new Object[]{"Auto Created Queues"}).__()).__();
                float used = 0.0f;
                CSQueue root = this.cs.getRootQueue();
                this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root, this.cs);
                boolean hasAnyLabelLinkedToNM = false;
                if (null != this.nodeLabelsInfo) {
                    for (RMNodeLabel label : this.nodeLabelsInfo) {
                        if (label.getLabelName().length() == 0 || label.getNumActiveNMs() <= 0) continue;
                        hasAnyLabelLinkedToNM = true;
                        break;
                    }
                }
                if (!hasAnyLabelLinkedToNM) {
                    used = sinfo.getUsedCapacity() / 100.0f;
                    ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{"."}).__()).span(".q", "Queue: root").__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__()).__(QueueBlock.class).__();
                } else {
                    for (RMNodeLabel label : this.nodeLabelsInfo) {
                        this.csqinfo.qinfo = null;
                        this.csqinfo.label = label.getLabelName();
                        this.csqinfo.isExclusiveNodeLabel = label.getIsExclusive();
                        String nodeLabelDisplay = this.csqinfo.label.length() == 0 ? "<DEFAULT_PARTITION>" : this.csqinfo.label;
                        PartitionQueueCapacitiesInfo capacities = sinfo.getCapacities().getPartitionQueueCapacitiesInfo(this.csqinfo.label);
                        used = capacities.getUsedCapacity() / 100.0f;
                        String partitionUiTag = "Partition: " + nodeLabelDisplay + " " + label.getResource();
                        ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{"."}).__()).span(".q", partitionUiTag).__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__()).__();
                        Hamlet.UL underLabel = html.ul("#pq");
                        ((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.A)underLabel.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{"."}).__()).span(".q", "Queue: root").__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__()).__(QueueBlock.class).__()).__();
                    }
                }
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul.__()).__()).script().$type("text/javascript").__(new Object[]{"$('#cs').hide();"}).__()).__()).__(RMAppsBlock.class);
            html.__(HealthBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final CSQInfo csqinfo;

        @Inject
        QueueBlock(CSQInfo info) {
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            ArrayList<CapacitySchedulerQueueInfo> subQueues = this.csqinfo.qinfo == null ? this.csqinfo.csinfo.getQueues().getQueueInfoList() : this.csqinfo.qinfo.getQueues().getQueueInfoList();
            Hamlet.UL ul = html.ul("#pq");
            for (CapacitySchedulerQueueInfo info : subQueues) {
                String nodeLabel;
                String string = nodeLabel = this.csqinfo.label == null ? "" : this.csqinfo.label;
                if (!nodeLabel.isEmpty() && this.csqinfo.isExclusiveNodeLabel && !info.getNodeLabels().contains("*") && !info.getNodeLabels().contains(nodeLabel)) continue;
                PartitionQueueCapacitiesInfo partitionQueueCapsInfo = info.getCapacities().getPartitionQueueCapacitiesInfo(nodeLabel);
                float used = partitionQueueCapsInfo.getUsedCapacity() / 100.0f;
                float absCap = partitionQueueCapsInfo.getAbsoluteCapacity() / 100.0f;
                float absMaxCap = partitionQueueCapsInfo.getAbsoluteMaxCapacity() / 100.0f;
                float absUsedCap = partitionQueueCapsInfo.getAbsoluteUsedCapacity() / 100.0f;
                boolean isAutoCreatedLeafQueue = info.isLeafQueue() ? ((CapacitySchedulerLeafQueueInfo)info).isAutoCreatedLeafQueue() : false;
                float capPercent = absMaxCap == 0.0f ? 0.0f : absCap / absMaxCap;
                float usedCapPercent = absMaxCap == 0.0f ? 0.0f : absUsedCap / absMaxCap;
                String Q_WIDTH = CapacitySchedulerPage.width(absMaxCap * 0.8f);
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(isAutoCreatedLeafQueue ? StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_AUTO_CREATED, ";", Q_WIDTH}) : Q_WIDTH).$title(StringHelper.join((Object[])new Object[]{"Absolute Capacity:", CapacitySchedulerPage.percent(absCap)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_GIVEN, ";font-size:1px;", CapacitySchedulerPage.width(capPercent)})).__(new Object[]{Character.valueOf('.')}).__()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(usedCapPercent), ";font-size:1px;left:0%;", absUsedCap > absCap ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{Character.valueOf('.')}).__()).span(".q", "Queue: " + info.getQueuePath().substring(5)).__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__();
                this.csqinfo.qinfo = info;
                if (info.isLeafQueue()) {
                    ((Hamlet.UL)li.ul("#lq").li().__(LeafQueueInfoBlock.class).__()).__();
                    ((Hamlet.UL)li.ul("#lq").li().__(QueueUsersInfoBlock.class).__()).__();
                } else {
                    li.__(QueueBlock.class);
                }
                li.__();
            }
            ul.__();
        }
    }

    static class QueueUsersInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;
        private String nodeLabel;

        @Inject
        QueueUsersInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
            this.nodeLabel = info.label;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.table("#userinfo").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"User Name"}).__()).th().$class("ui-state-default").__(new Object[]{"Max Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Weight"}).__()).th().$class("ui-state-default").__(new Object[]{"Used Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Max AM Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Used AM Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Schedulable Apps"}).__()).th().$class("ui-state-default").__(new Object[]{"Non-Schedulable Apps"}).__()).__()).__()).tbody();
            PartitionResourcesInfo queueUsageResources = this.lqinfo.getResources().getPartitionResourceUsageInfo(this.nodeLabel == null ? "" : this.nodeLabel);
            ArrayList<UserInfo> users = this.lqinfo.getUsers().getUsersList();
            for (UserInfo userInfo : users) {
                ResourceInfo amUsed;
                ResourceInfo resourcesUsed = userInfo.getResourcesUsed();
                ResourceInfo userAMLimitPerPartition = queueUsageResources.getUserAmLimit();
                if (userAMLimitPerPartition == null) {
                    userAMLimitPerPartition = queueUsageResources.getAMLimit();
                }
                if ((double)userInfo.getUserWeight() != 1.0) {
                    userAMLimitPerPartition = new ResourceInfo(Resources.multiply((Resource)userAMLimitPerPartition.getResource(), (double)userInfo.getUserWeight()));
                }
                if (this.nodeLabel != null) {
                    resourcesUsed = userInfo.getResourceUsageInfo().getPartitionResourceUsageInfo(this.nodeLabel).getUsed();
                }
                if ((amUsed = userInfo.getAMResourcesUsed()) == null) {
                    amUsed = new ResourceInfo(Resources.none());
                }
                String highlightIfAsking = userInfo.getIsActive() ? CapacitySchedulerPage.ACTIVE_USER : null;
                tbody.tr().$style(highlightIfAsking).td(userInfo.getUsername()).td(userInfo.getUserResourceLimit().toString()).td(String.valueOf(userInfo.getUserWeight())).td(resourcesUsed.toString()).td(userAMLimitPerPartition.toString()).td(amUsed.toString()).td(Integer.toString(userInfo.getNumActiveApplications())).td(Integer.toString(userInfo.getNumPendingApplications())).__();
            }
            html.div().$class("usersinfo").h5("Active Users Info").__();
            ((Hamlet.TABLE)tbody.__()).__();
        }
    }

    static class LeafQueueInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;
        private String nodeLabel;

        @Inject
        LeafQueueInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
            this.nodeLabel = info.label;
        }

        protected void render(HtmlBlock.Block html) {
            if (this.nodeLabel == null) {
                this.renderLeafQueueInfoWithoutParition(html);
            } else {
                this.renderLeafQueueInfoWithPartition(html);
            }
        }

        private void renderLeafQueueInfoWithPartition(HtmlBlock.Block html) {
            String nodeLabelDisplay = this.nodeLabel.length() == 0 ? "<DEFAULT_PARTITION>" : this.nodeLabel;
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status for Partition '" + nodeLabelDisplay + "'");
            this.renderQueueCapacityInfo(ri, this.nodeLabel);
            html.__(InfoBlock.class);
            ri.clear();
            ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status").__("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderCommonLeafQueueInfo(ri);
            html.__(InfoBlock.class);
            ri.clear();
        }

        private void renderLeafQueueInfoWithoutParition(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status").__("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderQueueCapacityInfo(ri, "");
            this.renderCommonLeafQueueInfo(ri);
            html.__(InfoBlock.class);
            ri.clear();
        }

        private void renderQueueCapacityInfo(ResponseInfo ri, String label) {
            PartitionQueueCapacitiesInfo capacities = this.lqinfo.getCapacities().getPartitionQueueCapacitiesInfo(label);
            PartitionResourcesInfo resourceUsages = this.lqinfo.getResources().getPartitionResourceUsageInfo(label);
            ResourceInfo userAMResourceLimit = null;
            ArrayList<UserInfo> usersList = this.lqinfo.getUsers().getUsersList();
            if (!usersList.isEmpty()) {
                userAMResourceLimit = resourceUsages.getUserAmLimit();
            }
            if (userAMResourceLimit == null) {
                userAMResourceLimit = resourceUsages.getAMLimit();
            }
            ResourceInfo amUsed = resourceUsages.getAmUsed() == null ? new ResourceInfo(Resources.none()) : resourceUsages.getAmUsed();
            ri.__("Used Capacity:", (Object)CapacitySchedulerPage.appendPercent(resourceUsages.getUsed(), capacities.getUsedCapacity() / 100.0f)).__("Configured Capacity:", (Object)(capacities.getConfiguredMinResource() == null ? Resources.none().toString() : capacities.getConfiguredMinResource().toString())).__("Configured Max Capacity:", (Object)(capacities.getConfiguredMaxResource() == null || capacities.getConfiguredMaxResource().getResource().equals((Object)Resources.none()) ? "unlimited" : capacities.getConfiguredMaxResource().toString())).__("Effective Capacity:", (Object)CapacitySchedulerPage.appendPercent(capacities.getEffectiveMinResource(), capacities.getCapacity() / 100.0f)).__("Effective Max Capacity:", (Object)CapacitySchedulerPage.appendPercent(capacities.getEffectiveMaxResource(), capacities.getMaxCapacity() / 100.0f)).__("Absolute Used Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteUsedCapacity() / 100.0f)).__("Absolute Configured Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteCapacity() / 100.0f)).__("Absolute Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteMaxCapacity() / 100.0f)).__("Used Resources:", (Object)resourceUsages.getUsed().toString()).__("Configured Max Application Master Limit:", (Object)StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(capacities.getMaxAMLimitPercentage())})).__("Max Application Master Resources:", (Object)resourceUsages.getAMLimit().toString()).__("Used Application Master Resources:", (Object)amUsed.toString()).__("Max Application Master Resources Per User:", (Object)userAMResourceLimit.toString());
        }

        private void renderCommonLeafQueueInfo(ResponseInfo ri) {
            ri.__("Num Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumActiveApplications())).__("Num Non-Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumPendingApplications())).__("Num Containers:", (Object)Integer.toString(this.lqinfo.getNumContainers())).__("Max Applications:", (Object)Integer.toString(this.lqinfo.getMaxApplications())).__("Max Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxApplicationsPerUser())).__("Configured Minimum User Limit Percent:", (Object)(Integer.toString(this.lqinfo.getUserLimit()) + "%")).__("Configured User Limit Factor:", (Object)Float.valueOf(this.lqinfo.getUserLimitFactor())).__("Accessible Node Labels:", (Object)StringUtils.join((CharSequence)",", this.lqinfo.getNodeLabels())).__("Ordering Policy: ", (Object)this.lqinfo.getOrderingPolicyDisplayName()).__("Preemption:", (Object)(this.lqinfo.getPreemptionDisabled() ? "disabled" : "enabled")).__("Intra-queue Preemption:", (Object)(this.lqinfo.getIntraQueuePreemptionDisabled() ? "disabled" : "enabled")).__("Default Node Label Expression:", (Object)(this.lqinfo.getDefaultNodeLabelExpression() == null ? "<DEFAULT_PARTITION>" : this.lqinfo.getDefaultNodeLabelExpression())).__("Default Application Priority:", (Object)Integer.toString(this.lqinfo.getDefaultApplicationPriority()));
        }
    }

    @RequestScoped
    static class CSQInfo {
        CapacitySchedulerInfo csinfo;
        CapacitySchedulerQueueInfo qinfo;
        String label;
        boolean isExclusiveNodeLabel;

        CSQInfo() {
        }
    }
}

