/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CustomResourceInfo;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

@XmlRootElement(name="nodeInstanceType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeInstanceType {
    protected String modelName;
    protected CustomResourceInfo capacity;

    public String getModelName() {
        return this.modelName;
    }

    public CustomResourceInfo getCapacity() {
        return this.capacity;
    }

    public NodeInstanceType() {
    }

    public NodeInstanceType(String name, Resource res) {
        this.capacity = new CustomResourceInfo(res);
        this.modelName = name;
    }

    public static int[] getSuitableInstanceType(Resource res, List<NodeInstanceType> allType, ResourceCalculator rc) {
        int[] ret = new int[2];
        int buckets = 0;
        int minimumBuckets = Integer.MAX_VALUE;
        int bestInstanceIndex = -1;
        for (int i = 0; i < allType.size(); ++i) {
            buckets = (int)rc.computeAvailableContainers(allType.get(i).getCapacity().getResource(), res);
            if (buckets <= 0 || buckets >= minimumBuckets) continue;
            minimumBuckets = buckets;
            bestInstanceIndex = i;
        }
        ret[0] = bestInstanceIndex;
        ret[1] = minimumBuckets;
        return ret;
    }

    public String toStr(int count) {
        return "name:" + this.modelName + "; count:" + count;
    }
}

