/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingQueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleConditionalVariables;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResultType;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationHelper;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;

public class CSMappingPlacementRule
extends PlacementRule {
    private static final Log LOG = LogFactory.getLog(CSMappingPlacementRule.class);
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "_dot_";
    private CapacitySchedulerQueueManager queueManager;
    private List<MappingRule> mappingRules;
    private ImmutableSet<String> immutableVariables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group", (Object)"%application", (Object)"%specified");
    private Groups groups;
    private boolean overrideWithQueueMappings;
    private boolean failOnConfigError = true;

    @VisibleForTesting
    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    @VisibleForTesting
    public void setFailOnConfigError(boolean failOnConfigError) {
        this.failOnConfigError = failOnConfigError;
    }

    private MappingRuleValidationContext buildValidationContext() throws IOException {
        Preconditions.checkNotNull((Object)this.queueManager, (Object)"Queue manager must be initialized before building validation a context!");
        MappingRuleValidationContextImpl validationContext = new MappingRuleValidationContextImpl(this.queueManager);
        for (String var : this.immutableVariables) {
            try {
                validationContext.addImmutableVariable(var);
            }
            catch (YarnException e) {
                LOG.error((Object)("Error initializing placement variables, unable to register '" + var + "': " + e.getMessage()));
                throw new IOException(e);
            }
        }
        try {
            validationContext.addVariable("%default");
        }
        catch (YarnException e) {
            LOG.error((Object)("Error initializing placement variables, unable to register '%default': " + e.getMessage()));
            throw new IOException(e);
        }
        return validationContext;
    }

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new IOException("CSMappingPlacementRule can be only used with CapacityScheduler");
        }
        LOG.info((Object)("Initializing " + this.getClass().getSimpleName() + " queue mapping manager."));
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)((Object)scheduler);
        this.queueManager = csContext.getCapacitySchedulerQueueManager();
        CapacitySchedulerConfiguration conf = csContext.getConfiguration();
        this.overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        if (this.groups == null) {
            this.groups = Groups.getUserToGroupsMappingService((Configuration)conf);
        }
        MappingRuleValidationContext validationContext = this.buildValidationContext();
        this.mappingRules = conf.getMappingRules();
        for (MappingRule rule2 : this.mappingRules) {
            try {
                rule2.validate(validationContext);
            }
            catch (YarnException e) {
                LOG.error((Object)("Error initializing queue mappings, rule '" + rule2 + "' has encountered a validation error: " + e.getMessage()));
                if (!this.failOnConfigError) continue;
                throw new IOException(e);
            }
        }
        LOG.info((Object)("Initialized queue mappings, can override user specified queues: " + this.overrideWithQueueMappings + "  number of rules: " + this.mappingRules.size() + " mapping rules: " + this.mappingRules));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initialized with the following mapping rules:");
            this.mappingRules.forEach(rule -> LOG.debug((Object)rule.toString()));
        }
        return this.mappingRules.size() > 0;
    }

    private void setupGroupsForVariableContext(VariableContext vctx, String user) throws IOException {
        if (this.groups == null) {
            LOG.warn((Object)("Group provider hasn't been set, cannot query groups for user " + user));
            vctx.put("%primary_group", "");
            vctx.put("%secondary_group", "");
            return;
        }
        Set groupsSet = this.groups.getGroupsSet(user);
        if (groupsSet.isEmpty()) {
            LOG.warn((Object)("There are no groups for user '" + user + "'"));
            vctx.putExtraDataset("groups", groupsSet);
            return;
        }
        Iterator it = groupsSet.iterator();
        String primaryGroup = this.cleanName((String)it.next());
        ArrayList<String> secondaryGroupList = new ArrayList<String>();
        while (it.hasNext()) {
            String groupName = this.cleanName((String)it.next());
            secondaryGroupList.add(groupName);
        }
        if (secondaryGroupList.size() == 0) {
            vctx.put("%secondary_group", "");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + user + " is not associated with any Secondary Group."));
            }
        } else {
            vctx.putConditional("%secondary_group", new MappingRuleConditionalVariables.SecondaryGroupVariable(this.queueManager, secondaryGroupList));
        }
        vctx.put("%primary_group", primaryGroup);
        vctx.putExtraDataset("groups", groupsSet);
    }

    private VariableContext createVariableContext(ApplicationSubmissionContext asc, String user) {
        VariableContext vctx = new VariableContext();
        vctx.put("%user", this.cleanName(user));
        if (!asc.getQueue().equals("default")) {
            vctx.put("%specified", asc.getQueue());
        } else {
            vctx.put("%specified", "");
        }
        vctx.put("%application", asc.getApplicationName());
        vctx.put("%default", "root.default");
        try {
            this.setupGroupsForVariableContext(vctx, user);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to setup groups: {}" + e.getMessage()));
        }
        vctx.setImmutables((Set<String>)this.immutableVariables);
        return vctx;
    }

    private String validateAndNormalizeQueue(String queueName, boolean allowCreate) throws YarnException {
        MappingQueuePath path = new MappingQueuePath(queueName);
        if (path.hasEmptyPart()) {
            throw new YarnException("Invalid path returned by rule: '" + queueName + "'");
        }
        String leaf = path.getLeafName();
        String parent = path.getParent();
        String normalizedName = parent != null ? this.validateAndNormalizeQueueWithParent(parent, leaf, allowCreate) : this.validateAndNormalizeQueueWithNoParent(leaf);
        CSQueue queue = this.queueManager.getQueueByFullName(normalizedName);
        if (queue != null && !(queue instanceof LeafQueue)) {
            throw new YarnException("Mapping rule returned a non-leaf queue '" + normalizedName + "', cannot place application in it.");
        }
        return normalizedName;
    }

    private String validateAndNormalizeQueueWithParent(String parent, String leaf, boolean allowCreate) throws YarnException {
        String normalizedPath = MappingRuleValidationHelper.normalizeQueuePathRoot(this.queueManager, parent + DOT + leaf);
        MappingRuleValidationHelper.ValidationResult validity = MappingRuleValidationHelper.validateQueuePathAutoCreation(this.queueManager, normalizedPath);
        switch (validity) {
            case AMBIGUOUS_PARENT: {
                throw new YarnException("Mapping rule specified a parent queue '" + parent + "', but it is ambiguous.");
            }
            case AMBIGUOUS_QUEUE: {
                throw new YarnException("Mapping rule specified a target queue '" + normalizedPath + "', but it is ambiguous.");
            }
            case EMPTY_PATH: {
                throw new YarnException("Mapping rule did not specify a target queue.");
            }
            case NO_PARENT_PROVIDED: {
                throw new YarnException("Mapping rule did not specify an existing queue nor a dynamic parent queue.");
            }
            case NO_DYNAMIC_PARENT: {
                throw new YarnException("Mapping rule specified a parent queue '" + parent + "', but it is not a dynamic parent queue, and no queue exists with name '" + leaf + "' under it.");
            }
            case QUEUE_EXISTS: {
                break;
            }
            case CREATABLE: {
                if (allowCreate) break;
                throw new YarnException("Mapping rule doesn't allow auto-creation of the queue '" + normalizedPath + "'.");
            }
            default: {
                throw new YarnException("Unknown queue path validation result. '" + (Object)((Object)validity) + "'.");
            }
        }
        return normalizedPath;
    }

    private String validateAndNormalizeQueueWithNoParent(String leaf) throws YarnException {
        CSQueue queue = this.queueManager.getQueue(leaf);
        if (queue == null) {
            if (this.queueManager.isAmbiguous(leaf)) {
                throw new YarnException("Queue '" + leaf + "' specified in mapping rule is ambiguous");
            }
            throw new YarnException("Queue '" + leaf + "' specified in mapping rule does not exist.");
        }
        return queue.getQueuePath();
    }

    private MappingRuleResult evaluateRule(MappingRule rule, VariableContext variables) {
        MappingRuleResult result = rule.evaluate(variables);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluated rule '" + rule + "' with result: '" + result + "'"));
        }
        if (result.getResult() == MappingRuleResultType.PLACE) {
            try {
                result.updateNormalizedQueue(this.validateAndNormalizeQueue(result.getQueue(), result.isCreateAllowed()));
            }
            catch (Exception e) {
                result = rule.getFallback();
                LOG.info((Object)("Cannot place to queue '" + result.getQueue() + "' returned by mapping rule. Reason: '" + e.getMessage() + "' Fallback operation:'" + result + "'"));
            }
        }
        return result;
    }

    private ApplicationPlacementContext createPlacementContext(String queueName) {
        int parentQueueNameEndIndex = queueName.lastIndexOf(DOT);
        if (parentQueueNameEndIndex > -1) {
            String parent = queueName.substring(0, parentQueueNameEndIndex).trim();
            String leaf = queueName.substring(parentQueueNameEndIndex + 1).trim();
            return new ApplicationPlacementContext(leaf, parent);
        }
        return new ApplicationPlacementContext(queueName);
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        return this.getPlacementForApp(asc, user, false);
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user, boolean recovery) throws YarnException {
        String appQueue = asc.getQueue();
        LOG.debug((Object)("Looking placement for app '" + asc.getApplicationName() + "' originally submitted to queue '" + appQueue + "', with override enabled '" + this.overrideWithQueueMappings + "'"));
        if (!(appQueue == null || appQueue.equals("default") || this.overrideWithQueueMappings || recovery)) {
            LOG.info((Object)("Have no jurisdiction over application submission '" + asc.getApplicationName() + "', moving to next PlacementRule engine"));
            return null;
        }
        VariableContext variables = this.createVariableContext(asc, user);
        ApplicationPlacementContext ret = null;
        for (MappingRule rule : this.mappingRules) {
            MappingRuleResult result = this.evaluateRule(rule, variables);
            switch (result.getResult()) {
                case PLACE_TO_DEFAULT: {
                    ret = this.placeToDefault(asc, variables, rule);
                    break;
                }
                case PLACE: {
                    ret = this.placeToQueue(asc, rule, result);
                    break;
                }
                case REJECT: {
                    LOG.info((Object)("Rejecting application '" + asc.getApplicationName() + "', reason: Mapping rule '{}' fallback action is set to REJECT."));
                    throw new YarnException("Application submission have been rejected by a mapping rule. Please see the logs for details");
                }
                case SKIP: {
                    break;
                }
                default: {
                    LOG.error((Object)("Invalid result '" + result + "'"));
                }
            }
            if (ret == null) continue;
            break;
        }
        if (ret == null) {
            LOG.info((Object)("No matching rule found for application '" + asc.getApplicationName() + "', moving to next PlacementRule engine"));
        }
        if (recovery && (ret == null || !ret.getQueue().equals(asc.getQueue()))) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Placement final result '" + (ret == null ? "null" : ret.getFullQueuePath()) + "' for application '" + asc.getApplicationId() + "'"));
        }
        return ret;
    }

    private ApplicationPlacementContext placeToQueue(ApplicationSubmissionContext asc, MappingRule rule, MappingRuleResult result) {
        LOG.debug((Object)("Application '" + asc.getApplicationName() + "' have been placed to queue '" + result.getNormalizedQueue() + "' by rule " + rule));
        return this.createPlacementContext(result.getNormalizedQueue());
    }

    private ApplicationPlacementContext placeToDefault(ApplicationSubmissionContext asc, VariableContext variables, MappingRule rule) throws YarnException {
        try {
            String queueName = this.validateAndNormalizeQueue(variables.replacePathVariables("%default"), false);
            LOG.debug((Object)("Application '" + asc.getApplicationName() + "' have been placed to queue '" + queueName + "' by the fallback option of rule " + rule));
            return this.createPlacementContext(queueName);
        }
        catch (YarnException e) {
            LOG.error((Object)("Rejecting application due to a failed fallback action '" + asc.getApplicationName() + "', reason: " + e.getMessage()));
            throw new YarnException("Application submission have been rejected by a mapping rule. Please see the logs for details");
        }
    }

    private String cleanName(String name) {
        if (name.contains(DOT)) {
            String converted = name.replaceAll("\\.", DOT_REPLACEMENT);
            LOG.warn((Object)("Name " + name + " is converted to " + converted + " when it is used as a queue name."));
            return converted;
        }
        return name;
    }
}

