/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

public class MappingQueuePath {
    private String parent;
    private String leaf;

    public MappingQueuePath(String parent, String leaf) {
        this.parent = parent;
        this.leaf = leaf;
    }

    public MappingQueuePath(String fullPath) {
        this.setFromFullPath(fullPath);
    }

    private void setFromFullPath(String fullPath) {
        this.parent = null;
        this.leaf = fullPath;
        int lastDotIdx = fullPath.lastIndexOf(".");
        if (lastDotIdx > -1) {
            this.parent = fullPath.substring(0, lastDotIdx).trim();
            this.leaf = fullPath.substring(lastDotIdx + 1).trim();
        }
    }

    public boolean hasEmptyPart() {
        String[] parts = this.getFullPath().split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals("")) continue;
            return true;
        }
        return false;
    }

    public String getParent() {
        return this.parent;
    }

    public String getLeafName() {
        return this.leaf;
    }

    public String getFullPath() {
        return this.hasParent() ? this.parent + "." + this.leaf : this.leaf;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public String toString() {
        return this.getFullPath();
    }
}

