/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

public interface RMNode {
    public NodeId getNodeID();

    public String getHostName();

    public int getCommandPort();

    public int getHttpPort();

    public String getNodeAddress();

    public String getHttpAddress();

    public String getHealthReport();

    public long getLastHealthReportTime();

    public String getNodeManagerVersion();

    public Resource getTotalCapability();

    public ResourceUtilization getAggregatedContainersUtilization();

    public ResourceUtilization getNodeUtilization();

    public Resource getPhysicalResource();

    public String getRackName();

    public Node getNode();

    public NodeState getState();

    public List<ContainerId> getContainersToCleanUp();

    public List<ApplicationId> getAppsToCleanup();

    public List<ApplicationId> getRunningApps();

    public void setAndUpdateNodeHeartbeatResponse(NodeHeartbeatResponse var1);

    public NodeHeartbeatResponse getLastNodeHeartBeatResponse();

    public void resetLastNodeHeartBeatResponse();

    public List<UpdatedContainerInfo> pullContainerUpdates();

    public Set<String> getNodeLabels();

    public List<Container> pullNewlyIncreasedContainers();

    public OpportunisticContainersStatus getOpportunisticContainersStatus();

    public long getUntrackedTimeStamp();

    public void setUntrackedTimeStamp(long var1);

    public Integer getDecommissioningTimeout();

    public Map<String, Long> getAllocationTagsWithCount();

    public RMContext getRMContext();

    public Set<NodeAttribute> getAllNodeAttributes();
}

