/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityLevel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class ActivitiesLogger {
    private static final Log LOG = LogFactory.getLog(ActivitiesLogger.class);

    private static void recordActivity(ActivitiesManager activitiesManager, NodeId nodeId, String parentName, String childName, Priority priority, ActivityState state, String diagnostic, ActivityLevel level) {
        activitiesManager.addSchedulingActivityForNode(nodeId, parentName, childName, priority != null ? Integer.valueOf(priority.getPriority()) : null, state, diagnostic, level, null);
    }

    private static NodeId getRecordingNodeId(ActivitiesManager activitiesManager, SchedulerNode node) {
        return activitiesManager == null ? null : activitiesManager.getRecordingNodeId(node);
    }

    private static String getRequestName(Integer priority, Long allocationRequestId) {
        return "request_" + (priority == null ? "" : priority) + "_" + (allocationRequestId == null ? "" : allocationRequestId);
    }

    private static Integer getPriority(SchedulerRequestKey schedulerKey) {
        Priority priority = schedulerKey == null ? null : schedulerKey.getPriority();
        return priority == null ? null : Integer.valueOf(priority.getPriority());
    }

    public static class NODE {
        public static void finishSkippedNodeAllocation(ActivitiesManager activitiesManager, SchedulerNode node) {
            NODE.finishAllocatedNodeAllocation(activitiesManager, node, null, AllocationState.SKIPPED);
        }

        public static void finishAllocatedNodeAllocation(ActivitiesManager activitiesManager, SchedulerNode node, ContainerId containerId, AllocationState containerState) {
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            if (nodeId == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(nodeId)) {
                activitiesManager.updateAllocationFinalState(nodeId, containerId, containerState);
            }
        }

        public static void finishNodeUpdateRecording(ActivitiesManager activitiesManager, NodeId nodeID, String partition) {
            if (activitiesManager == null) {
                return;
            }
            activitiesManager.finishNodeUpdateRecording(nodeID, partition);
        }

        public static void startNodeUpdateRecording(ActivitiesManager activitiesManager, NodeId nodeID) {
            if (activitiesManager == null) {
                return;
            }
            activitiesManager.startNodeUpdateRecording(nodeID);
        }
    }

    public static class QUEUE {
        public static void recordQueueActivity(ActivitiesManager activitiesManager, SchedulerNode node, String parentQueueName, String queueName, ActivityState state, String diagnostic) {
            QUEUE.recordQueueActivity(activitiesManager, node, parentQueueName, queueName, state, () -> diagnostic);
        }

        public static void recordQueueActivity(ActivitiesManager activitiesManager, SchedulerNode node, String parentQueueName, String queueName, ActivityState state, Supplier<String> diagnosticSupplier) {
            if (activitiesManager == null) {
                return;
            }
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            if (activitiesManager.shouldRecordThisNode(nodeId)) {
                ActivitiesLogger.recordActivity(activitiesManager, nodeId, parentQueueName, queueName, null, state, diagnosticSupplier.get(), ActivityLevel.QUEUE);
            }
        }
    }

    public static class APP {
        public static void recordSkippedAppActivityWithoutAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, SchedulerRequestKey requestKey, String diagnostic, ActivityLevel level) {
            APP.recordAppActivityWithoutAllocation(activitiesManager, node, application, requestKey, diagnostic, ActivityState.SKIPPED, level);
        }

        public static void recordRejectedAppActivityFromLeafQueue(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, Priority priority, String diagnostic) {
            if (activitiesManager == null) {
                return;
            }
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            if (activitiesManager.shouldRecordThisNode(nodeId)) {
                ActivitiesLogger.recordActivity(activitiesManager, nodeId, application.getQueueName(), application.getApplicationId().toString(), priority, ActivityState.REJECTED, diagnostic, ActivityLevel.APP);
            }
            APP.finishSkippedAppAllocationRecording(activitiesManager, application.getApplicationId(), ActivityState.REJECTED, diagnostic);
        }

        public static void recordAppActivityWithoutAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, SchedulerRequestKey schedulerKey, String diagnostic, ActivityState appState, ActivityLevel level) {
            if (activitiesManager == null) {
                return;
            }
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            if (activitiesManager.shouldRecordThisNode(nodeId)) {
                String requestName = null;
                Integer priority = null;
                Long allocationRequestId = null;
                if (level == ActivityLevel.NODE || level == ActivityLevel.REQUEST) {
                    if (schedulerKey == null) {
                        LOG.warn((Object)("Request key should not be null at " + (Object)((Object)level) + " level."));
                        return;
                    }
                    priority = ActivitiesLogger.getPriority(schedulerKey);
                    allocationRequestId = schedulerKey.getAllocationRequestId();
                    requestName = ActivitiesLogger.getRequestName(priority, allocationRequestId);
                }
                switch (level) {
                    case NODE: {
                        APP.recordSchedulerActivityAtNodeLevel(activitiesManager, application, requestName, priority, allocationRequestId, null, nodeId, appState, diagnostic);
                        break;
                    }
                    case REQUEST: {
                        APP.recordSchedulerActivityAtRequestLevel(activitiesManager, application, requestName, priority, allocationRequestId, nodeId, appState, diagnostic);
                        break;
                    }
                    case APP: {
                        APP.recordSchedulerActivityAtAppLevel(activitiesManager, application, nodeId, appState, diagnostic);
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Doesn't handle app activities at " + (Object)((Object)level) + " level."));
                    }
                }
            }
            if (activitiesManager.shouldRecordThisApp(application.getApplicationId())) {
                activitiesManager.addSchedulingActivityForApp(application.getApplicationId(), null, ActivitiesLogger.getPriority(schedulerKey), appState, diagnostic, level, nodeId, schedulerKey == null ? null : Long.valueOf(schedulerKey.getAllocationRequestId()));
            }
        }

        public static void recordAppActivityWithAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, RMContainer updatedContainer, ActivityState activityState) {
            if (activitiesManager == null) {
                return;
            }
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            if (nodeId == null || nodeId == ActivitiesManager.EMPTY_NODE_ID) {
                nodeId = updatedContainer.getNodeId();
            }
            if (activitiesManager.shouldRecordThisNode(nodeId)) {
                Integer containerPriority = updatedContainer.getContainer().getPriority().getPriority();
                Long allocationRequestId = updatedContainer.getContainer().getAllocationRequestId();
                String requestName = ActivitiesLogger.getRequestName(containerPriority, allocationRequestId);
                APP.recordSchedulerActivityAtNodeLevel(activitiesManager, application, requestName, containerPriority, allocationRequestId, updatedContainer.getContainer().toString(), nodeId, activityState, ActivityDiagnosticConstant.EMPTY);
            }
            if (activitiesManager.shouldRecordThisApp(application.getApplicationId())) {
                activitiesManager.addSchedulingActivityForApp(application.getApplicationId(), updatedContainer.getContainerId(), updatedContainer.getContainer().getPriority().getPriority(), activityState, ActivityDiagnosticConstant.EMPTY, ActivityLevel.NODE, nodeId, updatedContainer.getContainer().getAllocationRequestId());
            }
        }

        private static void recordSchedulerActivityAtNodeLevel(ActivitiesManager activitiesManager, SchedulerApplicationAttempt app, String requestName, Integer priority, Long allocationRequestId, String containerId, NodeId nodeId, ActivityState state, String diagnostic) {
            activitiesManager.addSchedulingActivityForNode(nodeId, requestName, containerId, null, state, diagnostic, ActivityLevel.NODE, null);
            APP.recordSchedulerActivityAtRequestLevel(activitiesManager, app, requestName, priority, allocationRequestId, nodeId, state, ActivityDiagnosticConstant.EMPTY);
        }

        private static void recordSchedulerActivityAtRequestLevel(ActivitiesManager activitiesManager, SchedulerApplicationAttempt app, String requestName, Integer priority, Long allocationRequestId, NodeId nodeId, ActivityState state, String diagnostic) {
            activitiesManager.addSchedulingActivityForNode(nodeId, app.getApplicationId().toString(), requestName, priority, state, diagnostic, ActivityLevel.REQUEST, allocationRequestId);
            APP.recordSchedulerActivityAtAppLevel(activitiesManager, app, nodeId, state, ActivityDiagnosticConstant.EMPTY);
        }

        private static void recordSchedulerActivityAtAppLevel(ActivitiesManager activitiesManager, SchedulerApplicationAttempt app, NodeId nodeId, ActivityState state, String diagnostic) {
            activitiesManager.addSchedulingActivityForNode(nodeId, app.getQueueName(), app.getApplicationId().toString(), app.getPriority().getPriority(), state, diagnostic, ActivityLevel.APP, null);
        }

        public static void startAppAllocationRecording(ActivitiesManager activitiesManager, FiCaSchedulerNode node, long currentTime, SchedulerApplicationAttempt application) {
            if (activitiesManager == null) {
                return;
            }
            NodeId nodeId = ActivitiesLogger.getRecordingNodeId(activitiesManager, node);
            activitiesManager.startAppAllocationRecording(nodeId, currentTime, application);
        }

        public static void finishAllocatedAppAllocationRecording(ActivitiesManager activitiesManager, ApplicationId applicationId, ContainerId containerId, ActivityState containerState, String diagnostic) {
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisApp(applicationId)) {
                activitiesManager.finishAppAllocationRecording(applicationId, containerId, containerState, diagnostic);
            }
        }

        public static void finishSkippedAppAllocationRecording(ActivitiesManager activitiesManager, ApplicationId applicationId, ActivityState containerState, String diagnostic) {
            APP.finishAllocatedAppAllocationRecording(activitiesManager, applicationId, null, containerState, diagnostic);
        }
    }
}

