/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapacitySchedulerConfigValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CapacitySchedulerConfigValidator.class);

    private CapacitySchedulerConfigValidator() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateCSConfiguration(Configuration oldConf, Configuration newConf, RMContext rmContext) throws IOException {
        CapacityScheduler liveScheduler = (CapacityScheduler)rmContext.getScheduler();
        CapacityScheduler newCs = new CapacityScheduler();
        try {
            newCs.setConf(oldConf);
            newCs.setRMContext(rmContext);
            newCs.init(oldConf);
            newCs.addNodes(liveScheduler.getAllNodes());
            newCs.reinitialize(newConf, rmContext, true);
            boolean bl = true;
            return bl;
        }
        finally {
            newCs.stop();
        }
    }

    public static Set<String> validatePlacementRules(Collection<String> placementRuleStrs) throws IOException {
        HashSet<String> distinguishRuleSet = new HashSet<String>();
        for (String pls : placementRuleStrs) {
            if (distinguishRuleSet.add(pls)) continue;
            throw new IOException("Invalid PlacementRule inputs which contains duplicate rule strings");
        }
        return distinguishRuleSet;
    }

    public static void validateMemoryAllocation(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0, max should be no smaller than min.");
        }
    }

    public static void validateVCores(Configuration conf) {
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores <= 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min and max should be greater than 0, max should be no smaller than min.");
        }
    }

    private static boolean isDynamicQueue(CSQueue csQueue) {
        return ((AbstractCSQueue)csQueue).isDynamicQueue();
    }

    public static void validateQueueHierarchy(CSQueueStore queues, CSQueueStore newQueues, CapacitySchedulerConfiguration newConf) throws IOException {
        for (CSQueue oldQueue : queues.getQueues()) {
            if (AbstractAutoCreatedLeafQueue.class.isAssignableFrom(oldQueue.getClass())) continue;
            String queuePath = oldQueue.getQueuePath();
            CSQueue newQueue = newQueues.get(queuePath);
            String configPrefix = CapacitySchedulerConfiguration.getQueuePrefix(oldQueue.getQueuePath());
            String state = newConf.get(configPrefix + "state");
            QueueState newQueueState = null;
            if (state != null) {
                try {
                    newQueueState = QueueState.valueOf((String)state);
                }
                catch (Exception ex) {
                    LOG.warn("Not a valid queue state for queue " + oldQueue.getQueuePath());
                }
            }
            if (null == newQueue) {
                if (oldQueue.getState() == QueueState.STOPPED || newQueueState == QueueState.STOPPED) {
                    LOG.info("Deleting Queue " + queuePath + ", as it is not present in the modified capacity configuration xml");
                    continue;
                }
                if (CapacitySchedulerConfigValidator.isDynamicQueue(oldQueue)) continue;
                throw new IOException(oldQueue.getQueuePath() + " cannot be deleted from the capacity scheduler configuration, as the queue is not yet in stopped state. Current State : " + oldQueue.getState());
            }
            if (!oldQueue.getQueuePath().equals(newQueue.getQueuePath())) {
                throw new IOException(queuePath + " is moved from:" + oldQueue.getQueuePath() + " to:" + newQueue.getQueuePath() + " after refresh, which is not allowed.");
            }
            if (oldQueue instanceof ParentQueue && !(oldQueue instanceof ManagedParentQueue) && newQueue instanceof ManagedParentQueue) {
                throw new IOException("Can not convert parent queue: " + oldQueue.getQueuePath() + " to auto create enabled parent queue since it could have other pre-configured queues which is not supported");
            }
            if (oldQueue instanceof ManagedParentQueue && !(newQueue instanceof ManagedParentQueue)) {
                throw new IOException("Cannot convert auto create enabled parent queue: " + oldQueue.getQueuePath() + " to leaf queue. Please check  parent queue's configuration " + "auto-create-child-queue.enabled" + " is set to true");
            }
            if (oldQueue instanceof LeafQueue && newQueue instanceof ParentQueue) {
                if (oldQueue.getState() == QueueState.STOPPED || newQueueState == QueueState.STOPPED) {
                    LOG.info("Converting the leaf queue: " + oldQueue.getQueuePath() + " to parent queue.");
                    continue;
                }
                throw new IOException("Can not convert the leaf queue: " + oldQueue.getQueuePath() + " to parent queue since it is not yet in stopped state. Current State : " + oldQueue.getState());
            }
            if (!(oldQueue instanceof ParentQueue) || !(newQueue instanceof LeafQueue)) continue;
            LOG.info("Converting the parent queue: " + oldQueue.getQueuePath() + " to leaf queue.");
        }
    }
}

