/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
public class UsersManager
implements AbstractUsersManager {
    private static final Log LOG = LogFactory.getLog(UsersManager.class);
    private final LeafQueue lQueue;
    private final RMNodeLabelsManager labelManager;
    private final ResourceCalculator resourceCalculator;
    private final CapacitySchedulerContext scheduler;
    private Map<String, User> users = new ConcurrentHashMap<String, User>();
    private ResourceUsage totalResUsageForActiveUsers = new ResourceUsage();
    private ResourceUsage totalResUsageForNonActiveUsers = new ResourceUsage();
    private Set<String> activeUsersSet = new HashSet<String>();
    private Set<String> nonActiveUsersSet = new HashSet<String>();
    private UsageRatios qUsageRatios;
    private AtomicLong latestVersionOfUsersState = new AtomicLong(0L);
    private Map<String, Map<SchedulingMode, Long>> localVersionOfActiveUsersState = new HashMap<String, Map<SchedulingMode, Long>>();
    private Map<String, Map<SchedulingMode, Long>> localVersionOfAllUsersState = new HashMap<String, Map<SchedulingMode, Long>>();
    private volatile float userLimit;
    private volatile float userLimitFactor;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private final QueueMetrics metrics;
    private AtomicInteger activeUsers = new AtomicInteger(0);
    private AtomicInteger activeUsersWithOnlyPendingApps = new AtomicInteger(0);
    private Map<String, Set<ApplicationId>> usersApplications = new HashMap<String, Set<ApplicationId>>();
    Map<String, Map<SchedulingMode, Resource>> preComputedActiveUserLimit = new ConcurrentHashMap<String, Map<SchedulingMode, Resource>>();
    Map<String, Map<SchedulingMode, Resource>> preComputedAllUserLimit = new ConcurrentHashMap<String, Map<SchedulingMode, Resource>>();
    private float activeUsersTimesWeights = 0.0f;
    private float allUsersTimesWeights = 0.0f;

    public UsersManager(QueueMetrics metrics, LeafQueue lQueue, RMNodeLabelsManager labelManager, CapacitySchedulerContext scheduler, ResourceCalculator resourceCalculator) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.lQueue = lQueue;
        this.scheduler = scheduler;
        this.labelManager = labelManager;
        this.resourceCalculator = resourceCalculator;
        this.qUsageRatios = new UsageRatios();
        this.metrics = metrics;
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
    }

    public float getUserLimit() {
        return this.userLimit;
    }

    public void setUserLimit(float userLimit) {
        this.userLimit = userLimit;
    }

    public float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    public void setUserLimitFactor(float userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    @VisibleForTesting
    public float getUsageRatio(String label) {
        return this.qUsageRatios.getUsageRatio(label);
    }

    public void userLimitNeedsRecompute() {
        this.writeLock.lock();
        try {
            long value = this.latestVersionOfUsersState.incrementAndGet();
            if (value < 0L) {
                this.latestVersionOfUsersState.set(0L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public User getUser(String userName) {
        return this.users.get(userName);
    }

    public void removeUser(String userName) {
        this.writeLock.lock();
        try {
            this.users.remove(userName);
            this.activeUsersSet.remove(userName);
            this.nonActiveUsersSet.remove(userName);
            this.activeUsersTimesWeights = this.sumActiveUsersTimesWeights();
            this.allUsersTimesWeights = this.sumAllUsersTimesWeights();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserAndAddIfAbsent(String userName) {
        this.writeLock.lock();
        try {
            User u = this.getUser(userName);
            if (null == u) {
                u = new User(userName);
                this.addUser(userName, u);
                if (!this.nonActiveUsersSet.contains(userName)) {
                    this.nonActiveUsersSet.add(userName);
                }
            }
            User user = u;
            return user;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addUser(String userName, User user) {
        this.users.put(userName, user);
        user.setWeight(this.getUserWeightFromQueue(userName));
        this.allUsersTimesWeights = this.sumAllUsersTimesWeights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<UserInfo> getUsersInfo() {
        this.readLock.lock();
        try {
            ArrayList<UserInfo> usersToReturn = new ArrayList<UserInfo>();
            for (Map.Entry<String, User> entry : this.getUsers().entrySet()) {
                User user = entry.getValue();
                usersToReturn.add(new UserInfo(entry.getKey(), Resources.clone((Resource)user.getAllUsed()), user.getActiveApplications(), user.getPendingApplications(), Resources.clone((Resource)user.getConsumedAMResources()), Resources.clone((Resource)user.getUserResourceLimit()), user.getResourceUsage(), user.getWeight(), this.activeUsersSet.contains(user.userName)));
            }
            ArrayList<UserInfo> arrayList = usersToReturn;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private float getUserWeightFromQueue(String userName) {
        return this.lQueue.getUserWeights().getByUser(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getComputedResourceLimitForActiveUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        Map<SchedulingMode, Resource> userLimitPerSchedulingMode;
        this.writeLock.lock();
        try {
            userLimitPerSchedulingMode = this.preComputedActiveUserLimit.get(nodePartition);
            if (this.isRecomputeNeeded(schedulingMode, nodePartition, true)) {
                userLimitPerSchedulingMode = this.reComputeUserLimits(userName, nodePartition, clusterResource, schedulingMode, true);
                this.setLocalVersionOfUsersState(nodePartition, schedulingMode, true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        Resource userLimitResource = userLimitPerSchedulingMode.get((Object)schedulingMode);
        User user = this.getUser(userName);
        float weight = user == null ? 1.0f : user.getWeight();
        Resource userSpecificUserLimit = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)userLimitResource, (double)weight, (Resource)this.lQueue.getMinimumAllocation());
        if (user != null) {
            user.setUserResourceLimit(userSpecificUserLimit);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userLimit is fetched. userLimit=" + userLimitResource + ", userSpecificUserLimit=" + userSpecificUserLimit + ", schedulingMode=" + (Object)((Object)schedulingMode) + ", partition=" + nodePartition));
        }
        return userSpecificUserLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getComputedResourceLimitForAllUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        Map<SchedulingMode, Resource> userLimitPerSchedulingMode;
        this.writeLock.lock();
        try {
            userLimitPerSchedulingMode = this.preComputedAllUserLimit.get(nodePartition);
            if (this.isRecomputeNeeded(schedulingMode, nodePartition, false)) {
                userLimitPerSchedulingMode = this.reComputeUserLimits(userName, nodePartition, clusterResource, schedulingMode, false);
                this.setLocalVersionOfUsersState(nodePartition, schedulingMode, false);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        Resource userLimitResource = userLimitPerSchedulingMode.get((Object)schedulingMode);
        User user = this.getUser(userName);
        float weight = user == null ? 1.0f : user.getWeight();
        Resource userSpecificUserLimit = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)userLimitResource, (double)weight, (Resource)this.lQueue.getMinimumAllocation());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userLimit is fetched. userLimit=" + userLimitResource + ", userSpecificUserLimit=" + userSpecificUserLimit + ", schedulingMode=" + (Object)((Object)schedulingMode) + ", partition=" + nodePartition));
        }
        return userSpecificUserLimit;
    }

    private boolean isRecomputeNeeded(SchedulingMode schedulingMode, String nodePartition, boolean isActive) {
        return this.getLocalVersionOfUsersState(nodePartition, schedulingMode, isActive) != this.latestVersionOfUsersState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalVersionOfUsersState(String nodePartition, SchedulingMode schedulingMode, boolean isActive) {
        this.writeLock.lock();
        try {
            Map<String, Map<SchedulingMode, Long>> localVersionOfUsersState = isActive ? this.localVersionOfActiveUsersState : this.localVersionOfAllUsersState;
            Map<SchedulingMode, Long> localVersion = localVersionOfUsersState.get(nodePartition);
            if (null == localVersion) {
                localVersion = new HashMap<SchedulingMode, Long>();
                localVersionOfUsersState.put(nodePartition, localVersion);
            }
            localVersion.put(schedulingMode, this.latestVersionOfUsersState.get());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLocalVersionOfUsersState(String nodePartition, SchedulingMode schedulingMode, boolean isActive) {
        this.readLock.lock();
        try {
            Map<String, Map<SchedulingMode, Long>> localVersionOfUsersState;
            Map<String, Map<SchedulingMode, Long>> map = localVersionOfUsersState = isActive ? this.localVersionOfActiveUsersState : this.localVersionOfAllUsersState;
            if (!localVersionOfUsersState.containsKey(nodePartition)) {
                long l = -1L;
                return l;
            }
            Map<SchedulingMode, Long> localVersion = localVersionOfUsersState.get(nodePartition);
            if (!localVersion.containsKey((Object)schedulingMode)) {
                long l = -1L;
                return l;
            }
            long l = localVersion.get((Object)schedulingMode);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<SchedulingMode, Resource> reComputeUserLimits(String userName, String nodePartition, Resource clusterResource, SchedulingMode schedulingMode, boolean activeMode) {
        Map<String, Map<SchedulingMode, Resource>> computedMap = null;
        computedMap = activeMode ? this.preComputedActiveUserLimit : this.preComputedAllUserLimit;
        Map<SchedulingMode, Resource> userLimitPerSchedulingMode = computedMap.get(nodePartition);
        if (userLimitPerSchedulingMode == null) {
            userLimitPerSchedulingMode = new ConcurrentHashMap<SchedulingMode, Resource>();
            computedMap.put(nodePartition, userLimitPerSchedulingMode);
        }
        Resource computedUserLimit = this.computeUserLimit(userName, clusterResource, nodePartition, schedulingMode, activeMode);
        userLimitPerSchedulingMode.put(schedulingMode, computedUserLimit);
        this.computeNumActiveUsersWithOnlyPendingApps();
        return userLimitPerSchedulingMode;
    }

    private void computeNumActiveUsersWithOnlyPendingApps() {
        int numPendingUsers = 0;
        for (User user : this.users.values()) {
            if (user.getPendingApplications() <= 0 || user.getActiveApplications() > 0) continue;
            ++numPendingUsers;
        }
        this.activeUsersWithOnlyPendingApps = new AtomicInteger(numPendingUsers);
    }

    @VisibleForTesting
    Resource computeUserLimit(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode, boolean activeUser) {
        Resource queueCapacity;
        Resource partitionResource = this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        Resource originalCapacity = queueCapacity = this.lQueue.getEffectiveCapacity(nodePartition);
        Resource required = this.lQueue.getMinimumAllocation();
        queueCapacity = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)queueCapacity, (Resource)required);
        Resource consumed = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (double)this.getUsageRatio(nodePartition), (Resource)this.lQueue.getMinimumAllocation());
        Resource currentCapacity = Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)consumed, (Resource)queueCapacity) ? queueCapacity : Resources.add((Resource)consumed, (Resource)required);
        float usersSummedByWeight = this.activeUsersTimesWeights;
        Resource resourceUsed = Resources.add((Resource)this.totalResUsageForActiveUsers.getUsed(nodePartition), (Resource)required);
        if (!activeUser) {
            resourceUsed = currentCapacity;
            usersSummedByWeight = this.allUsersTimesWeights;
        }
        Resource userLimitResource = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)resourceUsed, (float)usersSummedByWeight), (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)Resources.multiplyAndRoundDown((Resource)currentCapacity, (double)this.getUserLimit()), (int)100));
        Resource maxUserLimit = Resources.none();
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY) {
            maxUserLimit = this.getUserLimitFactor() == -1.0f || originalCapacity.equals((Object)Resources.none()) ? this.lQueue.getEffectiveMaxCapacityDown(nodePartition, this.lQueue.getMinimumAllocation()) : Resources.multiplyAndRoundDown((Resource)queueCapacity, (double)this.getUserLimitFactor());
        } else if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            maxUserLimit = partitionResource;
        }
        userLimitResource = Resources.roundUp((ResourceCalculator)this.resourceCalculator, (Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)userLimitResource, (Resource)maxUserLimit), (Resource)this.lQueue.getMinimumAllocation());
        if (LOG.isDebugEnabled()) {
            float weight = this.lQueue.getUserWeights().getByUser(userName);
            LOG.debug((Object)("User limit computation for " + userName + ",  in queue: " + this.lQueue.getQueuePath() + ",  userLimitPercent=" + this.lQueue.getUserLimit() + ",  userLimitFactor=" + this.lQueue.getUserLimitFactor() + ",  required=" + required + ",  consumed=" + consumed + ",  user-limit-resource=" + userLimitResource + ",  queueCapacity=" + queueCapacity + ",  qconsumed=" + this.lQueue.getQueueResourceUsage().getUsed() + ",  currentCapacity=" + currentCapacity + ",  activeUsers=" + usersSummedByWeight + ",  clusterCapacity=" + clusterResource + ",  resourceByLabel=" + partitionResource + ",  usageratio=" + this.getUsageRatio(nodePartition) + ",  Partition=" + nodePartition + ",  resourceUsed=" + resourceUsed + ",  maxUserLimit=" + maxUserLimit + ",  userWeight=" + weight));
        }
        return userLimitResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUsageRatio(String partition, Resource clusterResource) {
        this.writeLock.lock();
        try {
            Resource resourceByLabel = this.labelManager.getResourceByLabel(partition, clusterResource);
            float consumed = 0.0f;
            for (Map.Entry<String, User> entry : this.getUsers().entrySet()) {
                User user = entry.getValue();
                consumed += user.setAndUpdateUsageRatio(this.resourceCalculator, resourceByLabel, partition);
            }
            this.qUsageRatios.setUsageRatio(partition, consumed);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void incQueueUsageRatio(String nodePartition, float delta) {
        this.qUsageRatios.incUsageRatio(nodePartition, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateApplication(String user, ApplicationId applicationId) {
        this.writeLock.lock();
        try {
            User userDesc = this.getUser(user);
            if (userDesc != null && userDesc.getActiveApplications() <= 0) {
                return;
            }
            Set<ApplicationId> userApps = this.usersApplications.get(user);
            if (userApps == null) {
                userApps = new HashSet<ApplicationId>();
                this.usersApplications.put(user, userApps);
                this.activeUsers.incrementAndGet();
                this.metrics.incrActiveUsers();
                this.userLimitNeedsRecompute();
                this.updateActiveUsersResourceUsage(user);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User " + user + " added to activeUsers, currently: " + this.activeUsers));
                }
            }
            if (userApps.add(applicationId)) {
                this.metrics.activateApp(user);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateApplication(String user, ApplicationId applicationId) {
        this.writeLock.lock();
        try {
            Set<ApplicationId> userApps = this.usersApplications.get(user);
            if (userApps != null) {
                if (userApps.remove(applicationId)) {
                    this.metrics.deactivateApp(user);
                }
                if (userApps.isEmpty()) {
                    this.usersApplications.remove(user);
                    this.activeUsers.decrementAndGet();
                    this.metrics.decrActiveUsers();
                    this.userLimitNeedsRecompute();
                    this.updateNonActiveUsersResourceUsage(user);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("User " + user + " removed from activeUsers, currently: " + this.activeUsers));
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getNumActiveUsers() {
        return this.activeUsers.get() + this.activeUsersWithOnlyPendingApps.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float sumActiveUsersTimesWeights() {
        float count = 0.0f;
        this.readLock.lock();
        try {
            for (String u : this.activeUsersSet) {
                count += this.getUser(u).getWeight();
            }
            float f = count;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float sumAllUsersTimesWeights() {
        float count = 0.0f;
        this.readLock.lock();
        try {
            for (String u : this.users.keySet()) {
                count += this.getUser(u).getWeight();
            }
            float f = count;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveUsersResourceUsage(String userName) {
        this.writeLock.lock();
        try {
            User user = this.getUserAndAddIfAbsent(userName);
            ResourceUsage resourceUsage = user.getResourceUsage();
            if (this.nonActiveUsersSet.contains(userName)) {
                this.nonActiveUsersSet.remove(userName);
                this.activeUsersSet.add(userName);
                this.activeUsersTimesWeights = this.sumActiveUsersTimesWeights();
                for (String partition : resourceUsage.getExistingNodeLabels()) {
                    this.totalResUsageForNonActiveUsers.decUsed(partition, resourceUsage.getUsed(partition));
                    this.totalResUsageForActiveUsers.incUsed(partition, resourceUsage.getUsed(partition));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User '" + userName + "' has become active. Hence move user to active list.Active users size = " + this.activeUsersSet.size() + "Non-active users size = " + this.nonActiveUsersSet.size() + "Total Resource usage for active users=" + this.totalResUsageForActiveUsers.getAllUsed() + ".Total Resource usage for non-active users=" + this.totalResUsageForNonActiveUsers.getAllUsed()));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNonActiveUsersResourceUsage(String userName) {
        this.writeLock.lock();
        try {
            User user = this.getUser(userName);
            if (user == null) {
                return;
            }
            ResourceUsage resourceUsage = user.getResourceUsage();
            if (this.activeUsersSet.contains(userName)) {
                this.activeUsersSet.remove(userName);
                this.nonActiveUsersSet.add(userName);
                this.activeUsersTimesWeights = this.sumActiveUsersTimesWeights();
                for (String partition : resourceUsage.getExistingNodeLabels()) {
                    this.totalResUsageForActiveUsers.decUsed(partition, resourceUsage.getUsed(partition));
                    this.totalResUsageForNonActiveUsers.incUsed(partition, resourceUsage.getUsed(partition));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("User '" + userName + "' has become non-active.Hence move user to non-active list.Active users size = " + this.activeUsersSet.size() + "Non-active users size = " + this.nonActiveUsersSet.size() + "Total Resource usage for active users=" + this.totalResUsageForActiveUsers.getAllUsed() + ".Total Resource usage for non-active users=" + this.totalResUsageForNonActiveUsers.getAllUsed()));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ResourceUsage getTotalResourceUsagePerUser(String userName) {
        if (this.nonActiveUsersSet.contains(userName)) {
            return this.totalResUsageForNonActiveUsers;
        }
        if (this.activeUsersSet.contains(userName)) {
            return this.totalResUsageForActiveUsers;
        }
        LOG.warn((Object)("User '" + userName + "' is not present in active/non-active. This is highly unlikely.We can consider this user in non-active list in this case."));
        return this.totalResUsageForNonActiveUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User updateUserResourceUsage(String userName, Resource resource, String nodePartition, boolean isAllocate) {
        this.writeLock.lock();
        try {
            User user = this.getUserAndAddIfAbsent(userName);
            this.updateResourceUsagePerUser(user, resource, nodePartition, isAllocate);
            this.userLimitNeedsRecompute();
            Resource resourceByLabel = this.labelManager.getResourceByLabel(nodePartition, this.scheduler.getClusterResource());
            this.incQueueUsageRatio(nodePartition, user.updateUsageRatio(this.resourceCalculator, resourceByLabel, nodePartition));
            User user2 = user;
            return user2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateResourceUsagePerUser(User user, Resource resource, String nodePartition, boolean isAllocate) {
        ResourceUsage totalResourceUsageForUsers = this.getTotalResourceUsagePerUser(user.userName);
        if (isAllocate) {
            user.getResourceUsage().incUsed(nodePartition, resource);
            totalResourceUsageForUsers.incUsed(nodePartition, resource);
        } else {
            user.getResourceUsage().decUsed(nodePartition, resource);
            totalResourceUsageForUsers.decUsed(nodePartition, resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User resource is updated.Total Resource usage for active users=" + this.totalResUsageForActiveUsers.getAllUsed() + ".Total Resource usage for non-active users=" + this.totalResUsageForNonActiveUsers.getAllUsed()));
        }
    }

    public void updateUserWeights() {
        this.writeLock.lock();
        try {
            for (Map.Entry<String, User> ue : this.users.entrySet()) {
                ue.getValue().setWeight(this.getUserWeightFromQueue(ue.getKey()));
            }
            this.activeUsersTimesWeights = this.sumActiveUsersTimesWeights();
            this.allUsersTimesWeights = this.sumAllUsersTimesWeights();
            this.userLimitNeedsRecompute();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public int getNumActiveUsersWithOnlyPendingApps() {
        return this.activeUsersWithOnlyPendingApps.get();
    }

    @VisibleForTesting
    void setUsageRatio(String label, float usage) {
        this.qUsageRatios.usageRatios.put(label, Float.valueOf(usage));
    }

    @VisibleForTesting
    public static class User {
        ResourceUsage userResourceUsage = new ResourceUsage();
        String userName = null;
        volatile Resource userResourceLimit = Resource.newInstance((int)0, (int)0);
        private volatile AtomicInteger pendingApplications = new AtomicInteger(0);
        private volatile AtomicInteger activeApplications = new AtomicInteger(0);
        private UsageRatios userUsageRatios = new UsageRatios();
        private ReentrantReadWriteLock.WriteLock writeLock;
        private float weight;

        public User(String name) {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.writeLock = lock.writeLock();
            this.userName = name;
        }

        public ResourceUsage getResourceUsage() {
            return this.userResourceUsage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float setAndUpdateUsageRatio(ResourceCalculator resourceCalculator, Resource resource, String nodePartition) {
            this.writeLock.lock();
            try {
                this.userUsageRatios.setUsageRatio(nodePartition, 0.0f);
                float f = this.updateUsageRatio(resourceCalculator, resource, nodePartition);
                return f;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float updateUsageRatio(ResourceCalculator resourceCalculator, Resource resource, String nodePartition) {
            this.writeLock.lock();
            try {
                float newRatio = Resources.ratio((ResourceCalculator)resourceCalculator, (Resource)this.getUsed(nodePartition), (Resource)resource);
                float delta = newRatio - this.userUsageRatios.getUsageRatio(nodePartition);
                this.userUsageRatios.setUsageRatio(nodePartition, newRatio);
                float f = delta;
                return f;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public Resource getUsed() {
            return this.userResourceUsage.getUsed();
        }

        public Resource getAllUsed() {
            return this.userResourceUsage.getAllUsed();
        }

        public Resource getUsed(String label) {
            return this.userResourceUsage.getUsed(label);
        }

        public int getPendingApplications() {
            return this.pendingApplications.get();
        }

        public int getActiveApplications() {
            return this.activeApplications.get();
        }

        public Resource getConsumedAMResources() {
            return this.userResourceUsage.getAMUsed();
        }

        public Resource getConsumedAMResources(String label) {
            return this.userResourceUsage.getAMUsed(label);
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public void submitApplication() {
            this.pendingApplications.incrementAndGet();
        }

        public void activateApplication() {
            this.pendingApplications.decrementAndGet();
            this.activeApplications.incrementAndGet();
        }

        public void finishApplication(boolean wasActive) {
            if (wasActive) {
                this.activeApplications.decrementAndGet();
            } else {
                this.pendingApplications.decrementAndGet();
            }
        }

        public Resource getUserResourceLimit() {
            return this.userResourceLimit;
        }

        public void setUserResourceLimit(Resource userResourceLimit) {
            this.userResourceLimit = userResourceLimit;
        }

        public String getUserName() {
            return this.userName;
        }

        @VisibleForTesting
        public void setResourceUsage(ResourceUsage resourceUsage) {
            this.userResourceUsage = resourceUsage;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float weight) {
            this.weight = weight;
        }
    }

    private static class UsageRatios {
        private Map<String, Float> usageRatios;
        private ReentrantReadWriteLock.ReadLock readLock;
        private ReentrantReadWriteLock.WriteLock writeLock;

        public UsageRatios() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
            this.usageRatios = new HashMap<String, Float>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incUsageRatio(String label, float delta) {
            this.writeLock.lock();
            try {
                float usage = 0.0f;
                if (this.usageRatios.containsKey(label)) {
                    usage = this.usageRatios.get(label).floatValue();
                }
                this.usageRatios.put(label, Float.valueOf(usage += delta));
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getUsageRatio(String label) {
            this.readLock.lock();
            try {
                Float f = this.usageRatios.get(label);
                if (null == f) {
                    float f2 = 0.0f;
                    return f2;
                }
                float f3 = f.floatValue();
                return f3;
            }
            finally {
                this.readLock.unlock();
            }
        }

        private void setUsageRatio(String label, float ratio) {
            this.writeLock.lock();
            try {
                this.usageRatios.put(label, Float.valueOf(ratio));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

