/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationHelper;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;

public class MappingRuleValidationContextImpl
implements MappingRuleValidationContext {
    private Set<String> knownVariables = Sets.newHashSet();
    private Set<String> immutableVariables = Sets.newHashSet();
    private final CapacitySchedulerQueueManager queueManager;

    public MappingRuleValidationContextImpl(CapacitySchedulerQueueManager qm) {
        this.queueManager = qm;
    }

    private boolean validateStaticQueuePath(QueuePath path) throws YarnException {
        String normalizedPath = MappingRuleValidationHelper.normalizeQueuePathRoot(this.queueManager, path.getFullPath());
        MappingRuleValidationHelper.ValidationResult validity = MappingRuleValidationHelper.validateQueuePathAutoCreation(this.queueManager, normalizedPath);
        switch (validity) {
            case AMBIGUOUS_PARENT: {
                throw new YarnException("Target queue path '" + path + "' contains an ambiguous parent queue '" + path.getParent() + "' reference.");
            }
            case AMBIGUOUS_QUEUE: {
                throw new YarnException("Target queue is an ambiguous leaf queue '" + path.getFullPath() + "'.");
            }
            case EMPTY_PATH: {
                throw new YarnException("Mapping rule did not specify a target queue.");
            }
            case NO_PARENT_PROVIDED: {
                throw new YarnException("Target queue does not exist and has no parent defined '" + path.getFullPath() + "'.");
            }
            case NO_DYNAMIC_PARENT: {
                throw new YarnException("Mapping rule specified a parent queue '" + path.getParent() + "', but it is not a dynamic parent queue, and no queue exists with name '" + path.getLeafName() + "' under it.");
            }
            case QUEUE_EXISTS: {
                CSQueue queue = this.queueManager.getQueue(normalizedPath);
                if (queue instanceof AbstractLeafQueue) break;
                throw new YarnException("Target queue '" + path.getFullPath() + "' but it's not a leaf queue.");
            }
            case CREATABLE: {
                break;
            }
            default: {
                throw new YarnException("Unknown queue path validation result. '" + (Object)((Object)validity) + "'.");
            }
        }
        return true;
    }

    private boolean validateDynamicQueuePath(QueuePath path) throws YarnException {
        String normalizedStaticPartParent;
        String nextPart;
        ArrayList parts = new ArrayList();
        Collections.addAll(parts, path.getFullPath().split("\\."));
        Iterator pointer = parts.iterator();
        if (!pointer.hasNext()) {
            throw new YarnException("Empty queue path provided '" + path + "'");
        }
        StringBuilder staticPartBuffer = new StringBuilder((String)pointer.next());
        String staticPartParent = null;
        if (!this.isPathStatic(staticPartBuffer.toString())) {
            return true;
        }
        while (pointer.hasNext() && this.isPathStatic(nextPart = (String)pointer.next())) {
            staticPartParent = staticPartBuffer.toString();
            staticPartBuffer.append(".").append(nextPart);
        }
        String staticPart = staticPartBuffer.toString();
        String normalizedStaticPart = MappingRuleValidationHelper.normalizeQueuePathRoot(this.queueManager, staticPart);
        CSQueue queue = this.queueManager.getQueue(normalizedStaticPart);
        if (queue != null) {
            if (queue instanceof AbstractLeafQueue) {
                throw new YarnException("Queue path '" + path + "' is invalid because '" + normalizedStaticPart + "' is a leaf queue, which can have no other queues under it.");
            }
            return true;
        }
        if (staticPartParent != null && this.isDynamicParent(queue = this.queueManager.getQueue(normalizedStaticPartParent = MappingRuleValidationHelper.normalizeQueuePathRoot(this.queueManager, staticPartParent)))) {
            return true;
        }
        throw new YarnException("No eligible parent found on path '" + path + "'.");
    }

    private boolean isDynamicParent(CSQueue queue) {
        if (queue == null) {
            return false;
        }
        if (queue instanceof ManagedParentQueue) {
            return true;
        }
        if (queue instanceof ParentQueue) {
            return ((ParentQueue)queue).isEligibleForAutoQueueCreation();
        }
        return false;
    }

    @Override
    public boolean validateQueuePath(String queuePath) throws YarnException {
        if (queuePath == null || queuePath.isEmpty()) {
            throw new YarnException("Queue path is empty.");
        }
        QueuePath path = new QueuePath(queuePath);
        if (this.isPathStatic(queuePath)) {
            return this.validateStaticQueuePath(path);
        }
        return this.validateDynamicQueuePath(path);
    }

    @Override
    public boolean isPathStatic(String queuePath) throws YarnException {
        String[] parts = queuePath.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].isEmpty()) {
                throw new YarnException("Path segment cannot be empty '" + queuePath + "'.");
            }
            if (this.isPathPartStatic(parts[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isPathPartStatic(String pathPart) {
        return !this.knownVariables.contains(pathPart);
    }

    @Override
    public void addVariable(String variable) throws YarnException {
        if (this.immutableVariables.contains(variable)) {
            throw new YarnException("Variable '" + variable + "' is immutable cannot add to the modified variable list.");
        }
        this.knownVariables.add(variable);
    }

    @Override
    public void addImmutableVariable(String variable) throws YarnException {
        if (this.knownVariables.contains(variable) && !this.immutableVariables.contains(variable)) {
            throw new YarnException("Variable '" + variable + "' already added as a mutable variable cannot set it to immutable.");
        }
        this.knownVariables.add(variable);
        this.immutableVariables.add(variable);
    }

    @Override
    public Set<String> getVariables() {
        return ImmutableSet.copyOf(this.knownVariables);
    }
}

