/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;

public class Allocation {
    final List<Container> containers;
    final Set<ContainerId> strictContainers;
    final Set<ContainerId> fungibleContainers;
    final List<ResourceRequest> fungibleResources;
    final List<NMToken> nmTokens;
    final List<Container> increasedContainers;
    final List<Container> decreasedContainers;
    final List<Container> promotedContainers;
    final List<Container> demotedContainers;
    private final List<Container> previousAttemptContainers;
    private Resource resourceLimit;

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers, Set<ContainerId> fungibleContainers, List<ResourceRequest> fungibleResources) {
        this(containers, resourceLimit, strictContainers, fungibleContainers, fungibleResources, null);
    }

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers, Set<ContainerId> fungibleContainers, List<ResourceRequest> fungibleResources, List<NMToken> nmTokens) {
        this(containers, resourceLimit, strictContainers, fungibleContainers, fungibleResources, nmTokens, null, null, null, null, null);
    }

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers, Set<ContainerId> fungibleContainers, List<ResourceRequest> fungibleResources, List<NMToken> nmTokens, List<Container> increasedContainers, List<Container> decreasedContainer) {
        this(containers, resourceLimit, strictContainers, fungibleContainers, fungibleResources, nmTokens, increasedContainers, decreasedContainer, null, null, null);
    }

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers, Set<ContainerId> fungibleContainers, List<ResourceRequest> fungibleResources, List<NMToken> nmTokens, List<Container> increasedContainers, List<Container> decreasedContainer, List<Container> promotedContainers, List<Container> demotedContainer, List<Container> previousAttemptContainers) {
        this.containers = containers;
        this.resourceLimit = resourceLimit;
        this.strictContainers = strictContainers;
        this.fungibleContainers = fungibleContainers;
        this.fungibleResources = fungibleResources;
        this.nmTokens = nmTokens;
        this.increasedContainers = increasedContainers;
        this.decreasedContainers = decreasedContainer;
        this.promotedContainers = promotedContainers;
        this.demotedContainers = demotedContainer;
        this.previousAttemptContainers = previousAttemptContainers;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public Resource getResourceLimit() {
        return this.resourceLimit;
    }

    public Set<ContainerId> getStrictContainerPreemptions() {
        return this.strictContainers;
    }

    public Set<ContainerId> getContainerPreemptions() {
        return this.fungibleContainers;
    }

    public List<ResourceRequest> getResourcePreemptions() {
        return this.fungibleResources;
    }

    public List<NMToken> getNMTokens() {
        return this.nmTokens;
    }

    public List<Container> getIncreasedContainers() {
        return this.increasedContainers;
    }

    public List<Container> getDecreasedContainers() {
        return this.decreasedContainers;
    }

    public List<Container> getPromotedContainers() {
        return this.promotedContainers;
    }

    public List<Container> getDemotedContainers() {
        return this.demotedContainers;
    }

    public List<Container> getPreviousAttemptContainers() {
        return this.previousAttemptContainers;
    }

    @VisibleForTesting
    public void setResourceLimit(Resource resource) {
        this.resourceLimit = resource;
    }

    public String toString() {
        return "Allocation{containers=" + this.containers + ", strictContainers=" + this.strictContainers + ", fungibleContainers=" + this.fungibleContainers + ", fungibleResources=" + this.fungibleResources + ", nmTokens=" + this.nmTokens + ", increasedContainers=" + this.increasedContainers + ", decreasedContainers=" + this.decreasedContainers + ", promotedContainers=" + this.promotedContainers + ", demotedContainers=" + this.demotedContainers + ", previousAttemptContainers=" + this.previousAttemptContainers + ", resourceLimit=" + this.resourceLimit + '}';
    }
}

