/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ApplicationPlacementAllocatorFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.DiagnosticsCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PendingAskUpdateResult;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SingleConstraintAppPlacementAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Log LOG = LogFactory.getLog(AppSchedulingInfo.class);
    private final ApplicationId applicationId;
    private final ApplicationAttemptId applicationAttemptId;
    private final AtomicLong containerIdCounter;
    private final String user;
    private Queue queue;
    private AbstractUsersManager abstractUsersManager;
    private volatile boolean pending = true;
    private ResourceUsage appResourceUsage;
    private AtomicBoolean userBlacklistChanged = new AtomicBoolean(false);
    private final Set<String> placesBlacklistedBySystem = new HashSet<String>();
    private Set<String> placesBlacklistedByApp = new HashSet<String>();
    private Set<String> requestedPartitions = new HashSet<String>();
    private final ConcurrentSkipListSet<SchedulerRequestKey> schedulerKeys = new ConcurrentSkipListSet();
    private final Map<SchedulerRequestKey, AppPlacementAllocator<SchedulerNode>> schedulerKeyToAppPlacementAllocator = new ConcurrentHashMap<SchedulerRequestKey, AppPlacementAllocator<SchedulerNode>>();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public final ContainerUpdateContext updateContext;
    private final Map<String, String> applicationSchedulingEnvs = new HashMap<String, String>();
    private final RMContext rmContext;

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, long epoch, ResourceUsage appResourceUsage, Map<String, String> applicationSchedulingEnvs, RMContext rmContext) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.user = user;
        this.abstractUsersManager = abstractUsersManager;
        this.containerIdCounter = new AtomicLong(epoch << 40);
        this.appResourceUsage = appResourceUsage;
        this.applicationSchedulingEnvs.putAll(applicationSchedulingEnvs);
        this.rmContext = rmContext;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.updateContext = new ContainerUpdateContext(this);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public long getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public String getQueueName() {
        this.readLock.lock();
        try {
            String string = this.queue.getQueueName();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isPending() {
        return this.pending;
    }

    public Set<String> getRequestedPartitions() {
        return this.requestedPartitions;
    }

    private void clearRequests() {
        this.schedulerKeys.clear();
        this.schedulerKeyToAppPlacementAllocator.clear();
        LOG.info((Object)("Application " + this.applicationId + " requests cleared"));
    }

    public ContainerUpdateContext getUpdateContext() {
        return this.updateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateResourceRequests(List<ResourceRequest> resourceRequests, boolean recoverPreemptedRequestForAContainer) {
        boolean offswitchResourcesUpdated;
        this.writeLock.lock();
        try {
            offswitchResourcesUpdated = this.internalAddResourceRequests(recoverPreemptedRequestForAContainer, resourceRequests);
        }
        finally {
            this.writeLock.unlock();
        }
        return offswitchResourcesUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateResourceRequests(Map<SchedulerRequestKey, Map<String, ResourceRequest>> dedupRequests, boolean recoverPreemptedRequestForAContainer) {
        boolean offswitchResourcesUpdated;
        this.writeLock.lock();
        try {
            offswitchResourcesUpdated = this.internalAddResourceRequests(recoverPreemptedRequestForAContainer, dedupRequests);
        }
        finally {
            this.writeLock.unlock();
        }
        return offswitchResourcesUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSchedulingRequests(List<SchedulingRequest> schedulingRequests, boolean recoverPreemptedRequestForAContainer) {
        boolean offswitchResourcesUpdated;
        this.writeLock.lock();
        try {
            offswitchResourcesUpdated = this.addSchedulingRequests(recoverPreemptedRequestForAContainer, schedulingRequests);
        }
        finally {
            this.writeLock.unlock();
        }
        return offswitchResourcesUpdated;
    }

    public void removeAppPlacement(SchedulerRequestKey schedulerRequestKey) {
        this.schedulerKeyToAppPlacementAllocator.remove(schedulerRequestKey);
    }

    private boolean addSchedulingRequests(boolean recoverPreemptedRequestForAContainer, List<SchedulingRequest> schedulingRequests) {
        boolean requireUpdatePendingResource = false;
        for (SchedulingRequest request : schedulingRequests) {
            SchedulerRequestKey schedulerRequestKey = SchedulerRequestKey.create((SchedulingRequest)request);
            AppPlacementAllocator<SchedulerNode> appPlacementAllocator = this.getAndAddAppPlacementAllocatorIfNotExist(schedulerRequestKey, SingleConstraintAppPlacementAllocator.class.getCanonicalName());
            PendingAskUpdateResult pendingAmountChanges = appPlacementAllocator.updatePendingAsk(schedulerRequestKey, request, recoverPreemptedRequestForAContainer);
            if (null == pendingAmountChanges) continue;
            this.updatePendingResources(pendingAmountChanges, schedulerRequestKey, this.queue.getMetrics());
            requireUpdatePendingResource = true;
        }
        return requireUpdatePendingResource;
    }

    private AppPlacementAllocator<SchedulerNode> getAndAddAppPlacementAllocatorIfNotExist(SchedulerRequestKey schedulerRequestKey, String placementTypeClass) {
        AppPlacementAllocator<SchedulerNode> appPlacementAllocator = this.schedulerKeyToAppPlacementAllocator.get(schedulerRequestKey);
        if (appPlacementAllocator == null) {
            appPlacementAllocator = ApplicationPlacementAllocatorFactory.getAppPlacementAllocator(placementTypeClass, this, schedulerRequestKey, this.rmContext);
            this.schedulerKeyToAppPlacementAllocator.put(schedulerRequestKey, appPlacementAllocator);
        }
        return appPlacementAllocator;
    }

    private boolean internalAddResourceRequests(boolean recoverPreemptedRequestForAContainer, Map<SchedulerRequestKey, Map<String, ResourceRequest>> dedupRequests) {
        boolean offswitchResourcesUpdated = false;
        for (Map.Entry<SchedulerRequestKey, Map<String, ResourceRequest>> entry : dedupRequests.entrySet()) {
            SchedulerRequestKey schedulerRequestKey = entry.getKey();
            AppPlacementAllocator<SchedulerNode> appPlacementAllocator = this.getAndAddAppPlacementAllocatorIfNotExist(schedulerRequestKey, this.applicationSchedulingEnvs.get("APPLICATION_PLACEMENT_TYPE_CLASS"));
            PendingAskUpdateResult pendingAmountChanges = appPlacementAllocator.updatePendingAsk(entry.getValue().values(), recoverPreemptedRequestForAContainer);
            if (null == pendingAmountChanges) continue;
            this.updatePendingResources(pendingAmountChanges, schedulerRequestKey, this.queue.getMetrics());
            offswitchResourcesUpdated = true;
        }
        return offswitchResourcesUpdated;
    }

    private boolean internalAddResourceRequests(boolean recoverPreemptedRequestForAContainer, List<ResourceRequest> resourceRequests) {
        if (null == resourceRequests || resourceRequests.isEmpty()) {
            return false;
        }
        HashMap<SchedulerRequestKey, Map<String, ResourceRequest>> dedupRequests = new HashMap<SchedulerRequestKey, Map<String, ResourceRequest>>();
        for (ResourceRequest request : resourceRequests) {
            SchedulerRequestKey schedulerKey = SchedulerRequestKey.create((ResourceRequest)request);
            if (!dedupRequests.containsKey(schedulerKey)) {
                dedupRequests.put(schedulerKey, new HashMap());
            }
            ((Map)dedupRequests.get(schedulerKey)).put(request.getResourceName(), request);
        }
        return this.internalAddResourceRequests(recoverPreemptedRequestForAContainer, dedupRequests);
    }

    private void updatePendingResources(PendingAskUpdateResult updateResult, SchedulerRequestKey schedulerKey, QueueMetrics metrics) {
        int lastRequestContainers;
        PendingAsk lastPendingAsk = updateResult.getLastPendingAsk();
        PendingAsk newPendingAsk = updateResult.getNewPendingAsk();
        String lastNodePartition = updateResult.getLastNodePartition();
        String newNodePartition = updateResult.getNewNodePartition();
        int n = lastRequestContainers = lastPendingAsk != null ? lastPendingAsk.getCount() : 0;
        if (newPendingAsk.getCount() <= 0) {
            if (lastRequestContainers >= 0) {
                this.schedulerKeys.remove(schedulerKey);
                this.schedulerKeyToAppPlacementAllocator.remove(schedulerKey);
            }
            LOG.info((Object)("checking for deactivate of application :" + this.applicationId));
            this.checkForDeactivation();
        } else if (lastRequestContainers <= 0) {
            this.schedulerKeys.add(schedulerKey);
            this.abstractUsersManager.activateApplication(this.user, this.applicationId);
        }
        if (lastPendingAsk != null) {
            metrics.decrPendingResources(lastNodePartition, this.user, lastPendingAsk.getCount(), lastPendingAsk.getPerAllocationResource());
            Resource decreasedResource = Resources.multiply((Resource)lastPendingAsk.getPerAllocationResource(), (double)lastRequestContainers);
            this.queue.decPendingResource(lastNodePartition, decreasedResource);
            this.appResourceUsage.decPending(lastNodePartition, decreasedResource);
        }
        metrics.incrPendingResources(newNodePartition, this.user, newPendingAsk.getCount(), newPendingAsk.getPerAllocationResource());
        Resource increasedResource = Resources.multiply((Resource)newPendingAsk.getPerAllocationResource(), (double)newPendingAsk.getCount());
        this.queue.incPendingResource(newNodePartition, increasedResource);
        this.appResourceUsage.incPending(newNodePartition, increasedResource);
    }

    public void addRequestedPartition(String partition) {
        this.requestedPartitions.add(partition);
    }

    public void decPendingResource(String partition, Resource toDecrease) {
        this.queue.decPendingResource(partition, toDecrease);
        this.appResourceUsage.decPending(partition, toDecrease);
    }

    public void updatePlacesBlacklistedByApp(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedByApp, blacklistAdditions, blacklistRemovals)) {
            this.userBlacklistChanged.set(true);
        }
    }

    public void updatePlacesBlacklistedBySystem(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedBySystem, blacklistAdditions, blacklistRemovals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateBlacklistedPlaces(Set<String> blacklist, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        boolean changed = false;
        Set<String> set = blacklist;
        synchronized (set) {
            if (blacklistAdditions != null) {
                changed = blacklist.addAll(blacklistAdditions);
            }
            if (blacklistRemovals != null) {
                changed = blacklist.removeAll(blacklistRemovals) || changed;
            }
        }
        return changed;
    }

    public boolean getAndResetBlacklistChanged() {
        return this.userBlacklistChanged.getAndSet(false);
    }

    public Collection<SchedulerRequestKey> getSchedulerKeys() {
        return this.schedulerKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceRequest> getAllResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        this.readLock.lock();
        try {
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                ret.addAll(ap.getResourceRequests().values());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return ret;
    }

    public PendingAsk getNextPendingAsk() {
        this.readLock.lock();
        try {
            if (!this.schedulerKeys.isEmpty()) {
                SchedulerRequestKey firstRequestKey = this.schedulerKeys.first();
                PendingAsk pendingAsk = this.getPendingAsk(firstRequestKey, "*");
                return pendingAsk;
            }
            PendingAsk pendingAsk = null;
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PendingAsk getPendingAsk(SchedulerRequestKey schedulerKey) {
        return this.getPendingAsk(schedulerKey, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingAsk getPendingAsk(SchedulerRequestKey schedulerKey, String resourceName) {
        this.readLock.lock();
        try {
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            PendingAsk pendingAsk = ap == null ? PendingAsk.ZERO : ap.getPendingAsk(resourceName);
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaceBlacklisted(String resourceName, boolean blacklistedBySystem) {
        if (blacklistedBySystem) {
            Set<String> set = this.placesBlacklistedBySystem;
            synchronized (set) {
                return this.placesBlacklistedBySystem.contains(resourceName);
            }
        }
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return this.placesBlacklistedByApp.contains(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerRequest allocate(NodeType type, SchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer containerAllocated) {
        this.writeLock.lock();
        try {
            if (null != containerAllocated) {
                this.updateMetricsForAllocatedContainer(type, node, containerAllocated);
            }
            ContainerRequest containerRequest = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey).allocate(schedulerKey, type, node);
            return containerRequest;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void checkForDeactivation() {
        if (this.schedulerKeys.isEmpty()) {
            this.abstractUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Queue newQueue) {
        this.writeLock.lock();
        try {
            QueueMetrics oldMetrics = this.queue.getMetrics();
            QueueMetrics newMetrics = newQueue.getMetrics();
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                PendingAsk ask = ap.getPendingAsk("*");
                if (ask.getCount() <= 0) continue;
                oldMetrics.decrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                newMetrics.incrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                Resource delta = Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount());
                this.queue.decPendingResource(ap.getPrimaryRequestedNodePartition(), delta);
                newQueue.incPendingResource(ap.getPrimaryRequestedNodePartition(), delta);
            }
            oldMetrics.moveAppFrom(this);
            newMetrics.moveAppTo(this);
            this.abstractUsersManager.deactivateApplication(this.user, this.applicationId);
            this.abstractUsersManager = newQueue.getAbstractUsersManager();
            if (!this.schedulerKeys.isEmpty()) {
                this.abstractUsersManager.activateApplication(this.user, this.applicationId);
            }
            this.queue = newQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.writeLock.lock();
        try {
            QueueMetrics metrics = this.queue.getMetrics();
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                PendingAsk ask = ap.getPendingAsk("*");
                if (ask.getCount() <= 0) continue;
                metrics.decrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                this.queue.decPendingResource(ap.getPrimaryRequestedNodePartition(), Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount()));
            }
            metrics.finishAppAttempt(this.applicationId, this.pending, this.user);
            this.clearRequests();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setQueue(Queue queue) {
        this.writeLock.lock();
        try {
            this.queue = queue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> getBlackList() {
        return this.placesBlacklistedByApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBlackListCopy() {
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return new HashSet<String>(this.placesBlacklistedByApp);
        }
    }

    public void transferStateFromPreviousAppSchedulingInfo(AppSchedulingInfo appInfo) {
        this.placesBlacklistedByApp = appInfo.getBlackList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverContainer(RMContainer rmContainer, String partition) {
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        this.writeLock.lock();
        try {
            QueueMetrics metrics = this.queue.getMetrics();
            if (this.pending) {
                this.pending = false;
                metrics.runAppAttempt(this.applicationId, this.user);
            }
            if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
                return;
            }
            metrics.allocateResources(partition, this.user, 1, rmContainer.getAllocatedResource(), false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAllocation(NodeType type, SchedulerNode node, SchedulerRequestKey schedulerKey) {
        this.readLock.lock();
        try {
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            if (null == ap) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ap.canAllocate(type, node);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateMetricsForAllocatedContainer(NodeType type, SchedulerNode node, RMContainer containerAllocated) {
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        AppSchedulingInfo.updateMetrics(this.applicationId, type, node, containerAllocated, this.user, this.queue);
    }

    public static void updateMetrics(ApplicationId applicationId, NodeType type, SchedulerNode node, RMContainer containerAllocated, String user, Queue queue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationId=" + applicationId + " container=" + containerAllocated.getContainer().getId() + " host=" + containerAllocated.getNodeId() + " user=" + user + " resource=" + containerAllocated.getContainer().getResource() + " type=" + (Object)((Object)type)));
        }
        if (node != null) {
            queue.getMetrics().allocateResources(node.getPartition(), user, 1, containerAllocated.getContainer().getResource(), false);
            queue.getMetrics().decrPendingResources(containerAllocated.getNodeLabelExpression(), user, 1, containerAllocated.getContainer().getResource());
        }
        queue.getMetrics().incrNodeTypeAggregations(user, type);
    }

    public <N extends SchedulerNode> AppPlacementAllocator<N> getAppPlacementAllocator(SchedulerRequestKey schedulerkey) {
        return this.schedulerKeyToAppPlacementAllocator.get(schedulerkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDelayTo(SchedulerRequestKey schedulerKey, String resourceName) {
        this.readLock.lock();
        try {
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            boolean bl = ap == null || ap.canDelayTo(resourceName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean precheckNode(SchedulerRequestKey schedulerKey, SchedulerNode schedulerNode, SchedulingMode schedulingMode, Optional<DiagnosticsCollector> dcOpt) {
        this.readLock.lock();
        try {
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            boolean bl = ap != null && ap.precheckNode(schedulerNode, schedulingMode, dcOpt);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getDefaultNodeLabelExpression() {
        try {
            this.readLock.lock();
            String string = this.queue.getDefaultNodeLabelExpression();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, String> getApplicationSchedulingEnvs() {
        return this.applicationSchedulingEnvs;
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }
}

